# 窗体美化

``` C#

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace Startup
{
    public class FormRegion : Form
    {
        private float TitleFontSize => titleFontSize;
        private float titleFontSize = 86;
        private const int WM_SYSCOMMAND = 0x0112;
        private const int SC_MOVE = 0xF010;
        private const int HTCAPTION = 0x0002;
        private Form form;
        private Label lblTitle = new Label();
        private Button btnClose = new Button();
        private Button btnMini = new Button();
        private Label lblInfor = new Label();
        private Panel pnlProgress = new Panel();

        public string Infor
        {
            get
            {
                return lblInfor.Text;
            }

            set
            {
                lblInfor.Text = value;
            }
        }

        protected override CreateParams CreateParams
        {
            get
            {
                var cp = base.CreateParams;
                cp.ExStyle |= 0x02000000;
                return cp;
            }
        }

        private string Title
        {
            get
            {
                return lblTitle.Text;
            }

            set
            {
                lblTitle.Text = value;
            }
        }

        private SizeF titleTextSize
        {
            get;
            set;
        }

        public FormRegion(Form form, string title)
        {
            this.form = form;
            Title = title;
        }

        public void CreateRegion(Bitmap bitmap)
        {
            if (form == null || bitmap == null)
                return;

            form.Width = bitmap.Width;
            form.Height = bitmap.Height;

            form.Width = form.Width;
            form.Height = form.Height;
            form.FormBorderStyle = FormBorderStyle.None;
            form.BackgroundImage = bitmap;
            form.Region = new Region(GetRegionFrom(bitmap));

            Font font = new Font("微软雅黑", titleFontSize, FontStyle.Regular);
            var g = form.CreateGraphics();
            titleTextSize = g.MeasureString(Title, font);

            lblTitle.Location = new Point((form.Width - (int)titleTextSize.Width) / 2, (form.Height - (int)titleTextSize.Height) / 2);
            lblInfor.TextAlign = ContentAlignment.MiddleLeft;
            lblTitle.Font = font;
            lblTitle.AutoSize = true;
            lblTitle.ForeColor = Color.White;
            lblTitle.BackColor = Color.Transparent;
            form.Controls.Add(lblTitle);
            form.MouseDown += delegate
            {
                ReleaseCapture();
                SendMessage(form.Handle, WM_SYSCOMMAND, SC_MOVE + HTCAPTION, 0);
            };

            AddControlButton(form);

            Font fontSmall = new Font("微软雅黑", 8f, FontStyle.Regular);
            lblInfor.Location = new Point(2, form.Height - 25);
            lblInfor.Font = fontSmall;
            lblInfor.Width = 3 * this.form.Width / 4;
            lblInfor.ForeColor = Color.White;
            lblInfor.BackColor = Color.Transparent;
            form.Controls.Add(lblInfor);

            //pnlProgress.Location = new Point(0, lblTitle.Location.Y + (int)titleTextSize.Height);
            //pnlProgress.Width = form.Width;
            //pnlProgress.Height = 10;
            //pnlProgress.BackColor = Color.Transparent;
            //pnlProgress.Paint += delegate
            //{
            //    AddProgressBar(30);
            //};
            //form.Controls.Add(pnlProgress);
        }

        //private float AddProgressBar(float x)
        //{
        //    var g = pnlProgress.CreateGraphics();
        //    //g.Clear(Color.White);
        //    g.SmoothingMode = SmoothingMode.HighQuality;
        //    g.FillEllipse(new SolidBrush(Color.White), x, lblTitle.Location.Y + titleTextSize.Height, 5, 5);

        //    return x;
        //}

        private void AddControlButton(Form form)
        {
            var imgClose0 = Properties.Resources.close0;
            btnClose.Width = imgClose0.Width;
            btnClose.Height = imgClose0.Height;
            btnClose.BackgroundImage = imgClose0;
            btnClose.Region = new Region(GetRegionFrom(imgClose0));
            btnClose.Location = new Point(form.Width - btnClose.Width, 0);
            btnClose.FlatStyle = FlatStyle.Flat;
            btnClose.FlatAppearance.BorderSize = 0;

            ToolTip tip0 = new ToolTip();
            btnClose.MouseEnter += delegate
            {
                tip0.Active = true;
                btnClose.BackgroundImage = Properties.Resources.close1;
                tip0.Show("Close", form, btnClose.Location.X, btnClose.Height);
            };
            btnClose.MouseLeave += delegate
            {
                tip0.Active = false;
                btnClose.BackgroundImage = Properties.Resources.close0;
            };
            btnClose.MouseDown += delegate
            {
                AnimateWindow(form.Handle, 400, /*0x00050010*/0x00050009);
                form.Close();
            };
            form.Controls.Add(btnClose);

            ToolTip tip1 = new ToolTip();
            var imgMini = Properties.Resources.mini;
            btnMini.Width = imgMini.Width;
            btnMini.Height = imgMini.Height;
            btnMini.BackgroundImage = imgMini;
            btnMini.Region = new Region(GetRegionFrom(imgMini));
            btnMini.Location = new Point(form.Width - btnMini.Width - btnClose.Width, 0);
            btnMini.FlatStyle = FlatStyle.Flat;
            btnMini.FlatAppearance.BorderSize = 0;
            btnMini.MouseEnter += delegate
            {
                tip1.Active = true;
                btnMini.BackgroundImage = Properties.Resources.mini1;
                tip1.Show("Minimize", form, btnMini.Location.X, btnMini.Height);
            };
            btnMini.MouseLeave += delegate
            {
                tip1.Active = false;
                btnMini.BackgroundImage = Properties.Resources.mini;
            };
            btnMini.MouseDown += delegate
            {
                AnimateWindow(form.Handle, 400, 0x00050006);// 向左下角动画
                form.WindowState = FormWindowState.Minimized;
            };
            form.Controls.Add(btnMini);
        }

        [DllImport("user32.dll")]
        private static extern bool ReleaseCapture();
        [DllImport("user32.dll")]
        private static extern bool SendMessage(IntPtr hwnd, int wMsg, int wParam, int lParam);
        [DllImport("user32.dll")]
        public static extern bool AnimateWindow(IntPtr hWnd, uint dwTime, uint dwFlags);

        /// <summary>   
        /// //计算位图中不透明部分的边界  
        /// </summary>   
        /// <returns>Calculated graphics path</returns>   
        private GraphicsPath GetRegionFrom(Bitmap bitmap)
        {
            //创建 GraphicsPath  
            GraphicsPath graphicsPath = new GraphicsPath();
            //使用左上角的一点的颜色作为我们透明色  
            //Color colorTransparent = bitmap.GetPixel(0, 0);
            Color colorTransparent = Color.White;

            //第一个找到点的X  
            int colOpaquePixel = 0;
            for (int row = 0; row < bitmap.Height; row++)
            {
                colOpaquePixel = 0;
                for (int col = 0; col < bitmap.Width; col++)
                {
                    //如果是不需要透明处理的点则标记，然后继续偏历  
                    if (bitmap.GetPixel(col, row) != colorTransparent)
                    {
                        //记录当前  
                        colOpaquePixel = col;
                        //建立新变量来记录当前点  
                        int colNext = col;
                        ///从找到的不透明点开始，继续寻找不透明点,一直到找到或则达到图片宽度   
                        for (colNext = colOpaquePixel; colNext < bitmap.Width; colNext++)
                            if (bitmap.GetPixel(colNext, row) == colorTransparent)
                                break;
                        //将不透明点加到graphics path  
                        graphicsPath.AddRectangle(new Rectangle(colOpaquePixel, row, colNext - colOpaquePixel, 1));
                        col = colNext;
                    }
                }
            }
            return graphicsPath;
        }
    }
}

```

替换相关图片即可美化窗体。