#### 条件判断多少次

```csharp
// 代码1
if (dgvDiagnose.SelectedRows.Count != 1)
	return;

if (!m_MRFirstPageDAL.m_dsDiagnosis.IsInitialized)
	return;

if (m_MRFirstPageDAL.m_dsDiagnosis.Tables.Count != 1)
	return;
```

显然代码1判断3次。三个表达式的值都为`false`才执行后面的代码。因此执行后面代码的概率为1/8，不执行的概率为7/8。

现在考虑这样一段代码

```c#
// 代码2
if (dgvDiagnose.SelectedRows.Count != 1 || !m_MRFirstPageDAL.m_dsDiagnosis.IsInitialized || m_MRFirstPageDAL.m_dsDiagnosis.Tables.Count != 1)
	return;
```

代码2的`if`判断中，只要3个表达式其中一个符合条件，则后面代码都不能被执行。假如后面的代码不能被执行，那么至少判断1次，至多判断3次。假如判断是从左往右进行，那么判断1次表明程序只判断了`dgvDiagnose.SelectedRows.Count != 1`就确定了`if`表达式的值，就是说这个判断的值为`true`。判断2次表明`dgvDiagnose.SelectedRows.Count != 1`为`false`，而`!m_MRFirstPageDAL.m_dsDiagnosis.IsInitialized`为`true`。判断3次表明`dgvDiagnose.SelectedRows.Count != 1`，`!m_MRFirstPageDAL.m_dsDiagnosis.IsInitialized`都为`false`，而`m_MRFirstPageDAL.m_dsDiagnosis.Tables.Count != 1`为`true`。判断从右向左执行也是同样的道理。总之，这种情况下，不执行后面代码的判断次数的取值范围为`[1-3]`，不执行的概率为7/8，执行概率1/8。

```csharp
// 代码3
if (dgvDiagnose.SelectedRows.Count != 1 && !m_MRFirstPageDAL.m_dsDiagnosis.IsInitialized && m_MRFirstPageDAL.m_dsDiagnosis.Tables.Count != 1)
	return;
```

代码3表明，只有三个表达式同时为`true`，后面的代码才不执行。换言之，只要其中一个不是`true`，后面的代码都会被执行。这种情况下，不执行后面代码的概率为1/8，执行概率7/8。

```csharp
// 代码4
if (dgvDiagnose.SelectedRows.Count != 1 && !m_MRFirstPageDAL.m_dsDiagnosis.IsInitialized || m_MRFirstPageDAL.m_dsDiagnosis.Tables.Count != 1)
	return;

或

// 代码5
if (dgvDiagnose.SelectedRows.Count != 1 || !m_MRFirstPageDAL.m_dsDiagnosis.IsInitialized && m_MRFirstPageDAL.m_dsDiagnosis.Tables.Count != 1)
	return;
```

代码4或代码5，这种情况下，由于`&&`优先级大于`||`，若要后面的代码被执行，则`if`判断结果必为`false`。那么`(a && b || c)`中，`c`，` a && b` 必为`false`。`a && b`为`false`，表明a，b中至少一个为false，显然有三种情况。那么，不执行后面代码的概率为3/8，执行概率5/8。`(a || b && c)`也是同样的道理。

从以上的分析中，可以归纳出2条结论

1、代码1与代码2不等同。代码1必定判断3次，而代码2最多判断3次。也就是说，代码2的3个判断表达式发生失效的概率为2/3，代码1发生判断失效的概率为0。

2、后续代码失效的概率，代码2比代码3的高。虽然是`||`连接的，看起来似乎要更宽松，实际不是。