# 扫盲，什么叫同步异步

同步，就是`A要从B得到一些结果，A等着B出结果，B做不完A就一直等着`。同步就相当于顺序执行。

异步，就是`A要从B得到一些结果，A告诉B它要结果，然后做自己的事，B做完后通知A结果是xxx`。异步的意思就是非顺序执行的。至于执行的顺序是什么，这是不确定的。而某个任务要执行到什么时间结束，这要看分给这个任务的CPU时间。时间到了就结束（分时系统，大部分情况都是这样）。

为什么需要异步？显然异步更加高效。比如更新UI，若将大量任务交给主线程处理，那么主线程需要花许多时间处理这些任务，这将导致界面被阻塞，使用者的感受就是卡。如果把一些操作交给多个线程或进程处理，这就减轻了主线程的负担。如果主线程做的事足够少，使用者就感觉不到卡。

如何写异步的代码？用`async和await`。async修饰的方法是可异步（非顺序，不等主线程）执行的方法。await修饰async方法内耗时的操作。这样主线程解析到await修饰的操作时，就可以跳过这个操作，继续执行主线程内的操作。

相似的，计算机网络中也有异步同步的概念——异步传输，同步传输。异步传输比较自由，规则较少，但正因为规则少，反而需要更多的检测，从而导致传输效率降低。规则复杂的同步传输方式效率却很高。TCP/IP协议就是同步传输。帧的概念也是对应同步传输方式。

