#### 所谓条形码

#### 一、条码

条形码，从外形看是一条条粗细，彼此间间隔不同的线段。正是由于这两个特点，可用来表示若干字符。

常用的条形码编码格式有`Code39`,`Code128`。一般的39码可表示44种字符

| 可表示字符 | 表示意义 |   二进制码   |
| :--------: | :------: | :----------: |
|     0      |          | 101001101101 |
|     1      |          | 110100101011 |
|     2      |          | 101100101011 |
|     3      |          | 110110010101 |
|     4      |          | 101001101011 |
|     5      |          | 110100110101 |
|     6      |          | 101100110101 |
|     7      |          | 101001011011 |
|     8      |          | 110100101101 |
|     9      |          | 101100101101 |
|     A      |          | 110101001011 |
|     B      |          | 101101001011 |
|     C      |          | 110110100101 |
|     D      |          | 101011001011 |
|     E      |          | 110101100101 |
|     F      |          | 101101100101 |
|     G      |          | 101010011011 |
|     H      |          | 110101001101 |
|     I      |          | 101101001101 |
|     J      |          | 101011001101 |
|     K      |          | 110101010011 |
|     L      |          | 101101010011 |
|     M      |          | 110110101001 |
|     N      |          | 101011010011 |
|     O      |          | 110101101001 |
|     P      |          | 101101101001 |
|     Q      |          | 101010110011 |
|     R      |          | 110101011001 |
|     S      |          | 101101011001 |
|     T      |          | 101011011001 |
|     U      |          | 110010101011 |
|     V      |          | 100110101011 |
|     W      |          | 110011010101 |
|     X      |          | 100101101011 |
|     Y      |          | 110010110101 |
|     Z      |          | 100110110101 |
|     -      |          | 100101011011 |
|     .      |    点    | 110010101101 |
|            |  空字符  | 100110101101 |
|     $      |          | 100100100101 |
|     /      |          | 100100101001 |
|     +      |          | 100101001001 |
|     %      |          | 101001001001 |
|     *      |          | 100101101101 |

显然，若无需表示复杂的字符，例如只需要用一定规则排列的数字表示信息时，用Code39码就OK了。但是，实际需要编码的字符往往不只这基本的44个字符。为满足需要，出现了扩展的Code39码。扩展后的Code39码能表示128种字符

| 表示的字符 | 编码 | 表示的字符 | 编码  | 表示的字符 | 编码 | 表示的字符 |      编码      |
| :--------: | :--: | :--------: | :---: | :--------: | :--: | :--------: | :------------: |
|    NUL     |  %U  |     SP     | Space |     @      |  %V  |     `      |       %W       |
|    SOH     |  $A  |     !      |  /A   |     A      |  A   |     a      |       +A       |
|    STX     |  $B  |     "      |  /B   |     B      |  B   |     b      |       +B       |
|    ETX     |  $C  |     #      |  /C   |     C      |  C   |     c      |       +C       |
|    EOT     |  $D  |     $      |  /D   |     D      |  D   |     d      |       +D       |
|    ENQ     |  $E  |     %      |  /E   |     E      |  E   |     e      |       +E       |
|    ACK     |  $F  |     &      |  /F   |     F      |  F   |     f      |       +F       |
|    BEL     |  $G  |     '      |  /G   |     G      |  G   |     g      |       +G       |
|     BS     |  $H  |     (      |  /H   |     H      |  H   |     H      |       H        |
|     HT     |  $I  |     )      |  /I   |     I      |  I   |     i      |       +I       |
|     LF     |  $J  |     *      |  /J   |     J      |  J   |     j      |       +J       |
|     VT     |  $K  |     +      |  /K   |     K      |  K   |     k      |       +K       |
|     FF     |  $L  |     ,      |  /L   |     L      |  L   |     l      |       +L       |
|     CR     |  $M  |     -      |   -   |     M      |  M   |     m      |       +M       |
|     SO     |  $N  |     .      |   .   |     N      |  N   |     n      |       +N       |
|     SI     |  $O  |     /      |  /O   |     O      |  O   |     o      |       +O       |
|    DLE     |  $P  |     0      |   0   |     P      |  P   |     p      |       +P       |
|    DC1     |  $Q  |     1      |   1   |     Q      |  Q   |     q      |       +Q       |
|    DC2     |  $R  |     2      |   2   |     R      |  R   |     r      |       +R       |
|    DC3     |  $S  |     3      |   3   |     S      |  S   |     s      |       +S       |
|    DC4     |  $T  |     4      |   4   |     T      |  T   |     t      |       +T       |
|    NAK     |  $U  |     5      |   5   |     U      |  U   |     u      |       +U       |
|    SYN     |  $V  |     6      |   6   |     V      |  V   |     v      |       +V       |
|    ETB     |  $W  |     7      |   7   |     W      |  W   |     w      |       +W       |
|    CAN     |  $X  |     8      |   8   |     X      |  X   |     x      |       +X       |
|     EM     |  $Y  |     9      |   9   |     Y      |  Y   |     y      |       +Y       |
|    SUB     |  $Z  |     :      |  /Z   |     Z      |  Z   |     z      |       +Z       |
|    ESC     |  %A  |     ;      |  %F   |     [      |  %K  |     {      |       %P       |
|     FS     |  %B  |     <<     |  %G   |     \      |  %L  |     \|     |       %Q       |
|     GS     |  %C  |     =      |  %H   |     ]      |  %M  |     }      |       %R       |
|     RS     |  %D  |     >      |  %I   |     ^      |  %N  |     ~      |       %S       |
|     US     |  %E  |     ?      |  %J   |     _      |  %O  |    DEL     | %T, %X, %Y, %Z |

Code128码能表示128种字符。Code128与扩展后的Code39都能表示128种字符，区别在于其编码规则不同。由于编码规则不同，所以产生的条码线的粗细，间隔都有差别。

##### 二、识别设备

能够识别条码的设备。常见的是扫码枪。扫码枪识别条码的原理是利用光的反射。扫码枪会发出一道光，打到条码上后，黑色的条码线会吸收掉这段光波，而没被吸收的部分将返回到感应器。通过芯片（解码规则）处理得到的间断信息。于是这段条码的含义就被明确了。因此，若扫码枪与条码编码不对应，即加密与解密的规则不一致，当然就出现无法识别条码的现象了。

而现在的手机应用，如微信也能识别条码。识别的原理与第一种是不一样的。打开微信扫描条码，摄像头本身并没发光，但微信程序却成功地识别出条码表示的含义。很显然，这是采用图像识别的技术。虽然第一种方法也有图像识别的意味，甚至也可以称为图像识别。但是后者却是标标准准的图像识别。推测微信程序首先会捕获目标条码，之后尽可能地增大色差，使得条码线色与背景色能够更加容易地区别开。然后关键是要处理条码线的宽度与间隙宽度，再从中解密得到正确的信息，因此就必然要检测像素。检测时也没必要对整个图片进行处理，实际上只需要截取有限高度的整段条码即可。因为条码是根据条码线宽度与间隙表示信息的。而因为一般商品的条码编码规则已经受到国家规范，所以实际上很容易解密出商品下方的字符码（正确的信息）。当然，这些识别过程不可能在本地完成的，因为牵扯到复杂的计算，放在本地计算无疑十分消耗用户CPU。用户也不乐意为此承担复杂的计算。

#### 三、字体

只需在电脑上安装某种条码字体，再在需要引用的地方把一段有效的字串的字体设置为这种条码字体，就能在需要显示条码的位置显示条码图而不是这段字串。显然，这将字串转条码的处理过程甩给了操作系统。好处是简化了开发难度。开发者无需再去定义某种规则的字符映射关系，也不需要再调用底层绘图方法在目标位置将条码线绘制出来。定义一套字体文件，然后甩锅给操作系统，只用设置要显示的字串即可。如果安装的某个条码字体可以加密这段字串（设置要显示的字串全都在字体文件中有对应），那么操作系统在显示这段字串时，将根据这个字体文件将之加密成条码线。

还有一些字体文件，本身就会自动在条码线下方显示一串字符，来表示这个条码的含义。应该是因为这个字体文件定义了在条码线下方显示字串文本的方法。总之要告诉操作系统，应当在条码线下方绘制字串。