# 快速排序

```csharp
private void QuickSort(int[] inputArray, int lowIndex, int highIndex)
{
    if (lowIndex >= highIndex)
    {
        return;
    }
    int middleIndex = SortFunction(inputArray, lowIndex, highIndex);
    QuickSort(inputArray, lowIndex, middleIndex);
    QuickSort(inputArray, middleIndex + 1, highIndex);
}

private int SortFunction(int[] inputArray, int lowIndex, int highIndex)
{
    int minValue = inputArray[lowIndex];
    for (; highIndex > lowIndex; highIndex--)
    {
        if (inputArray[highIndex] <= minValue)
        {
            inputArray[lowIndex] = inputArray[highIndex];
            for (; lowIndex < highIndex; lowIndex++)
            {
                if (inputArray[lowIndex] >= minValue)
                {
                    inputArray[highIndex] = inputArray[lowIndex];
                    break;
                }
            }
        }
    }
    inputArray[lowIndex] = minValue;
    return lowIndex;
}

```

