#### WPF平移动画

```c#
    /// <summary>
    /// 左移动画
    /// </summary>
    private void leftTrans(Button button)
    {
        TranslateTransform translate = new TranslateTransform();
        button.RenderTransform = translate;

        NameScope.SetNameScope(this, new NameScope());
        this.RegisterName("translate", translate);

        //设置动画路径
        PathFigure pathFigure = new PathFigure();
        pathFigure.IsClosed = false;//此值设为 false，则为单向动画
        pathFigure.StartPoint = new Point(0, 0);
        pathFigure.Segments.Add(new LineSegment(new Point(-50, 0), true));

        PathGeometry pathGeometry = new PathGeometry();
        pathGeometry.Figures.Add(pathFigure);

        Path path = new Path();
        path.Data = pathGeometry;

        //声明路径动画
        DoubleAnimationUsingPath animationX = new DoubleAnimationUsingPath();
        animationX.PathGeometry = path.Data.GetFlattenedPathGeometry();
        animationX.Source = PathAnimationSource.X;
        animationX.Duration = new Duration(TimeSpan.FromMilliseconds(200));

        Storyboard storyboard = new Storyboard();
        Storyboard.SetTargetName(animationX, "translate");
        Storyboard.SetTargetProperty(animationX, new PropertyPath(TranslateTransform.XProperty));

        storyboard.Children.Add(animationX);
        storyboard.Begin(button);//开始动画
    }

    /// <summary>
    /// 右移动画
    /// </summary>
    private void rightTrans(Button button)
    {
        TranslateTransform translate = new TranslateTransform();
        button.RenderTransform = translate;

        NameScope.SetNameScope(this, new NameScope());
        this.RegisterName("translate", translate);

        //设置动画路径
        PathFigure pathFigure = new PathFigure();
        pathFigure.IsClosed = false;//此值设为 false，则为单向动画
        pathFigure.StartPoint = new Point(0, 0);
        pathFigure.Segments.Add(new LineSegment(new Point(50, 0), true));

        PathGeometry pathGeometry = new PathGeometry();
        pathGeometry.Figures.Add(pathFigure);

        Path path = new Path();
        path.Data = pathGeometry;

        //声明路径动画
        DoubleAnimationUsingPath animationX = new DoubleAnimationUsingPath();
        animationX.PathGeometry = path.Data.GetFlattenedPathGeometry();
        animationX.Source = PathAnimationSource.X;
        animationX.Duration = new Duration(TimeSpan.FromMilliseconds(200));

        Storyboard storyboard = new Storyboard();
        Storyboard.SetTargetName(animationX, "translate");
        Storyboard.SetTargetProperty(animationX, new PropertyPath(TranslateTransform.XProperty));

        storyboard.Children.Add(animationX);
        storyboard.Begin(button);//开始动画
    }

    /// <summary>
    /// 上移动画
    /// </summary>
    private void topTrans(Button button)
    {
        TranslateTransform translate = new TranslateTransform();
        button.RenderTransform = translate;

        NameScope.SetNameScope(this, new NameScope());
        this.RegisterName("translate", translate);

        //设置动画路径
        PathFigure pathFigure = new PathFigure();
        pathFigure.IsClosed = false;//此值设为 false，则为单向动画
        pathFigure.StartPoint = new Point(0, 0);
        pathFigure.Segments.Add(new LineSegment(new Point(0, -50), true));

        PathGeometry pathGeometry = new PathGeometry();
        pathGeometry.Figures.Add(pathFigure);

        Path path = new Path();
        path.Data = pathGeometry;

        //声明路径动画
        DoubleAnimationUsingPath animationY = new DoubleAnimationUsingPath();
        animationY.PathGeometry = path.Data.GetFlattenedPathGeometry();
        animationY.Source = PathAnimationSource.Y;
        animationY.Duration = new Duration(TimeSpan.FromMilliseconds(200));

        Storyboard storyboard = new Storyboard();
        Storyboard.SetTargetName(animationY, "translate");
        Storyboard.SetTargetProperty(animationY, new PropertyPath(TranslateTransform.YProperty));

        storyboard.Children.Add(animationY);
        storyboard.Begin(button);//开始动画
    }

    /// <summary>
    /// 下移动画
    /// </summary>
    private void bottomTrans(Button button)
    {
        TranslateTransform translate = new TranslateTransform();
        button.RenderTransform = translate;

        NameScope.SetNameScope(this, new NameScope());
        this.RegisterName("translate", translate);

        //设置动画路径
        PathFigure pathFigure = new PathFigure();
        pathFigure.IsClosed = false;//此值设为 false，则为单向动画
        pathFigure.StartPoint = new Point(0, 0);
        pathFigure.Segments.Add(new LineSegment(new Point(0, 50), true));

        PathGeometry pathGeometry = new PathGeometry();
        pathGeometry.Figures.Add(pathFigure);

        Path path = new Path();
        path.Data = pathGeometry;

        //声明路径动画
        DoubleAnimationUsingPath animationY = new DoubleAnimationUsingPath();
        animationY.PathGeometry = path.Data.GetFlattenedPathGeometry();
        animationY.Source = PathAnimationSource.Y;
        animationY.Duration = new Duration(TimeSpan.FromMilliseconds(200));

        Storyboard storyboard = new Storyboard();
        Storyboard.SetTargetName(animationY, "translate");
        Storyboard.SetTargetProperty(animationY, new PropertyPath(TranslateTransform.YProperty));

        storyboard.Children.Add(animationY);
        storyboard.Begin(button);//开始动画
    }
```
