## 委托事件实现窗体间互操作

有两个窗体`frm1`，`frm2`。假如我们需要用`frm1`引发`frm2`执行某些操作。可在`frm1`中注册一个委托，然后用此委托注册一个事件，再然后在`frm1`中引发这个事件。同时在`frm2`中注册这个事件。这样就可以了。代码大概这样

```csharp
// frm1
public delegate void FilterCol();
public event FilterCol FilterColEvent;

// frm1上又有一个Button
private void button1_Click(object sender, EventArgs e)
{
    FilterColEvent?.Invoke();//引发事件

    Close();
}
```

`FilterColEvent?.Invoke();`相当于

```csharp
if(FilterColEvent != null)
	FilterColEvent();
```

```csharp
// frm2
frm1 fm=new frm1();
fm.FilterColEvent += xxx;

void xxx()
{
    xxxxxxxxxx;
}
```

