#### 委托事件实现一个窗体向另一个窗体传值

利用委托和事件可以方便地在一个窗体上让另一个窗体执行某个操作，并且还能把这个窗体的值传到另一个窗体。传值利用事件的参数。大概这样写

```csharp
// frm1
public partial class frmRowAddSetting : Form
{
        public delegate void RowAddSetting();
        public event EventHandler<RowAddSettingEventArgs> RowAddSettingEvent;

        private void button1_Click(object sender, EventArgs e)
        {
            Queue<string> qu0 = new Queue<string>();
            Queue<int> qu1 = new Queue<int>();

            for (int i = 0; i < checkedListBox1.Items.Count; i++)
            {
                if (checkedListBox1.GetItemChecked(i))
                {
                    qu0.Enqueue(checkedListBox1.Items[i].ToString());
                    qu1.Enqueue(i);
                }
            }

            EventHandler<RowAddSettingEventArgs> temp = RowAddSettingEvent;
            if (temp != null)
            {
                RowAddSettingEventArgs ee = new RowAddSettingEventArgs();
                ee.CheckedItemsText = qu0.ToArray();
                ee.CheckedItemsIndex = qu1.ToArray();
                ee.UserChecked = true;

                temp(sender, ee);//引发事件，并传值
            }

            Close();
        }
    }

    public class RowAddSettingEventArgs:EventArgs
    {
        /// <summary>
        /// 选中的项
        /// </summary>
        public string [] CheckedItemsText { get; set; }
        /// <summary>
        /// 选中项的索引
        /// </summary>
        public int [] CheckedItemsIndex { get; set; }
        /// <summary>
        /// 用户选择了项，默认为False,表示用户未选择项
        /// </summary>
        public bool UserChecked = false;
    }
 }

```

```csharp
// frm2

private void xxx()
{
    frm1 fm=new frm1();
	frm1.RowAddSettingEvent += frm1_RowAddSettingEvent;//注册事件，引发事件后，代码执行到此处将执行对应事件
	
	frm1.ShowDialog();
}

private void frm1_RowAddSettingEvent(object sender, RowAddSettingEventArgs e)
{
    //取出传递过来的值
    string [] vArr0 = e.CheckedItemsText;
    int [] vArr1 = e.CheckedItemsIndex;
    bool vBool = e.UserChecked;
}

```

