#### C#正则表达式进行简单的字符串匹配识别

直接上代码：

```csharp
if (!Regex.IsMatch(comboBox1.Text, @"(高端类|中端类|低端类)"))//产品类型格式验证
{
  MessageBox.Show("产品类型格式不正确！", "警告", MessageBoxButtons.OK, MessageBoxIcon.Error);
  return;
}//------例1

if (!Regex.IsMatch(comboBox2.Text, @"\d(16|32|48|56)"))//线路类型格式验证
{
  MessageBox.Show("线路类型格式不正确！", "警告", MessageBoxButtons.OK, MessageBoxIcon.Error);
  return;
}//-------例2

```

例1中只有括号中规定的三个字符串才能通过匹配。例2中除了括号中规定的4个字符串外还有`\d`代表的整数。

规则表如下：

| 字　　符          | 描　　述                                     |
| ------------- | ---------------------------------------- |
| \             | 转义字符，将一个具有特殊功能的字符转义为一个普通字符，或反过来          |
| ^             | 匹配输入字符串的开始位置                             |
| $             | 匹配输入字符串的结束位置                             |
| *             | 匹配前面的零次或多次的子表达式                          |
| +             | 匹配前面的一次或多次的子表达式                          |
| ?             | 匹配前面的零次或一次的子表达式                          |
| {*n*}         | *n*是一个非负整数，匹配前面的*n*次子表达式                 |
| {*n*,}        | *n*是一个非负整数，至少匹配前面的*n*次子表达式               |
| {*n*,*m*}     | *m*和*n*均为非负整数，其中*n*<=*m*，最少匹配*n*次且最多匹配*m*次 |
| ?             | 当该字符紧跟在其他限制符（*，+，?，{*n*}，{*n*,}，{*n*，*m*}）后面时，匹配模式尽可能少的匹配所搜索的字符串 |
| .             | 匹配除“\n”之外的任何单个字符                         |
| (*pattern*)   | 匹配*pattern*并获取这一匹配                       |
| (?:*pattern*) | 匹配*pattern*但不获取匹配结果                      |
| (?=*pattern*) | 正向预查，在任何匹配*pattern*的字符串开始处匹配查找字符串        |
| (?!*pattern*) | 负向预查，在任何不匹配*pattern*的字符串开始处匹配查找字符串       |
| *x*\|*y*      | 匹配*x*或*y*。例如，‘z\|food'能匹配“z”或“food”。‘(z\|f)ood'则匹配“zood”或“food” |
| [*xyz*]       | 字符集合。匹配所包含的任意一个字符。例如，‘[abc]'可以匹配“plain”中的‘a' |
| [^*xyz*]      | 负值字符集合。匹配未包含的任意字符。例如，‘[^abc]'可以匹配“plain”中的‘p' |
| [*a-z*]       | 匹配指定范围内的任意字符。例如，‘[a-z]'可以匹配'a'到'z'范围内的任意小写字母字符 |
| [^*a-z*]      | 匹配不在指定范围内的任意字符。例如，‘[^a-z]'可以匹配不在‘a'～‘z''内的任意字符 |
| \b            | 匹配一个单词边界，指单词和空格间的位置                      |
| \B            | 匹配非单词边界                                  |
| \d            | 匹配一个数字字符，等价于[0-9]                        |
| \D            | 匹配一个非数字字符，等价于[^0-9]                      |
| \f            | 匹配一个换页符                                  |
| \n            | 匹配一个换行符                                  |
| \r            | 匹配一个回车符                                  |
| \s            | 匹配任何空白字符，包括空格、制表符、换页符等                   |

| \S   | 匹配任何非空白字符                         |
| ---- | --------------------------------- |
| \t   | 匹配一个制表符                           |
| \v   | 匹配一个垂直制表符。等价于\x0b和\cK             |
| \w   | 匹配包括下划线的任何单词字符。等价于‘'[A-Za-z0-9_]' |
| \W   | 匹配任何非单词字符。等价于‘[^A-Za-z0-9_]'      |