#### 正则表达式用例-精编版

```html
匹配中文:[\u4e00-\u9fa5]
```

```
匹配英文字母:[a-zA-Z]
```

```
匹配数字:[0-9]
```

```
匹配中文，英文字母和数字及_:
^[\u4e00-\u9fa5_a-zA-Z0-9]+$
```

```
匹配中文，英文字母和数字及 _ 同时判断输入长度：
[\u4e00-\u9fa5_a-zA-Z0-9_]{4,10}
^[\w\u4E00-\u9FA5\uF900-\uFA2D]*$
```

```
只含有汉字、数字、字母、下划线，下划线位置不限：
^[a-zA-Z0-9_\u4e00-\u9fa5]+$
```

```
由数字、26个英文字母或者下划线组成的字符串
^\w+$
```

```
2~4个汉字
@"^[\u4E00-\u9FA5]{2,4}$";
```

```
最长不得超过7个汉字，或14个字节(数字，字母和下划线)正则表达式
^[\u4e00-\u9fa5]{1,7}$|^[\dA-Za-z_]{1,14}$
```

```
匹配双字节字符(包括汉字在内)：[^x00-xff] 
【可以用来计算字符串的长度（一个双字节字符长度计2，ASCII字符计1）】
```

```
匹配空白行的正则表达式：ns*r 
【可以用来删除空白行 】
```

```
匹配HTML标记的正则表达式：<(S*?)[^>]*>.*?|<.*? /> 
【这个仅仅能匹配部分，对于复杂的嵌套标记无能为力 】
```

```
匹配首尾空白字符的正则表达式：^s*|s*$ 
【可以用来删除行首行尾的空白字符(包括空格、制表符、换页符等等)，非常有用的表达式 】
```

```
匹配Email地址的正则表达式：w+([-+.]w+)*@w+([-.]w+)*.w+([-.]w+)* 
【表单验证时很实用 】
```

```
匹配网址URL的正则表达式：[a-zA-z]+://[^s]* 
【网上流传的版本功能很有限，上面这个基本可以满足需求 】
```

```
匹配帐号是否合法(字母开头，允许5-16字节，允许字母数字下划线)：^[a-zA-Z][a-zA-Z0-9_]{4,15}$ 
【表单验证时很实用 】
```

```
匹配国内电话号码：d{3}-d{8}|d{4}-d{7} 
【匹配形式如 0511-4405222 或 021-87888822 】
```

```
匹配腾讯QQ号：[1-9][0-9]{4,} 
【腾讯QQ号从10000开始 】
```

```
匹配中国邮政编码：[1-9]d{5}(?!d) 
【中国邮政编码为6位数字 】
```

```
匹配身份证：d{15}|d{18} 
【中国的身份证为15位或18位 】
```

```
匹配ip地址：d+.d+.d+.d+ 
【提取ip地址时有用 】
```

```
匹配特定数字： 
　　^[1-9]d*$　 　 //匹配正整数 
　　^-[1-9]d*$ 　 //匹配负整数 
　　^-?[1-9]d*$　　 //匹配整数 
　　^[1-9]d*|0$　 //匹配非负整数（正整数 + 0） 
　　^-[1-9]d*|0$　　 //匹配非正整数（负整数 + 0） 
　　^[1-9]d*.d*|0.d*[1-9]d*$　　 //匹配正浮点数 
　　^-([1-9]d*.d*|0.d*[1-9]d*)$　 //匹配负浮点数 
　　^-?([1-9]d*.d*|0.d*[1-9]d*|0?.0+|0)$　 //匹配浮点数 
　　^[1-9]d*.d*|0.d*[1-9]d*|0?.0+|0$　　 //匹配非负浮点数（正浮点数 + 0） 
　　^(-([1-9]d*.d*|0.d*[1-9]d*))|0?.0+|0$　　//匹配非正浮点数（负浮点数 + 0） 
【评注：处理大量数据时有用，具体应用时注意修正 】
```

```
匹配特定字符串： 
　　^[A-Za-z]+$　　//匹配由26个英文字母组成的字符串 
　　^[A-Z]+$　　//匹配由26个英文字母的大写组成的字符串 
　　^[a-z]+$　　//匹配由26个英文字母的小写组成的字符串 
　　^[A-Za-z0-9]+$　　//匹配由数字和26个英文字母组成的字符串 
　　^w+$　　//匹配由数字、26个英文字母或者下划线组成的字符串 
```

```
在使用RegularExpression验证控件时的验证功能及其验证表达式介绍如下: 
　　只能输入数字：“^[0-9]*$” 
　　只能输入n位的数字：“^d{n}$” 
　　只能输入至少n位数字：“^d{n,}$” 
　　只能输入m-n位的数字：“^d{m,n}$” 
　　只能输入零和非零开头的数字：“^(0|[1-9][0-9]*)$” 
　　只能输入有两位小数的正实数：“^[0-9]+(.[0-9]{2})?$” 
　　只能输入有1-3位小数的正实数：“^[0-9]+(.[0-9]{1,3})?$” 
　　只能输入非零的正整数：“^+?[1-9][0-9]*$” 
　　只能输入非零的负整数：“^-[1-9][0-9]*$” 
　　只能输入长度为3的字符：“^.{3}$” 
　　只能输入由26个英文字母组成的字符串：“^[A-Za-z]+$” 
　　只能输入由26个大写英文字母组成的字符串：“^[A-Z]+$” 
　　只能输入由26个小写英文字母组成的字符串：“^[a-z]+$” 
　　只能输入由数字和26个英文字母组成的字符串：“^[A-Za-z0-9]+$” 
　　只能输入由数字、26个英文字母或者下划线组成的字符串：“^w+$” 
```

```
　
验证用户密码:“^[a-zA-Z]w{5,17}$”
【格式为：以字母开头，长度在6-18之间，只能包含字符、数字和下划线。】 
```

```
验证是否含有^%&',;=?$"等字符：“[^%&',;=?$x22]+” 
```

```
只能输入汉字：“^[u4e00-u9fa5],{0,}$” 
```

```
验证InternetURL：“^http://([w-]+.)+[w-]+(/[w-./?%&=]*)?$” 
```

```
验证电话号码：“^((d{3,4})|d{3,4}-)?d{7,8}$” 
【格式为：“XXXX-XXXXXXX”，“XXXX-XXXXXXXX”，“XXX-XXXXXXX”，“XXX-XXXXXXXX”，“XXXXXXX”，“XXXXXXXX”】
```

```
验证一年的12个月：“^(0?[1-9]|1[0-2])$”
【格式为：“01”-“09”和“1”“12” 】
```

```
验证一个月的31天：“^((0?[1-9])|((1|2)[0-9])|30|31)$” 
【格式为：“01”“09”和“1”“31”】
```

```
从URL地址中提取文件名的javascript程序 
　　s="http://www.9499.net/page1.htm"; 
　　s=s.replace(/(.*/){0,}([^.]+).*/ig,"$2") ;
```

```
利用正则表达式限制网页表单里的文本框输入内容 
【用正则表达式限制只能输入中文：onkeyup="value=value.replace(/[^u4E00-u9FA5]/g,')
"onbeforepaste="clipboardData.setData('text',clipboardData.getData('text').replace(/[^u4E00-u9FA5]/g,'))" 】
```

```
【用正则表达式限制只能输入全角字符： onkeyup="value=value.replace(/[^uFF00-uFFFF]/g,')
"onbeforepaste="clipboardData.setData('text',clipboardData.getData('text').replace(/[^uFF00-uFFFF]/g,'))" 】
```

```
【用正则表达式限制只能输入数字：onkeyup="value=value.replace(/[^d]/g,') "onbeforepaste= "clipboardData.setData
('text',clipboardData.getData('text').replace(/[^d]/g,'))" 】
```

```
【用正则表达式限制只能输入数字和英文：onkeyup="value=value.replace(/[W]/g,') "onbeforepaste="clipboardData.setData
('text',clipboardData.getData('text').replace(/[^d]/g,'】
```

