### Github库名命名规范

#### 一、必要性说明

由于迁移到Github上的项目越来越多，对项目的管理越来越困难。由于各项目命名具有随意性，用之代表git仓库名后就很难快速回忆起这个项目的相关细节，通常需要不断打开某个库才能有所了解。因此，十分必要对git库名命名方式进行规范以便于项目的管理。

#### 二、命名规则

GIT库名一律采用`项目名-类型-年月`的形式。其中对`项目名`的规范如下：

- 库名中不得出现下述规定的字符`-` `\` `@` `!` `#` `$` `%` `^` `&` `*` `()` `[]` `{}` `|` `\` `;` `:` `''` `’`  `，` `。` `《` `》` `<` `>` `·` `~` 。
- 库名应尽量避免使用 `名.名`的形式。
- 库名应尽量使用英文，禁止使用中文字符。一般情况下，库名中出现的各个单词的首字母应使用大写。各个单词不能使用连接符 `-`连接；如有必要，应使用下划线 `_` 。
- 缩写的单词一律使用大写。

对`类型`的规定如下：

TST——测试项目

BC——已完成项目

SUS——被搁置项目

ING——正在进行的项目

TST-BC——已完成的测试项目

TST-SUS——被搁置的测试项目

TST-ING——正在进行的测试项目

