简体中文 | [English](./README.md)

### Ⅰ. 简介

- [scheduler](https://github.com/zfoo-project/zfoo/blob/main/scheduler/README.md) 时间任务调度总线，cron表达式的解析使用了spring自带的解释器模式

### Ⅱ. 时间任务调度

![Image text](../doc/image/scheduler/scheduler01.png)

- 前后调整本地机器时间都会触发任务调度，本地开发非常有用
- ScheduledExecutorService每秒钟执行一次triggerPerSecond()方法，循环遍历可执行的scheduler
- zfoo认为一个程序中不会有太多的时间任务调度，所以ScheduledExecutorService只有一条线程，所以使用者要避免做耗时和阻塞的运算，如果有这样的需求可以抛到其它线程池
- zfoo scheduler使用Javassist字节码增强技术动态代理时间调度任务，避免了反射，没有性能损耗

### Ⅲ. Cron Expression Example

```
30 * * * * ?           每半分钟触发任务
30 10 * * * ?          每小时的10分30秒触发任务
30 10 1 * * ?          每天1点10分30秒触发任务
30 10 1 20 * ?         每月20号1点10分30秒触发任务
30 10 1 20 10 ? *      每年10月20号1点10分30秒触发任务
30 10 1 20 10 ? 2018   2018年10月20号1点10分30秒触发任务
30 10 1 ? 10 * 2018    2018年10月每天20号1点10分30秒触发任务
30 10 1 ? 10 SUN 2018  2018年10月每周日1点10分30秒触发任务
15,30,45 * * * * ?     每分钟的15,30,45秒个触发一次
15-45 * * * * ?        每分钟的15秒到45秒内，每秒都触发一次
15/5 * * * * ?         每分钟的15秒开始触发，每隔5秒触发一次
15-30/5 * * * * ?      每分钟的15秒到30秒之间开始触发，每隔5秒触发一次
0 0/3 * * * ?          每小时的第0分0秒开始，没三分钟触发一次
0 15 10 ? * MON-FRI    星期一到星期五每天10点15分0秒触发一次
0 15 10 L * ?          每个月的最后一天的10点15分0秒触发任务
0 15 10 LW * ?         每个月最后一个工作日的10点15分0秒触发任务
0 15 10 ? * 5L         每个月最后一个星期四的10点15分0秒触发任务
0 15 10 ? * 5#3        每个月第三周的星期四的10点15分0秒触发任务
```
