/*
 * Copyright (C) 2020 The zfoo Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package com.zfoo.protocol.packet;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.zfoo.protocol.ProtocolManager;
import com.zfoo.protocol.util.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import org.junit.Ignore;
import org.junit.Test;

import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.zfoo.protocol.BenchmarkTesting.*;

/**
 * 主要来测试极端大的对象序列化和反序列化情况，极端大的对象指的是字段多，对象大，方法大
 */
public class VeryBigObject {

    @Ignore
    @Test
    public void veryBigObjectTest() {
        if (benchmark <= 0 || benchmark >= 10_0000_0000) {
            return;
        }

        ByteBuf buffer = new UnpooledHeapByteBuf(ByteBufAllocator.DEFAULT, 100, 10_0000);

        // 序列化和反序列化极端大的对象
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < benchmark; i++) {
            buffer.clear();
            ProtocolManager.write(buffer, VeryBigObject.veryBigObject);
            var packet = ProtocolManager.read(buffer);
        }

        System.out.println(StringUtils.format("[zfoo]     [超大对象] [thread:{}] [size:{}] [time:{}]", Thread.currentThread().getName(), buffer.writerIndex(), System.currentTimeMillis() - startTime));


        try {
            var kryo = kryos.get();

            var output = new Output(10_0000);
            var input = new Input(output.getBuffer());

            // 序列化和反序列化极端大的对象
            startTime = System.currentTimeMillis();
            for (int i = 0; i < benchmark; i++) {
                input.reset();
                output.reset();
                kryo.writeObject(output, VeryBigObject.veryBigObject);
                var mess = kryo.readObject(input, VeryBigObject.class);
            }
            System.out.println(StringUtils.format("[kryo]     [超大对象] [thread:{}] [size:{}] [time:{}]", Thread.currentThread().getName(), output.position(), System.currentTimeMillis() - startTime));
        } catch (Exception e) {
            e.printStackTrace();
        }

        veryBigObjectTest();
    }

    public byte a1;
    public Byte aa1;
    public byte[] aaa1;
    public Byte[] aaaa1;
    public short b1;
    public Short bb1;
    public short[] bbb1;
    public Short[] bbbb1;
    public int c1;
    public Integer cc1;
    public int[] ccc1;
    public Integer[] cccc1;
    public long d1;
    public Long dd1;
    public long[] ddd1;
    public Long[] dddd1;
    public float e1;
    public Float ee1;
    public float[] eee1;
    public Float[] eeee1;
    public double f1;
    public Double ff1;
    public double[] fff1;
    public Double[] ffff1;
    public boolean g1;
    public Boolean gg1;
    public boolean[] ggg1;
    public Boolean[] gggg1;
    public String jj1;
    public String[] jjj1;
    public ObjectA kk1;
    public ObjectA[] kkk1;
    public List<Integer> l1;
    public List<String> llll1;
    public Map<Integer, String> m1;
    public Map<Integer, ObjectA> mm1;
    public Set<Integer> s1;
    public Set<String> ssss1;
    public byte a2;
    public Byte aa2;
    public byte[] aaa2;
    public Byte[] aaaa2;
    public short b2;
    public Short bb2;
    public short[] bbb2;
    public Short[] bbbb2;
    public int c2;
    public Integer cc2;
    public int[] ccc2;
    public Integer[] cccc2;
    public long d2;
    public Long dd2;
    public long[] ddd2;
    public Long[] dddd2;
    public float e2;
    public Float ee2;
    public float[] eee2;
    public Float[] eeee2;
    public double f2;
    public Double ff2;
    public double[] fff2;
    public Double[] ffff2;
    public boolean g2;
    public Boolean gg2;
    public boolean[] ggg2;
    public Boolean[] gggg2;
    public String jj2;
    public String[] jjj2;
    public ObjectA kk2;
    public ObjectA[] kkk2;
    public List<Integer> l2;
    public List<String> llll2;
    public Map<Integer, String> m2;
    public Map<Integer, ObjectA> mm2;
    public Set<Integer> s2;
    public Set<String> ssss2;
    public byte a3;
    public Byte aa3;
    public byte[] aaa3;
    public Byte[] aaaa3;
    public short b3;
    public Short bb3;
    public short[] bbb3;
    public Short[] bbbb3;
    public int c3;
    public Integer cc3;
    public int[] ccc3;
    public Integer[] cccc3;
    public long d3;
    public Long dd3;
    public long[] ddd3;
    public Long[] dddd3;
    public float e3;
    public Float ee3;
    public float[] eee3;
    public Float[] eeee3;
    public double f3;
    public Double ff3;
    public double[] fff3;
    public Double[] ffff3;
    public boolean g3;
    public Boolean gg3;
    public boolean[] ggg3;
    public Boolean[] gggg3;
    public String jj3;
    public String[] jjj3;
    public ObjectA kk3;
    public ObjectA[] kkk3;
    public List<Integer> l3;
    public List<String> llll3;
    public Map<Integer, String> m3;
    public Map<Integer, ObjectA> mm3;
    public Set<Integer> s3;
    public Set<String> ssss3;
    public byte a4;
    public Byte aa4;
    public byte[] aaa4;
    public Byte[] aaaa4;
    public short b4;
    public Short bb4;
    public short[] bbb4;
    public Short[] bbbb4;
    public int c4;
    public Integer cc4;
    public int[] ccc4;
    public Integer[] cccc4;
    public long d4;
    public Long dd4;
    public long[] ddd4;
    public Long[] dddd4;
    public float e4;
    public Float ee4;
    public float[] eee4;
    public Float[] eeee4;
    public double f4;
    public Double ff4;
    public double[] fff4;
    public Double[] ffff4;
    public boolean g4;
    public Boolean gg4;
    public boolean[] ggg4;
    public Boolean[] gggg4;
    public String jj4;
    public String[] jjj4;
    public ObjectA kk4;
    public ObjectA[] kkk4;
    public List<Integer> l4;
    public List<String> llll4;
    public Map<Integer, String> m4;
    public Map<Integer, ObjectA> mm4;
    public Set<Integer> s4;
    public Set<String> ssss4;
    public byte a5;
    public Byte aa5;
    public byte[] aaa5;
    public Byte[] aaaa5;
    public short b5;
    public Short bb5;
    public short[] bbb5;
    public Short[] bbbb5;
    public int c5;
    public Integer cc5;
    public int[] ccc5;
    public Integer[] cccc5;
    public long d5;
    public Long dd5;
    public long[] ddd5;
    public Long[] dddd5;
    public float e5;
    public Float ee5;
    public float[] eee5;
    public Float[] eeee5;
    public double f5;
    public Double ff5;
    public double[] fff5;
    public Double[] ffff5;
    public boolean g5;
    public Boolean gg5;
    public boolean[] ggg5;
    public Boolean[] gggg5;
    public String jj5;
    public String[] jjj5;
    public ObjectA kk5;
    public ObjectA[] kkk5;
    public List<Integer> l5;
    public List<String> llll5;
    public Map<Integer, String> m5;
    public Map<Integer, ObjectA> mm5;
    public Set<Integer> s5;
    public Set<String> ssss5;
    public byte a6;
    public Byte aa6;
    public byte[] aaa6;
    public Byte[] aaaa6;
    public short b6;
    public Short bb6;
    public short[] bbb6;
    public Short[] bbbb6;
    public int c6;
    public Integer cc6;
    public int[] ccc6;
    public Integer[] cccc6;
    public long d6;
    public Long dd6;
    public long[] ddd6;
    public Long[] dddd6;
    public float e6;
    public Float ee6;
    public float[] eee6;
    public Float[] eeee6;
    public double f6;
    public Double ff6;
    public double[] fff6;
    public Double[] ffff6;
    public boolean g6;
    public Boolean gg6;
    public boolean[] ggg6;
    public Boolean[] gggg6;
    public String jj6;
    public String[] jjj6;
    public ObjectA kk6;
    public ObjectA[] kkk6;
    public List<Integer> l6;
    public List<String> llll6;
    public Map<Integer, String> m6;
    public Map<Integer, ObjectA> mm6;
    public Set<Integer> s6;
    public Set<String> ssss6;
    public byte a7;
    public Byte aa7;
    public byte[] aaa7;
    public Byte[] aaaa7;
    public short b7;
    public Short bb7;
    public short[] bbb7;
    public Short[] bbbb7;
    public int c7;
    public Integer cc7;
    public int[] ccc7;
    public Integer[] cccc7;
    public long d7;
    public Long dd7;
    public long[] ddd7;
    public Long[] dddd7;
    public float e7;
    public Float ee7;
    public float[] eee7;
    public Float[] eeee7;
    public double f7;
    public Double ff7;
    public double[] fff7;
    public Double[] ffff7;
    public boolean g7;
    public Boolean gg7;
    public boolean[] ggg7;
    public Boolean[] gggg7;
    public String jj7;
    public String[] jjj7;
    public ObjectA kk7;
    public ObjectA[] kkk7;
    public List<Integer> l7;
    public List<String> llll7;
    public Map<Integer, String> m7;
    public Map<Integer, ObjectA> mm7;
    public Set<Integer> s7;
    public Set<String> ssss7;
    public byte a8;
    public Byte aa8;
    public byte[] aaa8;
    public Byte[] aaaa8;
    public short b8;
    public Short bb8;
    public short[] bbb8;
    public Short[] bbbb8;
    public int c8;
    public Integer cc8;
    public int[] ccc8;
    public Integer[] cccc8;
    public long d8;
    public Long dd8;
    public long[] ddd8;
    public Long[] dddd8;
    public float e8;
    public Float ee8;
    public float[] eee8;
    public Float[] eeee8;
    public double f8;
    public Double ff8;
    public double[] fff8;
    public Double[] ffff8;
    public boolean g8;
    public Boolean gg8;
    public boolean[] ggg8;
    public Boolean[] gggg8;
    public String jj8;
    public String[] jjj8;
    public ObjectA kk8;
    public ObjectA[] kkk8;
    public List<Integer> l8;
    public List<String> llll8;
    public Map<Integer, String> m8;
    public Map<Integer, ObjectA> mm8;
    public Set<Integer> s8;
    public Set<String> ssss8;
    public byte a9;
    public Byte aa9;
    public byte[] aaa9;
    public Byte[] aaaa9;
    public short b9;
    public Short bb9;
    public short[] bbb9;
    public Short[] bbbb9;
    public int c9;
    public Integer cc9;
    public int[] ccc9;
    public Integer[] cccc9;
    public long d9;
    public Long dd9;
    public long[] ddd9;
    public Long[] dddd9;
    public float e9;
    public Float ee9;
    public float[] eee9;
    public Float[] eeee9;
    public double f9;
    public Double ff9;
    public double[] fff9;
    public Double[] ffff9;
    public boolean g9;
    public Boolean gg9;
    public boolean[] ggg9;
    public Boolean[] gggg9;
    public String jj9;
    public String[] jjj9;
    public ObjectA kk9;
    public ObjectA[] kkk9;
    public List<Integer> l9;
    public List<String> llll9;
    public Map<Integer, String> m9;
    public Map<Integer, ObjectA> mm9;
    public Set<Integer> s9;
    public Set<String> ssss9;
    public byte a10;
    public Byte aa10;
    public byte[] aaa10;
    public Byte[] aaaa10;
    public short b10;
    public Short bb10;
    public short[] bbb10;
    public Short[] bbbb10;
    public int c10;
    public Integer cc10;
    public int[] ccc10;
    public Integer[] cccc10;
    public long d10;
    public Long dd10;
    public long[] ddd10;
    public Long[] dddd10;
    public float e10;
    public Float ee10;
    public float[] eee10;
    public Float[] eeee10;
    public double f10;
    public Double ff10;
    public double[] fff10;
    public Double[] ffff10;
    public boolean g10;
    public Boolean gg10;
    public boolean[] ggg10;
    public Boolean[] gggg10;
    public String jj10;
    public String[] jjj10;
    public ObjectA kk10;
    public ObjectA[] kkk10;
    public List<Integer> l10;
    public List<String> llll10;
    public Map<Integer, String> m10;
    public Map<Integer, ObjectA> mm10;
    public Set<Integer> s10;
    public Set<String> ssss10;
    public byte a11;
    public Byte aa11;
    public byte[] aaa11;
    public Byte[] aaaa11;
    public short b11;
    public Short bb11;
    public short[] bbb11;
    public Short[] bbbb11;
    public int c11;
    public Integer cc11;
    public int[] ccc11;
    public Integer[] cccc11;
    public long d11;
    public Long dd11;
    public long[] ddd11;
    public Long[] dddd11;
    public float e11;
    public Float ee11;
    public float[] eee11;
    public Float[] eeee11;
    public double f11;
    public Double ff11;
    public double[] fff11;
    public Double[] ffff11;
    public boolean g11;
    public Boolean gg11;
    public boolean[] ggg11;
    public Boolean[] gggg11;
    public String jj11;
    public String[] jjj11;
    public ObjectA kk11;
    public ObjectA[] kkk11;
    public List<Integer> l11;
    public List<String> llll11;
    public Map<Integer, String> m11;
    public Map<Integer, ObjectA> mm11;
    public Set<Integer> s11;
    public Set<String> ssss11;
    public byte a12;
    public Byte aa12;
    public byte[] aaa12;
    public Byte[] aaaa12;
    public short b12;
    public Short bb12;
    public short[] bbb12;
    public Short[] bbbb12;
    public int c12;
    public Integer cc12;
    public int[] ccc12;
    public Integer[] cccc12;
    public long d12;
    public Long dd12;
    public long[] ddd12;
    public Long[] dddd12;
    public float e12;
    public Float ee12;
    public float[] eee12;
    public Float[] eeee12;
    public double f12;
    public Double ff12;
    public double[] fff12;
    public Double[] ffff12;
    public boolean g12;
    public Boolean gg12;
    public boolean[] ggg12;
    public Boolean[] gggg12;
    public String jj12;
    public String[] jjj12;
    public ObjectA kk12;
    public ObjectA[] kkk12;
    public List<Integer> l12;
    public List<String> llll12;
    public Map<Integer, String> m12;
    public Map<Integer, ObjectA> mm12;
    public Set<Integer> s12;
    public Set<String> ssss12;
    public byte a13;
    public Byte aa13;
    public byte[] aaa13;
    public Byte[] aaaa13;
    public short b13;
    public Short bb13;
    public short[] bbb13;
    public Short[] bbbb13;
    public int c13;
    public Integer cc13;
    public int[] ccc13;
    public Integer[] cccc13;
    public long d13;
    public Long dd13;
    public long[] ddd13;
    public Long[] dddd13;
    public float e13;
    public Float ee13;
    public float[] eee13;
    public Float[] eeee13;
    public double f13;
    public Double ff13;
    public double[] fff13;
    public Double[] ffff13;
    public boolean g13;
    public Boolean gg13;
    public boolean[] ggg13;
    public Boolean[] gggg13;
    public String jj13;
    public String[] jjj13;
    public ObjectA kk13;
    public ObjectA[] kkk13;
    public List<Integer> l13;
    public List<String> llll13;
    public Map<Integer, String> m13;
    public Map<Integer, ObjectA> mm13;
    public Set<Integer> s13;
    public Set<String> ssss13;
    public byte a14;
    public Byte aa14;
    public byte[] aaa14;
    public Byte[] aaaa14;
    public short b14;
    public Short bb14;
    public short[] bbb14;
    public Short[] bbbb14;
    public int c14;
    public Integer cc14;
    public int[] ccc14;
    public Integer[] cccc14;
    public long d14;
    public Long dd14;
    public long[] ddd14;
    public Long[] dddd14;
    public float e14;
    public Float ee14;
    public float[] eee14;
    public Float[] eeee14;
    public double f14;
    public Double ff14;
    public double[] fff14;
    public Double[] ffff14;
    public boolean g14;
    public Boolean gg14;
    public boolean[] ggg14;
    public Boolean[] gggg14;
    public String jj14;
    public String[] jjj14;
    public ObjectA kk14;
    public ObjectA[] kkk14;
    public List<Integer> l14;
    public List<String> llll14;
    public Map<Integer, String> m14;
    public Map<Integer, ObjectA> mm14;
    public Set<Integer> s14;
    public Set<String> ssss14;
    public byte a15;
    public Byte aa15;
    public byte[] aaa15;
    public Byte[] aaaa15;
    public short b15;
    public Short bb15;
    public short[] bbb15;
    public Short[] bbbb15;
    public int c15;
    public Integer cc15;
    public int[] ccc15;
    public Integer[] cccc15;
    public long d15;
    public Long dd15;
    public long[] ddd15;
    public Long[] dddd15;
    public float e15;
    public Float ee15;
    public float[] eee15;
    public Float[] eeee15;
    public double f15;
    public Double ff15;
    public double[] fff15;
    public Double[] ffff15;
    public boolean g15;
    public Boolean gg15;
    public boolean[] ggg15;
    public Boolean[] gggg15;
    public String jj15;
    public String[] jjj15;
    public ObjectA kk15;
    public ObjectA[] kkk15;
    public List<Integer> l15;
    public List<String> llll15;
    public Map<Integer, String> m15;
    public Map<Integer, ObjectA> mm15;
    public Set<Integer> s15;
    public Set<String> ssss15;
    public byte a16;
    public Byte aa16;
    public byte[] aaa16;
    public Byte[] aaaa16;
    public short b16;
    public Short bb16;
    public short[] bbb16;
    public Short[] bbbb16;
    public int c16;
    public Integer cc16;
    public int[] ccc16;
    public Integer[] cccc16;
    public long d16;
    public Long dd16;
    public long[] ddd16;
    public Long[] dddd16;
    public float e16;
    public Float ee16;
    public float[] eee16;
    public Float[] eeee16;
    public double f16;
    public Double ff16;
    public double[] fff16;
    public Double[] ffff16;
    public boolean g16;
    public Boolean gg16;
    public boolean[] ggg16;
    public Boolean[] gggg16;
    public String jj16;
    public String[] jjj16;
    public ObjectA kk16;
    public ObjectA[] kkk16;
    public List<Integer> l16;
    public List<String> llll16;
    public Map<Integer, String> m16;
    public Map<Integer, ObjectA> mm16;
    public Set<Integer> s16;
    public Set<String> ssss16;
    public byte a17;
    public Byte aa17;
    public byte[] aaa17;
    public Byte[] aaaa17;
    public short b17;
    public Short bb17;
    public short[] bbb17;
    public Short[] bbbb17;
    public int c17;
    public Integer cc17;
    public int[] ccc17;
    public Integer[] cccc17;
    public long d17;
    public Long dd17;
    public long[] ddd17;
    public Long[] dddd17;
    public float e17;
    public Float ee17;
    public float[] eee17;
    public Float[] eeee17;
    public double f17;
    public Double ff17;
    public double[] fff17;
    public Double[] ffff17;
    public boolean g17;
    public Boolean gg17;
    public boolean[] ggg17;
    public Boolean[] gggg17;
    public String jj17;
    public String[] jjj17;
    public ObjectA kk17;
    public ObjectA[] kkk17;
    public List<Integer> l17;
    public List<String> llll17;
    public Map<Integer, String> m17;
    public Map<Integer, ObjectA> mm17;
    public Set<Integer> s17;
    public Set<String> ssss17;
    public byte a18;
    public Byte aa18;
    public byte[] aaa18;
    public Byte[] aaaa18;
    public short b18;
    public Short bb18;
    public short[] bbb18;
    public Short[] bbbb18;
    public int c18;
    public Integer cc18;
    public int[] ccc18;
    public Integer[] cccc18;
    public long d18;
    public Long dd18;
    public long[] ddd18;
    public Long[] dddd18;
    public float e18;
    public Float ee18;
    public float[] eee18;
    public Float[] eeee18;
    public double f18;
    public Double ff18;
    public double[] fff18;
    public Double[] ffff18;
    public boolean g18;
    public Boolean gg18;
    public boolean[] ggg18;
    public Boolean[] gggg18;
    public String jj18;
    public String[] jjj18;
    public ObjectA kk18;
    public ObjectA[] kkk18;
    public List<Integer> l18;
    public List<String> llll18;
    public Map<Integer, String> m18;
    public Map<Integer, ObjectA> mm18;
    public Set<Integer> s18;
    public Set<String> ssss18;
    public byte a19;
    public Byte aa19;
    public byte[] aaa19;
    public Byte[] aaaa19;
    public short b19;
    public Short bb19;
    public short[] bbb19;
    public Short[] bbbb19;
    public int c19;
    public Integer cc19;
    public int[] ccc19;
    public Integer[] cccc19;
    public long d19;
    public Long dd19;
    public long[] ddd19;
    public Long[] dddd19;
    public float e19;
    public Float ee19;
    public float[] eee19;
    public Float[] eeee19;
    public double f19;
    public Double ff19;
    public double[] fff19;
    public Double[] ffff19;
    public boolean g19;
    public Boolean gg19;
    public boolean[] ggg19;
    public Boolean[] gggg19;
    public String jj19;
    public String[] jjj19;
    public ObjectA kk19;
    public ObjectA[] kkk19;
    public List<Integer> l19;
    public List<String> llll19;
    public Map<Integer, String> m19;
    public Map<Integer, ObjectA> mm19;
    public Set<Integer> s19;
    public Set<String> ssss19;
    public byte a20;
    public Byte aa20;
    public byte[] aaa20;
    public Byte[] aaaa20;
    public short b20;
    public Short bb20;
    public short[] bbb20;
    public Short[] bbbb20;
    public int c20;
    public Integer cc20;
    public int[] ccc20;
    public Integer[] cccc20;
    public long d20;
    public Long dd20;
    public long[] ddd20;
    public Long[] dddd20;
    public float e20;
    public Float ee20;
    public float[] eee20;
    public Float[] eeee20;
    public double f20;
    public Double ff20;
    public double[] fff20;
    public Double[] ffff20;
    public boolean g20;
    public Boolean gg20;
    public boolean[] ggg20;
    public Boolean[] gggg20;
    public String jj20;
    public String[] jjj20;
    public ObjectA kk20;
    public ObjectA[] kkk20;
    public List<Integer> l20;
    public List<String> llll20;
    public Map<Integer, String> m20;
    public Map<Integer, ObjectA> mm20;
    public Set<Integer> s20;
    public Set<String> ssss20;
    public byte a21;
    public Byte aa21;
    public byte[] aaa21;
    public Byte[] aaaa21;
    public short b21;
    public Short bb21;
    public short[] bbb21;
    public Short[] bbbb21;
    public int c21;
    public Integer cc21;
    public int[] ccc21;
    public Integer[] cccc21;
    public long d21;
    public Long dd21;
    public long[] ddd21;
    public Long[] dddd21;
    public float e21;
    public Float ee21;
    public float[] eee21;
    public Float[] eeee21;
    public double f21;
    public Double ff21;
    public double[] fff21;
    public Double[] ffff21;
    public boolean g21;
    public Boolean gg21;
    public boolean[] ggg21;
    public Boolean[] gggg21;
    public String jj21;
    public String[] jjj21;
    public ObjectA kk21;
    public ObjectA[] kkk21;
    public List<Integer> l21;
    public List<String> llll21;
    public Map<Integer, String> m21;
    public Map<Integer, ObjectA> mm21;
    public Set<Integer> s21;
    public Set<String> ssss21;
    public byte a22;
    public Byte aa22;
    public byte[] aaa22;
    public Byte[] aaaa22;
    public short b22;
    public Short bb22;
    public short[] bbb22;
    public Short[] bbbb22;
    public int c22;
    public Integer cc22;
    public int[] ccc22;
    public Integer[] cccc22;
    public long d22;
    public Long dd22;
    public long[] ddd22;
    public Long[] dddd22;
    public float e22;
    public Float ee22;
    public float[] eee22;
    public Float[] eeee22;
    public double f22;
    public Double ff22;
    public double[] fff22;
    public Double[] ffff22;
    public boolean g22;
    public Boolean gg22;
    public boolean[] ggg22;
    public Boolean[] gggg22;
    public String jj22;
    public String[] jjj22;
    public ObjectA kk22;
    public ObjectA[] kkk22;
    public List<Integer> l22;
    public List<String> llll22;
    public Map<Integer, String> m22;
    public Map<Integer, ObjectA> mm22;
    public Set<Integer> s22;
    public Set<String> ssss22;
    public byte a23;
    public Byte aa23;
    public byte[] aaa23;
    public Byte[] aaaa23;
    public short b23;
    public Short bb23;
    public short[] bbb23;
    public Short[] bbbb23;
    public int c23;
    public Integer cc23;
    public int[] ccc23;
    public Integer[] cccc23;
    public long d23;
    public Long dd23;
    public long[] ddd23;
    public Long[] dddd23;
    public float e23;
    public Float ee23;
    public float[] eee23;
    public Float[] eeee23;
    public double f23;
    public Double ff23;
    public double[] fff23;
    public Double[] ffff23;
    public boolean g23;
    public Boolean gg23;
    public boolean[] ggg23;
    public Boolean[] gggg23;
    public String jj23;
    public String[] jjj23;
    public ObjectA kk23;
    public ObjectA[] kkk23;
    public List<Integer> l23;
    public List<String> llll23;
    public Map<Integer, String> m23;
    public Map<Integer, ObjectA> mm23;
    public Set<Integer> s23;
    public Set<String> ssss23;
    public byte a24;
    public Byte aa24;
    public byte[] aaa24;
    public Byte[] aaaa24;
    public short b24;
    public Short bb24;
    public short[] bbb24;
    public Short[] bbbb24;
    public int c24;
    public Integer cc24;
    public int[] ccc24;
    public Integer[] cccc24;
    public long d24;
    public Long dd24;
    public long[] ddd24;
    public Long[] dddd24;
    public float e24;
    public Float ee24;
    public float[] eee24;
    public Float[] eeee24;
    public double f24;
    public Double ff24;
    public double[] fff24;
    public Double[] ffff24;
    public boolean g24;
    public Boolean gg24;
    public boolean[] ggg24;
    public Boolean[] gggg24;
    public String jj24;
    public String[] jjj24;
    public ObjectA kk24;
    public ObjectA[] kkk24;
    public List<Integer> l24;
    public List<String> llll24;
    public Map<Integer, String> m24;
    public Map<Integer, ObjectA> mm24;
    public Set<Integer> s24;
    public Set<String> ssss24;
    public byte a25;
    public Byte aa25;
    public byte[] aaa25;
    public Byte[] aaaa25;
    public short b25;
    public Short bb25;
    public short[] bbb25;
    public Short[] bbbb25;
    public int c25;
    public Integer cc25;
    public int[] ccc25;
    public Integer[] cccc25;
    public long d25;
    public Long dd25;
    public long[] ddd25;
    public Long[] dddd25;
    public float e25;
    public Float ee25;
    public float[] eee25;
    public Float[] eeee25;
    public double f25;
    public Double ff25;
    public double[] fff25;
    public Double[] ffff25;
    public boolean g25;
    public Boolean gg25;
    public boolean[] ggg25;
    public Boolean[] gggg25;
    public String jj25;
    public String[] jjj25;
    public ObjectA kk25;
    public ObjectA[] kkk25;
    public List<Integer> l25;
    public List<String> llll25;
    public Map<Integer, String> m25;
    public Map<Integer, ObjectA> mm25;
    public Set<Integer> s25;
    public Set<String> ssss25;
    public byte a26;
    public Byte aa26;
    public byte[] aaa26;
    public Byte[] aaaa26;
    public short b26;
    public Short bb26;
    public short[] bbb26;
    public Short[] bbbb26;
    public int c26;
    public Integer cc26;
    public int[] ccc26;
    public Integer[] cccc26;
    public long d26;
    public Long dd26;
    public long[] ddd26;
    public Long[] dddd26;
    public float e26;
    public Float ee26;
    public float[] eee26;
    public Float[] eeee26;
    public double f26;
    public Double ff26;
    public double[] fff26;
    public Double[] ffff26;
    public boolean g26;
    public Boolean gg26;
    public boolean[] ggg26;
    public Boolean[] gggg26;
    public String jj26;
    public String[] jjj26;
    public ObjectA kk26;
    public ObjectA[] kkk26;
    public List<Integer> l26;
    public List<String> llll26;
    public Map<Integer, String> m26;
    public Map<Integer, ObjectA> mm26;
    public Set<Integer> s26;
    public Set<String> ssss26;
    public byte a27;
    public Byte aa27;
    public byte[] aaa27;
    public Byte[] aaaa27;
    public short b27;
    public Short bb27;
    public short[] bbb27;
    public Short[] bbbb27;
    public int c27;
    public Integer cc27;
    public int[] ccc27;
    public Integer[] cccc27;
    public long d27;
    public Long dd27;
    public long[] ddd27;
    public Long[] dddd27;
    public float e27;
    public Float ee27;
    public float[] eee27;
    public Float[] eeee27;
    public double f27;
    public Double ff27;
    public double[] fff27;
    public Double[] ffff27;
    public boolean g27;
    public Boolean gg27;
    public boolean[] ggg27;
    public Boolean[] gggg27;
    public String jj27;
    public String[] jjj27;
    public ObjectA kk27;
    public ObjectA[] kkk27;
    public List<Integer> l27;
    public List<String> llll27;
    public Map<Integer, String> m27;
    public Map<Integer, ObjectA> mm27;
    public Set<Integer> s27;
    public Set<String> ssss27;
    public byte a28;
    public Byte aa28;
    public byte[] aaa28;
    public Byte[] aaaa28;
    public short b28;
    public Short bb28;
    public short[] bbb28;
    public Short[] bbbb28;
    public int c28;
    public Integer cc28;
    public int[] ccc28;
    public Integer[] cccc28;
    public long d28;
    public Long dd28;
    public long[] ddd28;
    public Long[] dddd28;
    public float e28;
    public Float ee28;
    public float[] eee28;
    public Float[] eeee28;
    public double f28;
    public Double ff28;
    public double[] fff28;
    public Double[] ffff28;
    public boolean g28;
    public Boolean gg28;
    public boolean[] ggg28;
    public Boolean[] gggg28;
    public String jj28;
    public String[] jjj28;
    public ObjectA kk28;
    public ObjectA[] kkk28;
    public List<Integer> l28;
    public List<String> llll28;
    public Map<Integer, String> m28;
    public Map<Integer, ObjectA> mm28;
    public Set<Integer> s28;
    public Set<String> ssss28;
    public byte a29;
    public Byte aa29;
    public byte[] aaa29;
    public Byte[] aaaa29;
    public short b29;
    public Short bb29;
    public short[] bbb29;
    public Short[] bbbb29;
    public int c29;
    public Integer cc29;
    public int[] ccc29;
    public Integer[] cccc29;
    public long d29;
    public Long dd29;
    public long[] ddd29;
    public Long[] dddd29;
    public float e29;
    public Float ee29;
    public float[] eee29;
    public Float[] eeee29;
    public double f29;
    public Double ff29;
    public double[] fff29;
    public Double[] ffff29;
    public boolean g29;
    public Boolean gg29;
    public boolean[] ggg29;
    public Boolean[] gggg29;
    public String jj29;
    public String[] jjj29;
    public ObjectA kk29;
    public ObjectA[] kkk29;
    public List<Integer> l29;
    public List<String> llll29;
    public Map<Integer, String> m29;
    public Map<Integer, ObjectA> mm29;
    public Set<Integer> s29;
    public Set<String> ssss29;
    public byte a30;
    public Byte aa30;
    public byte[] aaa30;
    public Byte[] aaaa30;
    public short b30;
    public Short bb30;
    public short[] bbb30;
    public Short[] bbbb30;
    public int c30;
    public Integer cc30;
    public int[] ccc30;
    public Integer[] cccc30;
    public long d30;
    public Long dd30;
    public long[] ddd30;
    public Long[] dddd30;
    public float e30;
    public Float ee30;
    public float[] eee30;
    public Float[] eeee30;
    public double f30;
    public Double ff30;
    public double[] fff30;
    public Double[] ffff30;
    public boolean g30;
    public Boolean gg30;
    public boolean[] ggg30;
    public Boolean[] gggg30;
    public String jj30;
    public String[] jjj30;
    public ObjectA kk30;
    public ObjectA[] kkk30;
    public List<Integer> l30;
    public List<String> llll30;
    public Map<Integer, String> m30;
    public Map<Integer, ObjectA> mm30;
    public Set<Integer> s30;
    public Set<String> ssss30;
    public byte a31;
    public Byte aa31;
    public byte[] aaa31;
    public Byte[] aaaa31;
    public short b31;
    public Short bb31;
    public short[] bbb31;
    public Short[] bbbb31;
    public int c31;
    public Integer cc31;
    public int[] ccc31;
    public Integer[] cccc31;
    public long d31;
    public Long dd31;
    public long[] ddd31;
    public Long[] dddd31;
    public float e31;
    public Float ee31;
    public float[] eee31;
    public Float[] eeee31;
    public double f31;
    public Double ff31;
    public double[] fff31;
    public Double[] ffff31;
    public boolean g31;
    public Boolean gg31;
    public boolean[] ggg31;
    public Boolean[] gggg31;
    public String jj31;
    public String[] jjj31;
    public ObjectA kk31;
    public ObjectA[] kkk31;
    public List<Integer> l31;
    public List<String> llll31;
    public Map<Integer, String> m31;
    public Map<Integer, ObjectA> mm31;
    public Set<Integer> s31;
    public Set<String> ssss31;
    public byte a32;
    public Byte aa32;
    public byte[] aaa32;
    public Byte[] aaaa32;
    public short b32;
    public Short bb32;
    public short[] bbb32;
    public Short[] bbbb32;
    public int c32;
    public Integer cc32;
    public int[] ccc32;
    public Integer[] cccc32;
    public long d32;
    public Long dd32;
    public long[] ddd32;
    public Long[] dddd32;
    public float e32;
    public Float ee32;
    public float[] eee32;
    public Float[] eeee32;
    public double f32;
    public Double ff32;
    public double[] fff32;
    public Double[] ffff32;
    public boolean g32;
    public Boolean gg32;
    public boolean[] ggg32;
    public Boolean[] gggg32;
    public String jj32;
    public String[] jjj32;
    public ObjectA kk32;
    public ObjectA[] kkk32;
    public List<Integer> l32;
    public List<String> llll32;
    public Map<Integer, String> m32;
    public Map<Integer, ObjectA> mm32;
    public Set<Integer> s32;
    public Set<String> ssss32;
    public byte a33;
    public Byte aa33;
    public byte[] aaa33;
    public Byte[] aaaa33;
    public short b33;
    public Short bb33;
    public short[] bbb33;
    public Short[] bbbb33;
    public int c33;
    public Integer cc33;
    public int[] ccc33;
    public Integer[] cccc33;
    public long d33;
    public Long dd33;
    public long[] ddd33;
    public Long[] dddd33;
    public float e33;
    public Float ee33;
    public float[] eee33;
    public Float[] eeee33;
    public double f33;
    public Double ff33;
    public double[] fff33;
    public Double[] ffff33;
    public boolean g33;
    public Boolean gg33;
    public boolean[] ggg33;
    public Boolean[] gggg33;
    public String jj33;
    public String[] jjj33;
    public ObjectA kk33;
    public ObjectA[] kkk33;
    public List<Integer> l33;
    public List<String> llll33;
    public Map<Integer, String> m33;
    public Map<Integer, ObjectA> mm33;
    public Set<Integer> s33;
    public Set<String> ssss33;
    public byte a34;
    public Byte aa34;
    public byte[] aaa34;
    public Byte[] aaaa34;
    public short b34;
    public Short bb34;
    public short[] bbb34;
    public Short[] bbbb34;
    public int c34;
    public Integer cc34;
    public int[] ccc34;
    public Integer[] cccc34;
    public long d34;
    public Long dd34;
    public long[] ddd34;
    public Long[] dddd34;
    public float e34;
    public Float ee34;
    public float[] eee34;
    public Float[] eeee34;
    public double f34;
    public Double ff34;
    public double[] fff34;
    public Double[] ffff34;
    public boolean g34;
    public Boolean gg34;
    public boolean[] ggg34;
    public Boolean[] gggg34;
    public String jj34;
    public String[] jjj34;
    public ObjectA kk34;
    public ObjectA[] kkk34;
    public List<Integer> l34;
    public List<String> llll34;
    public Map<Integer, String> m34;
    public Map<Integer, ObjectA> mm34;
    public Set<Integer> s34;
    public Set<String> ssss34;
    public byte a35;
    public Byte aa35;
    public byte[] aaa35;
    public Byte[] aaaa35;
    public short b35;
    public Short bb35;
    public short[] bbb35;
    public Short[] bbbb35;
    public int c35;
    public Integer cc35;
    public int[] ccc35;
    public Integer[] cccc35;
    public long d35;
    public Long dd35;
    public long[] ddd35;
    public Long[] dddd35;
    public float e35;
    public Float ee35;
    public float[] eee35;
    public Float[] eeee35;
    public double f35;
    public Double ff35;
    public double[] fff35;
    public Double[] ffff35;
    public boolean g35;
    public Boolean gg35;
    public boolean[] ggg35;
    public Boolean[] gggg35;
    public String jj35;
    public String[] jjj35;
    public ObjectA kk35;
    public ObjectA[] kkk35;
    public List<Integer> l35;
    public List<String> llll35;
    public Map<Integer, String> m35;
    public Map<Integer, ObjectA> mm35;
    public Set<Integer> s35;
    public Set<String> ssss35;
    public byte a36;
    public Byte aa36;
    public byte[] aaa36;
    public Byte[] aaaa36;
    public short b36;
    public Short bb36;
    public short[] bbb36;
    public Short[] bbbb36;
    public int c36;
    public Integer cc36;
    public int[] ccc36;
    public Integer[] cccc36;
    public long d36;
    public Long dd36;
    public long[] ddd36;
    public Long[] dddd36;
    public float e36;
    public Float ee36;
    public float[] eee36;
    public Float[] eeee36;
    public double f36;
    public Double ff36;
    public double[] fff36;
    public Double[] ffff36;
    public boolean g36;
    public Boolean gg36;
    public boolean[] ggg36;
    public Boolean[] gggg36;
    public String jj36;
    public String[] jjj36;
    public ObjectA kk36;
    public ObjectA[] kkk36;
    public List<Integer> l36;
    public List<String> llll36;
    public Map<Integer, String> m36;
    public Map<Integer, ObjectA> mm36;
    public Set<Integer> s36;
    public Set<String> ssss36;
    public byte a37;
    public Byte aa37;
    public byte[] aaa37;
    public Byte[] aaaa37;
    public short b37;
    public Short bb37;
    public short[] bbb37;
    public Short[] bbbb37;
    public int c37;
    public Integer cc37;
    public int[] ccc37;
    public Integer[] cccc37;
    public long d37;
    public Long dd37;
    public long[] ddd37;
    public Long[] dddd37;
    public float e37;
    public Float ee37;
    public float[] eee37;
    public Float[] eeee37;
    public double f37;
    public Double ff37;
    public double[] fff37;
    public Double[] ffff37;
    public boolean g37;
    public Boolean gg37;
    public boolean[] ggg37;
    public Boolean[] gggg37;
    public String jj37;
    public String[] jjj37;
    public ObjectA kk37;
    public ObjectA[] kkk37;
    public List<Integer> l37;
    public List<String> llll37;
    public Map<Integer, String> m37;
    public Map<Integer, ObjectA> mm37;
    public Set<Integer> s37;
    public Set<String> ssss37;
    public byte a38;
    public Byte aa38;
    public byte[] aaa38;
    public Byte[] aaaa38;
    public short b38;
    public Short bb38;
    public short[] bbb38;
    public Short[] bbbb38;
    public int c38;
    public Integer cc38;
    public int[] ccc38;
    public Integer[] cccc38;
    public long d38;
    public Long dd38;
    public long[] ddd38;
    public Long[] dddd38;
    public float e38;
    public Float ee38;
    public float[] eee38;
    public Float[] eeee38;
    public double f38;
    public Double ff38;
    public double[] fff38;
    public Double[] ffff38;
    public boolean g38;
    public Boolean gg38;
    public boolean[] ggg38;
    public Boolean[] gggg38;
    public String jj38;
    public String[] jjj38;
    public ObjectA kk38;
    public ObjectA[] kkk38;
    public List<Integer> l38;
    public List<String> llll38;
    public Map<Integer, String> m38;
    public Map<Integer, ObjectA> mm38;
    public Set<Integer> s38;
    public Set<String> ssss38;
    public byte a39;
    public Byte aa39;
    public byte[] aaa39;
    public Byte[] aaaa39;
    public short b39;
    public Short bb39;
    public short[] bbb39;
    public Short[] bbbb39;
    public int c39;
    public Integer cc39;
    public int[] ccc39;
    public Integer[] cccc39;
    public long d39;
    public Long dd39;
    public long[] ddd39;
    public Long[] dddd39;
    public float e39;
    public Float ee39;
    public float[] eee39;
    public Float[] eeee39;
    public double f39;
    public Double ff39;
    public double[] fff39;
    public Double[] ffff39;
    public boolean g39;
    public Boolean gg39;
    public boolean[] ggg39;
    public Boolean[] gggg39;
    public String jj39;
    public String[] jjj39;
    public ObjectA kk39;
    public ObjectA[] kkk39;
    public List<Integer> l39;
    public List<String> llll39;
    public Map<Integer, String> m39;
    public Map<Integer, ObjectA> mm39;
    public Set<Integer> s39;
    public Set<String> ssss39;
    public byte a40;
    public Byte aa40;
    public byte[] aaa40;
    public Byte[] aaaa40;
    public short b40;
    public Short bb40;
    public short[] bbb40;
    public Short[] bbbb40;
    public int c40;
    public Integer cc40;
    public int[] ccc40;
    public Integer[] cccc40;
    public long d40;
    public Long dd40;
    public long[] ddd40;
    public Long[] dddd40;
    public float e40;
    public Float ee40;
    public float[] eee40;
    public Float[] eeee40;
    public double f40;
    public Double ff40;
    public double[] fff40;
    public Double[] ffff40;
    public boolean g40;
    public Boolean gg40;
    public boolean[] ggg40;
    public Boolean[] gggg40;
    public String jj40;
    public String[] jjj40;
    public ObjectA kk40;
    public ObjectA[] kkk40;
    public List<Integer> l40;
    public List<String> llll40;
    public Map<Integer, String> m40;
    public Map<Integer, ObjectA> mm40;
    public Set<Integer> s40;
    public Set<String> ssss40;
    public byte a41;
    public Byte aa41;
    public byte[] aaa41;
    public Byte[] aaaa41;
    public short b41;
    public Short bb41;
    public short[] bbb41;
    public Short[] bbbb41;
    public int c41;
    public Integer cc41;
    public int[] ccc41;
    public Integer[] cccc41;
    public long d41;
    public Long dd41;
    public long[] ddd41;
    public Long[] dddd41;
    public float e41;
    public Float ee41;
    public float[] eee41;
    public Float[] eeee41;
    public double f41;
    public Double ff41;
    public double[] fff41;
    public Double[] ffff41;
    public boolean g41;
    public Boolean gg41;
    public boolean[] ggg41;
    public Boolean[] gggg41;
    public String jj41;
    public String[] jjj41;
    public ObjectA kk41;
    public ObjectA[] kkk41;
    public List<Integer> l41;
    public List<String> llll41;
    public Map<Integer, String> m41;
    public Map<Integer, ObjectA> mm41;
    public Set<Integer> s41;
    public Set<String> ssss41;
    public byte a42;
    public Byte aa42;
    public byte[] aaa42;
    public Byte[] aaaa42;
    public short b42;
    public Short bb42;
    public short[] bbb42;
    public Short[] bbbb42;
    public int c42;
    public Integer cc42;
    public int[] ccc42;
    public Integer[] cccc42;
    public long d42;
    public Long dd42;
    public long[] ddd42;
    public Long[] dddd42;
    public float e42;
    public Float ee42;
    public float[] eee42;
    public Float[] eeee42;
    public double f42;
    public Double ff42;
    public double[] fff42;
    public Double[] ffff42;
    public boolean g42;
    public Boolean gg42;
    public boolean[] ggg42;
    public Boolean[] gggg42;
    public String jj42;
    public String[] jjj42;
    public ObjectA kk42;
    public ObjectA[] kkk42;
    public List<Integer> l42;
    public List<String> llll42;
    public Map<Integer, String> m42;
    public Map<Integer, ObjectA> mm42;
    public Set<Integer> s42;
    public Set<String> ssss42;
    public byte a43;
    public Byte aa43;
    public byte[] aaa43;
    public Byte[] aaaa43;
    public short b43;
    public Short bb43;
    public short[] bbb43;
    public Short[] bbbb43;
    public int c43;
    public Integer cc43;
    public int[] ccc43;
    public Integer[] cccc43;
    public long d43;
    public Long dd43;
    public long[] ddd43;
    public Long[] dddd43;
    public float e43;
    public Float ee43;
    public float[] eee43;
    public Float[] eeee43;
    public double f43;
    public Double ff43;
    public double[] fff43;
    public Double[] ffff43;
    public boolean g43;
    public Boolean gg43;
    public boolean[] ggg43;
    public Boolean[] gggg43;
    public String jj43;
    public String[] jjj43;
    public ObjectA kk43;
    public ObjectA[] kkk43;
    public List<Integer> l43;
    public List<String> llll43;
    public Map<Integer, String> m43;
    public Map<Integer, ObjectA> mm43;
    public Set<Integer> s43;
    public Set<String> ssss43;
    public byte a44;
    public Byte aa44;
    public byte[] aaa44;
    public Byte[] aaaa44;
    public short b44;
    public Short bb44;
    public short[] bbb44;
    public Short[] bbbb44;
    public int c44;
    public Integer cc44;
    public int[] ccc44;
    public Integer[] cccc44;
    public long d44;
    public Long dd44;
    public long[] ddd44;
    public Long[] dddd44;
    public float e44;
    public Float ee44;
    public float[] eee44;
    public Float[] eeee44;
    public double f44;
    public Double ff44;
    public double[] fff44;
    public Double[] ffff44;
    public boolean g44;
    public Boolean gg44;
    public boolean[] ggg44;
    public Boolean[] gggg44;
    public String jj44;
    public String[] jjj44;
    public ObjectA kk44;
    public ObjectA[] kkk44;
    public List<Integer> l44;
    public List<String> llll44;
    public Map<Integer, String> m44;
    public Map<Integer, ObjectA> mm44;
    public Set<Integer> s44;
    public Set<String> ssss44;
    public byte a45;
    public Byte aa45;
    public byte[] aaa45;
    public Byte[] aaaa45;
    public short b45;
    public Short bb45;
    public short[] bbb45;
    public Short[] bbbb45;
    public int c45;
    public Integer cc45;
    public int[] ccc45;
    public Integer[] cccc45;
    public long d45;
    public Long dd45;
    public long[] ddd45;
    public Long[] dddd45;
    public float e45;
    public Float ee45;
    public float[] eee45;
    public Float[] eeee45;
    public double f45;
    public Double ff45;
    public double[] fff45;
    public Double[] ffff45;
    public boolean g45;
    public Boolean gg45;
    public boolean[] ggg45;
    public Boolean[] gggg45;
    public String jj45;
    public String[] jjj45;
    public ObjectA kk45;
    public ObjectA[] kkk45;
    public List<Integer> l45;
    public List<String> llll45;
    public Map<Integer, String> m45;
    public Map<Integer, ObjectA> mm45;
    public Set<Integer> s45;
    public Set<String> ssss45;
    public byte a46;
    public Byte aa46;
    public byte[] aaa46;
    public Byte[] aaaa46;
    public short b46;
    public Short bb46;
    public short[] bbb46;
    public Short[] bbbb46;
    public int c46;
    public Integer cc46;
    public int[] ccc46;
    public Integer[] cccc46;
    public long d46;
    public Long dd46;
    public long[] ddd46;
    public Long[] dddd46;
    public float e46;
    public Float ee46;
    public float[] eee46;
    public Float[] eeee46;
    public double f46;
    public Double ff46;
    public double[] fff46;
    public Double[] ffff46;
    public boolean g46;
    public Boolean gg46;
    public boolean[] ggg46;
    public Boolean[] gggg46;
    public String jj46;
    public String[] jjj46;
    public ObjectA kk46;
    public ObjectA[] kkk46;
    public List<Integer> l46;
    public List<String> llll46;
    public Map<Integer, String> m46;
    public Map<Integer, ObjectA> mm46;
    public Set<Integer> s46;
    public Set<String> ssss46;
    public byte a47;
    public Byte aa47;
    public byte[] aaa47;
    public Byte[] aaaa47;
    public short b47;
    public Short bb47;
    public short[] bbb47;
    public Short[] bbbb47;
    public int c47;
    public Integer cc47;
    public int[] ccc47;
    public Integer[] cccc47;
    public long d47;
    public Long dd47;
    public long[] ddd47;
    public Long[] dddd47;
    public float e47;
    public Float ee47;
    public float[] eee47;
    public Float[] eeee47;
    public double f47;
    public Double ff47;
    public double[] fff47;
    public Double[] ffff47;
    public boolean g47;
    public Boolean gg47;
    public boolean[] ggg47;
    public Boolean[] gggg47;
    public String jj47;
    public String[] jjj47;
    public ObjectA kk47;
    public ObjectA[] kkk47;
    public List<Integer> l47;
    public List<String> llll47;
    public Map<Integer, String> m47;
    public Map<Integer, ObjectA> mm47;
    public Set<Integer> s47;
    public Set<String> ssss47;
    public byte a48;
    public Byte aa48;
    public byte[] aaa48;
    public Byte[] aaaa48;
    public short b48;
    public Short bb48;
    public short[] bbb48;
    public Short[] bbbb48;
    public int c48;
    public Integer cc48;
    public int[] ccc48;
    public Integer[] cccc48;
    public long d48;
    public Long dd48;
    public long[] ddd48;
    public Long[] dddd48;
    public float e48;
    public Float ee48;
    public float[] eee48;
    public Float[] eeee48;
    public double f48;
    public Double ff48;
    public double[] fff48;
    public Double[] ffff48;
    public boolean g48;
    public Boolean gg48;
    public boolean[] ggg48;
    public Boolean[] gggg48;
    public String jj48;
    public String[] jjj48;
    public ObjectA kk48;
    public ObjectA[] kkk48;
    public List<Integer> l48;
    public List<String> llll48;
    public Map<Integer, String> m48;
    public Map<Integer, ObjectA> mm48;
    public Set<Integer> s48;
    public Set<String> ssss48;
    public byte a49;
    public Byte aa49;
    public byte[] aaa49;
    public Byte[] aaaa49;
    public short b49;
    public Short bb49;
    public short[] bbb49;
    public Short[] bbbb49;
    public int c49;
    public Integer cc49;
    public int[] ccc49;
    public Integer[] cccc49;
    public long d49;
    public Long dd49;
    public long[] ddd49;
    public Long[] dddd49;
    public float e49;
    public Float ee49;
    public float[] eee49;
    public Float[] eeee49;
    public double f49;
    public Double ff49;
    public double[] fff49;
    public Double[] ffff49;
    public boolean g49;
    public Boolean gg49;
    public boolean[] ggg49;
    public Boolean[] gggg49;
    public String jj49;
    public String[] jjj49;
    public ObjectA kk49;
    public ObjectA[] kkk49;
    public List<Integer> l49;
    public List<String> llll49;
    public Map<Integer, String> m49;
    public Map<Integer, ObjectA> mm49;
    public Set<Integer> s49;
    public Set<String> ssss49;
    public byte a50;
    public Byte aa50;
    public byte[] aaa50;
    public Byte[] aaaa50;
    public short b50;
    public Short bb50;
    public short[] bbb50;
    public Short[] bbbb50;
    public int c50;
    public Integer cc50;
    public int[] ccc50;
    public Integer[] cccc50;
    public long d50;
    public Long dd50;
    public long[] ddd50;
    public Long[] dddd50;
    public float e50;
    public Float ee50;
    public float[] eee50;
    public Float[] eeee50;
    public double f50;
    public Double ff50;
    public double[] fff50;
    public Double[] ffff50;
    public boolean g50;
    public Boolean gg50;
    public boolean[] ggg50;
    public Boolean[] gggg50;
    public String jj50;
    public String[] jjj50;
    public ObjectA kk50;
    public ObjectA[] kkk50;
    public List<Integer> l50;
    public List<String> llll50;
    public Map<Integer, String> m50;
    public Map<Integer, ObjectA> mm50;
    public Set<Integer> s50;
    public Set<String> ssss50;
    public byte a51;
    public Byte aa51;
    public byte[] aaa51;
    public Byte[] aaaa51;
    public short b51;
    public Short bb51;
    public short[] bbb51;
    public Short[] bbbb51;
    public int c51;
    public Integer cc51;
    public int[] ccc51;
    public Integer[] cccc51;
    public long d51;
    public Long dd51;
    public long[] ddd51;
    public Long[] dddd51;
    public float e51;
    public Float ee51;
    public float[] eee51;
    public Float[] eeee51;
    public double f51;
    public Double ff51;
    public double[] fff51;
    public Double[] ffff51;
    public boolean g51;
    public Boolean gg51;
    public boolean[] ggg51;
    public Boolean[] gggg51;
    public String jj51;
    public String[] jjj51;
    public ObjectA kk51;
    public ObjectA[] kkk51;
    public List<Integer> l51;
    public List<String> llll51;
    public Map<Integer, String> m51;
    public Map<Integer, ObjectA> mm51;
    public Set<Integer> s51;
    public Set<String> ssss51;
    public byte a52;
    public Byte aa52;
    public byte[] aaa52;
    public Byte[] aaaa52;
    public short b52;
    public Short bb52;
    public short[] bbb52;
    public Short[] bbbb52;
    public int c52;
    public Integer cc52;
    public int[] ccc52;
    public Integer[] cccc52;
    public long d52;
    public Long dd52;
    public long[] ddd52;
    public Long[] dddd52;
    public float e52;
    public Float ee52;
    public float[] eee52;
    public Float[] eeee52;
    public double f52;
    public Double ff52;
    public double[] fff52;
    public Double[] ffff52;
    public boolean g52;
    public Boolean gg52;
    public boolean[] ggg52;
    public Boolean[] gggg52;
    public String jj52;
    public String[] jjj52;
    public ObjectA kk52;
    public ObjectA[] kkk52;
    public List<Integer> l52;
    public List<String> llll52;
    public Map<Integer, String> m52;
    public Map<Integer, ObjectA> mm52;
    public Set<Integer> s52;
    public Set<String> ssss52;
    public byte a53;
    public Byte aa53;
    public byte[] aaa53;
    public Byte[] aaaa53;
    public short b53;
    public Short bb53;
    public short[] bbb53;
    public Short[] bbbb53;
    public int c53;
    public Integer cc53;
    public int[] ccc53;
    public Integer[] cccc53;
    public long d53;
    public Long dd53;
    public long[] ddd53;
    public Long[] dddd53;
    public float e53;
    public Float ee53;
    public float[] eee53;
    public Float[] eeee53;
    public double f53;
    public Double ff53;
    public double[] fff53;
    public Double[] ffff53;
    public boolean g53;
    public Boolean gg53;
    public boolean[] ggg53;
    public Boolean[] gggg53;
    public String jj53;
    public String[] jjj53;
    public ObjectA kk53;
    public ObjectA[] kkk53;
    public List<Integer> l53;
    public List<String> llll53;
    public Map<Integer, String> m53;
    public Map<Integer, ObjectA> mm53;
    public Set<Integer> s53;
    public Set<String> ssss53;
    public byte a54;
    public Byte aa54;
    public byte[] aaa54;
    public Byte[] aaaa54;
    public short b54;
    public Short bb54;
    public short[] bbb54;
    public Short[] bbbb54;
    public int c54;
    public Integer cc54;
    public int[] ccc54;
    public Integer[] cccc54;
    public long d54;
    public Long dd54;
    public long[] ddd54;
    public Long[] dddd54;
    public float e54;
    public Float ee54;
    public float[] eee54;
    public Float[] eeee54;
    public double f54;
    public Double ff54;
    public double[] fff54;
    public Double[] ffff54;
    public boolean g54;
    public Boolean gg54;
    public boolean[] ggg54;
    public Boolean[] gggg54;
    public String jj54;
    public String[] jjj54;
    public ObjectA kk54;
    public ObjectA[] kkk54;
    public List<Integer> l54;
    public List<String> llll54;
    public Map<Integer, String> m54;
    public Map<Integer, ObjectA> mm54;
    public Set<Integer> s54;
    public Set<String> ssss54;
    public byte a55;
    public Byte aa55;
    public byte[] aaa55;
    public Byte[] aaaa55;
    public short b55;
    public Short bb55;
    public short[] bbb55;
    public Short[] bbbb55;
    public int c55;
    public Integer cc55;
    public int[] ccc55;
    public Integer[] cccc55;
    public long d55;
    public Long dd55;
    public long[] ddd55;
    public Long[] dddd55;
    public float e55;
    public Float ee55;
    public float[] eee55;
    public Float[] eeee55;
    public double f55;
    public Double ff55;
    public double[] fff55;
    public Double[] ffff55;
    public boolean g55;
    public Boolean gg55;
    public boolean[] ggg55;
    public Boolean[] gggg55;
    public String jj55;
    public String[] jjj55;
    public ObjectA kk55;
    public ObjectA[] kkk55;
    public List<Integer> l55;
    public List<String> llll55;
    public Map<Integer, String> m55;
    public Map<Integer, ObjectA> mm55;
    public Set<Integer> s55;
    public Set<String> ssss55;
    public byte a56;
    public Byte aa56;
    public byte[] aaa56;
    public Byte[] aaaa56;
    public short b56;
    public Short bb56;
    public short[] bbb56;
    public Short[] bbbb56;
    public int c56;
    public Integer cc56;
    public int[] ccc56;
    public Integer[] cccc56;
    public long d56;
    public Long dd56;
    public long[] ddd56;
    public Long[] dddd56;
    public float e56;
    public Float ee56;
    public float[] eee56;
    public Float[] eeee56;
    public double f56;
    public Double ff56;
    public double[] fff56;
    public Double[] ffff56;
    public boolean g56;
    public Boolean gg56;
    public boolean[] ggg56;
    public Boolean[] gggg56;
    public String jj56;
    public String[] jjj56;
    public ObjectA kk56;
    public ObjectA[] kkk56;
    public List<Integer> l56;
    public List<String> llll56;
    public Map<Integer, String> m56;
    public Map<Integer, ObjectA> mm56;
    public Set<Integer> s56;
    public Set<String> ssss56;
    public byte a57;
    public Byte aa57;
    public byte[] aaa57;
    public Byte[] aaaa57;
    public short b57;
    public Short bb57;
    public short[] bbb57;
    public Short[] bbbb57;
    public int c57;
    public Integer cc57;
    public int[] ccc57;
    public Integer[] cccc57;
    public long d57;
    public Long dd57;
    public long[] ddd57;
    public Long[] dddd57;
    public float e57;
    public Float ee57;
    public float[] eee57;
    public Float[] eeee57;
    public double f57;
    public Double ff57;
    public double[] fff57;
    public Double[] ffff57;
    public boolean g57;
    public Boolean gg57;
    public boolean[] ggg57;
    public Boolean[] gggg57;
    public String jj57;
    public String[] jjj57;
    public ObjectA kk57;
    public ObjectA[] kkk57;
    public List<Integer> l57;
    public List<String> llll57;
    public Map<Integer, String> m57;
    public Map<Integer, ObjectA> mm57;
    public Set<Integer> s57;
    public Set<String> ssss57;
    public byte a58;
    public Byte aa58;
    public byte[] aaa58;
    public Byte[] aaaa58;
    public short b58;
    public Short bb58;
    public short[] bbb58;
    public Short[] bbbb58;
    public int c58;
    public Integer cc58;
    public int[] ccc58;
    public Integer[] cccc58;
    public long d58;
    public Long dd58;
    public long[] ddd58;
    public Long[] dddd58;
    public float e58;
    public Float ee58;
    public float[] eee58;
    public Float[] eeee58;
    public double f58;
    public Double ff58;
    public double[] fff58;
    public Double[] ffff58;
    public boolean g58;
    public Boolean gg58;
    public boolean[] ggg58;
    public Boolean[] gggg58;
    public String jj58;
    public String[] jjj58;
    public ObjectA kk58;
    public ObjectA[] kkk58;
    public List<Integer> l58;
    public List<String> llll58;
    public Map<Integer, String> m58;
    public Map<Integer, ObjectA> mm58;
    public Set<Integer> s58;
    public Set<String> ssss58;
    public byte a59;
    public Byte aa59;
    public byte[] aaa59;
    public Byte[] aaaa59;
    public short b59;
    public Short bb59;
    public short[] bbb59;
    public Short[] bbbb59;
    public int c59;
    public Integer cc59;
    public int[] ccc59;
    public Integer[] cccc59;
    public long d59;
    public Long dd59;
    public long[] ddd59;
    public Long[] dddd59;
    public float e59;
    public Float ee59;
    public float[] eee59;
    public Float[] eeee59;
    public double f59;
    public Double ff59;
    public double[] fff59;
    public Double[] ffff59;
    public boolean g59;
    public Boolean gg59;
    public boolean[] ggg59;
    public Boolean[] gggg59;
    public String jj59;
    public String[] jjj59;
    public ObjectA kk59;
    public ObjectA[] kkk59;
    public List<Integer> l59;
    public List<String> llll59;
    public Map<Integer, String> m59;
    public Map<Integer, ObjectA> mm59;
    public Set<Integer> s59;
    public Set<String> ssss59;
    public byte a60;
    public Byte aa60;
    public byte[] aaa60;
    public Byte[] aaaa60;
    public short b60;
    public Short bb60;
    public short[] bbb60;
    public Short[] bbbb60;
    public int c60;
    public Integer cc60;
    public int[] ccc60;
    public Integer[] cccc60;
    public long d60;
    public Long dd60;
    public long[] ddd60;
    public Long[] dddd60;
    public float e60;
    public Float ee60;
    public float[] eee60;
    public Float[] eeee60;
    public double f60;
    public Double ff60;
    public double[] fff60;
    public Double[] ffff60;
    public boolean g60;
    public Boolean gg60;
    public boolean[] ggg60;
    public Boolean[] gggg60;
    public String jj60;
    public String[] jjj60;
    public ObjectA kk60;
    public ObjectA[] kkk60;
    public List<Integer> l60;
    public List<String> llll60;
    public Map<Integer, String> m60;
    public Map<Integer, ObjectA> mm60;
    public Set<Integer> s60;
    public Set<String> ssss60;
    public byte a61;
    public Byte aa61;
    public byte[] aaa61;
    public Byte[] aaaa61;
    public short b61;
    public Short bb61;
    public short[] bbb61;
    public Short[] bbbb61;
    public int c61;
    public Integer cc61;
    public int[] ccc61;
    public Integer[] cccc61;
    public long d61;
    public Long dd61;
    public long[] ddd61;
    public Long[] dddd61;
    public float e61;
    public Float ee61;
    public float[] eee61;
    public Float[] eeee61;
    public double f61;
    public Double ff61;
    public double[] fff61;
    public Double[] ffff61;
    public boolean g61;
    public Boolean gg61;
    public boolean[] ggg61;
    public Boolean[] gggg61;
    public String jj61;
    public String[] jjj61;
    public ObjectA kk61;
    public ObjectA[] kkk61;
    public List<Integer> l61;
    public List<String> llll61;
    public Map<Integer, String> m61;
    public Map<Integer, ObjectA> mm61;
    public Set<Integer> s61;
    public Set<String> ssss61;
    public byte a62;
    public Byte aa62;
    public byte[] aaa62;
    public Byte[] aaaa62;
    public short b62;
    public Short bb62;
    public short[] bbb62;
    public Short[] bbbb62;
    public int c62;
    public Integer cc62;
    public int[] ccc62;
    public Integer[] cccc62;
    public long d62;
    public Long dd62;
    public long[] ddd62;
    public Long[] dddd62;
    public float e62;
    public Float ee62;
    public float[] eee62;
    public Float[] eeee62;
    public double f62;
    public Double ff62;
    public double[] fff62;
    public Double[] ffff62;
    public boolean g62;
    public Boolean gg62;
    public boolean[] ggg62;
    public Boolean[] gggg62;
    public String jj62;
    public String[] jjj62;
    public ObjectA kk62;
    public ObjectA[] kkk62;
    public List<Integer> l62;
    public List<String> llll62;
    public Map<Integer, String> m62;
    public Map<Integer, ObjectA> mm62;
    public Set<Integer> s62;
    public Set<String> ssss62;
    public byte a63;
    public Byte aa63;
    public byte[] aaa63;
    public Byte[] aaaa63;
    public short b63;
    public Short bb63;
    public short[] bbb63;
    public Short[] bbbb63;
    public int c63;
    public Integer cc63;
    public int[] ccc63;
    public Integer[] cccc63;
    public long d63;
    public Long dd63;
    public long[] ddd63;
    public Long[] dddd63;
    public float e63;
    public Float ee63;
    public float[] eee63;
    public Float[] eeee63;
    public double f63;
    public Double ff63;
    public double[] fff63;
    public Double[] ffff63;
    public boolean g63;
    public Boolean gg63;
    public boolean[] ggg63;
    public Boolean[] gggg63;
    public String jj63;
    public String[] jjj63;
    public ObjectA kk63;
    public ObjectA[] kkk63;
    public List<Integer> l63;
    public List<String> llll63;
    public Map<Integer, String> m63;
    public Map<Integer, ObjectA> mm63;
    public Set<Integer> s63;
    public Set<String> ssss63;
    public byte a64;
    public Byte aa64;
    public byte[] aaa64;
    public Byte[] aaaa64;
    public short b64;
    public Short bb64;
    public short[] bbb64;
    public Short[] bbbb64;
    public int c64;
    public Integer cc64;
    public int[] ccc64;
    public Integer[] cccc64;
    public long d64;
    public Long dd64;
    public long[] ddd64;
    public Long[] dddd64;
    public float e64;
    public Float ee64;
    public float[] eee64;
    public Float[] eeee64;
    public double f64;
    public Double ff64;
    public double[] fff64;
    public Double[] ffff64;
    public boolean g64;
    public Boolean gg64;
    public boolean[] ggg64;
    public Boolean[] gggg64;
    public String jj64;
    public String[] jjj64;
    public ObjectA kk64;
    public ObjectA[] kkk64;
    public List<Integer> l64;
    public List<String> llll64;
    public Map<Integer, String> m64;
    public Map<Integer, ObjectA> mm64;
    public Set<Integer> s64;
    public Set<String> ssss64;
    public byte a65;
    public Byte aa65;
    public byte[] aaa65;
    public Byte[] aaaa65;
    public short b65;
    public Short bb65;
    public short[] bbb65;
    public Short[] bbbb65;
    public int c65;
    public Integer cc65;
    public int[] ccc65;
    public Integer[] cccc65;
    public long d65;
    public Long dd65;
    public long[] ddd65;
    public Long[] dddd65;
    public float e65;
    public Float ee65;
    public float[] eee65;
    public Float[] eeee65;
    public double f65;
    public Double ff65;
    public double[] fff65;
    public Double[] ffff65;
    public boolean g65;
    public Boolean gg65;
    public boolean[] ggg65;
    public Boolean[] gggg65;
    public String jj65;
    public String[] jjj65;
    public ObjectA kk65;
    public ObjectA[] kkk65;
    public List<Integer> l65;
    public List<String> llll65;
    public Map<Integer, String> m65;
    public Map<Integer, ObjectA> mm65;
    public Set<Integer> s65;
    public Set<String> ssss65;
    public byte a66;
    public Byte aa66;
    public byte[] aaa66;
    public Byte[] aaaa66;
    public short b66;
    public Short bb66;
    public short[] bbb66;
    public Short[] bbbb66;
    public int c66;
    public Integer cc66;
    public int[] ccc66;
    public Integer[] cccc66;
    public long d66;
    public Long dd66;
    public long[] ddd66;
    public Long[] dddd66;
    public float e66;
    public Float ee66;
    public float[] eee66;
    public Float[] eeee66;
    public double f66;
    public Double ff66;
    public double[] fff66;
    public Double[] ffff66;
    public boolean g66;
    public Boolean gg66;
    public boolean[] ggg66;
    public Boolean[] gggg66;
    public String jj66;
    public String[] jjj66;
    public ObjectA kk66;
    public ObjectA[] kkk66;
    public List<Integer> l66;
    public List<String> llll66;
    public Map<Integer, String> m66;
    public Map<Integer, ObjectA> mm66;
    public Set<Integer> s66;
    public Set<String> ssss66;
    public byte a67;
    public Byte aa67;
    public byte[] aaa67;
    public Byte[] aaaa67;
    public short b67;
    public Short bb67;
    public short[] bbb67;
    public Short[] bbbb67;
    public int c67;
    public Integer cc67;
    public int[] ccc67;
    public Integer[] cccc67;
    public long d67;
    public Long dd67;
    public long[] ddd67;
    public Long[] dddd67;
    public float e67;
    public Float ee67;
    public float[] eee67;
    public Float[] eeee67;
    public double f67;
    public Double ff67;
    public double[] fff67;
    public Double[] ffff67;
    public boolean g67;
    public Boolean gg67;
    public boolean[] ggg67;
    public Boolean[] gggg67;
    public String jj67;
    public String[] jjj67;
    public ObjectA kk67;
    public ObjectA[] kkk67;
    public List<Integer> l67;
    public List<String> llll67;
    public Map<Integer, String> m67;
    public Map<Integer, ObjectA> mm67;
    public Set<Integer> s67;
    public Set<String> ssss67;
    public byte a68;
    public Byte aa68;
    public byte[] aaa68;
    public Byte[] aaaa68;
    public short b68;
    public Short bb68;
    public short[] bbb68;
    public Short[] bbbb68;
    public int c68;
    public Integer cc68;
    public int[] ccc68;
    public Integer[] cccc68;
    public long d68;
    public Long dd68;
    public long[] ddd68;
    public Long[] dddd68;
    public float e68;
    public Float ee68;
    public float[] eee68;
    public Float[] eeee68;
    public double f68;
    public Double ff68;
    public double[] fff68;
    public Double[] ffff68;
    public boolean g68;
    public Boolean gg68;
    public boolean[] ggg68;
    public Boolean[] gggg68;
    public String jj68;
    public String[] jjj68;
    public ObjectA kk68;
    public ObjectA[] kkk68;
    public List<Integer> l68;
    public List<String> llll68;
    public Map<Integer, String> m68;
    public Map<Integer, ObjectA> mm68;
    public Set<Integer> s68;
    public Set<String> ssss68;
    public byte a69;
    public Byte aa69;
    public byte[] aaa69;
    public Byte[] aaaa69;
    public short b69;
    public Short bb69;
    public short[] bbb69;
    public Short[] bbbb69;
    public int c69;
    public Integer cc69;
    public int[] ccc69;
    public Integer[] cccc69;
    public long d69;
    public Long dd69;
    public long[] ddd69;
    public Long[] dddd69;
    public float e69;
    public Float ee69;
    public float[] eee69;
    public Float[] eeee69;
    public double f69;
    public Double ff69;
    public double[] fff69;
    public Double[] ffff69;
    public boolean g69;
    public Boolean gg69;
    public boolean[] ggg69;
    public Boolean[] gggg69;
    public String jj69;
    public String[] jjj69;
    public ObjectA kk69;
    public ObjectA[] kkk69;
    public List<Integer> l69;
    public List<String> llll69;
    public Map<Integer, String> m69;
    public Map<Integer, ObjectA> mm69;
    public Set<Integer> s69;
    public Set<String> ssss69;
    public byte a70;
    public Byte aa70;
    public byte[] aaa70;
    public Byte[] aaaa70;
    public short b70;
    public Short bb70;
    public short[] bbb70;
    public Short[] bbbb70;
    public int c70;
    public Integer cc70;
    public int[] ccc70;
    public Integer[] cccc70;
    public long d70;
    public Long dd70;
    public long[] ddd70;
    public Long[] dddd70;
    public float e70;
    public Float ee70;
    public float[] eee70;
    public Float[] eeee70;
    public double f70;
    public Double ff70;
    public double[] fff70;
    public Double[] ffff70;
    public boolean g70;
    public Boolean gg70;
    public boolean[] ggg70;
    public Boolean[] gggg70;
    public String jj70;
    public String[] jjj70;
    public ObjectA kk70;
    public ObjectA[] kkk70;
    public List<Integer> l70;
    public List<String> llll70;
    public Map<Integer, String> m70;
    public Map<Integer, ObjectA> mm70;
    public Set<Integer> s70;
    public Set<String> ssss70;
    public byte a71;
    public Byte aa71;
    public byte[] aaa71;
    public Byte[] aaaa71;
    public short b71;
    public Short bb71;
    public short[] bbb71;
    public Short[] bbbb71;
    public int c71;
    public Integer cc71;
    public int[] ccc71;
    public Integer[] cccc71;
    public long d71;
    public Long dd71;
    public long[] ddd71;
    public Long[] dddd71;
    public float e71;
    public Float ee71;
    public float[] eee71;
    public Float[] eeee71;
    public double f71;
    public Double ff71;
    public double[] fff71;
    public Double[] ffff71;
    public boolean g71;
    public Boolean gg71;
    public boolean[] ggg71;
    public Boolean[] gggg71;
    public String jj71;
    public String[] jjj71;
    public ObjectA kk71;
    public ObjectA[] kkk71;
    public List<Integer> l71;
    public List<String> llll71;
    public Map<Integer, String> m71;
    public Map<Integer, ObjectA> mm71;
    public Set<Integer> s71;
    public Set<String> ssss71;
    public byte a72;
    public Byte aa72;
    public byte[] aaa72;
    public Byte[] aaaa72;
    public short b72;
    public Short bb72;
    public short[] bbb72;
    public Short[] bbbb72;
    public int c72;
    public Integer cc72;
    public int[] ccc72;
    public Integer[] cccc72;
    public long d72;
    public Long dd72;
    public long[] ddd72;
    public Long[] dddd72;
    public float e72;
    public Float ee72;
    public float[] eee72;
    public Float[] eeee72;
    public double f72;
    public Double ff72;
    public double[] fff72;
    public Double[] ffff72;
    public boolean g72;
    public Boolean gg72;
    public boolean[] ggg72;
    public Boolean[] gggg72;
    public String jj72;
    public String[] jjj72;
    public ObjectA kk72;
    public ObjectA[] kkk72;
    public List<Integer> l72;
    public List<String> llll72;
    public Map<Integer, String> m72;
    public Map<Integer, ObjectA> mm72;
    public Set<Integer> s72;
    public Set<String> ssss72;
    public byte a73;
    public Byte aa73;
    public byte[] aaa73;
    public Byte[] aaaa73;
    public short b73;
    public Short bb73;
    public short[] bbb73;
    public Short[] bbbb73;
    public int c73;
    public Integer cc73;
    public int[] ccc73;
    public Integer[] cccc73;
    public long d73;
    public Long dd73;
    public long[] ddd73;
    public Long[] dddd73;
    public float e73;
    public Float ee73;
    public float[] eee73;
    public Float[] eeee73;
    public double f73;
    public Double ff73;
    public double[] fff73;
    public Double[] ffff73;
    public boolean g73;
    public Boolean gg73;
    public boolean[] ggg73;
    public Boolean[] gggg73;
    public String jj73;
    public String[] jjj73;
    public ObjectA kk73;
    public ObjectA[] kkk73;
    public List<Integer> l73;
    public List<String> llll73;
    public Map<Integer, String> m73;
    public Map<Integer, ObjectA> mm73;
    public Set<Integer> s73;
    public Set<String> ssss73;
    public byte a74;
    public Byte aa74;
    public byte[] aaa74;
    public Byte[] aaaa74;
    public short b74;
    public Short bb74;
    public short[] bbb74;
    public Short[] bbbb74;
    public int c74;
    public Integer cc74;
    public int[] ccc74;
    public Integer[] cccc74;
    public long d74;
    public Long dd74;
    public long[] ddd74;
    public Long[] dddd74;
    public float e74;
    public Float ee74;
    public float[] eee74;
    public Float[] eeee74;
    public double f74;
    public Double ff74;
    public double[] fff74;
    public Double[] ffff74;
    public boolean g74;
    public Boolean gg74;
    public boolean[] ggg74;
    public Boolean[] gggg74;
    public String jj74;
    public String[] jjj74;
    public ObjectA kk74;
    public ObjectA[] kkk74;
    public List<Integer> l74;
    public List<String> llll74;
    public Map<Integer, String> m74;
    public Map<Integer, ObjectA> mm74;
    public Set<Integer> s74;
    public Set<String> ssss74;
    public byte a75;
    public Byte aa75;
    public byte[] aaa75;
    public Byte[] aaaa75;
    public short b75;
    public Short bb75;
    public short[] bbb75;
    public Short[] bbbb75;
    public int c75;
    public Integer cc75;
    public int[] ccc75;
    public Integer[] cccc75;
    public long d75;
    public Long dd75;
    public long[] ddd75;
    public Long[] dddd75;
    public float e75;
    public Float ee75;
    public float[] eee75;
    public Float[] eeee75;
    public double f75;
    public Double ff75;
    public double[] fff75;
    public Double[] ffff75;
    public boolean g75;
    public Boolean gg75;
    public boolean[] ggg75;
    public Boolean[] gggg75;
    public String jj75;
    public String[] jjj75;
    public ObjectA kk75;
    public ObjectA[] kkk75;
    public List<Integer> l75;
    public List<String> llll75;
    public Map<Integer, String> m75;
    public Map<Integer, ObjectA> mm75;
    public Set<Integer> s75;
    public Set<String> ssss75;
    public byte a76;
    public Byte aa76;
    public byte[] aaa76;
    public Byte[] aaaa76;
    public short b76;
    public Short bb76;
    public short[] bbb76;
    public Short[] bbbb76;
    public int c76;
    public Integer cc76;
    public int[] ccc76;
    public Integer[] cccc76;
    public long d76;
    public Long dd76;
    public long[] ddd76;
    public Long[] dddd76;
    public float e76;
    public Float ee76;
    public float[] eee76;
    public Float[] eeee76;
    public double f76;
    public Double ff76;
    public double[] fff76;
    public Double[] ffff76;
    public boolean g76;
    public Boolean gg76;
    public boolean[] ggg76;
    public Boolean[] gggg76;
    public String jj76;
    public String[] jjj76;
    public ObjectA kk76;
    public ObjectA[] kkk76;
    public List<Integer> l76;
    public List<String> llll76;
    public Map<Integer, String> m76;
    public Map<Integer, ObjectA> mm76;
    public Set<Integer> s76;
    public Set<String> ssss76;
    public byte a77;
    public Byte aa77;
    public byte[] aaa77;
    public Byte[] aaaa77;
    public short b77;
    public Short bb77;
    public short[] bbb77;
    public Short[] bbbb77;
    public int c77;
    public Integer cc77;
    public int[] ccc77;
    public Integer[] cccc77;
    public long d77;
    public Long dd77;
    public long[] ddd77;
    public Long[] dddd77;
    public float e77;
    public Float ee77;
    public float[] eee77;
    public Float[] eeee77;
    public double f77;
    public Double ff77;
    public double[] fff77;
    public Double[] ffff77;
    public boolean g77;
    public Boolean gg77;
    public boolean[] ggg77;
    public Boolean[] gggg77;
    public String jj77;
    public String[] jjj77;
    public ObjectA kk77;
    public ObjectA[] kkk77;
    public List<Integer> l77;
    public List<String> llll77;
    public Map<Integer, String> m77;
    public Map<Integer, ObjectA> mm77;
    public Set<Integer> s77;
    public Set<String> ssss77;
    public byte a78;
    public Byte aa78;
    public byte[] aaa78;
    public Byte[] aaaa78;
    public short b78;
    public Short bb78;
    public short[] bbb78;
    public Short[] bbbb78;
    public int c78;
    public Integer cc78;
    public int[] ccc78;
    public Integer[] cccc78;
    public long d78;
    public Long dd78;
    public long[] ddd78;
    public Long[] dddd78;
    public float e78;
    public Float ee78;
    public float[] eee78;
    public Float[] eeee78;
    public double f78;
    public Double ff78;
    public double[] fff78;
    public Double[] ffff78;
    public boolean g78;
    public Boolean gg78;
    public boolean[] ggg78;
    public Boolean[] gggg78;
    public String jj78;
    public String[] jjj78;
    public ObjectA kk78;
    public ObjectA[] kkk78;
    public List<Integer> l78;
    public List<String> llll78;
    public Map<Integer, String> m78;
    public Map<Integer, ObjectA> mm78;
    public Set<Integer> s78;
    public Set<String> ssss78;
    public byte a79;
    public Byte aa79;
    public byte[] aaa79;
    public Byte[] aaaa79;
    public short b79;
    public Short bb79;
    public short[] bbb79;
    public Short[] bbbb79;
    public int c79;
    public Integer cc79;
    public int[] ccc79;
    public Integer[] cccc79;
    public long d79;
    public Long dd79;
    public long[] ddd79;
    public Long[] dddd79;
    public float e79;
    public Float ee79;
    public float[] eee79;
    public Float[] eeee79;
    public double f79;
    public Double ff79;
    public double[] fff79;
    public Double[] ffff79;
    public boolean g79;
    public Boolean gg79;
    public boolean[] ggg79;
    public Boolean[] gggg79;
    public String jj79;
    public String[] jjj79;
    public ObjectA kk79;
    public ObjectA[] kkk79;
    public List<Integer> l79;
    public List<String> llll79;
    public Map<Integer, String> m79;
    public Map<Integer, ObjectA> mm79;
    public Set<Integer> s79;
    public Set<String> ssss79;
    public byte a80;
    public Byte aa80;
    public byte[] aaa80;
    public Byte[] aaaa80;
    public short b80;
    public Short bb80;
    public short[] bbb80;
    public Short[] bbbb80;
    public int c80;
    public Integer cc80;
    public int[] ccc80;
    public Integer[] cccc80;
    public long d80;
    public Long dd80;
    public long[] ddd80;
    public Long[] dddd80;
    public float e80;
    public Float ee80;
    public float[] eee80;
    public Float[] eeee80;
    public double f80;
    public Double ff80;
    public double[] fff80;
    public Double[] ffff80;
    public boolean g80;
    public Boolean gg80;
    public boolean[] ggg80;
    public Boolean[] gggg80;
    public String jj80;
    public String[] jjj80;
    public ObjectA kk80;
    public ObjectA[] kkk80;
    public List<Integer> l80;
    public List<String> llll80;
    public Map<Integer, String> m80;
    public Map<Integer, ObjectA> mm80;
    public Set<Integer> s80;
    public Set<String> ssss80;
    public byte a81;
    public Byte aa81;
    public byte[] aaa81;
    public Byte[] aaaa81;
    public short b81;
    public Short bb81;
    public short[] bbb81;
    public Short[] bbbb81;
    public int c81;
    public Integer cc81;
    public int[] ccc81;
    public Integer[] cccc81;
    public long d81;
    public Long dd81;
    public long[] ddd81;
    public Long[] dddd81;
    public float e81;
    public Float ee81;
    public float[] eee81;
    public Float[] eeee81;
    public double f81;
    public Double ff81;
    public double[] fff81;
    public Double[] ffff81;
    public boolean g81;
    public Boolean gg81;
    public boolean[] ggg81;
    public Boolean[] gggg81;
    public String jj81;
    public String[] jjj81;
    public ObjectA kk81;
    public ObjectA[] kkk81;
    public List<Integer> l81;
    public List<String> llll81;
    public Map<Integer, String> m81;
    public Map<Integer, ObjectA> mm81;
    public Set<Integer> s81;
    public Set<String> ssss81;
    public byte a82;
    public Byte aa82;
    public byte[] aaa82;
    public Byte[] aaaa82;
    public short b82;
    public Short bb82;
    public short[] bbb82;
    public Short[] bbbb82;
    public int c82;
    public Integer cc82;
    public int[] ccc82;
    public Integer[] cccc82;
    public long d82;
    public Long dd82;
    public long[] ddd82;
    public Long[] dddd82;
    public float e82;
    public Float ee82;
    public float[] eee82;
    public Float[] eeee82;
    public double f82;
    public Double ff82;
    public double[] fff82;
    public Double[] ffff82;
    public boolean g82;
    public Boolean gg82;
    public boolean[] ggg82;
    public Boolean[] gggg82;
    public String jj82;
    public String[] jjj82;
    public ObjectA kk82;
    public ObjectA[] kkk82;
    public List<Integer> l82;
    public List<String> llll82;
    public Map<Integer, String> m82;
    public Map<Integer, ObjectA> mm82;
    public Set<Integer> s82;
    public Set<String> ssss82;
    public byte a83;
    public Byte aa83;
    public byte[] aaa83;
    public Byte[] aaaa83;
    public short b83;
    public Short bb83;
    public short[] bbb83;
    public Short[] bbbb83;
    public int c83;
    public Integer cc83;
    public int[] ccc83;
    public Integer[] cccc83;
    public long d83;
    public Long dd83;
    public long[] ddd83;
    public Long[] dddd83;
    public float e83;
    public Float ee83;
    public float[] eee83;
    public Float[] eeee83;
    public double f83;
    public Double ff83;
    public double[] fff83;
    public Double[] ffff83;
    public boolean g83;
    public Boolean gg83;
    public boolean[] ggg83;
    public Boolean[] gggg83;
    public String jj83;
    public String[] jjj83;
    public ObjectA kk83;
    public ObjectA[] kkk83;
    public List<Integer> l83;
    public List<String> llll83;
    public Map<Integer, String> m83;
    public Map<Integer, ObjectA> mm83;
    public Set<Integer> s83;
    public Set<String> ssss83;
    public byte a84;
    public Byte aa84;
    public byte[] aaa84;
    public Byte[] aaaa84;
    public short b84;
    public Short bb84;
    public short[] bbb84;
    public Short[] bbbb84;
    public int c84;
    public Integer cc84;
    public int[] ccc84;
    public Integer[] cccc84;
    public long d84;
    public Long dd84;
    public long[] ddd84;
    public Long[] dddd84;
    public float e84;
    public Float ee84;
    public float[] eee84;
    public Float[] eeee84;
    public double f84;
    public Double ff84;
    public double[] fff84;
    public Double[] ffff84;
    public boolean g84;
    public Boolean gg84;
    public boolean[] ggg84;
    public Boolean[] gggg84;
    public String jj84;
    public String[] jjj84;
    public ObjectA kk84;
    public ObjectA[] kkk84;
    public List<Integer> l84;
    public List<String> llll84;
    public Map<Integer, String> m84;
    public Map<Integer, ObjectA> mm84;
    public Set<Integer> s84;
    public Set<String> ssss84;
    public byte a85;
    public Byte aa85;
    public byte[] aaa85;
    public Byte[] aaaa85;
    public short b85;
    public Short bb85;
    public short[] bbb85;
    public Short[] bbbb85;
    public int c85;
    public Integer cc85;
    public int[] ccc85;
    public Integer[] cccc85;
    public long d85;
    public Long dd85;
    public long[] ddd85;
    public Long[] dddd85;
    public float e85;
    public Float ee85;
    public float[] eee85;
    public Float[] eeee85;
    public double f85;
    public Double ff85;
    public double[] fff85;
    public Double[] ffff85;
    public boolean g85;
    public Boolean gg85;
    public boolean[] ggg85;
    public Boolean[] gggg85;
    public String jj85;
    public String[] jjj85;
    public ObjectA kk85;
    public ObjectA[] kkk85;
    public List<Integer> l85;
    public List<String> llll85;
    public Map<Integer, String> m85;
    public Map<Integer, ObjectA> mm85;
    public Set<Integer> s85;
    public Set<String> ssss85;
    public byte a86;
    public Byte aa86;
    public byte[] aaa86;
    public Byte[] aaaa86;
    public short b86;
    public Short bb86;
    public short[] bbb86;
    public Short[] bbbb86;
    public int c86;
    public Integer cc86;
    public int[] ccc86;
    public Integer[] cccc86;
    public long d86;
    public Long dd86;
    public long[] ddd86;
    public Long[] dddd86;
    public float e86;
    public Float ee86;
    public float[] eee86;
    public Float[] eeee86;
    public double f86;
    public Double ff86;
    public double[] fff86;
    public Double[] ffff86;
    public boolean g86;
    public Boolean gg86;
    public boolean[] ggg86;
    public Boolean[] gggg86;
    public String jj86;
    public String[] jjj86;
    public ObjectA kk86;
    public ObjectA[] kkk86;
    public List<Integer> l86;
    public List<String> llll86;
    public Map<Integer, String> m86;
    public Map<Integer, ObjectA> mm86;
    public Set<Integer> s86;
    public Set<String> ssss86;
    public byte a87;
    public Byte aa87;
    public byte[] aaa87;
    public Byte[] aaaa87;
    public short b87;
    public Short bb87;
    public short[] bbb87;
    public Short[] bbbb87;
    public int c87;
    public Integer cc87;
    public int[] ccc87;
    public Integer[] cccc87;
    public long d87;
    public Long dd87;
    public long[] ddd87;
    public Long[] dddd87;
    public float e87;
    public Float ee87;
    public float[] eee87;
    public Float[] eeee87;
    public double f87;
    public Double ff87;
    public double[] fff87;
    public Double[] ffff87;
    public boolean g87;
    public Boolean gg87;
    public boolean[] ggg87;
    public Boolean[] gggg87;
    public String jj87;
    public String[] jjj87;
    public ObjectA kk87;
    public ObjectA[] kkk87;
    public List<Integer> l87;
    public List<String> llll87;
    public Map<Integer, String> m87;
    public Map<Integer, ObjectA> mm87;
    public Set<Integer> s87;
    public Set<String> ssss87;
    public byte a88;
    public Byte aa88;
    public byte[] aaa88;
    public Byte[] aaaa88;
    public short b88;
    public Short bb88;
    public short[] bbb88;
    public Short[] bbbb88;
    public int c88;
    public Integer cc88;
    public int[] ccc88;
    public Integer[] cccc88;
    public long d88;
    public Long dd88;
    public long[] ddd88;
    public Long[] dddd88;
    public float e88;
    public Float ee88;
    public float[] eee88;
    public Float[] eeee88;
    public double f88;
    public Double ff88;
    public double[] fff88;
    public Double[] ffff88;
    public boolean g88;
    public Boolean gg88;
    public boolean[] ggg88;
    public Boolean[] gggg88;
    public String jj88;
    public String[] jjj88;
    public ObjectA kk88;
    public ObjectA[] kkk88;
    public List<Integer> l88;
    public List<String> llll88;
    public Map<Integer, String> m88;
    public Map<Integer, ObjectA> mm88;
    public Set<Integer> s88;
    public Set<String> ssss88;

    public static final VeryBigObject veryBigObject = new VeryBigObject();

    static {
        veryBigObject.a1 = byteValue;
        veryBigObject.aa1 = byteValue;
        veryBigObject.aaa1 = byteArray;
        veryBigObject.aaaa1 = byteBoxArray;
        veryBigObject.b1 = shortValue;
        veryBigObject.bb1 = shortValue;
        veryBigObject.bbb1 = shortArray;
        veryBigObject.bbbb1 = shortBoxArray;
        veryBigObject.c1 = intValue;
        veryBigObject.cc1 = intValue;
        veryBigObject.ccc1 = intArray;
        veryBigObject.cccc1 = integerArray;
        veryBigObject.d1 = longValue;
        veryBigObject.dd1 = longValue;
        veryBigObject.ddd1 = longArray;
        veryBigObject.dddd1 = longBoxArray;
        veryBigObject.e1 = floatValue;
        veryBigObject.ee1 = floatValue;
        veryBigObject.eee1 = floatArray;
        veryBigObject.eeee1 = floatBoxArray;
        veryBigObject.f1 = doubleValue;
        veryBigObject.ff1 = doubleValue;
        veryBigObject.fff1 = doubleArray;
        veryBigObject.ffff1 = doubleBoxArray;
        veryBigObject.g1 = true;
        veryBigObject.gg1 = true;
        veryBigObject.ggg1 = booleanArray;
        veryBigObject.gggg1 = booleanBoxArray;
        veryBigObject.jj1 = stringValue;
        veryBigObject.jjj1 = stringArray;
        veryBigObject.kk1 = objectA;
        veryBigObject.kkk1 = new ObjectA[]{objectA, objectA};
        veryBigObject.l1 = listWithInteger;
        veryBigObject.llll1 = listWithString;
        veryBigObject.m1 = mapWithInteger;
        veryBigObject.mm1 = mapWithObject;
        veryBigObject.s1 = setWithInteger;
        veryBigObject.ssss1 = setWithString;
        veryBigObject.a2 = byteValue;
        veryBigObject.aa2 = byteValue;
        veryBigObject.aaa2 = byteArray;
        veryBigObject.aaaa2 = byteBoxArray;
        veryBigObject.b2 = shortValue;
        veryBigObject.bb2 = shortValue;
        veryBigObject.bbb2 = shortArray;
        veryBigObject.bbbb2 = shortBoxArray;
        veryBigObject.c2 = intValue;
        veryBigObject.cc2 = intValue;
        veryBigObject.ccc2 = intArray;
        veryBigObject.cccc2 = integerArray;
        veryBigObject.d2 = longValue;
        veryBigObject.dd2 = longValue;
        veryBigObject.ddd2 = longArray;
        veryBigObject.dddd2 = longBoxArray;
        veryBigObject.e2 = floatValue;
        veryBigObject.ee2 = floatValue;
        veryBigObject.eee2 = floatArray;
        veryBigObject.eeee2 = floatBoxArray;
        veryBigObject.f2 = doubleValue;
        veryBigObject.ff2 = doubleValue;
        veryBigObject.fff2 = doubleArray;
        veryBigObject.ffff2 = doubleBoxArray;
        veryBigObject.g2 = true;
        veryBigObject.gg2 = true;
        veryBigObject.ggg2 = booleanArray;
        veryBigObject.gggg2 = booleanBoxArray;
        veryBigObject.jj2 = stringValue;
        veryBigObject.jjj2 = stringArray;
        veryBigObject.kk2 = objectA;
        veryBigObject.kkk2 = new ObjectA[]{objectA, objectA};
        veryBigObject.l2 = listWithInteger;
        veryBigObject.llll2 = listWithString;
        veryBigObject.m2 = mapWithInteger;
        veryBigObject.mm2 = mapWithObject;
        veryBigObject.s2 = setWithInteger;
        veryBigObject.ssss2 = setWithString;
        veryBigObject.a3 = byteValue;
        veryBigObject.aa3 = byteValue;
        veryBigObject.aaa3 = byteArray;
        veryBigObject.aaaa3 = byteBoxArray;
        veryBigObject.b3 = shortValue;
        veryBigObject.bb3 = shortValue;
        veryBigObject.bbb3 = shortArray;
        veryBigObject.bbbb3 = shortBoxArray;
        veryBigObject.c3 = intValue;
        veryBigObject.cc3 = intValue;
        veryBigObject.ccc3 = intArray;
        veryBigObject.cccc3 = integerArray;
        veryBigObject.d3 = longValue;
        veryBigObject.dd3 = longValue;
        veryBigObject.ddd3 = longArray;
        veryBigObject.dddd3 = longBoxArray;
        veryBigObject.e3 = floatValue;
        veryBigObject.ee3 = floatValue;
        veryBigObject.eee3 = floatArray;
        veryBigObject.eeee3 = floatBoxArray;
        veryBigObject.f3 = doubleValue;
        veryBigObject.ff3 = doubleValue;
        veryBigObject.fff3 = doubleArray;
        veryBigObject.ffff3 = doubleBoxArray;
        veryBigObject.g3 = true;
        veryBigObject.gg3 = true;
        veryBigObject.ggg3 = booleanArray;
        veryBigObject.gggg3 = booleanBoxArray;
        veryBigObject.jj3 = stringValue;
        veryBigObject.jjj3 = stringArray;
        veryBigObject.kk3 = objectA;
        veryBigObject.kkk3 = new ObjectA[]{objectA, objectA};
        veryBigObject.l3 = listWithInteger;
        veryBigObject.llll3 = listWithString;
        veryBigObject.m3 = mapWithInteger;
        veryBigObject.mm3 = mapWithObject;
        veryBigObject.s3 = setWithInteger;
        veryBigObject.ssss3 = setWithString;
        veryBigObject.a4 = byteValue;
        veryBigObject.aa4 = byteValue;
        veryBigObject.aaa4 = byteArray;
        veryBigObject.aaaa4 = byteBoxArray;
        veryBigObject.b4 = shortValue;
        veryBigObject.bb4 = shortValue;
        veryBigObject.bbb4 = shortArray;
        veryBigObject.bbbb4 = shortBoxArray;
        veryBigObject.c4 = intValue;
        veryBigObject.cc4 = intValue;
        veryBigObject.ccc4 = intArray;
        veryBigObject.cccc4 = integerArray;
        veryBigObject.d4 = longValue;
        veryBigObject.dd4 = longValue;
        veryBigObject.ddd4 = longArray;
        veryBigObject.dddd4 = longBoxArray;
        veryBigObject.e4 = floatValue;
        veryBigObject.ee4 = floatValue;
        veryBigObject.eee4 = floatArray;
        veryBigObject.eeee4 = floatBoxArray;
        veryBigObject.f4 = doubleValue;
        veryBigObject.ff4 = doubleValue;
        veryBigObject.fff4 = doubleArray;
        veryBigObject.ffff4 = doubleBoxArray;
        veryBigObject.g4 = true;
        veryBigObject.gg4 = true;
        veryBigObject.ggg4 = booleanArray;
        veryBigObject.gggg4 = booleanBoxArray;
        veryBigObject.jj4 = stringValue;
        veryBigObject.jjj4 = stringArray;
        veryBigObject.kk4 = objectA;
        veryBigObject.kkk4 = new ObjectA[]{objectA, objectA};
        veryBigObject.l4 = listWithInteger;
        veryBigObject.llll4 = listWithString;
        veryBigObject.m4 = mapWithInteger;
        veryBigObject.mm4 = mapWithObject;
        veryBigObject.s4 = setWithInteger;
        veryBigObject.ssss4 = setWithString;
        veryBigObject.a5 = byteValue;
        veryBigObject.aa5 = byteValue;
        veryBigObject.aaa5 = byteArray;
        veryBigObject.aaaa5 = byteBoxArray;
        veryBigObject.b5 = shortValue;
        veryBigObject.bb5 = shortValue;
        veryBigObject.bbb5 = shortArray;
        veryBigObject.bbbb5 = shortBoxArray;
        veryBigObject.c5 = intValue;
        veryBigObject.cc5 = intValue;
        veryBigObject.ccc5 = intArray;
        veryBigObject.cccc5 = integerArray;
        veryBigObject.d5 = longValue;
        veryBigObject.dd5 = longValue;
        veryBigObject.ddd5 = longArray;
        veryBigObject.dddd5 = longBoxArray;
        veryBigObject.e5 = floatValue;
        veryBigObject.ee5 = floatValue;
        veryBigObject.eee5 = floatArray;
        veryBigObject.eeee5 = floatBoxArray;
        veryBigObject.f5 = doubleValue;
        veryBigObject.ff5 = doubleValue;
        veryBigObject.fff5 = doubleArray;
        veryBigObject.ffff5 = doubleBoxArray;
        veryBigObject.g5 = true;
        veryBigObject.gg5 = true;
        veryBigObject.ggg5 = booleanArray;
        veryBigObject.gggg5 = booleanBoxArray;
        veryBigObject.jj5 = stringValue;
        veryBigObject.jjj5 = stringArray;
        veryBigObject.kk5 = objectA;
        veryBigObject.kkk5 = new ObjectA[]{objectA, objectA};
        veryBigObject.l5 = listWithInteger;
        veryBigObject.llll5 = listWithString;
        veryBigObject.m5 = mapWithInteger;
        veryBigObject.mm5 = mapWithObject;
        veryBigObject.s5 = setWithInteger;
        veryBigObject.ssss5 = setWithString;
        veryBigObject.a6 = byteValue;
        veryBigObject.aa6 = byteValue;
        veryBigObject.aaa6 = byteArray;
        veryBigObject.aaaa6 = byteBoxArray;
        veryBigObject.b6 = shortValue;
        veryBigObject.bb6 = shortValue;
        veryBigObject.bbb6 = shortArray;
        veryBigObject.bbbb6 = shortBoxArray;
        veryBigObject.c6 = intValue;
        veryBigObject.cc6 = intValue;
        veryBigObject.ccc6 = intArray;
        veryBigObject.cccc6 = integerArray;
        veryBigObject.d6 = longValue;
        veryBigObject.dd6 = longValue;
        veryBigObject.ddd6 = longArray;
        veryBigObject.dddd6 = longBoxArray;
        veryBigObject.e6 = floatValue;
        veryBigObject.ee6 = floatValue;
        veryBigObject.eee6 = floatArray;
        veryBigObject.eeee6 = floatBoxArray;
        veryBigObject.f6 = doubleValue;
        veryBigObject.ff6 = doubleValue;
        veryBigObject.fff6 = doubleArray;
        veryBigObject.ffff6 = doubleBoxArray;
        veryBigObject.g6 = true;
        veryBigObject.gg6 = true;
        veryBigObject.ggg6 = booleanArray;
        veryBigObject.gggg6 = booleanBoxArray;
        veryBigObject.jj6 = stringValue;
        veryBigObject.jjj6 = stringArray;
        veryBigObject.kk6 = objectA;
        veryBigObject.kkk6 = new ObjectA[]{objectA, objectA};
        veryBigObject.l6 = listWithInteger;
        veryBigObject.llll6 = listWithString;
        veryBigObject.m6 = mapWithInteger;
        veryBigObject.mm6 = mapWithObject;
        veryBigObject.s6 = setWithInteger;
        veryBigObject.ssss6 = setWithString;
        veryBigObject.a7 = byteValue;
        veryBigObject.aa7 = byteValue;
        veryBigObject.aaa7 = byteArray;
        veryBigObject.aaaa7 = byteBoxArray;
        veryBigObject.b7 = shortValue;
        veryBigObject.bb7 = shortValue;
        veryBigObject.bbb7 = shortArray;
        veryBigObject.bbbb7 = shortBoxArray;
        veryBigObject.c7 = intValue;
        veryBigObject.cc7 = intValue;
        veryBigObject.ccc7 = intArray;
        veryBigObject.cccc7 = integerArray;
        veryBigObject.d7 = longValue;
        veryBigObject.dd7 = longValue;
        veryBigObject.ddd7 = longArray;
        veryBigObject.dddd7 = longBoxArray;
        veryBigObject.e7 = floatValue;
        veryBigObject.ee7 = floatValue;
        veryBigObject.eee7 = floatArray;
        veryBigObject.eeee7 = floatBoxArray;
        veryBigObject.f7 = doubleValue;
        veryBigObject.ff7 = doubleValue;
        veryBigObject.fff7 = doubleArray;
        veryBigObject.ffff7 = doubleBoxArray;
        veryBigObject.g7 = true;
        veryBigObject.gg7 = true;
        veryBigObject.ggg7 = booleanArray;
        veryBigObject.gggg7 = booleanBoxArray;
        veryBigObject.jj7 = stringValue;
        veryBigObject.jjj7 = stringArray;
        veryBigObject.kk7 = objectA;
        veryBigObject.kkk7 = new ObjectA[]{objectA, objectA};
        veryBigObject.l7 = listWithInteger;
        veryBigObject.llll7 = listWithString;
        veryBigObject.m7 = mapWithInteger;
        veryBigObject.mm7 = mapWithObject;
        veryBigObject.s7 = setWithInteger;
        veryBigObject.ssss7 = setWithString;
        veryBigObject.a8 = byteValue;
        veryBigObject.aa8 = byteValue;
        veryBigObject.aaa8 = byteArray;
        veryBigObject.aaaa8 = byteBoxArray;
        veryBigObject.b8 = shortValue;
        veryBigObject.bb8 = shortValue;
        veryBigObject.bbb8 = shortArray;
        veryBigObject.bbbb8 = shortBoxArray;
        veryBigObject.c8 = intValue;
        veryBigObject.cc8 = intValue;
        veryBigObject.ccc8 = intArray;
        veryBigObject.cccc8 = integerArray;
        veryBigObject.d8 = longValue;
        veryBigObject.dd8 = longValue;
        veryBigObject.ddd8 = longArray;
        veryBigObject.dddd8 = longBoxArray;
        veryBigObject.e8 = floatValue;
        veryBigObject.ee8 = floatValue;
        veryBigObject.eee8 = floatArray;
        veryBigObject.eeee8 = floatBoxArray;
        veryBigObject.f8 = doubleValue;
        veryBigObject.ff8 = doubleValue;
        veryBigObject.fff8 = doubleArray;
        veryBigObject.ffff8 = doubleBoxArray;
        veryBigObject.g8 = true;
        veryBigObject.gg8 = true;
        veryBigObject.ggg8 = booleanArray;
        veryBigObject.gggg8 = booleanBoxArray;
        veryBigObject.jj8 = stringValue;
        veryBigObject.jjj8 = stringArray;
        veryBigObject.kk8 = objectA;
        veryBigObject.kkk8 = new ObjectA[]{objectA, objectA};
        veryBigObject.l8 = listWithInteger;
        veryBigObject.llll8 = listWithString;
        veryBigObject.m8 = mapWithInteger;
        veryBigObject.mm8 = mapWithObject;
        veryBigObject.s8 = setWithInteger;
        veryBigObject.ssss8 = setWithString;
        veryBigObject.a9 = byteValue;
        veryBigObject.aa9 = byteValue;
        veryBigObject.aaa9 = byteArray;
        veryBigObject.aaaa9 = byteBoxArray;
        veryBigObject.b9 = shortValue;
        veryBigObject.bb9 = shortValue;
        veryBigObject.bbb9 = shortArray;
        veryBigObject.bbbb9 = shortBoxArray;
        veryBigObject.c9 = intValue;
        veryBigObject.cc9 = intValue;
        veryBigObject.ccc9 = intArray;
        veryBigObject.cccc9 = integerArray;
        veryBigObject.d9 = longValue;
        veryBigObject.dd9 = longValue;
        veryBigObject.ddd9 = longArray;
        veryBigObject.dddd9 = longBoxArray;
        veryBigObject.e9 = floatValue;
        veryBigObject.ee9 = floatValue;
        veryBigObject.eee9 = floatArray;
        veryBigObject.eeee9 = floatBoxArray;
        veryBigObject.f9 = doubleValue;
        veryBigObject.ff9 = doubleValue;
        veryBigObject.fff9 = doubleArray;
        veryBigObject.ffff9 = doubleBoxArray;
        veryBigObject.g9 = true;
        veryBigObject.gg9 = true;
        veryBigObject.ggg9 = booleanArray;
        veryBigObject.gggg9 = booleanBoxArray;
        veryBigObject.jj9 = stringValue;
        veryBigObject.jjj9 = stringArray;
        veryBigObject.kk9 = objectA;
        veryBigObject.kkk9 = new ObjectA[]{objectA, objectA};
        veryBigObject.l9 = listWithInteger;
        veryBigObject.llll9 = listWithString;
        veryBigObject.m9 = mapWithInteger;
        veryBigObject.mm9 = mapWithObject;
        veryBigObject.s9 = setWithInteger;
        veryBigObject.ssss9 = setWithString;
        veryBigObject.a10 = byteValue;
        veryBigObject.aa10 = byteValue;
        veryBigObject.aaa10 = byteArray;
        veryBigObject.aaaa10 = byteBoxArray;
        veryBigObject.b10 = shortValue;
        veryBigObject.bb10 = shortValue;
        veryBigObject.bbb10 = shortArray;
        veryBigObject.bbbb10 = shortBoxArray;
        veryBigObject.c10 = intValue;
        veryBigObject.cc10 = intValue;
        veryBigObject.ccc10 = intArray;
        veryBigObject.cccc10 = integerArray;
        veryBigObject.d10 = longValue;
        veryBigObject.dd10 = longValue;
        veryBigObject.ddd10 = longArray;
        veryBigObject.dddd10 = longBoxArray;
        veryBigObject.e10 = floatValue;
        veryBigObject.ee10 = floatValue;
        veryBigObject.eee10 = floatArray;
        veryBigObject.eeee10 = floatBoxArray;
        veryBigObject.f10 = doubleValue;
        veryBigObject.ff10 = doubleValue;
        veryBigObject.fff10 = doubleArray;
        veryBigObject.ffff10 = doubleBoxArray;
        veryBigObject.g10 = true;
        veryBigObject.gg10 = true;
        veryBigObject.ggg10 = booleanArray;
        veryBigObject.gggg10 = booleanBoxArray;
        veryBigObject.jj10 = stringValue;
        veryBigObject.jjj10 = stringArray;
        veryBigObject.kk10 = objectA;
        veryBigObject.kkk10 = new ObjectA[]{objectA, objectA};
        veryBigObject.l10 = listWithInteger;
        veryBigObject.llll10 = listWithString;
        veryBigObject.m10 = mapWithInteger;
        veryBigObject.mm10 = mapWithObject;
        veryBigObject.s10 = setWithInteger;
        veryBigObject.ssss10 = setWithString;
        veryBigObject.a11 = byteValue;
        veryBigObject.aa11 = byteValue;
        veryBigObject.aaa11 = byteArray;
        veryBigObject.aaaa11 = byteBoxArray;
        veryBigObject.b11 = shortValue;
        veryBigObject.bb11 = shortValue;
        veryBigObject.bbb11 = shortArray;
        veryBigObject.bbbb11 = shortBoxArray;
        veryBigObject.c11 = intValue;
        veryBigObject.cc11 = intValue;
        veryBigObject.ccc11 = intArray;
        veryBigObject.cccc11 = integerArray;
        veryBigObject.d11 = longValue;
        veryBigObject.dd11 = longValue;
        veryBigObject.ddd11 = longArray;
        veryBigObject.dddd11 = longBoxArray;
        veryBigObject.e11 = floatValue;
        veryBigObject.ee11 = floatValue;
        veryBigObject.eee11 = floatArray;
        veryBigObject.eeee11 = floatBoxArray;
        veryBigObject.f11 = doubleValue;
        veryBigObject.ff11 = doubleValue;
        veryBigObject.fff11 = doubleArray;
        veryBigObject.ffff11 = doubleBoxArray;
        veryBigObject.g11 = true;
        veryBigObject.gg11 = true;
        veryBigObject.ggg11 = booleanArray;
        veryBigObject.gggg11 = booleanBoxArray;
        veryBigObject.jj11 = stringValue;
        veryBigObject.jjj11 = stringArray;
        veryBigObject.kk11 = objectA;
        veryBigObject.kkk11 = new ObjectA[]{objectA, objectA};
        veryBigObject.l11 = listWithInteger;
        veryBigObject.llll11 = listWithString;
        veryBigObject.m11 = mapWithInteger;
        veryBigObject.mm11 = mapWithObject;
        veryBigObject.s11 = setWithInteger;
        veryBigObject.ssss11 = setWithString;
        veryBigObject.a12 = byteValue;
        veryBigObject.aa12 = byteValue;
        veryBigObject.aaa12 = byteArray;
        veryBigObject.aaaa12 = byteBoxArray;
        veryBigObject.b12 = shortValue;
        veryBigObject.bb12 = shortValue;
        veryBigObject.bbb12 = shortArray;
        veryBigObject.bbbb12 = shortBoxArray;
        veryBigObject.c12 = intValue;
        veryBigObject.cc12 = intValue;
        veryBigObject.ccc12 = intArray;
        veryBigObject.cccc12 = integerArray;
        veryBigObject.d12 = longValue;
        veryBigObject.dd12 = longValue;
        veryBigObject.ddd12 = longArray;
        veryBigObject.dddd12 = longBoxArray;
        veryBigObject.e12 = floatValue;
        veryBigObject.ee12 = floatValue;
        veryBigObject.eee12 = floatArray;
        veryBigObject.eeee12 = floatBoxArray;
        veryBigObject.f12 = doubleValue;
        veryBigObject.ff12 = doubleValue;
        veryBigObject.fff12 = doubleArray;
        veryBigObject.ffff12 = doubleBoxArray;
        veryBigObject.g12 = true;
        veryBigObject.gg12 = true;
        veryBigObject.ggg12 = booleanArray;
        veryBigObject.gggg12 = booleanBoxArray;
        veryBigObject.jj12 = stringValue;
        veryBigObject.jjj12 = stringArray;
        veryBigObject.kk12 = objectA;
        veryBigObject.kkk12 = new ObjectA[]{objectA, objectA};
        veryBigObject.l12 = listWithInteger;
        veryBigObject.llll12 = listWithString;
        veryBigObject.m12 = mapWithInteger;
        veryBigObject.mm12 = mapWithObject;
        veryBigObject.s12 = setWithInteger;
        veryBigObject.ssss12 = setWithString;
        veryBigObject.a13 = byteValue;
        veryBigObject.aa13 = byteValue;
        veryBigObject.aaa13 = byteArray;
        veryBigObject.aaaa13 = byteBoxArray;
        veryBigObject.b13 = shortValue;
        veryBigObject.bb13 = shortValue;
        veryBigObject.bbb13 = shortArray;
        veryBigObject.bbbb13 = shortBoxArray;
        veryBigObject.c13 = intValue;
        veryBigObject.cc13 = intValue;
        veryBigObject.ccc13 = intArray;
        veryBigObject.cccc13 = integerArray;
        veryBigObject.d13 = longValue;
        veryBigObject.dd13 = longValue;
        veryBigObject.ddd13 = longArray;
        veryBigObject.dddd13 = longBoxArray;
        veryBigObject.e13 = floatValue;
        veryBigObject.ee13 = floatValue;
        veryBigObject.eee13 = floatArray;
        veryBigObject.eeee13 = floatBoxArray;
        veryBigObject.f13 = doubleValue;
        veryBigObject.ff13 = doubleValue;
        veryBigObject.fff13 = doubleArray;
        veryBigObject.ffff13 = doubleBoxArray;
        veryBigObject.g13 = true;
        veryBigObject.gg13 = true;
        veryBigObject.ggg13 = booleanArray;
        veryBigObject.gggg13 = booleanBoxArray;
        veryBigObject.jj13 = stringValue;
        veryBigObject.jjj13 = stringArray;
        veryBigObject.kk13 = objectA;
        veryBigObject.kkk13 = new ObjectA[]{objectA, objectA};
        veryBigObject.l13 = listWithInteger;
        veryBigObject.llll13 = listWithString;
        veryBigObject.m13 = mapWithInteger;
        veryBigObject.mm13 = mapWithObject;
        veryBigObject.s13 = setWithInteger;
        veryBigObject.ssss13 = setWithString;
        veryBigObject.a14 = byteValue;
        veryBigObject.aa14 = byteValue;
        veryBigObject.aaa14 = byteArray;
        veryBigObject.aaaa14 = byteBoxArray;
        veryBigObject.b14 = shortValue;
        veryBigObject.bb14 = shortValue;
        veryBigObject.bbb14 = shortArray;
        veryBigObject.bbbb14 = shortBoxArray;
        veryBigObject.c14 = intValue;
        veryBigObject.cc14 = intValue;
        veryBigObject.ccc14 = intArray;
        veryBigObject.cccc14 = integerArray;
        veryBigObject.d14 = longValue;
        veryBigObject.dd14 = longValue;
        veryBigObject.ddd14 = longArray;
        veryBigObject.dddd14 = longBoxArray;
        veryBigObject.e14 = floatValue;
        veryBigObject.ee14 = floatValue;
        veryBigObject.eee14 = floatArray;
        veryBigObject.eeee14 = floatBoxArray;
        veryBigObject.f14 = doubleValue;
        veryBigObject.ff14 = doubleValue;
        veryBigObject.fff14 = doubleArray;
        veryBigObject.ffff14 = doubleBoxArray;
        veryBigObject.g14 = true;
        veryBigObject.gg14 = true;
        veryBigObject.ggg14 = booleanArray;
        veryBigObject.gggg14 = booleanBoxArray;
        veryBigObject.jj14 = stringValue;
        veryBigObject.jjj14 = stringArray;
        veryBigObject.kk14 = objectA;
        veryBigObject.kkk14 = new ObjectA[]{objectA, objectA};
        veryBigObject.l14 = listWithInteger;
        veryBigObject.llll14 = listWithString;
        veryBigObject.m14 = mapWithInteger;
        veryBigObject.mm14 = mapWithObject;
        veryBigObject.s14 = setWithInteger;
        veryBigObject.ssss14 = setWithString;
        veryBigObject.a15 = byteValue;
        veryBigObject.aa15 = byteValue;
        veryBigObject.aaa15 = byteArray;
        veryBigObject.aaaa15 = byteBoxArray;
        veryBigObject.b15 = shortValue;
        veryBigObject.bb15 = shortValue;
        veryBigObject.bbb15 = shortArray;
        veryBigObject.bbbb15 = shortBoxArray;
        veryBigObject.c15 = intValue;
        veryBigObject.cc15 = intValue;
        veryBigObject.ccc15 = intArray;
        veryBigObject.cccc15 = integerArray;
        veryBigObject.d15 = longValue;
        veryBigObject.dd15 = longValue;
        veryBigObject.ddd15 = longArray;
        veryBigObject.dddd15 = longBoxArray;
        veryBigObject.e15 = floatValue;
        veryBigObject.ee15 = floatValue;
        veryBigObject.eee15 = floatArray;
        veryBigObject.eeee15 = floatBoxArray;
        veryBigObject.f15 = doubleValue;
        veryBigObject.ff15 = doubleValue;
        veryBigObject.fff15 = doubleArray;
        veryBigObject.ffff15 = doubleBoxArray;
        veryBigObject.g15 = true;
        veryBigObject.gg15 = true;
        veryBigObject.ggg15 = booleanArray;
        veryBigObject.gggg15 = booleanBoxArray;
        veryBigObject.jj15 = stringValue;
        veryBigObject.jjj15 = stringArray;
        veryBigObject.kk15 = objectA;
        veryBigObject.kkk15 = new ObjectA[]{objectA, objectA};
        veryBigObject.l15 = listWithInteger;
        veryBigObject.llll15 = listWithString;
        veryBigObject.m15 = mapWithInteger;
        veryBigObject.mm15 = mapWithObject;
        veryBigObject.s15 = setWithInteger;
        veryBigObject.ssss15 = setWithString;
        veryBigObject.a16 = byteValue;
        veryBigObject.aa16 = byteValue;
        veryBigObject.aaa16 = byteArray;
        veryBigObject.aaaa16 = byteBoxArray;
        veryBigObject.b16 = shortValue;
        veryBigObject.bb16 = shortValue;
        veryBigObject.bbb16 = shortArray;
        veryBigObject.bbbb16 = shortBoxArray;
        veryBigObject.c16 = intValue;
        veryBigObject.cc16 = intValue;
        veryBigObject.ccc16 = intArray;
        veryBigObject.cccc16 = integerArray;
        veryBigObject.d16 = longValue;
        veryBigObject.dd16 = longValue;
        veryBigObject.ddd16 = longArray;
        veryBigObject.dddd16 = longBoxArray;
        veryBigObject.e16 = floatValue;
        veryBigObject.ee16 = floatValue;
        veryBigObject.eee16 = floatArray;
        veryBigObject.eeee16 = floatBoxArray;
        veryBigObject.f16 = doubleValue;
        veryBigObject.ff16 = doubleValue;
        veryBigObject.fff16 = doubleArray;
        veryBigObject.ffff16 = doubleBoxArray;
        veryBigObject.g16 = true;
        veryBigObject.gg16 = true;
        veryBigObject.ggg16 = booleanArray;
        veryBigObject.gggg16 = booleanBoxArray;
        veryBigObject.jj16 = stringValue;
        veryBigObject.jjj16 = stringArray;
        veryBigObject.kk16 = objectA;
        veryBigObject.kkk16 = new ObjectA[]{objectA, objectA};
        veryBigObject.l16 = listWithInteger;
        veryBigObject.llll16 = listWithString;
        veryBigObject.m16 = mapWithInteger;
        veryBigObject.mm16 = mapWithObject;
        veryBigObject.s16 = setWithInteger;
        veryBigObject.ssss16 = setWithString;
        veryBigObject.a17 = byteValue;
        veryBigObject.aa17 = byteValue;
        veryBigObject.aaa17 = byteArray;
        veryBigObject.aaaa17 = byteBoxArray;
        veryBigObject.b17 = shortValue;
        veryBigObject.bb17 = shortValue;
        veryBigObject.bbb17 = shortArray;
        veryBigObject.bbbb17 = shortBoxArray;
        veryBigObject.c17 = intValue;
        veryBigObject.cc17 = intValue;
        veryBigObject.ccc17 = intArray;
        veryBigObject.cccc17 = integerArray;
        veryBigObject.d17 = longValue;
        veryBigObject.dd17 = longValue;
        veryBigObject.ddd17 = longArray;
        veryBigObject.dddd17 = longBoxArray;
        veryBigObject.e17 = floatValue;
        veryBigObject.ee17 = floatValue;
        veryBigObject.eee17 = floatArray;
        veryBigObject.eeee17 = floatBoxArray;
        veryBigObject.f17 = doubleValue;
        veryBigObject.ff17 = doubleValue;
        veryBigObject.fff17 = doubleArray;
        veryBigObject.ffff17 = doubleBoxArray;
        veryBigObject.g17 = true;
        veryBigObject.gg17 = true;
        veryBigObject.ggg17 = booleanArray;
        veryBigObject.gggg17 = booleanBoxArray;
        veryBigObject.jj17 = stringValue;
        veryBigObject.jjj17 = stringArray;
        veryBigObject.kk17 = objectA;
        veryBigObject.kkk17 = new ObjectA[]{objectA, objectA};
        veryBigObject.l17 = listWithInteger;
        veryBigObject.llll17 = listWithString;
        veryBigObject.m17 = mapWithInteger;
        veryBigObject.mm17 = mapWithObject;
        veryBigObject.s17 = setWithInteger;
        veryBigObject.ssss17 = setWithString;
        veryBigObject.a18 = byteValue;
        veryBigObject.aa18 = byteValue;
        veryBigObject.aaa18 = byteArray;
        veryBigObject.aaaa18 = byteBoxArray;
        veryBigObject.b18 = shortValue;
        veryBigObject.bb18 = shortValue;
        veryBigObject.bbb18 = shortArray;
        veryBigObject.bbbb18 = shortBoxArray;
        veryBigObject.c18 = intValue;
        veryBigObject.cc18 = intValue;
        veryBigObject.ccc18 = intArray;
        veryBigObject.cccc18 = integerArray;
        veryBigObject.d18 = longValue;
        veryBigObject.dd18 = longValue;
        veryBigObject.ddd18 = longArray;
        veryBigObject.dddd18 = longBoxArray;
        veryBigObject.e18 = floatValue;
        veryBigObject.ee18 = floatValue;
        veryBigObject.eee18 = floatArray;
        veryBigObject.eeee18 = floatBoxArray;
        veryBigObject.f18 = doubleValue;
        veryBigObject.ff18 = doubleValue;
        veryBigObject.fff18 = doubleArray;
        veryBigObject.ffff18 = doubleBoxArray;
        veryBigObject.g18 = true;
        veryBigObject.gg18 = true;
        veryBigObject.ggg18 = booleanArray;
        veryBigObject.gggg18 = booleanBoxArray;
        veryBigObject.jj18 = stringValue;
        veryBigObject.jjj18 = stringArray;
        veryBigObject.kk18 = objectA;
        veryBigObject.kkk18 = new ObjectA[]{objectA, objectA};
        veryBigObject.l18 = listWithInteger;
        veryBigObject.llll18 = listWithString;
        veryBigObject.m18 = mapWithInteger;
        veryBigObject.mm18 = mapWithObject;
        veryBigObject.s18 = setWithInteger;
        veryBigObject.ssss18 = setWithString;
        veryBigObject.a19 = byteValue;
        veryBigObject.aa19 = byteValue;
        veryBigObject.aaa19 = byteArray;
        veryBigObject.aaaa19 = byteBoxArray;
        veryBigObject.b19 = shortValue;
        veryBigObject.bb19 = shortValue;
        veryBigObject.bbb19 = shortArray;
        veryBigObject.bbbb19 = shortBoxArray;
        veryBigObject.c19 = intValue;
        veryBigObject.cc19 = intValue;
        veryBigObject.ccc19 = intArray;
        veryBigObject.cccc19 = integerArray;
        veryBigObject.d19 = longValue;
        veryBigObject.dd19 = longValue;
        veryBigObject.ddd19 = longArray;
        veryBigObject.dddd19 = longBoxArray;
        veryBigObject.e19 = floatValue;
        veryBigObject.ee19 = floatValue;
        veryBigObject.eee19 = floatArray;
        veryBigObject.eeee19 = floatBoxArray;
        veryBigObject.f19 = doubleValue;
        veryBigObject.ff19 = doubleValue;
        veryBigObject.fff19 = doubleArray;
        veryBigObject.ffff19 = doubleBoxArray;
        veryBigObject.g19 = true;
        veryBigObject.gg19 = true;
        veryBigObject.ggg19 = booleanArray;
        veryBigObject.gggg19 = booleanBoxArray;
        veryBigObject.jj19 = stringValue;
        veryBigObject.jjj19 = stringArray;
        veryBigObject.kk19 = objectA;
        veryBigObject.kkk19 = new ObjectA[]{objectA, objectA};
        veryBigObject.l19 = listWithInteger;
        veryBigObject.llll19 = listWithString;
        veryBigObject.m19 = mapWithInteger;
        veryBigObject.mm19 = mapWithObject;
        veryBigObject.s19 = setWithInteger;
        veryBigObject.ssss19 = setWithString;
        veryBigObject.a20 = byteValue;
        veryBigObject.aa20 = byteValue;
        veryBigObject.aaa20 = byteArray;
        veryBigObject.aaaa20 = byteBoxArray;
        veryBigObject.b20 = shortValue;
        veryBigObject.bb20 = shortValue;
        veryBigObject.bbb20 = shortArray;
        veryBigObject.bbbb20 = shortBoxArray;
        veryBigObject.c20 = intValue;
        veryBigObject.cc20 = intValue;
        veryBigObject.ccc20 = intArray;
        veryBigObject.cccc20 = integerArray;
        veryBigObject.d20 = longValue;
        veryBigObject.dd20 = longValue;
        veryBigObject.ddd20 = longArray;
        veryBigObject.dddd20 = longBoxArray;
        veryBigObject.e20 = floatValue;
        veryBigObject.ee20 = floatValue;
        veryBigObject.eee20 = floatArray;
        veryBigObject.eeee20 = floatBoxArray;
        veryBigObject.f20 = doubleValue;
        veryBigObject.ff20 = doubleValue;
        veryBigObject.fff20 = doubleArray;
        veryBigObject.ffff20 = doubleBoxArray;
        veryBigObject.g20 = true;
        veryBigObject.gg20 = true;
        veryBigObject.ggg20 = booleanArray;
        veryBigObject.gggg20 = booleanBoxArray;
        veryBigObject.jj20 = stringValue;
        veryBigObject.jjj20 = stringArray;
        veryBigObject.kk20 = objectA;
        veryBigObject.kkk20 = new ObjectA[]{objectA, objectA};
        veryBigObject.l20 = listWithInteger;
        veryBigObject.llll20 = listWithString;
        veryBigObject.m20 = mapWithInteger;
        veryBigObject.mm20 = mapWithObject;
        veryBigObject.s20 = setWithInteger;
        veryBigObject.ssss20 = setWithString;
        veryBigObject.a21 = byteValue;
        veryBigObject.aa21 = byteValue;
        veryBigObject.aaa21 = byteArray;
        veryBigObject.aaaa21 = byteBoxArray;
        veryBigObject.b21 = shortValue;
        veryBigObject.bb21 = shortValue;
        veryBigObject.bbb21 = shortArray;
        veryBigObject.bbbb21 = shortBoxArray;
        veryBigObject.c21 = intValue;
        veryBigObject.cc21 = intValue;
        veryBigObject.ccc21 = intArray;
        veryBigObject.cccc21 = integerArray;
        veryBigObject.d21 = longValue;
        veryBigObject.dd21 = longValue;
        veryBigObject.ddd21 = longArray;
        veryBigObject.dddd21 = longBoxArray;
        veryBigObject.e21 = floatValue;
        veryBigObject.ee21 = floatValue;
        veryBigObject.eee21 = floatArray;
        veryBigObject.eeee21 = floatBoxArray;
        veryBigObject.f21 = doubleValue;
        veryBigObject.ff21 = doubleValue;
        veryBigObject.fff21 = doubleArray;
        veryBigObject.ffff21 = doubleBoxArray;
        veryBigObject.g21 = true;
        veryBigObject.gg21 = true;
        veryBigObject.ggg21 = booleanArray;
        veryBigObject.gggg21 = booleanBoxArray;
        veryBigObject.jj21 = stringValue;
        veryBigObject.jjj21 = stringArray;
        veryBigObject.kk21 = objectA;
        veryBigObject.kkk21 = new ObjectA[]{objectA, objectA};
        veryBigObject.l21 = listWithInteger;
        veryBigObject.llll21 = listWithString;
        veryBigObject.m21 = mapWithInteger;
        veryBigObject.mm21 = mapWithObject;
        veryBigObject.s21 = setWithInteger;
        veryBigObject.ssss21 = setWithString;
        veryBigObject.a22 = byteValue;
        veryBigObject.aa22 = byteValue;
        veryBigObject.aaa22 = byteArray;
        veryBigObject.aaaa22 = byteBoxArray;
        veryBigObject.b22 = shortValue;
        veryBigObject.bb22 = shortValue;
        veryBigObject.bbb22 = shortArray;
        veryBigObject.bbbb22 = shortBoxArray;
        veryBigObject.c22 = intValue;
        veryBigObject.cc22 = intValue;
        veryBigObject.ccc22 = intArray;
        veryBigObject.cccc22 = integerArray;
        veryBigObject.d22 = longValue;
        veryBigObject.dd22 = longValue;
        veryBigObject.ddd22 = longArray;
        veryBigObject.dddd22 = longBoxArray;
        veryBigObject.e22 = floatValue;
        veryBigObject.ee22 = floatValue;
        veryBigObject.eee22 = floatArray;
        veryBigObject.eeee22 = floatBoxArray;
        veryBigObject.f22 = doubleValue;
        veryBigObject.ff22 = doubleValue;
        veryBigObject.fff22 = doubleArray;
        veryBigObject.ffff22 = doubleBoxArray;
        veryBigObject.g22 = true;
        veryBigObject.gg22 = true;
        veryBigObject.ggg22 = booleanArray;
        veryBigObject.gggg22 = booleanBoxArray;
        veryBigObject.jj22 = stringValue;
        veryBigObject.jjj22 = stringArray;
        veryBigObject.kk22 = objectA;
        veryBigObject.kkk22 = new ObjectA[]{objectA, objectA};
        veryBigObject.l22 = listWithInteger;
        veryBigObject.llll22 = listWithString;
        veryBigObject.m22 = mapWithInteger;
        veryBigObject.mm22 = mapWithObject;
        veryBigObject.s22 = setWithInteger;
        veryBigObject.ssss22 = setWithString;
        veryBigObject.a23 = byteValue;
        veryBigObject.aa23 = byteValue;
        veryBigObject.aaa23 = byteArray;
        veryBigObject.aaaa23 = byteBoxArray;
        veryBigObject.b23 = shortValue;
        veryBigObject.bb23 = shortValue;
        veryBigObject.bbb23 = shortArray;
        veryBigObject.bbbb23 = shortBoxArray;
        veryBigObject.c23 = intValue;
        veryBigObject.cc23 = intValue;
        veryBigObject.ccc23 = intArray;
        veryBigObject.cccc23 = integerArray;
        veryBigObject.d23 = longValue;
        veryBigObject.dd23 = longValue;
        veryBigObject.ddd23 = longArray;
        veryBigObject.dddd23 = longBoxArray;
        veryBigObject.e23 = floatValue;
        veryBigObject.ee23 = floatValue;
        veryBigObject.eee23 = floatArray;
        veryBigObject.eeee23 = floatBoxArray;
        veryBigObject.f23 = doubleValue;
        veryBigObject.ff23 = doubleValue;
        veryBigObject.fff23 = doubleArray;
        veryBigObject.ffff23 = doubleBoxArray;
        veryBigObject.g23 = true;
        veryBigObject.gg23 = true;
        veryBigObject.ggg23 = booleanArray;
        veryBigObject.gggg23 = booleanBoxArray;
        veryBigObject.jj23 = stringValue;
        veryBigObject.jjj23 = stringArray;
        veryBigObject.kk23 = objectA;
        veryBigObject.kkk23 = new ObjectA[]{objectA, objectA};
        veryBigObject.l23 = listWithInteger;
        veryBigObject.llll23 = listWithString;
        veryBigObject.m23 = mapWithInteger;
        veryBigObject.mm23 = mapWithObject;
        veryBigObject.s23 = setWithInteger;
        veryBigObject.ssss23 = setWithString;
        veryBigObject.a24 = byteValue;
        veryBigObject.aa24 = byteValue;
        veryBigObject.aaa24 = byteArray;
        veryBigObject.aaaa24 = byteBoxArray;
        veryBigObject.b24 = shortValue;
        veryBigObject.bb24 = shortValue;
        veryBigObject.bbb24 = shortArray;
        veryBigObject.bbbb24 = shortBoxArray;
        veryBigObject.c24 = intValue;
        veryBigObject.cc24 = intValue;
        veryBigObject.ccc24 = intArray;
        veryBigObject.cccc24 = integerArray;
        veryBigObject.d24 = longValue;
        veryBigObject.dd24 = longValue;
        veryBigObject.ddd24 = longArray;
        veryBigObject.dddd24 = longBoxArray;
        veryBigObject.e24 = floatValue;
        veryBigObject.ee24 = floatValue;
        veryBigObject.eee24 = floatArray;
        veryBigObject.eeee24 = floatBoxArray;
        veryBigObject.f24 = doubleValue;
        veryBigObject.ff24 = doubleValue;
        veryBigObject.fff24 = doubleArray;
        veryBigObject.ffff24 = doubleBoxArray;
        veryBigObject.g24 = true;
        veryBigObject.gg24 = true;
        veryBigObject.ggg24 = booleanArray;
        veryBigObject.gggg24 = booleanBoxArray;
        veryBigObject.jj24 = stringValue;
        veryBigObject.jjj24 = stringArray;
        veryBigObject.kk24 = objectA;
        veryBigObject.kkk24 = new ObjectA[]{objectA, objectA};
        veryBigObject.l24 = listWithInteger;
        veryBigObject.llll24 = listWithString;
        veryBigObject.m24 = mapWithInteger;
        veryBigObject.mm24 = mapWithObject;
        veryBigObject.s24 = setWithInteger;
        veryBigObject.ssss24 = setWithString;
        veryBigObject.a25 = byteValue;
        veryBigObject.aa25 = byteValue;
        veryBigObject.aaa25 = byteArray;
        veryBigObject.aaaa25 = byteBoxArray;
        veryBigObject.b25 = shortValue;
        veryBigObject.bb25 = shortValue;
        veryBigObject.bbb25 = shortArray;
        veryBigObject.bbbb25 = shortBoxArray;
        veryBigObject.c25 = intValue;
        veryBigObject.cc25 = intValue;
        veryBigObject.ccc25 = intArray;
        veryBigObject.cccc25 = integerArray;
        veryBigObject.d25 = longValue;
        veryBigObject.dd25 = longValue;
        veryBigObject.ddd25 = longArray;
        veryBigObject.dddd25 = longBoxArray;
        veryBigObject.e25 = floatValue;
        veryBigObject.ee25 = floatValue;
        veryBigObject.eee25 = floatArray;
        veryBigObject.eeee25 = floatBoxArray;
        veryBigObject.f25 = doubleValue;
        veryBigObject.ff25 = doubleValue;
        veryBigObject.fff25 = doubleArray;
        veryBigObject.ffff25 = doubleBoxArray;
        veryBigObject.g25 = true;
        veryBigObject.gg25 = true;
        veryBigObject.ggg25 = booleanArray;
        veryBigObject.gggg25 = booleanBoxArray;
        veryBigObject.jj25 = stringValue;
        veryBigObject.jjj25 = stringArray;
        veryBigObject.kk25 = objectA;
        veryBigObject.kkk25 = new ObjectA[]{objectA, objectA};
        veryBigObject.l25 = listWithInteger;
        veryBigObject.llll25 = listWithString;
        veryBigObject.m25 = mapWithInteger;
        veryBigObject.mm25 = mapWithObject;
        veryBigObject.s25 = setWithInteger;
        veryBigObject.ssss25 = setWithString;
        veryBigObject.a26 = byteValue;
        veryBigObject.aa26 = byteValue;
        veryBigObject.aaa26 = byteArray;
        veryBigObject.aaaa26 = byteBoxArray;
        veryBigObject.b26 = shortValue;
        veryBigObject.bb26 = shortValue;
        veryBigObject.bbb26 = shortArray;
        veryBigObject.bbbb26 = shortBoxArray;
        veryBigObject.c26 = intValue;
        veryBigObject.cc26 = intValue;
        veryBigObject.ccc26 = intArray;
        veryBigObject.cccc26 = integerArray;
        veryBigObject.d26 = longValue;
        veryBigObject.dd26 = longValue;
        veryBigObject.ddd26 = longArray;
        veryBigObject.dddd26 = longBoxArray;
        veryBigObject.e26 = floatValue;
        veryBigObject.ee26 = floatValue;
        veryBigObject.eee26 = floatArray;
        veryBigObject.eeee26 = floatBoxArray;
        veryBigObject.f26 = doubleValue;
        veryBigObject.ff26 = doubleValue;
        veryBigObject.fff26 = doubleArray;
        veryBigObject.ffff26 = doubleBoxArray;
        veryBigObject.g26 = true;
        veryBigObject.gg26 = true;
        veryBigObject.ggg26 = booleanArray;
        veryBigObject.gggg26 = booleanBoxArray;
        veryBigObject.jj26 = stringValue;
        veryBigObject.jjj26 = stringArray;
        veryBigObject.kk26 = objectA;
        veryBigObject.kkk26 = new ObjectA[]{objectA, objectA};
        veryBigObject.l26 = listWithInteger;
        veryBigObject.llll26 = listWithString;
        veryBigObject.m26 = mapWithInteger;
        veryBigObject.mm26 = mapWithObject;
        veryBigObject.s26 = setWithInteger;
        veryBigObject.ssss26 = setWithString;
        veryBigObject.a27 = byteValue;
        veryBigObject.aa27 = byteValue;
        veryBigObject.aaa27 = byteArray;
        veryBigObject.aaaa27 = byteBoxArray;
        veryBigObject.b27 = shortValue;
        veryBigObject.bb27 = shortValue;
        veryBigObject.bbb27 = shortArray;
        veryBigObject.bbbb27 = shortBoxArray;
        veryBigObject.c27 = intValue;
        veryBigObject.cc27 = intValue;
        veryBigObject.ccc27 = intArray;
        veryBigObject.cccc27 = integerArray;
        veryBigObject.d27 = longValue;
        veryBigObject.dd27 = longValue;
        veryBigObject.ddd27 = longArray;
        veryBigObject.dddd27 = longBoxArray;
        veryBigObject.e27 = floatValue;
        veryBigObject.ee27 = floatValue;
        veryBigObject.eee27 = floatArray;
        veryBigObject.eeee27 = floatBoxArray;
        veryBigObject.f27 = doubleValue;
        veryBigObject.ff27 = doubleValue;
        veryBigObject.fff27 = doubleArray;
        veryBigObject.ffff27 = doubleBoxArray;
        veryBigObject.g27 = true;
        veryBigObject.gg27 = true;
        veryBigObject.ggg27 = booleanArray;
        veryBigObject.gggg27 = booleanBoxArray;
        veryBigObject.jj27 = stringValue;
        veryBigObject.jjj27 = stringArray;
        veryBigObject.kk27 = objectA;
        veryBigObject.kkk27 = new ObjectA[]{objectA, objectA};
        veryBigObject.l27 = listWithInteger;
        veryBigObject.llll27 = listWithString;
        veryBigObject.m27 = mapWithInteger;
        veryBigObject.mm27 = mapWithObject;
        veryBigObject.s27 = setWithInteger;
        veryBigObject.ssss27 = setWithString;
        veryBigObject.a28 = byteValue;
        veryBigObject.aa28 = byteValue;
        veryBigObject.aaa28 = byteArray;
        veryBigObject.aaaa28 = byteBoxArray;
        veryBigObject.b28 = shortValue;
        veryBigObject.bb28 = shortValue;
        veryBigObject.bbb28 = shortArray;
        veryBigObject.bbbb28 = shortBoxArray;
        veryBigObject.c28 = intValue;
        veryBigObject.cc28 = intValue;
        veryBigObject.ccc28 = intArray;
        veryBigObject.cccc28 = integerArray;
        veryBigObject.d28 = longValue;
        veryBigObject.dd28 = longValue;
        veryBigObject.ddd28 = longArray;
        veryBigObject.dddd28 = longBoxArray;
        veryBigObject.e28 = floatValue;
        veryBigObject.ee28 = floatValue;
        veryBigObject.eee28 = floatArray;
        veryBigObject.eeee28 = floatBoxArray;
        veryBigObject.f28 = doubleValue;
        veryBigObject.ff28 = doubleValue;
        veryBigObject.fff28 = doubleArray;
        veryBigObject.ffff28 = doubleBoxArray;
        veryBigObject.g28 = true;
        veryBigObject.gg28 = true;
        veryBigObject.ggg28 = booleanArray;
        veryBigObject.gggg28 = booleanBoxArray;
        veryBigObject.jj28 = stringValue;
        veryBigObject.jjj28 = stringArray;
        veryBigObject.kk28 = objectA;
        veryBigObject.kkk28 = new ObjectA[]{objectA, objectA};
        veryBigObject.l28 = listWithInteger;
        veryBigObject.llll28 = listWithString;
        veryBigObject.m28 = mapWithInteger;
        veryBigObject.mm28 = mapWithObject;
        veryBigObject.s28 = setWithInteger;
        veryBigObject.ssss28 = setWithString;
        veryBigObject.a29 = byteValue;
        veryBigObject.aa29 = byteValue;
        veryBigObject.aaa29 = byteArray;
        veryBigObject.aaaa29 = byteBoxArray;
        veryBigObject.b29 = shortValue;
        veryBigObject.bb29 = shortValue;
        veryBigObject.bbb29 = shortArray;
        veryBigObject.bbbb29 = shortBoxArray;
        veryBigObject.c29 = intValue;
        veryBigObject.cc29 = intValue;
        veryBigObject.ccc29 = intArray;
        veryBigObject.cccc29 = integerArray;
        veryBigObject.d29 = longValue;
        veryBigObject.dd29 = longValue;
        veryBigObject.ddd29 = longArray;
        veryBigObject.dddd29 = longBoxArray;
        veryBigObject.e29 = floatValue;
        veryBigObject.ee29 = floatValue;
        veryBigObject.eee29 = floatArray;
        veryBigObject.eeee29 = floatBoxArray;
        veryBigObject.f29 = doubleValue;
        veryBigObject.ff29 = doubleValue;
        veryBigObject.fff29 = doubleArray;
        veryBigObject.ffff29 = doubleBoxArray;
        veryBigObject.g29 = true;
        veryBigObject.gg29 = true;
        veryBigObject.ggg29 = booleanArray;
        veryBigObject.gggg29 = booleanBoxArray;
        veryBigObject.jj29 = stringValue;
        veryBigObject.jjj29 = stringArray;
        veryBigObject.kk29 = objectA;
        veryBigObject.kkk29 = new ObjectA[]{objectA, objectA};
        veryBigObject.l29 = listWithInteger;
        veryBigObject.llll29 = listWithString;
        veryBigObject.m29 = mapWithInteger;
        veryBigObject.mm29 = mapWithObject;
        veryBigObject.s29 = setWithInteger;
        veryBigObject.ssss29 = setWithString;
        veryBigObject.a30 = byteValue;
        veryBigObject.aa30 = byteValue;
        veryBigObject.aaa30 = byteArray;
        veryBigObject.aaaa30 = byteBoxArray;
        veryBigObject.b30 = shortValue;
        veryBigObject.bb30 = shortValue;
        veryBigObject.bbb30 = shortArray;
        veryBigObject.bbbb30 = shortBoxArray;
        veryBigObject.c30 = intValue;
        veryBigObject.cc30 = intValue;
        veryBigObject.ccc30 = intArray;
        veryBigObject.cccc30 = integerArray;
        veryBigObject.d30 = longValue;
        veryBigObject.dd30 = longValue;
        veryBigObject.ddd30 = longArray;
        veryBigObject.dddd30 = longBoxArray;
        veryBigObject.e30 = floatValue;
        veryBigObject.ee30 = floatValue;
        veryBigObject.eee30 = floatArray;
        veryBigObject.eeee30 = floatBoxArray;
        veryBigObject.f30 = doubleValue;
        veryBigObject.ff30 = doubleValue;
        veryBigObject.fff30 = doubleArray;
        veryBigObject.ffff30 = doubleBoxArray;
        veryBigObject.g30 = true;
        veryBigObject.gg30 = true;
        veryBigObject.ggg30 = booleanArray;
        veryBigObject.gggg30 = booleanBoxArray;
        veryBigObject.jj30 = stringValue;
        veryBigObject.jjj30 = stringArray;
        veryBigObject.kk30 = objectA;
        veryBigObject.kkk30 = new ObjectA[]{objectA, objectA};
        veryBigObject.l30 = listWithInteger;
        veryBigObject.llll30 = listWithString;
        veryBigObject.m30 = mapWithInteger;
        veryBigObject.mm30 = mapWithObject;
        veryBigObject.s30 = setWithInteger;
        veryBigObject.ssss30 = setWithString;
        veryBigObject.a31 = byteValue;
        veryBigObject.aa31 = byteValue;
        veryBigObject.aaa31 = byteArray;
        veryBigObject.aaaa31 = byteBoxArray;
        veryBigObject.b31 = shortValue;
        veryBigObject.bb31 = shortValue;
        veryBigObject.bbb31 = shortArray;
        veryBigObject.bbbb31 = shortBoxArray;
        veryBigObject.c31 = intValue;
        veryBigObject.cc31 = intValue;
        veryBigObject.ccc31 = intArray;
        veryBigObject.cccc31 = integerArray;
        veryBigObject.d31 = longValue;
        veryBigObject.dd31 = longValue;
        veryBigObject.ddd31 = longArray;
        veryBigObject.dddd31 = longBoxArray;
        veryBigObject.e31 = floatValue;
        veryBigObject.ee31 = floatValue;
        veryBigObject.eee31 = floatArray;
        veryBigObject.eeee31 = floatBoxArray;
        veryBigObject.f31 = doubleValue;
        veryBigObject.ff31 = doubleValue;
        veryBigObject.fff31 = doubleArray;
        veryBigObject.ffff31 = doubleBoxArray;
        veryBigObject.g31 = true;
        veryBigObject.gg31 = true;
        veryBigObject.ggg31 = booleanArray;
        veryBigObject.gggg31 = booleanBoxArray;
        veryBigObject.jj31 = stringValue;
        veryBigObject.jjj31 = stringArray;
        veryBigObject.kk31 = objectA;
        veryBigObject.kkk31 = new ObjectA[]{objectA, objectA};
        veryBigObject.l31 = listWithInteger;
        veryBigObject.llll31 = listWithString;
        veryBigObject.m31 = mapWithInteger;
        veryBigObject.mm31 = mapWithObject;
        veryBigObject.s31 = setWithInteger;
        veryBigObject.ssss31 = setWithString;
        veryBigObject.a32 = byteValue;
        veryBigObject.aa32 = byteValue;
        veryBigObject.aaa32 = byteArray;
        veryBigObject.aaaa32 = byteBoxArray;
        veryBigObject.b32 = shortValue;
        veryBigObject.bb32 = shortValue;
        veryBigObject.bbb32 = shortArray;
        veryBigObject.bbbb32 = shortBoxArray;
        veryBigObject.c32 = intValue;
        veryBigObject.cc32 = intValue;
        veryBigObject.ccc32 = intArray;
        veryBigObject.cccc32 = integerArray;
        veryBigObject.d32 = longValue;
        veryBigObject.dd32 = longValue;
        veryBigObject.ddd32 = longArray;
        veryBigObject.dddd32 = longBoxArray;
        veryBigObject.e32 = floatValue;
        veryBigObject.ee32 = floatValue;
        veryBigObject.eee32 = floatArray;
        veryBigObject.eeee32 = floatBoxArray;
        veryBigObject.f32 = doubleValue;
        veryBigObject.ff32 = doubleValue;
        veryBigObject.fff32 = doubleArray;
        veryBigObject.ffff32 = doubleBoxArray;
        veryBigObject.g32 = true;
        veryBigObject.gg32 = true;
        veryBigObject.ggg32 = booleanArray;
        veryBigObject.gggg32 = booleanBoxArray;
        veryBigObject.jj32 = stringValue;
        veryBigObject.jjj32 = stringArray;
        veryBigObject.kk32 = objectA;
        veryBigObject.kkk32 = new ObjectA[]{objectA, objectA};
        veryBigObject.l32 = listWithInteger;
        veryBigObject.llll32 = listWithString;
        veryBigObject.m32 = mapWithInteger;
        veryBigObject.mm32 = mapWithObject;
        veryBigObject.s32 = setWithInteger;
        veryBigObject.ssss32 = setWithString;
        veryBigObject.a33 = byteValue;
        veryBigObject.aa33 = byteValue;
        veryBigObject.aaa33 = byteArray;
        veryBigObject.aaaa33 = byteBoxArray;
        veryBigObject.b33 = shortValue;
        veryBigObject.bb33 = shortValue;
        veryBigObject.bbb33 = shortArray;
        veryBigObject.bbbb33 = shortBoxArray;
        veryBigObject.c33 = intValue;
        veryBigObject.cc33 = intValue;
        veryBigObject.ccc33 = intArray;
        veryBigObject.cccc33 = integerArray;
        veryBigObject.d33 = longValue;
        veryBigObject.dd33 = longValue;
        veryBigObject.ddd33 = longArray;
        veryBigObject.dddd33 = longBoxArray;
        veryBigObject.e33 = floatValue;
        veryBigObject.ee33 = floatValue;
        veryBigObject.eee33 = floatArray;
        veryBigObject.eeee33 = floatBoxArray;
        veryBigObject.f33 = doubleValue;
        veryBigObject.ff33 = doubleValue;
        veryBigObject.fff33 = doubleArray;
        veryBigObject.ffff33 = doubleBoxArray;
        veryBigObject.g33 = true;
        veryBigObject.gg33 = true;
        veryBigObject.ggg33 = booleanArray;
        veryBigObject.gggg33 = booleanBoxArray;
        veryBigObject.jj33 = stringValue;
        veryBigObject.jjj33 = stringArray;
        veryBigObject.kk33 = objectA;
        veryBigObject.kkk33 = new ObjectA[]{objectA, objectA};
        veryBigObject.l33 = listWithInteger;
        veryBigObject.llll33 = listWithString;
        veryBigObject.m33 = mapWithInteger;
        veryBigObject.mm33 = mapWithObject;
        veryBigObject.s33 = setWithInteger;
        veryBigObject.ssss33 = setWithString;
        veryBigObject.a34 = byteValue;
        veryBigObject.aa34 = byteValue;
        veryBigObject.aaa34 = byteArray;
        veryBigObject.aaaa34 = byteBoxArray;
        veryBigObject.b34 = shortValue;
        veryBigObject.bb34 = shortValue;
        veryBigObject.bbb34 = shortArray;
        veryBigObject.bbbb34 = shortBoxArray;
        veryBigObject.c34 = intValue;
        veryBigObject.cc34 = intValue;
        veryBigObject.ccc34 = intArray;
        veryBigObject.cccc34 = integerArray;
        veryBigObject.d34 = longValue;
        veryBigObject.dd34 = longValue;
        veryBigObject.ddd34 = longArray;
        veryBigObject.dddd34 = longBoxArray;
        veryBigObject.e34 = floatValue;
        veryBigObject.ee34 = floatValue;
        veryBigObject.eee34 = floatArray;
        veryBigObject.eeee34 = floatBoxArray;
        veryBigObject.f34 = doubleValue;
        veryBigObject.ff34 = doubleValue;
        veryBigObject.fff34 = doubleArray;
        veryBigObject.ffff34 = doubleBoxArray;
        veryBigObject.g34 = true;
        veryBigObject.gg34 = true;
        veryBigObject.ggg34 = booleanArray;
        veryBigObject.gggg34 = booleanBoxArray;
        veryBigObject.jj34 = stringValue;
        veryBigObject.jjj34 = stringArray;
        veryBigObject.kk34 = objectA;
        veryBigObject.kkk34 = new ObjectA[]{objectA, objectA};
        veryBigObject.l34 = listWithInteger;
        veryBigObject.llll34 = listWithString;
        veryBigObject.m34 = mapWithInteger;
        veryBigObject.mm34 = mapWithObject;
        veryBigObject.s34 = setWithInteger;
        veryBigObject.ssss34 = setWithString;
        veryBigObject.a35 = byteValue;
        veryBigObject.aa35 = byteValue;
        veryBigObject.aaa35 = byteArray;
        veryBigObject.aaaa35 = byteBoxArray;
        veryBigObject.b35 = shortValue;
        veryBigObject.bb35 = shortValue;
        veryBigObject.bbb35 = shortArray;
        veryBigObject.bbbb35 = shortBoxArray;
        veryBigObject.c35 = intValue;
        veryBigObject.cc35 = intValue;
        veryBigObject.ccc35 = intArray;
        veryBigObject.cccc35 = integerArray;
        veryBigObject.d35 = longValue;
        veryBigObject.dd35 = longValue;
        veryBigObject.ddd35 = longArray;
        veryBigObject.dddd35 = longBoxArray;
        veryBigObject.e35 = floatValue;
        veryBigObject.ee35 = floatValue;
        veryBigObject.eee35 = floatArray;
        veryBigObject.eeee35 = floatBoxArray;
        veryBigObject.f35 = doubleValue;
        veryBigObject.ff35 = doubleValue;
        veryBigObject.fff35 = doubleArray;
        veryBigObject.ffff35 = doubleBoxArray;
        veryBigObject.g35 = true;
        veryBigObject.gg35 = true;
        veryBigObject.ggg35 = booleanArray;
        veryBigObject.gggg35 = booleanBoxArray;
        veryBigObject.jj35 = stringValue;
        veryBigObject.jjj35 = stringArray;
        veryBigObject.kk35 = objectA;
        veryBigObject.kkk35 = new ObjectA[]{objectA, objectA};
        veryBigObject.l35 = listWithInteger;
        veryBigObject.llll35 = listWithString;
        veryBigObject.m35 = mapWithInteger;
        veryBigObject.mm35 = mapWithObject;
        veryBigObject.s35 = setWithInteger;
        veryBigObject.ssss35 = setWithString;
        veryBigObject.a36 = byteValue;
        veryBigObject.aa36 = byteValue;
        veryBigObject.aaa36 = byteArray;
        veryBigObject.aaaa36 = byteBoxArray;
        veryBigObject.b36 = shortValue;
        veryBigObject.bb36 = shortValue;
        veryBigObject.bbb36 = shortArray;
        veryBigObject.bbbb36 = shortBoxArray;
        veryBigObject.c36 = intValue;
        veryBigObject.cc36 = intValue;
        veryBigObject.ccc36 = intArray;
        veryBigObject.cccc36 = integerArray;
        veryBigObject.d36 = longValue;
        veryBigObject.dd36 = longValue;
        veryBigObject.ddd36 = longArray;
        veryBigObject.dddd36 = longBoxArray;
        veryBigObject.e36 = floatValue;
        veryBigObject.ee36 = floatValue;
        veryBigObject.eee36 = floatArray;
        veryBigObject.eeee36 = floatBoxArray;
        veryBigObject.f36 = doubleValue;
        veryBigObject.ff36 = doubleValue;
        veryBigObject.fff36 = doubleArray;
        veryBigObject.ffff36 = doubleBoxArray;
        veryBigObject.g36 = true;
        veryBigObject.gg36 = true;
        veryBigObject.ggg36 = booleanArray;
        veryBigObject.gggg36 = booleanBoxArray;
        veryBigObject.jj36 = stringValue;
        veryBigObject.jjj36 = stringArray;
        veryBigObject.kk36 = objectA;
        veryBigObject.kkk36 = new ObjectA[]{objectA, objectA};
        veryBigObject.l36 = listWithInteger;
        veryBigObject.llll36 = listWithString;
        veryBigObject.m36 = mapWithInteger;
        veryBigObject.mm36 = mapWithObject;
        veryBigObject.s36 = setWithInteger;
        veryBigObject.ssss36 = setWithString;
        veryBigObject.a37 = byteValue;
        veryBigObject.aa37 = byteValue;
        veryBigObject.aaa37 = byteArray;
        veryBigObject.aaaa37 = byteBoxArray;
        veryBigObject.b37 = shortValue;
        veryBigObject.bb37 = shortValue;
        veryBigObject.bbb37 = shortArray;
        veryBigObject.bbbb37 = shortBoxArray;
        veryBigObject.c37 = intValue;
        veryBigObject.cc37 = intValue;
        veryBigObject.ccc37 = intArray;
        veryBigObject.cccc37 = integerArray;
        veryBigObject.d37 = longValue;
        veryBigObject.dd37 = longValue;
        veryBigObject.ddd37 = longArray;
        veryBigObject.dddd37 = longBoxArray;
        veryBigObject.e37 = floatValue;
        veryBigObject.ee37 = floatValue;
        veryBigObject.eee37 = floatArray;
        veryBigObject.eeee37 = floatBoxArray;
        veryBigObject.f37 = doubleValue;
        veryBigObject.ff37 = doubleValue;
        veryBigObject.fff37 = doubleArray;
        veryBigObject.ffff37 = doubleBoxArray;
        veryBigObject.g37 = true;
        veryBigObject.gg37 = true;
        veryBigObject.ggg37 = booleanArray;
        veryBigObject.gggg37 = booleanBoxArray;
        veryBigObject.jj37 = stringValue;
        veryBigObject.jjj37 = stringArray;
        veryBigObject.kk37 = objectA;
        veryBigObject.kkk37 = new ObjectA[]{objectA, objectA};
        veryBigObject.l37 = listWithInteger;
        veryBigObject.llll37 = listWithString;
        veryBigObject.m37 = mapWithInteger;
        veryBigObject.mm37 = mapWithObject;
        veryBigObject.s37 = setWithInteger;
        veryBigObject.ssss37 = setWithString;
        veryBigObject.a38 = byteValue;
        veryBigObject.aa38 = byteValue;
        veryBigObject.aaa38 = byteArray;
        veryBigObject.aaaa38 = byteBoxArray;
        veryBigObject.b38 = shortValue;
        veryBigObject.bb38 = shortValue;
        veryBigObject.bbb38 = shortArray;
        veryBigObject.bbbb38 = shortBoxArray;
        veryBigObject.c38 = intValue;
        veryBigObject.cc38 = intValue;
        veryBigObject.ccc38 = intArray;
        veryBigObject.cccc38 = integerArray;
        veryBigObject.d38 = longValue;
        veryBigObject.dd38 = longValue;
        veryBigObject.ddd38 = longArray;
        veryBigObject.dddd38 = longBoxArray;
        veryBigObject.e38 = floatValue;
        veryBigObject.ee38 = floatValue;
        veryBigObject.eee38 = floatArray;
        veryBigObject.eeee38 = floatBoxArray;
        veryBigObject.f38 = doubleValue;
        veryBigObject.ff38 = doubleValue;
        veryBigObject.fff38 = doubleArray;
        veryBigObject.ffff38 = doubleBoxArray;
        veryBigObject.g38 = true;
        veryBigObject.gg38 = true;
        veryBigObject.ggg38 = booleanArray;
        veryBigObject.gggg38 = booleanBoxArray;
        veryBigObject.jj38 = stringValue;
        veryBigObject.jjj38 = stringArray;
        veryBigObject.kk38 = objectA;
        veryBigObject.kkk38 = new ObjectA[]{objectA, objectA};
        veryBigObject.l38 = listWithInteger;
        veryBigObject.llll38 = listWithString;
        veryBigObject.m38 = mapWithInteger;
        veryBigObject.mm38 = mapWithObject;
        veryBigObject.s38 = setWithInteger;
        veryBigObject.ssss38 = setWithString;
        veryBigObject.a39 = byteValue;
        veryBigObject.aa39 = byteValue;
        veryBigObject.aaa39 = byteArray;
        veryBigObject.aaaa39 = byteBoxArray;
        veryBigObject.b39 = shortValue;
        veryBigObject.bb39 = shortValue;
        veryBigObject.bbb39 = shortArray;
        veryBigObject.bbbb39 = shortBoxArray;
        veryBigObject.c39 = intValue;
        veryBigObject.cc39 = intValue;
        veryBigObject.ccc39 = intArray;
        veryBigObject.cccc39 = integerArray;
        veryBigObject.d39 = longValue;
        veryBigObject.dd39 = longValue;
        veryBigObject.ddd39 = longArray;
        veryBigObject.dddd39 = longBoxArray;
        veryBigObject.e39 = floatValue;
        veryBigObject.ee39 = floatValue;
        veryBigObject.eee39 = floatArray;
        veryBigObject.eeee39 = floatBoxArray;
        veryBigObject.f39 = doubleValue;
        veryBigObject.ff39 = doubleValue;
        veryBigObject.fff39 = doubleArray;
        veryBigObject.ffff39 = doubleBoxArray;
        veryBigObject.g39 = true;
        veryBigObject.gg39 = true;
        veryBigObject.ggg39 = booleanArray;
        veryBigObject.gggg39 = booleanBoxArray;
        veryBigObject.jj39 = stringValue;
        veryBigObject.jjj39 = stringArray;
        veryBigObject.kk39 = objectA;
        veryBigObject.kkk39 = new ObjectA[]{objectA, objectA};
        veryBigObject.l39 = listWithInteger;
        veryBigObject.llll39 = listWithString;
        veryBigObject.m39 = mapWithInteger;
        veryBigObject.mm39 = mapWithObject;
        veryBigObject.s39 = setWithInteger;
        veryBigObject.ssss39 = setWithString;
        veryBigObject.a40 = byteValue;
        veryBigObject.aa40 = byteValue;
        veryBigObject.aaa40 = byteArray;
        veryBigObject.aaaa40 = byteBoxArray;
        veryBigObject.b40 = shortValue;
        veryBigObject.bb40 = shortValue;
        veryBigObject.bbb40 = shortArray;
        veryBigObject.bbbb40 = shortBoxArray;
        veryBigObject.c40 = intValue;
        veryBigObject.cc40 = intValue;
        veryBigObject.ccc40 = intArray;
        veryBigObject.cccc40 = integerArray;
        veryBigObject.d40 = longValue;
        veryBigObject.dd40 = longValue;
        veryBigObject.ddd40 = longArray;
        veryBigObject.dddd40 = longBoxArray;
        veryBigObject.e40 = floatValue;
        veryBigObject.ee40 = floatValue;
        veryBigObject.eee40 = floatArray;
        veryBigObject.eeee40 = floatBoxArray;
        veryBigObject.f40 = doubleValue;
        veryBigObject.ff40 = doubleValue;
        veryBigObject.fff40 = doubleArray;
        veryBigObject.ffff40 = doubleBoxArray;
        veryBigObject.g40 = true;
        veryBigObject.gg40 = true;
        veryBigObject.ggg40 = booleanArray;
        veryBigObject.gggg40 = booleanBoxArray;
        veryBigObject.jj40 = stringValue;
        veryBigObject.jjj40 = stringArray;
        veryBigObject.kk40 = objectA;
        veryBigObject.kkk40 = new ObjectA[]{objectA, objectA};
        veryBigObject.l40 = listWithInteger;
        veryBigObject.llll40 = listWithString;
        veryBigObject.m40 = mapWithInteger;
        veryBigObject.mm40 = mapWithObject;
        veryBigObject.s40 = setWithInteger;
        veryBigObject.ssss40 = setWithString;
        veryBigObject.a41 = byteValue;
        veryBigObject.aa41 = byteValue;
        veryBigObject.aaa41 = byteArray;
        veryBigObject.aaaa41 = byteBoxArray;
        veryBigObject.b41 = shortValue;
        veryBigObject.bb41 = shortValue;
        veryBigObject.bbb41 = shortArray;
        veryBigObject.bbbb41 = shortBoxArray;
        veryBigObject.c41 = intValue;
        veryBigObject.cc41 = intValue;
        veryBigObject.ccc41 = intArray;
        veryBigObject.cccc41 = integerArray;
        veryBigObject.d41 = longValue;
        veryBigObject.dd41 = longValue;
        veryBigObject.ddd41 = longArray;
        veryBigObject.dddd41 = longBoxArray;
        veryBigObject.e41 = floatValue;
        veryBigObject.ee41 = floatValue;
        veryBigObject.eee41 = floatArray;
        veryBigObject.eeee41 = floatBoxArray;
        veryBigObject.f41 = doubleValue;
        veryBigObject.ff41 = doubleValue;
        veryBigObject.fff41 = doubleArray;
        veryBigObject.ffff41 = doubleBoxArray;
        veryBigObject.g41 = true;
        veryBigObject.gg41 = true;
        veryBigObject.ggg41 = booleanArray;
        veryBigObject.gggg41 = booleanBoxArray;
        veryBigObject.jj41 = stringValue;
        veryBigObject.jjj41 = stringArray;
        veryBigObject.kk41 = objectA;
        veryBigObject.kkk41 = new ObjectA[]{objectA, objectA};
        veryBigObject.l41 = listWithInteger;
        veryBigObject.llll41 = listWithString;
        veryBigObject.m41 = mapWithInteger;
        veryBigObject.mm41 = mapWithObject;
        veryBigObject.s41 = setWithInteger;
        veryBigObject.ssss41 = setWithString;
        veryBigObject.a42 = byteValue;
        veryBigObject.aa42 = byteValue;
        veryBigObject.aaa42 = byteArray;
        veryBigObject.aaaa42 = byteBoxArray;
        veryBigObject.b42 = shortValue;
        veryBigObject.bb42 = shortValue;
        veryBigObject.bbb42 = shortArray;
        veryBigObject.bbbb42 = shortBoxArray;
        veryBigObject.c42 = intValue;
        veryBigObject.cc42 = intValue;
        veryBigObject.ccc42 = intArray;
        veryBigObject.cccc42 = integerArray;
        veryBigObject.d42 = longValue;
        veryBigObject.dd42 = longValue;
        veryBigObject.ddd42 = longArray;
        veryBigObject.dddd42 = longBoxArray;
        veryBigObject.e42 = floatValue;
        veryBigObject.ee42 = floatValue;
        veryBigObject.eee42 = floatArray;
        veryBigObject.eeee42 = floatBoxArray;
        veryBigObject.f42 = doubleValue;
        veryBigObject.ff42 = doubleValue;
        veryBigObject.fff42 = doubleArray;
        veryBigObject.ffff42 = doubleBoxArray;
        veryBigObject.g42 = true;
        veryBigObject.gg42 = true;
        veryBigObject.ggg42 = booleanArray;
        veryBigObject.gggg42 = booleanBoxArray;
        veryBigObject.jj42 = stringValue;
        veryBigObject.jjj42 = stringArray;
        veryBigObject.kk42 = objectA;
        veryBigObject.kkk42 = new ObjectA[]{objectA, objectA};
        veryBigObject.l42 = listWithInteger;
        veryBigObject.llll42 = listWithString;
        veryBigObject.m42 = mapWithInteger;
        veryBigObject.mm42 = mapWithObject;
        veryBigObject.s42 = setWithInteger;
        veryBigObject.ssss42 = setWithString;
        veryBigObject.a43 = byteValue;
        veryBigObject.aa43 = byteValue;
        veryBigObject.aaa43 = byteArray;
        veryBigObject.aaaa43 = byteBoxArray;
        veryBigObject.b43 = shortValue;
        veryBigObject.bb43 = shortValue;
        veryBigObject.bbb43 = shortArray;
        veryBigObject.bbbb43 = shortBoxArray;
        veryBigObject.c43 = intValue;
        veryBigObject.cc43 = intValue;
        veryBigObject.ccc43 = intArray;
        veryBigObject.cccc43 = integerArray;
        veryBigObject.d43 = longValue;
        veryBigObject.dd43 = longValue;
        veryBigObject.ddd43 = longArray;
        veryBigObject.dddd43 = longBoxArray;
        veryBigObject.e43 = floatValue;
        veryBigObject.ee43 = floatValue;
        veryBigObject.eee43 = floatArray;
        veryBigObject.eeee43 = floatBoxArray;
        veryBigObject.f43 = doubleValue;
        veryBigObject.ff43 = doubleValue;
        veryBigObject.fff43 = doubleArray;
        veryBigObject.ffff43 = doubleBoxArray;
        veryBigObject.g43 = true;
        veryBigObject.gg43 = true;
        veryBigObject.ggg43 = booleanArray;
        veryBigObject.gggg43 = booleanBoxArray;
        veryBigObject.jj43 = stringValue;
        veryBigObject.jjj43 = stringArray;
        veryBigObject.kk43 = objectA;
        veryBigObject.kkk43 = new ObjectA[]{objectA, objectA};
        veryBigObject.l43 = listWithInteger;
        veryBigObject.llll43 = listWithString;
        veryBigObject.m43 = mapWithInteger;
        veryBigObject.mm43 = mapWithObject;
        veryBigObject.s43 = setWithInteger;
        veryBigObject.ssss43 = setWithString;
        veryBigObject.a44 = byteValue;
        veryBigObject.aa44 = byteValue;
        veryBigObject.aaa44 = byteArray;
        veryBigObject.aaaa44 = byteBoxArray;
        veryBigObject.b44 = shortValue;
        veryBigObject.bb44 = shortValue;
        veryBigObject.bbb44 = shortArray;
        veryBigObject.bbbb44 = shortBoxArray;
        veryBigObject.c44 = intValue;
        veryBigObject.cc44 = intValue;
        veryBigObject.ccc44 = intArray;
        veryBigObject.cccc44 = integerArray;
        veryBigObject.d44 = longValue;
        veryBigObject.dd44 = longValue;
        veryBigObject.ddd44 = longArray;
        veryBigObject.dddd44 = longBoxArray;
        veryBigObject.e44 = floatValue;
        veryBigObject.ee44 = floatValue;
        veryBigObject.eee44 = floatArray;
        veryBigObject.eeee44 = floatBoxArray;
        veryBigObject.f44 = doubleValue;
        veryBigObject.ff44 = doubleValue;
        veryBigObject.fff44 = doubleArray;
        veryBigObject.ffff44 = doubleBoxArray;
        veryBigObject.g44 = true;
        veryBigObject.gg44 = true;
        veryBigObject.ggg44 = booleanArray;
        veryBigObject.gggg44 = booleanBoxArray;
        veryBigObject.jj44 = stringValue;
        veryBigObject.jjj44 = stringArray;
        veryBigObject.kk44 = objectA;
        veryBigObject.kkk44 = new ObjectA[]{objectA, objectA};
        veryBigObject.l44 = listWithInteger;
        veryBigObject.llll44 = listWithString;
        veryBigObject.m44 = mapWithInteger;
        veryBigObject.mm44 = mapWithObject;
        veryBigObject.s44 = setWithInteger;
        veryBigObject.ssss44 = setWithString;
        veryBigObject.a45 = byteValue;
        veryBigObject.aa45 = byteValue;
        veryBigObject.aaa45 = byteArray;
        veryBigObject.aaaa45 = byteBoxArray;
        veryBigObject.b45 = shortValue;
        veryBigObject.bb45 = shortValue;
        veryBigObject.bbb45 = shortArray;
        veryBigObject.bbbb45 = shortBoxArray;
        veryBigObject.c45 = intValue;
        veryBigObject.cc45 = intValue;
        veryBigObject.ccc45 = intArray;
        veryBigObject.cccc45 = integerArray;
        veryBigObject.d45 = longValue;
        veryBigObject.dd45 = longValue;
        veryBigObject.ddd45 = longArray;
        veryBigObject.dddd45 = longBoxArray;
        veryBigObject.e45 = floatValue;
        veryBigObject.ee45 = floatValue;
        veryBigObject.eee45 = floatArray;
        veryBigObject.eeee45 = floatBoxArray;
        veryBigObject.f45 = doubleValue;
        veryBigObject.ff45 = doubleValue;
        veryBigObject.fff45 = doubleArray;
        veryBigObject.ffff45 = doubleBoxArray;
        veryBigObject.g45 = true;
        veryBigObject.gg45 = true;
        veryBigObject.ggg45 = booleanArray;
        veryBigObject.gggg45 = booleanBoxArray;
        veryBigObject.jj45 = stringValue;
        veryBigObject.jjj45 = stringArray;
        veryBigObject.kk45 = objectA;
        veryBigObject.kkk45 = new ObjectA[]{objectA, objectA};
        veryBigObject.l45 = listWithInteger;
        veryBigObject.llll45 = listWithString;
        veryBigObject.m45 = mapWithInteger;
        veryBigObject.mm45 = mapWithObject;
        veryBigObject.s45 = setWithInteger;
        veryBigObject.ssss45 = setWithString;
        veryBigObject.a46 = byteValue;
        veryBigObject.aa46 = byteValue;
        veryBigObject.aaa46 = byteArray;
        veryBigObject.aaaa46 = byteBoxArray;
        veryBigObject.b46 = shortValue;
        veryBigObject.bb46 = shortValue;
        veryBigObject.bbb46 = shortArray;
        veryBigObject.bbbb46 = shortBoxArray;
        veryBigObject.c46 = intValue;
        veryBigObject.cc46 = intValue;
        veryBigObject.ccc46 = intArray;
        veryBigObject.cccc46 = integerArray;
        veryBigObject.d46 = longValue;
        veryBigObject.dd46 = longValue;
        veryBigObject.ddd46 = longArray;
        veryBigObject.dddd46 = longBoxArray;
        veryBigObject.e46 = floatValue;
        veryBigObject.ee46 = floatValue;
        veryBigObject.eee46 = floatArray;
        veryBigObject.eeee46 = floatBoxArray;
        veryBigObject.f46 = doubleValue;
        veryBigObject.ff46 = doubleValue;
        veryBigObject.fff46 = doubleArray;
        veryBigObject.ffff46 = doubleBoxArray;
        veryBigObject.g46 = true;
        veryBigObject.gg46 = true;
        veryBigObject.ggg46 = booleanArray;
        veryBigObject.gggg46 = booleanBoxArray;
        veryBigObject.jj46 = stringValue;
        veryBigObject.jjj46 = stringArray;
        veryBigObject.kk46 = objectA;
        veryBigObject.kkk46 = new ObjectA[]{objectA, objectA};
        veryBigObject.l46 = listWithInteger;
        veryBigObject.llll46 = listWithString;
        veryBigObject.m46 = mapWithInteger;
        veryBigObject.mm46 = mapWithObject;
        veryBigObject.s46 = setWithInteger;
        veryBigObject.ssss46 = setWithString;
        veryBigObject.a47 = byteValue;
        veryBigObject.aa47 = byteValue;
        veryBigObject.aaa47 = byteArray;
        veryBigObject.aaaa47 = byteBoxArray;
        veryBigObject.b47 = shortValue;
        veryBigObject.bb47 = shortValue;
        veryBigObject.bbb47 = shortArray;
        veryBigObject.bbbb47 = shortBoxArray;
        veryBigObject.c47 = intValue;
        veryBigObject.cc47 = intValue;
        veryBigObject.ccc47 = intArray;
        veryBigObject.cccc47 = integerArray;
        veryBigObject.d47 = longValue;
        veryBigObject.dd47 = longValue;
        veryBigObject.ddd47 = longArray;
        veryBigObject.dddd47 = longBoxArray;
        veryBigObject.e47 = floatValue;
        veryBigObject.ee47 = floatValue;
        veryBigObject.eee47 = floatArray;
        veryBigObject.eeee47 = floatBoxArray;
        veryBigObject.f47 = doubleValue;
        veryBigObject.ff47 = doubleValue;
        veryBigObject.fff47 = doubleArray;
        veryBigObject.ffff47 = doubleBoxArray;
        veryBigObject.g47 = true;
        veryBigObject.gg47 = true;
        veryBigObject.ggg47 = booleanArray;
        veryBigObject.gggg47 = booleanBoxArray;
        veryBigObject.jj47 = stringValue;
        veryBigObject.jjj47 = stringArray;
        veryBigObject.kk47 = objectA;
        veryBigObject.kkk47 = new ObjectA[]{objectA, objectA};
        veryBigObject.l47 = listWithInteger;
        veryBigObject.llll47 = listWithString;
        veryBigObject.m47 = mapWithInteger;
        veryBigObject.mm47 = mapWithObject;
        veryBigObject.s47 = setWithInteger;
        veryBigObject.ssss47 = setWithString;
        veryBigObject.a48 = byteValue;
        veryBigObject.aa48 = byteValue;
        veryBigObject.aaa48 = byteArray;
        veryBigObject.aaaa48 = byteBoxArray;
        veryBigObject.b48 = shortValue;
        veryBigObject.bb48 = shortValue;
        veryBigObject.bbb48 = shortArray;
        veryBigObject.bbbb48 = shortBoxArray;
        veryBigObject.c48 = intValue;
        veryBigObject.cc48 = intValue;
        veryBigObject.ccc48 = intArray;
        veryBigObject.cccc48 = integerArray;
        veryBigObject.d48 = longValue;
        veryBigObject.dd48 = longValue;
        veryBigObject.ddd48 = longArray;
        veryBigObject.dddd48 = longBoxArray;
        veryBigObject.e48 = floatValue;
        veryBigObject.ee48 = floatValue;
        veryBigObject.eee48 = floatArray;
        veryBigObject.eeee48 = floatBoxArray;
        veryBigObject.f48 = doubleValue;
        veryBigObject.ff48 = doubleValue;
        veryBigObject.fff48 = doubleArray;
        veryBigObject.ffff48 = doubleBoxArray;
        veryBigObject.g48 = true;
        veryBigObject.gg48 = true;
        veryBigObject.ggg48 = booleanArray;
        veryBigObject.gggg48 = booleanBoxArray;
        veryBigObject.jj48 = stringValue;
        veryBigObject.jjj48 = stringArray;
        veryBigObject.kk48 = objectA;
        veryBigObject.kkk48 = new ObjectA[]{objectA, objectA};
        veryBigObject.l48 = listWithInteger;
        veryBigObject.llll48 = listWithString;
        veryBigObject.m48 = mapWithInteger;
        veryBigObject.mm48 = mapWithObject;
        veryBigObject.s48 = setWithInteger;
        veryBigObject.ssss48 = setWithString;
        veryBigObject.a49 = byteValue;
        veryBigObject.aa49 = byteValue;
        veryBigObject.aaa49 = byteArray;
        veryBigObject.aaaa49 = byteBoxArray;
        veryBigObject.b49 = shortValue;
        veryBigObject.bb49 = shortValue;
        veryBigObject.bbb49 = shortArray;
        veryBigObject.bbbb49 = shortBoxArray;
        veryBigObject.c49 = intValue;
        veryBigObject.cc49 = intValue;
        veryBigObject.ccc49 = intArray;
        veryBigObject.cccc49 = integerArray;
        veryBigObject.d49 = longValue;
        veryBigObject.dd49 = longValue;
        veryBigObject.ddd49 = longArray;
        veryBigObject.dddd49 = longBoxArray;
        veryBigObject.e49 = floatValue;
        veryBigObject.ee49 = floatValue;
        veryBigObject.eee49 = floatArray;
        veryBigObject.eeee49 = floatBoxArray;
        veryBigObject.f49 = doubleValue;
        veryBigObject.ff49 = doubleValue;
        veryBigObject.fff49 = doubleArray;
        veryBigObject.ffff49 = doubleBoxArray;
        veryBigObject.g49 = true;
        veryBigObject.gg49 = true;
        veryBigObject.ggg49 = booleanArray;
        veryBigObject.gggg49 = booleanBoxArray;
        veryBigObject.jj49 = stringValue;
        veryBigObject.jjj49 = stringArray;
        veryBigObject.kk49 = objectA;
        veryBigObject.kkk49 = new ObjectA[]{objectA, objectA};
        veryBigObject.l49 = listWithInteger;
        veryBigObject.llll49 = listWithString;
        veryBigObject.m49 = mapWithInteger;
        veryBigObject.mm49 = mapWithObject;
        veryBigObject.s49 = setWithInteger;
        veryBigObject.ssss49 = setWithString;
        veryBigObject.a50 = byteValue;
        veryBigObject.aa50 = byteValue;
        veryBigObject.aaa50 = byteArray;
        veryBigObject.aaaa50 = byteBoxArray;
        veryBigObject.b50 = shortValue;
        veryBigObject.bb50 = shortValue;
        veryBigObject.bbb50 = shortArray;
        veryBigObject.bbbb50 = shortBoxArray;
        veryBigObject.c50 = intValue;
        veryBigObject.cc50 = intValue;
        veryBigObject.ccc50 = intArray;
        veryBigObject.cccc50 = integerArray;
        veryBigObject.d50 = longValue;
        veryBigObject.dd50 = longValue;
        veryBigObject.ddd50 = longArray;
        veryBigObject.dddd50 = longBoxArray;
        veryBigObject.e50 = floatValue;
        veryBigObject.ee50 = floatValue;
        veryBigObject.eee50 = floatArray;
        veryBigObject.eeee50 = floatBoxArray;
        veryBigObject.f50 = doubleValue;
        veryBigObject.ff50 = doubleValue;
        veryBigObject.fff50 = doubleArray;
        veryBigObject.ffff50 = doubleBoxArray;
        veryBigObject.g50 = true;
        veryBigObject.gg50 = true;
        veryBigObject.ggg50 = booleanArray;
        veryBigObject.gggg50 = booleanBoxArray;
        veryBigObject.jj50 = stringValue;
        veryBigObject.jjj50 = stringArray;
        veryBigObject.kk50 = objectA;
        veryBigObject.kkk50 = new ObjectA[]{objectA, objectA};
        veryBigObject.l50 = listWithInteger;
        veryBigObject.llll50 = listWithString;
        veryBigObject.m50 = mapWithInteger;
        veryBigObject.mm50 = mapWithObject;
        veryBigObject.s50 = setWithInteger;
        veryBigObject.ssss50 = setWithString;
        veryBigObject.a51 = byteValue;
        veryBigObject.aa51 = byteValue;
        veryBigObject.aaa51 = byteArray;
        veryBigObject.aaaa51 = byteBoxArray;
        veryBigObject.b51 = shortValue;
        veryBigObject.bb51 = shortValue;
        veryBigObject.bbb51 = shortArray;
        veryBigObject.bbbb51 = shortBoxArray;
        veryBigObject.c51 = intValue;
        veryBigObject.cc51 = intValue;
        veryBigObject.ccc51 = intArray;
        veryBigObject.cccc51 = integerArray;
        veryBigObject.d51 = longValue;
        veryBigObject.dd51 = longValue;
        veryBigObject.ddd51 = longArray;
        veryBigObject.dddd51 = longBoxArray;
        veryBigObject.e51 = floatValue;
        veryBigObject.ee51 = floatValue;
        veryBigObject.eee51 = floatArray;
        veryBigObject.eeee51 = floatBoxArray;
        veryBigObject.f51 = doubleValue;
        veryBigObject.ff51 = doubleValue;
        veryBigObject.fff51 = doubleArray;
        veryBigObject.ffff51 = doubleBoxArray;
        veryBigObject.g51 = true;
        veryBigObject.gg51 = true;
        veryBigObject.ggg51 = booleanArray;
        veryBigObject.gggg51 = booleanBoxArray;
        veryBigObject.jj51 = stringValue;
        veryBigObject.jjj51 = stringArray;
        veryBigObject.kk51 = objectA;
        veryBigObject.kkk51 = new ObjectA[]{objectA, objectA};
        veryBigObject.l51 = listWithInteger;
        veryBigObject.llll51 = listWithString;
        veryBigObject.m51 = mapWithInteger;
        veryBigObject.mm51 = mapWithObject;
        veryBigObject.s51 = setWithInteger;
        veryBigObject.ssss51 = setWithString;
        veryBigObject.a52 = byteValue;
        veryBigObject.aa52 = byteValue;
        veryBigObject.aaa52 = byteArray;
        veryBigObject.aaaa52 = byteBoxArray;
        veryBigObject.b52 = shortValue;
        veryBigObject.bb52 = shortValue;
        veryBigObject.bbb52 = shortArray;
        veryBigObject.bbbb52 = shortBoxArray;
        veryBigObject.c52 = intValue;
        veryBigObject.cc52 = intValue;
        veryBigObject.ccc52 = intArray;
        veryBigObject.cccc52 = integerArray;
        veryBigObject.d52 = longValue;
        veryBigObject.dd52 = longValue;
        veryBigObject.ddd52 = longArray;
        veryBigObject.dddd52 = longBoxArray;
        veryBigObject.e52 = floatValue;
        veryBigObject.ee52 = floatValue;
        veryBigObject.eee52 = floatArray;
        veryBigObject.eeee52 = floatBoxArray;
        veryBigObject.f52 = doubleValue;
        veryBigObject.ff52 = doubleValue;
        veryBigObject.fff52 = doubleArray;
        veryBigObject.ffff52 = doubleBoxArray;
        veryBigObject.g52 = true;
        veryBigObject.gg52 = true;
        veryBigObject.ggg52 = booleanArray;
        veryBigObject.gggg52 = booleanBoxArray;
        veryBigObject.jj52 = stringValue;
        veryBigObject.jjj52 = stringArray;
        veryBigObject.kk52 = objectA;
        veryBigObject.kkk52 = new ObjectA[]{objectA, objectA};
        veryBigObject.l52 = listWithInteger;
        veryBigObject.llll52 = listWithString;
        veryBigObject.m52 = mapWithInteger;
        veryBigObject.mm52 = mapWithObject;
        veryBigObject.s52 = setWithInteger;
        veryBigObject.ssss52 = setWithString;
        veryBigObject.a53 = byteValue;
        veryBigObject.aa53 = byteValue;
        veryBigObject.aaa53 = byteArray;
        veryBigObject.aaaa53 = byteBoxArray;
        veryBigObject.b53 = shortValue;
        veryBigObject.bb53 = shortValue;
        veryBigObject.bbb53 = shortArray;
        veryBigObject.bbbb53 = shortBoxArray;
        veryBigObject.c53 = intValue;
        veryBigObject.cc53 = intValue;
        veryBigObject.ccc53 = intArray;
        veryBigObject.cccc53 = integerArray;
        veryBigObject.d53 = longValue;
        veryBigObject.dd53 = longValue;
        veryBigObject.ddd53 = longArray;
        veryBigObject.dddd53 = longBoxArray;
        veryBigObject.e53 = floatValue;
        veryBigObject.ee53 = floatValue;
        veryBigObject.eee53 = floatArray;
        veryBigObject.eeee53 = floatBoxArray;
        veryBigObject.f53 = doubleValue;
        veryBigObject.ff53 = doubleValue;
        veryBigObject.fff53 = doubleArray;
        veryBigObject.ffff53 = doubleBoxArray;
        veryBigObject.g53 = true;
        veryBigObject.gg53 = true;
        veryBigObject.ggg53 = booleanArray;
        veryBigObject.gggg53 = booleanBoxArray;
        veryBigObject.jj53 = stringValue;
        veryBigObject.jjj53 = stringArray;
        veryBigObject.kk53 = objectA;
        veryBigObject.kkk53 = new ObjectA[]{objectA, objectA};
        veryBigObject.l53 = listWithInteger;
        veryBigObject.llll53 = listWithString;
        veryBigObject.m53 = mapWithInteger;
        veryBigObject.mm53 = mapWithObject;
        veryBigObject.s53 = setWithInteger;
        veryBigObject.ssss53 = setWithString;
        veryBigObject.a54 = byteValue;
        veryBigObject.aa54 = byteValue;
        veryBigObject.aaa54 = byteArray;
        veryBigObject.aaaa54 = byteBoxArray;
        veryBigObject.b54 = shortValue;
        veryBigObject.bb54 = shortValue;
        veryBigObject.bbb54 = shortArray;
        veryBigObject.bbbb54 = shortBoxArray;
        veryBigObject.c54 = intValue;
        veryBigObject.cc54 = intValue;
        veryBigObject.ccc54 = intArray;
        veryBigObject.cccc54 = integerArray;
        veryBigObject.d54 = longValue;
        veryBigObject.dd54 = longValue;
        veryBigObject.ddd54 = longArray;
        veryBigObject.dddd54 = longBoxArray;
        veryBigObject.e54 = floatValue;
        veryBigObject.ee54 = floatValue;
        veryBigObject.eee54 = floatArray;
        veryBigObject.eeee54 = floatBoxArray;
        veryBigObject.f54 = doubleValue;
        veryBigObject.ff54 = doubleValue;
        veryBigObject.fff54 = doubleArray;
        veryBigObject.ffff54 = doubleBoxArray;
        veryBigObject.g54 = true;
        veryBigObject.gg54 = true;
        veryBigObject.ggg54 = booleanArray;
        veryBigObject.gggg54 = booleanBoxArray;
        veryBigObject.jj54 = stringValue;
        veryBigObject.jjj54 = stringArray;
        veryBigObject.kk54 = objectA;
        veryBigObject.kkk54 = new ObjectA[]{objectA, objectA};
        veryBigObject.l54 = listWithInteger;
        veryBigObject.llll54 = listWithString;
        veryBigObject.m54 = mapWithInteger;
        veryBigObject.mm54 = mapWithObject;
        veryBigObject.s54 = setWithInteger;
        veryBigObject.ssss54 = setWithString;
        veryBigObject.a55 = byteValue;
        veryBigObject.aa55 = byteValue;
        veryBigObject.aaa55 = byteArray;
        veryBigObject.aaaa55 = byteBoxArray;
        veryBigObject.b55 = shortValue;
        veryBigObject.bb55 = shortValue;
        veryBigObject.bbb55 = shortArray;
        veryBigObject.bbbb55 = shortBoxArray;
        veryBigObject.c55 = intValue;
        veryBigObject.cc55 = intValue;
        veryBigObject.ccc55 = intArray;
        veryBigObject.cccc55 = integerArray;
        veryBigObject.d55 = longValue;
        veryBigObject.dd55 = longValue;
        veryBigObject.ddd55 = longArray;
        veryBigObject.dddd55 = longBoxArray;
        veryBigObject.e55 = floatValue;
        veryBigObject.ee55 = floatValue;
        veryBigObject.eee55 = floatArray;
        veryBigObject.eeee55 = floatBoxArray;
        veryBigObject.f55 = doubleValue;
        veryBigObject.ff55 = doubleValue;
        veryBigObject.fff55 = doubleArray;
        veryBigObject.ffff55 = doubleBoxArray;
        veryBigObject.g55 = true;
        veryBigObject.gg55 = true;
        veryBigObject.ggg55 = booleanArray;
        veryBigObject.gggg55 = booleanBoxArray;
        veryBigObject.jj55 = stringValue;
        veryBigObject.jjj55 = stringArray;
        veryBigObject.kk55 = objectA;
        veryBigObject.kkk55 = new ObjectA[]{objectA, objectA};
        veryBigObject.l55 = listWithInteger;
        veryBigObject.llll55 = listWithString;
        veryBigObject.m55 = mapWithInteger;
        veryBigObject.mm55 = mapWithObject;
        veryBigObject.s55 = setWithInteger;
        veryBigObject.ssss55 = setWithString;
        veryBigObject.a56 = byteValue;
        veryBigObject.aa56 = byteValue;
        veryBigObject.aaa56 = byteArray;
        veryBigObject.aaaa56 = byteBoxArray;
        veryBigObject.b56 = shortValue;
        veryBigObject.bb56 = shortValue;
        veryBigObject.bbb56 = shortArray;
        veryBigObject.bbbb56 = shortBoxArray;
        veryBigObject.c56 = intValue;
        veryBigObject.cc56 = intValue;
        veryBigObject.ccc56 = intArray;
        veryBigObject.cccc56 = integerArray;
        veryBigObject.d56 = longValue;
        veryBigObject.dd56 = longValue;
        veryBigObject.ddd56 = longArray;
        veryBigObject.dddd56 = longBoxArray;
        veryBigObject.e56 = floatValue;
        veryBigObject.ee56 = floatValue;
        veryBigObject.eee56 = floatArray;
        veryBigObject.eeee56 = floatBoxArray;
        veryBigObject.f56 = doubleValue;
        veryBigObject.ff56 = doubleValue;
        veryBigObject.fff56 = doubleArray;
        veryBigObject.ffff56 = doubleBoxArray;
        veryBigObject.g56 = true;
        veryBigObject.gg56 = true;
        veryBigObject.ggg56 = booleanArray;
        veryBigObject.gggg56 = booleanBoxArray;
        veryBigObject.jj56 = stringValue;
        veryBigObject.jjj56 = stringArray;
        veryBigObject.kk56 = objectA;
        veryBigObject.kkk56 = new ObjectA[]{objectA, objectA};
        veryBigObject.l56 = listWithInteger;
        veryBigObject.llll56 = listWithString;
        veryBigObject.m56 = mapWithInteger;
        veryBigObject.mm56 = mapWithObject;
        veryBigObject.s56 = setWithInteger;
        veryBigObject.ssss56 = setWithString;
        veryBigObject.a57 = byteValue;
        veryBigObject.aa57 = byteValue;
        veryBigObject.aaa57 = byteArray;
        veryBigObject.aaaa57 = byteBoxArray;
        veryBigObject.b57 = shortValue;
        veryBigObject.bb57 = shortValue;
        veryBigObject.bbb57 = shortArray;
        veryBigObject.bbbb57 = shortBoxArray;
        veryBigObject.c57 = intValue;
        veryBigObject.cc57 = intValue;
        veryBigObject.ccc57 = intArray;
        veryBigObject.cccc57 = integerArray;
        veryBigObject.d57 = longValue;
        veryBigObject.dd57 = longValue;
        veryBigObject.ddd57 = longArray;
        veryBigObject.dddd57 = longBoxArray;
        veryBigObject.e57 = floatValue;
        veryBigObject.ee57 = floatValue;
        veryBigObject.eee57 = floatArray;
        veryBigObject.eeee57 = floatBoxArray;
        veryBigObject.f57 = doubleValue;
        veryBigObject.ff57 = doubleValue;
        veryBigObject.fff57 = doubleArray;
        veryBigObject.ffff57 = doubleBoxArray;
        veryBigObject.g57 = true;
        veryBigObject.gg57 = true;
        veryBigObject.ggg57 = booleanArray;
        veryBigObject.gggg57 = booleanBoxArray;
        veryBigObject.jj57 = stringValue;
        veryBigObject.jjj57 = stringArray;
        veryBigObject.kk57 = objectA;
        veryBigObject.kkk57 = new ObjectA[]{objectA, objectA};
        veryBigObject.l57 = listWithInteger;
        veryBigObject.llll57 = listWithString;
        veryBigObject.m57 = mapWithInteger;
        veryBigObject.mm57 = mapWithObject;
        veryBigObject.s57 = setWithInteger;
        veryBigObject.ssss57 = setWithString;
        veryBigObject.a58 = byteValue;
        veryBigObject.aa58 = byteValue;
        veryBigObject.aaa58 = byteArray;
        veryBigObject.aaaa58 = byteBoxArray;
        veryBigObject.b58 = shortValue;
        veryBigObject.bb58 = shortValue;
        veryBigObject.bbb58 = shortArray;
        veryBigObject.bbbb58 = shortBoxArray;
        veryBigObject.c58 = intValue;
        veryBigObject.cc58 = intValue;
        veryBigObject.ccc58 = intArray;
        veryBigObject.cccc58 = integerArray;
        veryBigObject.d58 = longValue;
        veryBigObject.dd58 = longValue;
        veryBigObject.ddd58 = longArray;
        veryBigObject.dddd58 = longBoxArray;
        veryBigObject.e58 = floatValue;
        veryBigObject.ee58 = floatValue;
        veryBigObject.eee58 = floatArray;
        veryBigObject.eeee58 = floatBoxArray;
        veryBigObject.f58 = doubleValue;
        veryBigObject.ff58 = doubleValue;
        veryBigObject.fff58 = doubleArray;
        veryBigObject.ffff58 = doubleBoxArray;
        veryBigObject.g58 = true;
        veryBigObject.gg58 = true;
        veryBigObject.ggg58 = booleanArray;
        veryBigObject.gggg58 = booleanBoxArray;
        veryBigObject.jj58 = stringValue;
        veryBigObject.jjj58 = stringArray;
        veryBigObject.kk58 = objectA;
        veryBigObject.kkk58 = new ObjectA[]{objectA, objectA};
        veryBigObject.l58 = listWithInteger;
        veryBigObject.llll58 = listWithString;
        veryBigObject.m58 = mapWithInteger;
        veryBigObject.mm58 = mapWithObject;
        veryBigObject.s58 = setWithInteger;
        veryBigObject.ssss58 = setWithString;
        veryBigObject.a59 = byteValue;
        veryBigObject.aa59 = byteValue;
        veryBigObject.aaa59 = byteArray;
        veryBigObject.aaaa59 = byteBoxArray;
        veryBigObject.b59 = shortValue;
        veryBigObject.bb59 = shortValue;
        veryBigObject.bbb59 = shortArray;
        veryBigObject.bbbb59 = shortBoxArray;
        veryBigObject.c59 = intValue;
        veryBigObject.cc59 = intValue;
        veryBigObject.ccc59 = intArray;
        veryBigObject.cccc59 = integerArray;
        veryBigObject.d59 = longValue;
        veryBigObject.dd59 = longValue;
        veryBigObject.ddd59 = longArray;
        veryBigObject.dddd59 = longBoxArray;
        veryBigObject.e59 = floatValue;
        veryBigObject.ee59 = floatValue;
        veryBigObject.eee59 = floatArray;
        veryBigObject.eeee59 = floatBoxArray;
        veryBigObject.f59 = doubleValue;
        veryBigObject.ff59 = doubleValue;
        veryBigObject.fff59 = doubleArray;
        veryBigObject.ffff59 = doubleBoxArray;
        veryBigObject.g59 = true;
        veryBigObject.gg59 = true;
        veryBigObject.ggg59 = booleanArray;
        veryBigObject.gggg59 = booleanBoxArray;
        veryBigObject.jj59 = stringValue;
        veryBigObject.jjj59 = stringArray;
        veryBigObject.kk59 = objectA;
        veryBigObject.kkk59 = new ObjectA[]{objectA, objectA};
        veryBigObject.l59 = listWithInteger;
        veryBigObject.llll59 = listWithString;
        veryBigObject.m59 = mapWithInteger;
        veryBigObject.mm59 = mapWithObject;
        veryBigObject.s59 = setWithInteger;
        veryBigObject.ssss59 = setWithString;
        veryBigObject.a60 = byteValue;
        veryBigObject.aa60 = byteValue;
        veryBigObject.aaa60 = byteArray;
        veryBigObject.aaaa60 = byteBoxArray;
        veryBigObject.b60 = shortValue;
        veryBigObject.bb60 = shortValue;
        veryBigObject.bbb60 = shortArray;
        veryBigObject.bbbb60 = shortBoxArray;
        veryBigObject.c60 = intValue;
        veryBigObject.cc60 = intValue;
        veryBigObject.ccc60 = intArray;
        veryBigObject.cccc60 = integerArray;
        veryBigObject.d60 = longValue;
        veryBigObject.dd60 = longValue;
        veryBigObject.ddd60 = longArray;
        veryBigObject.dddd60 = longBoxArray;
        veryBigObject.e60 = floatValue;
        veryBigObject.ee60 = floatValue;
        veryBigObject.eee60 = floatArray;
        veryBigObject.eeee60 = floatBoxArray;
        veryBigObject.f60 = doubleValue;
        veryBigObject.ff60 = doubleValue;
        veryBigObject.fff60 = doubleArray;
        veryBigObject.ffff60 = doubleBoxArray;
        veryBigObject.g60 = true;
        veryBigObject.gg60 = true;
        veryBigObject.ggg60 = booleanArray;
        veryBigObject.gggg60 = booleanBoxArray;
        veryBigObject.jj60 = stringValue;
        veryBigObject.jjj60 = stringArray;
        veryBigObject.kk60 = objectA;
        veryBigObject.kkk60 = new ObjectA[]{objectA, objectA};
        veryBigObject.l60 = listWithInteger;
        veryBigObject.llll60 = listWithString;
        veryBigObject.m60 = mapWithInteger;
        veryBigObject.mm60 = mapWithObject;
        veryBigObject.s60 = setWithInteger;
        veryBigObject.ssss60 = setWithString;
        veryBigObject.a61 = byteValue;
        veryBigObject.aa61 = byteValue;
        veryBigObject.aaa61 = byteArray;
        veryBigObject.aaaa61 = byteBoxArray;
        veryBigObject.b61 = shortValue;
        veryBigObject.bb61 = shortValue;
        veryBigObject.bbb61 = shortArray;
        veryBigObject.bbbb61 = shortBoxArray;
        veryBigObject.c61 = intValue;
        veryBigObject.cc61 = intValue;
        veryBigObject.ccc61 = intArray;
        veryBigObject.cccc61 = integerArray;
        veryBigObject.d61 = longValue;
        veryBigObject.dd61 = longValue;
        veryBigObject.ddd61 = longArray;
        veryBigObject.dddd61 = longBoxArray;
        veryBigObject.e61 = floatValue;
        veryBigObject.ee61 = floatValue;
        veryBigObject.eee61 = floatArray;
        veryBigObject.eeee61 = floatBoxArray;
        veryBigObject.f61 = doubleValue;
        veryBigObject.ff61 = doubleValue;
        veryBigObject.fff61 = doubleArray;
        veryBigObject.ffff61 = doubleBoxArray;
        veryBigObject.g61 = true;
        veryBigObject.gg61 = true;
        veryBigObject.ggg61 = booleanArray;
        veryBigObject.gggg61 = booleanBoxArray;
        veryBigObject.jj61 = stringValue;
        veryBigObject.jjj61 = stringArray;
        veryBigObject.kk61 = objectA;
        veryBigObject.kkk61 = new ObjectA[]{objectA, objectA};
        veryBigObject.l61 = listWithInteger;
        veryBigObject.llll61 = listWithString;
        veryBigObject.m61 = mapWithInteger;
        veryBigObject.mm61 = mapWithObject;
        veryBigObject.s61 = setWithInteger;
        veryBigObject.ssss61 = setWithString;
        veryBigObject.a62 = byteValue;
        veryBigObject.aa62 = byteValue;
        veryBigObject.aaa62 = byteArray;
        veryBigObject.aaaa62 = byteBoxArray;
        veryBigObject.b62 = shortValue;
        veryBigObject.bb62 = shortValue;
        veryBigObject.bbb62 = shortArray;
        veryBigObject.bbbb62 = shortBoxArray;
        veryBigObject.c62 = intValue;
        veryBigObject.cc62 = intValue;
        veryBigObject.ccc62 = intArray;
        veryBigObject.cccc62 = integerArray;
        veryBigObject.d62 = longValue;
        veryBigObject.dd62 = longValue;
        veryBigObject.ddd62 = longArray;
        veryBigObject.dddd62 = longBoxArray;
        veryBigObject.e62 = floatValue;
        veryBigObject.ee62 = floatValue;
        veryBigObject.eee62 = floatArray;
        veryBigObject.eeee62 = floatBoxArray;
        veryBigObject.f62 = doubleValue;
        veryBigObject.ff62 = doubleValue;
        veryBigObject.fff62 = doubleArray;
        veryBigObject.ffff62 = doubleBoxArray;
        veryBigObject.g62 = true;
        veryBigObject.gg62 = true;
        veryBigObject.ggg62 = booleanArray;
        veryBigObject.gggg62 = booleanBoxArray;
        veryBigObject.jj62 = stringValue;
        veryBigObject.jjj62 = stringArray;
        veryBigObject.kk62 = objectA;
        veryBigObject.kkk62 = new ObjectA[]{objectA, objectA};
        veryBigObject.l62 = listWithInteger;
        veryBigObject.llll62 = listWithString;
        veryBigObject.m62 = mapWithInteger;
        veryBigObject.mm62 = mapWithObject;
        veryBigObject.s62 = setWithInteger;
        veryBigObject.ssss62 = setWithString;
        veryBigObject.a63 = byteValue;
        veryBigObject.aa63 = byteValue;
        veryBigObject.aaa63 = byteArray;
        veryBigObject.aaaa63 = byteBoxArray;
        veryBigObject.b63 = shortValue;
        veryBigObject.bb63 = shortValue;
        veryBigObject.bbb63 = shortArray;
        veryBigObject.bbbb63 = shortBoxArray;
        veryBigObject.c63 = intValue;
        veryBigObject.cc63 = intValue;
        veryBigObject.ccc63 = intArray;
        veryBigObject.cccc63 = integerArray;
        veryBigObject.d63 = longValue;
        veryBigObject.dd63 = longValue;
        veryBigObject.ddd63 = longArray;
        veryBigObject.dddd63 = longBoxArray;
        veryBigObject.e63 = floatValue;
        veryBigObject.ee63 = floatValue;
        veryBigObject.eee63 = floatArray;
        veryBigObject.eeee63 = floatBoxArray;
        veryBigObject.f63 = doubleValue;
        veryBigObject.ff63 = doubleValue;
        veryBigObject.fff63 = doubleArray;
        veryBigObject.ffff63 = doubleBoxArray;
        veryBigObject.g63 = true;
        veryBigObject.gg63 = true;
        veryBigObject.ggg63 = booleanArray;
        veryBigObject.gggg63 = booleanBoxArray;
        veryBigObject.jj63 = stringValue;
        veryBigObject.jjj63 = stringArray;
        veryBigObject.kk63 = objectA;
        veryBigObject.kkk63 = new ObjectA[]{objectA, objectA};
        veryBigObject.l63 = listWithInteger;
        veryBigObject.llll63 = listWithString;
        veryBigObject.m63 = mapWithInteger;
        veryBigObject.mm63 = mapWithObject;
        veryBigObject.s63 = setWithInteger;
        veryBigObject.ssss63 = setWithString;
        veryBigObject.a64 = byteValue;
        veryBigObject.aa64 = byteValue;
        veryBigObject.aaa64 = byteArray;
        veryBigObject.aaaa64 = byteBoxArray;
        veryBigObject.b64 = shortValue;
        veryBigObject.bb64 = shortValue;
        veryBigObject.bbb64 = shortArray;
        veryBigObject.bbbb64 = shortBoxArray;
        veryBigObject.c64 = intValue;
        veryBigObject.cc64 = intValue;
        veryBigObject.ccc64 = intArray;
        veryBigObject.cccc64 = integerArray;
        veryBigObject.d64 = longValue;
        veryBigObject.dd64 = longValue;
        veryBigObject.ddd64 = longArray;
        veryBigObject.dddd64 = longBoxArray;
        veryBigObject.e64 = floatValue;
        veryBigObject.ee64 = floatValue;
        veryBigObject.eee64 = floatArray;
        veryBigObject.eeee64 = floatBoxArray;
        veryBigObject.f64 = doubleValue;
        veryBigObject.ff64 = doubleValue;
        veryBigObject.fff64 = doubleArray;
        veryBigObject.ffff64 = doubleBoxArray;
        veryBigObject.g64 = true;
        veryBigObject.gg64 = true;
        veryBigObject.ggg64 = booleanArray;
        veryBigObject.gggg64 = booleanBoxArray;
        veryBigObject.jj64 = stringValue;
        veryBigObject.jjj64 = stringArray;
        veryBigObject.kk64 = objectA;
        veryBigObject.kkk64 = new ObjectA[]{objectA, objectA};
        veryBigObject.l64 = listWithInteger;
        veryBigObject.llll64 = listWithString;
        veryBigObject.m64 = mapWithInteger;
        veryBigObject.mm64 = mapWithObject;
        veryBigObject.s64 = setWithInteger;
        veryBigObject.ssss64 = setWithString;
        veryBigObject.a65 = byteValue;
        veryBigObject.aa65 = byteValue;
        veryBigObject.aaa65 = byteArray;
        veryBigObject.aaaa65 = byteBoxArray;
        veryBigObject.b65 = shortValue;
        veryBigObject.bb65 = shortValue;
        veryBigObject.bbb65 = shortArray;
        veryBigObject.bbbb65 = shortBoxArray;
        veryBigObject.c65 = intValue;
        veryBigObject.cc65 = intValue;
        veryBigObject.ccc65 = intArray;
        veryBigObject.cccc65 = integerArray;
        veryBigObject.d65 = longValue;
        veryBigObject.dd65 = longValue;
        veryBigObject.ddd65 = longArray;
        veryBigObject.dddd65 = longBoxArray;
        veryBigObject.e65 = floatValue;
        veryBigObject.ee65 = floatValue;
        veryBigObject.eee65 = floatArray;
        veryBigObject.eeee65 = floatBoxArray;
        veryBigObject.f65 = doubleValue;
        veryBigObject.ff65 = doubleValue;
        veryBigObject.fff65 = doubleArray;
        veryBigObject.ffff65 = doubleBoxArray;
        veryBigObject.g65 = true;
        veryBigObject.gg65 = true;
        veryBigObject.ggg65 = booleanArray;
        veryBigObject.gggg65 = booleanBoxArray;
        veryBigObject.jj65 = stringValue;
        veryBigObject.jjj65 = stringArray;
        veryBigObject.kk65 = objectA;
        veryBigObject.kkk65 = new ObjectA[]{objectA, objectA};
        veryBigObject.l65 = listWithInteger;
        veryBigObject.llll65 = listWithString;
        veryBigObject.m65 = mapWithInteger;
        veryBigObject.mm65 = mapWithObject;
        veryBigObject.s65 = setWithInteger;
        veryBigObject.ssss65 = setWithString;
        veryBigObject.a66 = byteValue;
        veryBigObject.aa66 = byteValue;
        veryBigObject.aaa66 = byteArray;
        veryBigObject.aaaa66 = byteBoxArray;
        veryBigObject.b66 = shortValue;
        veryBigObject.bb66 = shortValue;
        veryBigObject.bbb66 = shortArray;
        veryBigObject.bbbb66 = shortBoxArray;
        veryBigObject.c66 = intValue;
        veryBigObject.cc66 = intValue;
        veryBigObject.ccc66 = intArray;
        veryBigObject.cccc66 = integerArray;
        veryBigObject.d66 = longValue;
        veryBigObject.dd66 = longValue;
        veryBigObject.ddd66 = longArray;
        veryBigObject.dddd66 = longBoxArray;
        veryBigObject.e66 = floatValue;
        veryBigObject.ee66 = floatValue;
        veryBigObject.eee66 = floatArray;
        veryBigObject.eeee66 = floatBoxArray;
        veryBigObject.f66 = doubleValue;
        veryBigObject.ff66 = doubleValue;
        veryBigObject.fff66 = doubleArray;
        veryBigObject.ffff66 = doubleBoxArray;
        veryBigObject.g66 = true;
        veryBigObject.gg66 = true;
        veryBigObject.ggg66 = booleanArray;
        veryBigObject.gggg66 = booleanBoxArray;
        veryBigObject.jj66 = stringValue;
        veryBigObject.jjj66 = stringArray;
        veryBigObject.kk66 = objectA;
        veryBigObject.kkk66 = new ObjectA[]{objectA, objectA};
        veryBigObject.l66 = listWithInteger;
        veryBigObject.llll66 = listWithString;
        veryBigObject.m66 = mapWithInteger;
        veryBigObject.mm66 = mapWithObject;
        veryBigObject.s66 = setWithInteger;
        veryBigObject.ssss66 = setWithString;
        veryBigObject.a67 = byteValue;
        veryBigObject.aa67 = byteValue;
        veryBigObject.aaa67 = byteArray;
        veryBigObject.aaaa67 = byteBoxArray;
        veryBigObject.b67 = shortValue;
        veryBigObject.bb67 = shortValue;
        veryBigObject.bbb67 = shortArray;
        veryBigObject.bbbb67 = shortBoxArray;
        veryBigObject.c67 = intValue;
        veryBigObject.cc67 = intValue;
        veryBigObject.ccc67 = intArray;
        veryBigObject.cccc67 = integerArray;
        veryBigObject.d67 = longValue;
        veryBigObject.dd67 = longValue;
        veryBigObject.ddd67 = longArray;
        veryBigObject.dddd67 = longBoxArray;
        veryBigObject.e67 = floatValue;
        veryBigObject.ee67 = floatValue;
        veryBigObject.eee67 = floatArray;
        veryBigObject.eeee67 = floatBoxArray;
        veryBigObject.f67 = doubleValue;
        veryBigObject.ff67 = doubleValue;
        veryBigObject.fff67 = doubleArray;
        veryBigObject.ffff67 = doubleBoxArray;
        veryBigObject.g67 = true;
        veryBigObject.gg67 = true;
        veryBigObject.ggg67 = booleanArray;
        veryBigObject.gggg67 = booleanBoxArray;
        veryBigObject.jj67 = stringValue;
        veryBigObject.jjj67 = stringArray;
        veryBigObject.kk67 = objectA;
        veryBigObject.kkk67 = new ObjectA[]{objectA, objectA};
        veryBigObject.l67 = listWithInteger;
        veryBigObject.llll67 = listWithString;
        veryBigObject.m67 = mapWithInteger;
        veryBigObject.mm67 = mapWithObject;
        veryBigObject.s67 = setWithInteger;
        veryBigObject.ssss67 = setWithString;
        veryBigObject.a68 = byteValue;
        veryBigObject.aa68 = byteValue;
        veryBigObject.aaa68 = byteArray;
        veryBigObject.aaaa68 = byteBoxArray;
        veryBigObject.b68 = shortValue;
        veryBigObject.bb68 = shortValue;
        veryBigObject.bbb68 = shortArray;
        veryBigObject.bbbb68 = shortBoxArray;
        veryBigObject.c68 = intValue;
        veryBigObject.cc68 = intValue;
        veryBigObject.ccc68 = intArray;
        veryBigObject.cccc68 = integerArray;
        veryBigObject.d68 = longValue;
        veryBigObject.dd68 = longValue;
        veryBigObject.ddd68 = longArray;
        veryBigObject.dddd68 = longBoxArray;
        veryBigObject.e68 = floatValue;
        veryBigObject.ee68 = floatValue;
        veryBigObject.eee68 = floatArray;
        veryBigObject.eeee68 = floatBoxArray;
        veryBigObject.f68 = doubleValue;
        veryBigObject.ff68 = doubleValue;
        veryBigObject.fff68 = doubleArray;
        veryBigObject.ffff68 = doubleBoxArray;
        veryBigObject.g68 = true;
        veryBigObject.gg68 = true;
        veryBigObject.ggg68 = booleanArray;
        veryBigObject.gggg68 = booleanBoxArray;
        veryBigObject.jj68 = stringValue;
        veryBigObject.jjj68 = stringArray;
        veryBigObject.kk68 = objectA;
        veryBigObject.kkk68 = new ObjectA[]{objectA, objectA};
        veryBigObject.l68 = listWithInteger;
        veryBigObject.llll68 = listWithString;
        veryBigObject.m68 = mapWithInteger;
        veryBigObject.mm68 = mapWithObject;
        veryBigObject.s68 = setWithInteger;
        veryBigObject.ssss68 = setWithString;
        veryBigObject.a69 = byteValue;
        veryBigObject.aa69 = byteValue;
        veryBigObject.aaa69 = byteArray;
        veryBigObject.aaaa69 = byteBoxArray;
        veryBigObject.b69 = shortValue;
        veryBigObject.bb69 = shortValue;
        veryBigObject.bbb69 = shortArray;
        veryBigObject.bbbb69 = shortBoxArray;
        veryBigObject.c69 = intValue;
        veryBigObject.cc69 = intValue;
        veryBigObject.ccc69 = intArray;
        veryBigObject.cccc69 = integerArray;
        veryBigObject.d69 = longValue;
        veryBigObject.dd69 = longValue;
        veryBigObject.ddd69 = longArray;
        veryBigObject.dddd69 = longBoxArray;
        veryBigObject.e69 = floatValue;
        veryBigObject.ee69 = floatValue;
        veryBigObject.eee69 = floatArray;
        veryBigObject.eeee69 = floatBoxArray;
        veryBigObject.f69 = doubleValue;
        veryBigObject.ff69 = doubleValue;
        veryBigObject.fff69 = doubleArray;
        veryBigObject.ffff69 = doubleBoxArray;
        veryBigObject.g69 = true;
        veryBigObject.gg69 = true;
        veryBigObject.ggg69 = booleanArray;
        veryBigObject.gggg69 = booleanBoxArray;
        veryBigObject.jj69 = stringValue;
        veryBigObject.jjj69 = stringArray;
        veryBigObject.kk69 = objectA;
        veryBigObject.kkk69 = new ObjectA[]{objectA, objectA};
        veryBigObject.l69 = listWithInteger;
        veryBigObject.llll69 = listWithString;
        veryBigObject.m69 = mapWithInteger;
        veryBigObject.mm69 = mapWithObject;
        veryBigObject.s69 = setWithInteger;
        veryBigObject.ssss69 = setWithString;
        veryBigObject.a70 = byteValue;
        veryBigObject.aa70 = byteValue;
        veryBigObject.aaa70 = byteArray;
        veryBigObject.aaaa70 = byteBoxArray;
        veryBigObject.b70 = shortValue;
        veryBigObject.bb70 = shortValue;
        veryBigObject.bbb70 = shortArray;
        veryBigObject.bbbb70 = shortBoxArray;
        veryBigObject.c70 = intValue;
        veryBigObject.cc70 = intValue;
        veryBigObject.ccc70 = intArray;
        veryBigObject.cccc70 = integerArray;
        veryBigObject.d70 = longValue;
        veryBigObject.dd70 = longValue;
        veryBigObject.ddd70 = longArray;
        veryBigObject.dddd70 = longBoxArray;
        veryBigObject.e70 = floatValue;
        veryBigObject.ee70 = floatValue;
        veryBigObject.eee70 = floatArray;
        veryBigObject.eeee70 = floatBoxArray;
        veryBigObject.f70 = doubleValue;
        veryBigObject.ff70 = doubleValue;
        veryBigObject.fff70 = doubleArray;
        veryBigObject.ffff70 = doubleBoxArray;
        veryBigObject.g70 = true;
        veryBigObject.gg70 = true;
        veryBigObject.ggg70 = booleanArray;
        veryBigObject.gggg70 = booleanBoxArray;
        veryBigObject.jj70 = stringValue;
        veryBigObject.jjj70 = stringArray;
        veryBigObject.kk70 = objectA;
        veryBigObject.kkk70 = new ObjectA[]{objectA, objectA};
        veryBigObject.l70 = listWithInteger;
        veryBigObject.llll70 = listWithString;
        veryBigObject.m70 = mapWithInteger;
        veryBigObject.mm70 = mapWithObject;
        veryBigObject.s70 = setWithInteger;
        veryBigObject.ssss70 = setWithString;
        veryBigObject.a71 = byteValue;
        veryBigObject.aa71 = byteValue;
        veryBigObject.aaa71 = byteArray;
        veryBigObject.aaaa71 = byteBoxArray;
        veryBigObject.b71 = shortValue;
        veryBigObject.bb71 = shortValue;
        veryBigObject.bbb71 = shortArray;
        veryBigObject.bbbb71 = shortBoxArray;
        veryBigObject.c71 = intValue;
        veryBigObject.cc71 = intValue;
        veryBigObject.ccc71 = intArray;
        veryBigObject.cccc71 = integerArray;
        veryBigObject.d71 = longValue;
        veryBigObject.dd71 = longValue;
        veryBigObject.ddd71 = longArray;
        veryBigObject.dddd71 = longBoxArray;
        veryBigObject.e71 = floatValue;
        veryBigObject.ee71 = floatValue;
        veryBigObject.eee71 = floatArray;
        veryBigObject.eeee71 = floatBoxArray;
        veryBigObject.f71 = doubleValue;
        veryBigObject.ff71 = doubleValue;
        veryBigObject.fff71 = doubleArray;
        veryBigObject.ffff71 = doubleBoxArray;
        veryBigObject.g71 = true;
        veryBigObject.gg71 = true;
        veryBigObject.ggg71 = booleanArray;
        veryBigObject.gggg71 = booleanBoxArray;
        veryBigObject.jj71 = stringValue;
        veryBigObject.jjj71 = stringArray;
        veryBigObject.kk71 = objectA;
        veryBigObject.kkk71 = new ObjectA[]{objectA, objectA};
        veryBigObject.l71 = listWithInteger;
        veryBigObject.llll71 = listWithString;
        veryBigObject.m71 = mapWithInteger;
        veryBigObject.mm71 = mapWithObject;
        veryBigObject.s71 = setWithInteger;
        veryBigObject.ssss71 = setWithString;
        veryBigObject.a72 = byteValue;
        veryBigObject.aa72 = byteValue;
        veryBigObject.aaa72 = byteArray;
        veryBigObject.aaaa72 = byteBoxArray;
        veryBigObject.b72 = shortValue;
        veryBigObject.bb72 = shortValue;
        veryBigObject.bbb72 = shortArray;
        veryBigObject.bbbb72 = shortBoxArray;
        veryBigObject.c72 = intValue;
        veryBigObject.cc72 = intValue;
        veryBigObject.ccc72 = intArray;
        veryBigObject.cccc72 = integerArray;
        veryBigObject.d72 = longValue;
        veryBigObject.dd72 = longValue;
        veryBigObject.ddd72 = longArray;
        veryBigObject.dddd72 = longBoxArray;
        veryBigObject.e72 = floatValue;
        veryBigObject.ee72 = floatValue;
        veryBigObject.eee72 = floatArray;
        veryBigObject.eeee72 = floatBoxArray;
        veryBigObject.f72 = doubleValue;
        veryBigObject.ff72 = doubleValue;
        veryBigObject.fff72 = doubleArray;
        veryBigObject.ffff72 = doubleBoxArray;
        veryBigObject.g72 = true;
        veryBigObject.gg72 = true;
        veryBigObject.ggg72 = booleanArray;
        veryBigObject.gggg72 = booleanBoxArray;
        veryBigObject.jj72 = stringValue;
        veryBigObject.jjj72 = stringArray;
        veryBigObject.kk72 = objectA;
        veryBigObject.kkk72 = new ObjectA[]{objectA, objectA};
        veryBigObject.l72 = listWithInteger;
        veryBigObject.llll72 = listWithString;
        veryBigObject.m72 = mapWithInteger;
        veryBigObject.mm72 = mapWithObject;
        veryBigObject.s72 = setWithInteger;
        veryBigObject.ssss72 = setWithString;
        veryBigObject.a73 = byteValue;
        veryBigObject.aa73 = byteValue;
        veryBigObject.aaa73 = byteArray;
        veryBigObject.aaaa73 = byteBoxArray;
        veryBigObject.b73 = shortValue;
        veryBigObject.bb73 = shortValue;
        veryBigObject.bbb73 = shortArray;
        veryBigObject.bbbb73 = shortBoxArray;
        veryBigObject.c73 = intValue;
        veryBigObject.cc73 = intValue;
        veryBigObject.ccc73 = intArray;
        veryBigObject.cccc73 = integerArray;
        veryBigObject.d73 = longValue;
        veryBigObject.dd73 = longValue;
        veryBigObject.ddd73 = longArray;
        veryBigObject.dddd73 = longBoxArray;
        veryBigObject.e73 = floatValue;
        veryBigObject.ee73 = floatValue;
        veryBigObject.eee73 = floatArray;
        veryBigObject.eeee73 = floatBoxArray;
        veryBigObject.f73 = doubleValue;
        veryBigObject.ff73 = doubleValue;
        veryBigObject.fff73 = doubleArray;
        veryBigObject.ffff73 = doubleBoxArray;
        veryBigObject.g73 = true;
        veryBigObject.gg73 = true;
        veryBigObject.ggg73 = booleanArray;
        veryBigObject.gggg73 = booleanBoxArray;
        veryBigObject.jj73 = stringValue;
        veryBigObject.jjj73 = stringArray;
        veryBigObject.kk73 = objectA;
        veryBigObject.kkk73 = new ObjectA[]{objectA, objectA};
        veryBigObject.l73 = listWithInteger;
        veryBigObject.llll73 = listWithString;
        veryBigObject.m73 = mapWithInteger;
        veryBigObject.mm73 = mapWithObject;
        veryBigObject.s73 = setWithInteger;
        veryBigObject.ssss73 = setWithString;
        veryBigObject.a74 = byteValue;
        veryBigObject.aa74 = byteValue;
        veryBigObject.aaa74 = byteArray;
        veryBigObject.aaaa74 = byteBoxArray;
        veryBigObject.b74 = shortValue;
        veryBigObject.bb74 = shortValue;
        veryBigObject.bbb74 = shortArray;
        veryBigObject.bbbb74 = shortBoxArray;
        veryBigObject.c74 = intValue;
        veryBigObject.cc74 = intValue;
        veryBigObject.ccc74 = intArray;
        veryBigObject.cccc74 = integerArray;
        veryBigObject.d74 = longValue;
        veryBigObject.dd74 = longValue;
        veryBigObject.ddd74 = longArray;
        veryBigObject.dddd74 = longBoxArray;
        veryBigObject.e74 = floatValue;
        veryBigObject.ee74 = floatValue;
        veryBigObject.eee74 = floatArray;
        veryBigObject.eeee74 = floatBoxArray;
        veryBigObject.f74 = doubleValue;
        veryBigObject.ff74 = doubleValue;
        veryBigObject.fff74 = doubleArray;
        veryBigObject.ffff74 = doubleBoxArray;
        veryBigObject.g74 = true;
        veryBigObject.gg74 = true;
        veryBigObject.ggg74 = booleanArray;
        veryBigObject.gggg74 = booleanBoxArray;
        veryBigObject.jj74 = stringValue;
        veryBigObject.jjj74 = stringArray;
        veryBigObject.kk74 = objectA;
        veryBigObject.kkk74 = new ObjectA[]{objectA, objectA};
        veryBigObject.l74 = listWithInteger;
        veryBigObject.llll74 = listWithString;
        veryBigObject.m74 = mapWithInteger;
        veryBigObject.mm74 = mapWithObject;
        veryBigObject.s74 = setWithInteger;
        veryBigObject.ssss74 = setWithString;
        veryBigObject.a75 = byteValue;
        veryBigObject.aa75 = byteValue;
        veryBigObject.aaa75 = byteArray;
        veryBigObject.aaaa75 = byteBoxArray;
        veryBigObject.b75 = shortValue;
        veryBigObject.bb75 = shortValue;
        veryBigObject.bbb75 = shortArray;
        veryBigObject.bbbb75 = shortBoxArray;
        veryBigObject.c75 = intValue;
        veryBigObject.cc75 = intValue;
        veryBigObject.ccc75 = intArray;
        veryBigObject.cccc75 = integerArray;
        veryBigObject.d75 = longValue;
        veryBigObject.dd75 = longValue;
        veryBigObject.ddd75 = longArray;
        veryBigObject.dddd75 = longBoxArray;
        veryBigObject.e75 = floatValue;
        veryBigObject.ee75 = floatValue;
        veryBigObject.eee75 = floatArray;
        veryBigObject.eeee75 = floatBoxArray;
        veryBigObject.f75 = doubleValue;
        veryBigObject.ff75 = doubleValue;
        veryBigObject.fff75 = doubleArray;
        veryBigObject.ffff75 = doubleBoxArray;
        veryBigObject.g75 = true;
        veryBigObject.gg75 = true;
        veryBigObject.ggg75 = booleanArray;
        veryBigObject.gggg75 = booleanBoxArray;
        veryBigObject.jj75 = stringValue;
        veryBigObject.jjj75 = stringArray;
        veryBigObject.kk75 = objectA;
        veryBigObject.kkk75 = new ObjectA[]{objectA, objectA};
        veryBigObject.l75 = listWithInteger;
        veryBigObject.llll75 = listWithString;
        veryBigObject.m75 = mapWithInteger;
        veryBigObject.mm75 = mapWithObject;
        veryBigObject.s75 = setWithInteger;
        veryBigObject.ssss75 = setWithString;
        veryBigObject.a76 = byteValue;
        veryBigObject.aa76 = byteValue;
        veryBigObject.aaa76 = byteArray;
        veryBigObject.aaaa76 = byteBoxArray;
        veryBigObject.b76 = shortValue;
        veryBigObject.bb76 = shortValue;
        veryBigObject.bbb76 = shortArray;
        veryBigObject.bbbb76 = shortBoxArray;
        veryBigObject.c76 = intValue;
        veryBigObject.cc76 = intValue;
        veryBigObject.ccc76 = intArray;
        veryBigObject.cccc76 = integerArray;
        veryBigObject.d76 = longValue;
        veryBigObject.dd76 = longValue;
        veryBigObject.ddd76 = longArray;
        veryBigObject.dddd76 = longBoxArray;
        veryBigObject.e76 = floatValue;
        veryBigObject.ee76 = floatValue;
        veryBigObject.eee76 = floatArray;
        veryBigObject.eeee76 = floatBoxArray;
        veryBigObject.f76 = doubleValue;
        veryBigObject.ff76 = doubleValue;
        veryBigObject.fff76 = doubleArray;
        veryBigObject.ffff76 = doubleBoxArray;
        veryBigObject.g76 = true;
        veryBigObject.gg76 = true;
        veryBigObject.ggg76 = booleanArray;
        veryBigObject.gggg76 = booleanBoxArray;
        veryBigObject.jj76 = stringValue;
        veryBigObject.jjj76 = stringArray;
        veryBigObject.kk76 = objectA;
        veryBigObject.kkk76 = new ObjectA[]{objectA, objectA};
        veryBigObject.l76 = listWithInteger;
        veryBigObject.llll76 = listWithString;
        veryBigObject.m76 = mapWithInteger;
        veryBigObject.mm76 = mapWithObject;
        veryBigObject.s76 = setWithInteger;
        veryBigObject.ssss76 = setWithString;
        veryBigObject.a77 = byteValue;
        veryBigObject.aa77 = byteValue;
        veryBigObject.aaa77 = byteArray;
        veryBigObject.aaaa77 = byteBoxArray;
        veryBigObject.b77 = shortValue;
        veryBigObject.bb77 = shortValue;
        veryBigObject.bbb77 = shortArray;
        veryBigObject.bbbb77 = shortBoxArray;
        veryBigObject.c77 = intValue;
        veryBigObject.cc77 = intValue;
        veryBigObject.ccc77 = intArray;
        veryBigObject.cccc77 = integerArray;
        veryBigObject.d77 = longValue;
        veryBigObject.dd77 = longValue;
        veryBigObject.ddd77 = longArray;
        veryBigObject.dddd77 = longBoxArray;
        veryBigObject.e77 = floatValue;
        veryBigObject.ee77 = floatValue;
        veryBigObject.eee77 = floatArray;
        veryBigObject.eeee77 = floatBoxArray;
        veryBigObject.f77 = doubleValue;
        veryBigObject.ff77 = doubleValue;
        veryBigObject.fff77 = doubleArray;
        veryBigObject.ffff77 = doubleBoxArray;
        veryBigObject.g77 = true;
        veryBigObject.gg77 = true;
        veryBigObject.ggg77 = booleanArray;
        veryBigObject.gggg77 = booleanBoxArray;
        veryBigObject.jj77 = stringValue;
        veryBigObject.jjj77 = stringArray;
        veryBigObject.kk77 = objectA;
        veryBigObject.kkk77 = new ObjectA[]{objectA, objectA};
        veryBigObject.l77 = listWithInteger;
        veryBigObject.llll77 = listWithString;
        veryBigObject.m77 = mapWithInteger;
        veryBigObject.mm77 = mapWithObject;
        veryBigObject.s77 = setWithInteger;
        veryBigObject.ssss77 = setWithString;
        veryBigObject.a78 = byteValue;
        veryBigObject.aa78 = byteValue;
        veryBigObject.aaa78 = byteArray;
        veryBigObject.aaaa78 = byteBoxArray;
        veryBigObject.b78 = shortValue;
        veryBigObject.bb78 = shortValue;
        veryBigObject.bbb78 = shortArray;
        veryBigObject.bbbb78 = shortBoxArray;
        veryBigObject.c78 = intValue;
        veryBigObject.cc78 = intValue;
        veryBigObject.ccc78 = intArray;
        veryBigObject.cccc78 = integerArray;
        veryBigObject.d78 = longValue;
        veryBigObject.dd78 = longValue;
        veryBigObject.ddd78 = longArray;
        veryBigObject.dddd78 = longBoxArray;
        veryBigObject.e78 = floatValue;
        veryBigObject.ee78 = floatValue;
        veryBigObject.eee78 = floatArray;
        veryBigObject.eeee78 = floatBoxArray;
        veryBigObject.f78 = doubleValue;
        veryBigObject.ff78 = doubleValue;
        veryBigObject.fff78 = doubleArray;
        veryBigObject.ffff78 = doubleBoxArray;
        veryBigObject.g78 = true;
        veryBigObject.gg78 = true;
        veryBigObject.ggg78 = booleanArray;
        veryBigObject.gggg78 = booleanBoxArray;
        veryBigObject.jj78 = stringValue;
        veryBigObject.jjj78 = stringArray;
        veryBigObject.kk78 = objectA;
        veryBigObject.kkk78 = new ObjectA[]{objectA, objectA};
        veryBigObject.l78 = listWithInteger;
        veryBigObject.llll78 = listWithString;
        veryBigObject.m78 = mapWithInteger;
        veryBigObject.mm78 = mapWithObject;
        veryBigObject.s78 = setWithInteger;
        veryBigObject.ssss78 = setWithString;
        veryBigObject.a79 = byteValue;
        veryBigObject.aa79 = byteValue;
        veryBigObject.aaa79 = byteArray;
        veryBigObject.aaaa79 = byteBoxArray;
        veryBigObject.b79 = shortValue;
        veryBigObject.bb79 = shortValue;
        veryBigObject.bbb79 = shortArray;
        veryBigObject.bbbb79 = shortBoxArray;
        veryBigObject.c79 = intValue;
        veryBigObject.cc79 = intValue;
        veryBigObject.ccc79 = intArray;
        veryBigObject.cccc79 = integerArray;
        veryBigObject.d79 = longValue;
        veryBigObject.dd79 = longValue;
        veryBigObject.ddd79 = longArray;
        veryBigObject.dddd79 = longBoxArray;
        veryBigObject.e79 = floatValue;
        veryBigObject.ee79 = floatValue;
        veryBigObject.eee79 = floatArray;
        veryBigObject.eeee79 = floatBoxArray;
        veryBigObject.f79 = doubleValue;
        veryBigObject.ff79 = doubleValue;
        veryBigObject.fff79 = doubleArray;
        veryBigObject.ffff79 = doubleBoxArray;
        veryBigObject.g79 = true;
        veryBigObject.gg79 = true;
        veryBigObject.ggg79 = booleanArray;
        veryBigObject.gggg79 = booleanBoxArray;
        veryBigObject.jj79 = stringValue;
        veryBigObject.jjj79 = stringArray;
        veryBigObject.kk79 = objectA;
        veryBigObject.kkk79 = new ObjectA[]{objectA, objectA};
        veryBigObject.l79 = listWithInteger;
        veryBigObject.llll79 = listWithString;
        veryBigObject.m79 = mapWithInteger;
        veryBigObject.mm79 = mapWithObject;
        veryBigObject.s79 = setWithInteger;
        veryBigObject.ssss79 = setWithString;
        veryBigObject.a80 = byteValue;
        veryBigObject.aa80 = byteValue;
        veryBigObject.aaa80 = byteArray;
        veryBigObject.aaaa80 = byteBoxArray;
        veryBigObject.b80 = shortValue;
        veryBigObject.bb80 = shortValue;
        veryBigObject.bbb80 = shortArray;
        veryBigObject.bbbb80 = shortBoxArray;
        veryBigObject.c80 = intValue;
        veryBigObject.cc80 = intValue;
        veryBigObject.ccc80 = intArray;
        veryBigObject.cccc80 = integerArray;
        veryBigObject.d80 = longValue;
        veryBigObject.dd80 = longValue;
        veryBigObject.ddd80 = longArray;
        veryBigObject.dddd80 = longBoxArray;
        veryBigObject.e80 = floatValue;
        veryBigObject.ee80 = floatValue;
        veryBigObject.eee80 = floatArray;
        veryBigObject.eeee80 = floatBoxArray;
        veryBigObject.f80 = doubleValue;
        veryBigObject.ff80 = doubleValue;
        veryBigObject.fff80 = doubleArray;
        veryBigObject.ffff80 = doubleBoxArray;
        veryBigObject.g80 = true;
        veryBigObject.gg80 = true;
        veryBigObject.ggg80 = booleanArray;
        veryBigObject.gggg80 = booleanBoxArray;
        veryBigObject.jj80 = stringValue;
        veryBigObject.jjj80 = stringArray;
        veryBigObject.kk80 = objectA;
        veryBigObject.kkk80 = new ObjectA[]{objectA, objectA};
        veryBigObject.l80 = listWithInteger;
        veryBigObject.llll80 = listWithString;
        veryBigObject.m80 = mapWithInteger;
        veryBigObject.mm80 = mapWithObject;
        veryBigObject.s80 = setWithInteger;
        veryBigObject.ssss80 = setWithString;
        veryBigObject.a81 = byteValue;
        veryBigObject.aa81 = byteValue;
        veryBigObject.aaa81 = byteArray;
        veryBigObject.aaaa81 = byteBoxArray;
        veryBigObject.b81 = shortValue;
        veryBigObject.bb81 = shortValue;
        veryBigObject.bbb81 = shortArray;
        veryBigObject.bbbb81 = shortBoxArray;
        veryBigObject.c81 = intValue;
        veryBigObject.cc81 = intValue;
        veryBigObject.ccc81 = intArray;
        veryBigObject.cccc81 = integerArray;
        veryBigObject.d81 = longValue;
        veryBigObject.dd81 = longValue;
        veryBigObject.ddd81 = longArray;
        veryBigObject.dddd81 = longBoxArray;
        veryBigObject.e81 = floatValue;
        veryBigObject.ee81 = floatValue;
        veryBigObject.eee81 = floatArray;
        veryBigObject.eeee81 = floatBoxArray;
        veryBigObject.f81 = doubleValue;
        veryBigObject.ff81 = doubleValue;
        veryBigObject.fff81 = doubleArray;
        veryBigObject.ffff81 = doubleBoxArray;
        veryBigObject.g81 = true;
        veryBigObject.gg81 = true;
        veryBigObject.ggg81 = booleanArray;
        veryBigObject.gggg81 = booleanBoxArray;
        veryBigObject.jj81 = stringValue;
        veryBigObject.jjj81 = stringArray;
        veryBigObject.kk81 = objectA;
        veryBigObject.kkk81 = new ObjectA[]{objectA, objectA};
        veryBigObject.l81 = listWithInteger;
        veryBigObject.llll81 = listWithString;
        veryBigObject.m81 = mapWithInteger;
        veryBigObject.mm81 = mapWithObject;
        veryBigObject.s81 = setWithInteger;
        veryBigObject.ssss81 = setWithString;
        veryBigObject.a82 = byteValue;
        veryBigObject.aa82 = byteValue;
        veryBigObject.aaa82 = byteArray;
        veryBigObject.aaaa82 = byteBoxArray;
        veryBigObject.b82 = shortValue;
        veryBigObject.bb82 = shortValue;
        veryBigObject.bbb82 = shortArray;
        veryBigObject.bbbb82 = shortBoxArray;
        veryBigObject.c82 = intValue;
        veryBigObject.cc82 = intValue;
        veryBigObject.ccc82 = intArray;
        veryBigObject.cccc82 = integerArray;
        veryBigObject.d82 = longValue;
        veryBigObject.dd82 = longValue;
        veryBigObject.ddd82 = longArray;
        veryBigObject.dddd82 = longBoxArray;
        veryBigObject.e82 = floatValue;
        veryBigObject.ee82 = floatValue;
        veryBigObject.eee82 = floatArray;
        veryBigObject.eeee82 = floatBoxArray;
        veryBigObject.f82 = doubleValue;
        veryBigObject.ff82 = doubleValue;
        veryBigObject.fff82 = doubleArray;
        veryBigObject.ffff82 = doubleBoxArray;
        veryBigObject.g82 = true;
        veryBigObject.gg82 = true;
        veryBigObject.ggg82 = booleanArray;
        veryBigObject.gggg82 = booleanBoxArray;
        veryBigObject.jj82 = stringValue;
        veryBigObject.jjj82 = stringArray;
        veryBigObject.kk82 = objectA;
        veryBigObject.kkk82 = new ObjectA[]{objectA, objectA};
        veryBigObject.l82 = listWithInteger;
        veryBigObject.llll82 = listWithString;
        veryBigObject.m82 = mapWithInteger;
        veryBigObject.mm82 = mapWithObject;
        veryBigObject.s82 = setWithInteger;
        veryBigObject.ssss82 = setWithString;
        veryBigObject.a83 = byteValue;
        veryBigObject.aa83 = byteValue;
        veryBigObject.aaa83 = byteArray;
        veryBigObject.aaaa83 = byteBoxArray;
        veryBigObject.b83 = shortValue;
        veryBigObject.bb83 = shortValue;
        veryBigObject.bbb83 = shortArray;
        veryBigObject.bbbb83 = shortBoxArray;
        veryBigObject.c83 = intValue;
        veryBigObject.cc83 = intValue;
        veryBigObject.ccc83 = intArray;
        veryBigObject.cccc83 = integerArray;
        veryBigObject.d83 = longValue;
        veryBigObject.dd83 = longValue;
        veryBigObject.ddd83 = longArray;
        veryBigObject.dddd83 = longBoxArray;
        veryBigObject.e83 = floatValue;
        veryBigObject.ee83 = floatValue;
        veryBigObject.eee83 = floatArray;
        veryBigObject.eeee83 = floatBoxArray;
        veryBigObject.f83 = doubleValue;
        veryBigObject.ff83 = doubleValue;
        veryBigObject.fff83 = doubleArray;
        veryBigObject.ffff83 = doubleBoxArray;
        veryBigObject.g83 = true;
        veryBigObject.gg83 = true;
        veryBigObject.ggg83 = booleanArray;
        veryBigObject.gggg83 = booleanBoxArray;
        veryBigObject.jj83 = stringValue;
        veryBigObject.jjj83 = stringArray;
        veryBigObject.kk83 = objectA;
        veryBigObject.kkk83 = new ObjectA[]{objectA, objectA};
        veryBigObject.l83 = listWithInteger;
        veryBigObject.llll83 = listWithString;
        veryBigObject.m83 = mapWithInteger;
        veryBigObject.mm83 = mapWithObject;
        veryBigObject.s83 = setWithInteger;
        veryBigObject.ssss83 = setWithString;
        veryBigObject.a84 = byteValue;
        veryBigObject.aa84 = byteValue;
        veryBigObject.aaa84 = byteArray;
        veryBigObject.aaaa84 = byteBoxArray;
        veryBigObject.b84 = shortValue;
        veryBigObject.bb84 = shortValue;
        veryBigObject.bbb84 = shortArray;
        veryBigObject.bbbb84 = shortBoxArray;
        veryBigObject.c84 = intValue;
        veryBigObject.cc84 = intValue;
        veryBigObject.ccc84 = intArray;
        veryBigObject.cccc84 = integerArray;
        veryBigObject.d84 = longValue;
        veryBigObject.dd84 = longValue;
        veryBigObject.ddd84 = longArray;
        veryBigObject.dddd84 = longBoxArray;
        veryBigObject.e84 = floatValue;
        veryBigObject.ee84 = floatValue;
        veryBigObject.eee84 = floatArray;
        veryBigObject.eeee84 = floatBoxArray;
        veryBigObject.f84 = doubleValue;
        veryBigObject.ff84 = doubleValue;
        veryBigObject.fff84 = doubleArray;
        veryBigObject.ffff84 = doubleBoxArray;
        veryBigObject.g84 = true;
        veryBigObject.gg84 = true;
        veryBigObject.ggg84 = booleanArray;
        veryBigObject.gggg84 = booleanBoxArray;
        veryBigObject.jj84 = stringValue;
        veryBigObject.jjj84 = stringArray;
        veryBigObject.kk84 = objectA;
        veryBigObject.kkk84 = new ObjectA[]{objectA, objectA};
        veryBigObject.l84 = listWithInteger;
        veryBigObject.llll84 = listWithString;
        veryBigObject.m84 = mapWithInteger;
        veryBigObject.mm84 = mapWithObject;
        veryBigObject.s84 = setWithInteger;
        veryBigObject.ssss84 = setWithString;
        veryBigObject.a85 = byteValue;
        veryBigObject.aa85 = byteValue;
        veryBigObject.aaa85 = byteArray;
        veryBigObject.aaaa85 = byteBoxArray;
        veryBigObject.b85 = shortValue;
        veryBigObject.bb85 = shortValue;
        veryBigObject.bbb85 = shortArray;
        veryBigObject.bbbb85 = shortBoxArray;
        veryBigObject.c85 = intValue;
        veryBigObject.cc85 = intValue;
        veryBigObject.ccc85 = intArray;
        veryBigObject.cccc85 = integerArray;
        veryBigObject.d85 = longValue;
        veryBigObject.dd85 = longValue;
        veryBigObject.ddd85 = longArray;
        veryBigObject.dddd85 = longBoxArray;
        veryBigObject.e85 = floatValue;
        veryBigObject.ee85 = floatValue;
        veryBigObject.eee85 = floatArray;
        veryBigObject.eeee85 = floatBoxArray;
        veryBigObject.f85 = doubleValue;
        veryBigObject.ff85 = doubleValue;
        veryBigObject.fff85 = doubleArray;
        veryBigObject.ffff85 = doubleBoxArray;
        veryBigObject.g85 = true;
        veryBigObject.gg85 = true;
        veryBigObject.ggg85 = booleanArray;
        veryBigObject.gggg85 = booleanBoxArray;
        veryBigObject.jj85 = stringValue;
        veryBigObject.jjj85 = stringArray;
        veryBigObject.kk85 = objectA;
        veryBigObject.kkk85 = new ObjectA[]{objectA, objectA};
        veryBigObject.l85 = listWithInteger;
        veryBigObject.llll85 = listWithString;
        veryBigObject.m85 = mapWithInteger;
        veryBigObject.mm85 = mapWithObject;
        veryBigObject.s85 = setWithInteger;
        veryBigObject.ssss85 = setWithString;
        veryBigObject.a86 = byteValue;
        veryBigObject.aa86 = byteValue;
        veryBigObject.aaa86 = byteArray;
        veryBigObject.aaaa86 = byteBoxArray;
        veryBigObject.b86 = shortValue;
        veryBigObject.bb86 = shortValue;
        veryBigObject.bbb86 = shortArray;
        veryBigObject.bbbb86 = shortBoxArray;
        veryBigObject.c86 = intValue;
        veryBigObject.cc86 = intValue;
        veryBigObject.ccc86 = intArray;
        veryBigObject.cccc86 = integerArray;
        veryBigObject.d86 = longValue;
        veryBigObject.dd86 = longValue;
        veryBigObject.ddd86 = longArray;
        veryBigObject.dddd86 = longBoxArray;
        veryBigObject.e86 = floatValue;
        veryBigObject.ee86 = floatValue;
        veryBigObject.eee86 = floatArray;
        veryBigObject.eeee86 = floatBoxArray;
        veryBigObject.f86 = doubleValue;
        veryBigObject.ff86 = doubleValue;
        veryBigObject.fff86 = doubleArray;
        veryBigObject.ffff86 = doubleBoxArray;
        veryBigObject.g86 = true;
        veryBigObject.gg86 = true;
        veryBigObject.ggg86 = booleanArray;
        veryBigObject.gggg86 = booleanBoxArray;
        veryBigObject.jj86 = stringValue;
        veryBigObject.jjj86 = stringArray;
        veryBigObject.kk86 = objectA;
        veryBigObject.kkk86 = new ObjectA[]{objectA, objectA};
        veryBigObject.l86 = listWithInteger;
        veryBigObject.llll86 = listWithString;
        veryBigObject.m86 = mapWithInteger;
        veryBigObject.mm86 = mapWithObject;
        veryBigObject.s86 = setWithInteger;
        veryBigObject.ssss86 = setWithString;
        veryBigObject.a87 = byteValue;
        veryBigObject.aa87 = byteValue;
        veryBigObject.aaa87 = byteArray;
        veryBigObject.aaaa87 = byteBoxArray;
        veryBigObject.b87 = shortValue;
        veryBigObject.bb87 = shortValue;
        veryBigObject.bbb87 = shortArray;
        veryBigObject.bbbb87 = shortBoxArray;
        veryBigObject.c87 = intValue;
        veryBigObject.cc87 = intValue;
        veryBigObject.ccc87 = intArray;
        veryBigObject.cccc87 = integerArray;
        veryBigObject.d87 = longValue;
        veryBigObject.dd87 = longValue;
        veryBigObject.ddd87 = longArray;
        veryBigObject.dddd87 = longBoxArray;
        veryBigObject.e87 = floatValue;
        veryBigObject.ee87 = floatValue;
        veryBigObject.eee87 = floatArray;
        veryBigObject.eeee87 = floatBoxArray;
        veryBigObject.f87 = doubleValue;
        veryBigObject.ff87 = doubleValue;
        veryBigObject.fff87 = doubleArray;
        veryBigObject.ffff87 = doubleBoxArray;
        veryBigObject.g87 = true;
        veryBigObject.gg87 = true;
        veryBigObject.ggg87 = booleanArray;
        veryBigObject.gggg87 = booleanBoxArray;
        veryBigObject.jj87 = stringValue;
        veryBigObject.jjj87 = stringArray;
        veryBigObject.kk87 = objectA;
        veryBigObject.kkk87 = new ObjectA[]{objectA, objectA};
        veryBigObject.l87 = listWithInteger;
        veryBigObject.llll87 = listWithString;
        veryBigObject.m87 = mapWithInteger;
        veryBigObject.mm87 = mapWithObject;
        veryBigObject.s87 = setWithInteger;
        veryBigObject.ssss87 = setWithString;
        veryBigObject.a88 = byteValue;
        veryBigObject.aa88 = byteValue;
        veryBigObject.aaa88 = byteArray;
        veryBigObject.aaaa88 = byteBoxArray;
        veryBigObject.b88 = shortValue;
        veryBigObject.bb88 = shortValue;
        veryBigObject.bbb88 = shortArray;
        veryBigObject.bbbb88 = shortBoxArray;
        veryBigObject.c88 = intValue;
        veryBigObject.cc88 = intValue;
        veryBigObject.ccc88 = intArray;
        veryBigObject.cccc88 = integerArray;
        veryBigObject.d88 = longValue;
        veryBigObject.dd88 = longValue;
        veryBigObject.ddd88 = longArray;
        veryBigObject.dddd88 = longBoxArray;
        veryBigObject.e88 = floatValue;
        veryBigObject.ee88 = floatValue;
        veryBigObject.eee88 = floatArray;
        veryBigObject.eeee88 = floatBoxArray;
        veryBigObject.f88 = doubleValue;
        veryBigObject.ff88 = doubleValue;
        veryBigObject.fff88 = doubleArray;
        veryBigObject.ffff88 = doubleBoxArray;
        veryBigObject.g88 = true;
        veryBigObject.gg88 = true;
        veryBigObject.ggg88 = booleanArray;
        veryBigObject.gggg88 = booleanBoxArray;
        veryBigObject.jj88 = stringValue;
        veryBigObject.jjj88 = stringArray;
        veryBigObject.kk88 = objectA;
        veryBigObject.kkk88 = new ObjectA[]{objectA, objectA};
        veryBigObject.l88 = listWithInteger;
        veryBigObject.llll88 = listWithString;
        veryBigObject.m88 = mapWithInteger;
        veryBigObject.mm88 = mapWithObject;
        veryBigObject.s88 = setWithInteger;
        veryBigObject.ssss88 = setWithString;
    }
}
