/*
 * Copyright (C) 2020 The zfoo Authors
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package com.zfoo.protocol.anno;

import java.lang.annotation.*;

/**
 * EN: Unique protocol number
 * CN: 唯一的协议号
 *
 * @author meiw
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface Protocol {

    short id() default 0;

    /**
     * EN: Use Javassist bytecode to enhance serialization of the protocol
     * CN: 使用Javassist字节码增强协议的序列化
     */
    boolean enhance() default true;

}

