/*
 * Copyright (C) 2020 The zfoo Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package com.zfoo.orm.accessor;

import com.zfoo.orm.cache.persister.PNode;
import com.zfoo.orm.model.IEntity;
import org.springframework.lang.Nullable;

import java.util.List;

/**
 * 对数据库进行（增，删，改）的相关方法
 *
 * @author godotg
 */
public interface IAccessor {

    <PK extends Comparable<PK>, E extends IEntity<PK>> boolean insert(E entity);

    <PK extends Comparable<PK>, E extends IEntity<PK>> void batchInsert(List<E> entities);

    <PK extends Comparable<PK>, E extends IEntity<PK>> boolean update(E entity);

    <PK extends Comparable<PK>, E extends IEntity<PK>> void batchUpdate(List<E> entities);

    <PK extends Comparable<PK>, E extends IEntity<PK>> boolean delete(E entity);

    <PK extends Comparable<PK>, E extends IEntity<PK>> boolean delete(PK pk, Class<E> entityClazz);

    <PK extends Comparable<PK>, E extends IEntity<PK>> void batchDelete(List<E> entities);

    <PK extends Comparable<PK>, E extends IEntity<PK>> void batchDelete(List<PK> pks, Class<E> entityClazz);

    @Nullable
    <PK extends Comparable<PK>, E extends IEntity<PK>> E load(PK pk, Class<E> entityClazz);

}
