/*
 * Copyright (C) 2020 The zfoo Authors
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */

package com.zfoo.boot;

import com.zfoo.event.EventContext;
import com.zfoo.event.schema.EventRegisterProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * Register the EventRegisterProcessor bean through the @Import annotation,
 * and when each bean is injected into the IOC container, it will pass through the EventRegisterProcessor.
 *
 * @author godotg
 */
@Configuration(proxyBeanMethods = false)
@Import({EventRegisterProcessor.class})
public class EventAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public EventContext eventContext() {
        return new EventContext();
    }

}
