<a href="https://awesome.re">
    <img src="https://awesome.re/badge-flat2.svg" alt="Awesome">
</a>

# Archive Message

We haven't been able to maintain this repo with the attention it needs, so we are archiving it. 

# A List of Awesome ZeroTier Things

Hello!

This repository contains a list of all things ZeroTier that can be
found on The Internet. Feel free to add yours!

[Pull Requests](https://github.com/zerotier/awesome-zerotier/edit/main/README.md) accepted!

## Contents
- [ZeroTier Self-Hosting](#zerotier-self-hosting)
- [ZeroTier Training](#zerotier-training)
- [ZeroTier Networking](#zerotier-networking)
- [ZeroTier Linux](#zerotier-linux)
- [ZeroTier Windows](#zerotier-windows)
- [ZeroTier Remote Access](#zerotier-remote-access)
- [ZeroTier SD-WAN](#zerotier-sd-wan)
- [ZeroTier IoT](#zerotier-iot)
- [ZeroTier Industrial IoT](#zerotier-industrial-iot)
- [ZeroTier Industrial IoT Hardware](#zerotier-industrial-iot-hardware)
- [ZeroTier Edge Computing](#zerotier-edge-computing)
- [ZeroTier Drone/UAV](#zerotier-droneuav)
- [ZeroTier Robotics](#zerotier-robotics)
- [ZeroTier Automotive/Electric/Autonomous Vehicles](#zerotier-automotive)
- [ZeroTier AgTech](#zerotier-agtech)
- [ZeroTier Earthquake Detection](#zerotier-earthquake-detection)
- [ZeroTier Infosec](#zerotier-infosec)
- [ZeroTier OpenWISP](#zerotier-openwisp)
- [ZeroTier IBM](#zerotier-ibm)
- [ZeroTier Terraform](#zerotier-terraform)
- [ZeroTier Kubernetes](#zerotier-kubernetes)
- [ZeroTier Docker](#zerotier-docker)
- [ZeroTier Bridging](#zerotier-bridging)
- [ZeroTier MikroTik](#zerotier-mikrotik)
- [ZeroTier Teltonika Networks](#zerotier-teltonika-networks)
- [ZeroTier Ubiquiti](#zerotier-ubiquiti)
- [ZeroTier OpenWrt](#zerotier-openwrt)
- [ZeroTier OPNsense](#zerotier-opnsense)
- [ZeroTier pfSense](#zerotier-pfsense)
- [ZeroTier Other Routers](#zerotier-other-routers)
- [ZeroTier Gateways](#zerotier-gateways)
- [ZeroTier Bastions](#zerotier-bastions)
- [ZeroTier Synology](#zerotier-synology)
- [ZeroTier Raspberry Pi](#zerotier-raspberry-pi)
- [ZeroTier 3-D Printing](#zerotier-3-d-printing)
- [ZeroTier Homelab](#zerotier-homelab)
- [ZeroTier Home Automation](#zerotier-home-automation)
- [ZeroTier Video/Camera/CCTV](#zerotier-videocameracctv)
- [ZeroTier EVE-NG](#zerotier-eve-ng)
- [ZeroTier Blender](#zerotier-blender)
- [ZeroTier Oculus](#zerotier-oculus)
- [ZeroTier Gaming](#zerotier-gaming)
- [ZeroTier Blockchain/Crypto](#zerotier-blockchaincrypto)
- [ZeroTier Everything Else](#zerotier-everything-else)
- [ZeroTier Reddit](#zerotier-reddit)
- [ZeroTier YouTube](#zerotier-youtube)


## ZeroTier Self-Hosting

#### Self-Hosting Network Controller Interfaces
- [key-networks / ztncui](https://github.com/key-networks/ztncui) - GUI for self-hosted ZeroTier.
- [key-networks / ztncui-aio](https://github.com/key-networks/ztncui-aio) - ZeroTier network controller user interface in a Docker container.
- [thedunston / bash_cli_zt](https://github.com/thedunston/bash_cli_zt) - Command Line interface for self-hosted ZeroTier.
- [dec0dOS / zero-ui](https://github.com/dec0dOS/zero-ui) - GUI for self-hosted ZeroTier.
- [mdplusplus/zerotier-network-controller-ui](https://hub.docker.com/r/mdplusplus/zerotier-network-controller-ui) - Docker image for self-hosted ZeroTier.
- [sinamics / ztnet](https://github.com/sinamics/ztnet) - Containerized GUI for self-hosted ZeroTier.

#### Self-Hosting articles
- [zerotier – The Dorknet rises](https://www.exclusionzone.org/2019/12/10/zerotier-the-dorknet-rises/) - Self-hosted ZeroTier on OPNsense.
- [From zero to Zerotier in k3s way](https://medium.com/iotops/from-zero-to-zerotier-in-k3s-way-eadff5745566) - Self-hosted ZeroTier on a Raspberry Pi, using k3s.

#### Self-Hosting videos
- [DB Tech - ZeroTier Network Controller in Docker](https://www.youtube.com/watch?v=oC7y_qYKUTU) - Self-hosted ZeroTier on Docker.


## ZeroTier Training

#### ZeroTier Training courses
- [CBT Nuggets - Securely Connect Local Network Devices to AWS VPC with ZeroTier](https://www.cbtnuggets.com/it-training/skills/securely-connect-local-network-devices-aws-vpczerotier)


## ZeroTier Networking

#### Networking articles
- [Abusing Public DNS for Zerotier Routing](https://dev.to/issmirnov/abusing-public-dns-for-zerotier-routing-36ke)
- [Building a Private Backplane Network for your VPSs with ZeroTier | Pete Keen](https://www.petekeen.net/building-a-private-backplane-network-with-zerotier)
- [Creating Secure Private Networks With ZeroTier VPN](https://dzone.com/articles/creating-secure-private-networks-with-zerotier-vpn)
- [Creating a Site-to-Site VPN with ZeroTier and BGP](https://www.linkedin.com/pulse/creating-site-to-site-vpn-zerotier-bgp-robert-lynch/)
- [How To Connect Everything From Everywhere with ZeroTier](https://blog.fosketts.net/2022/01/14/how-to-connect-everything-from-everywhere-with-zerotier/)
- [Multi-Cloud K3s, and also I got (temporarily) kicked off Google Cloud](https://www.danmanners.com/posts/2021-12-multi-cloud-k3s-and-booted-from-gcloud/)
- [Network Modeling: Segmented Lab access with Containerlab and ZeroTier](https://stubarea51.net/2021/11/23/network-modeling-segmented-lab-access-with-containerlab-and-zerotier)
- [Routing traffic to ZeroTier's subnet from all devices on the LAN](https://chrisatech.wordpress.com/2021/02/22/routing-traffic-to-zerotiers-subnet-from-all-devices-on-the-lan/)

#### Networking articles global
- [比frp更好用的内网穿透工具-ZeroTier One](https://jiayaoo3o.github.io/2020/06/11/%E6%AF%94frp%E6%9B%B4%E5%A5%BD%E7%94%A8%E7%9A%84%E5%86%85%E7%BD%91%E7%A9%BF%E9%80%8F%E5%B7%A5%E5%85%B7-ZeroTier%20One/#more)
- [zerotier 基礎使用步驟教學](https://blog.toolman.xyz/article/240)
- [ZeroTier | Δικτύωση απομακρυσμένων Linux, Windows, macOS, BSD, Android, iOS συσκευών](https://cerebrux.net/2021/10/24/zerotier-%ce%b4%ce%b9%ce%ba%cf%84%cf%8d%cf%89%cf%83%ce%b7-%ce%b1%cf%80%ce%bf%ce%bc%ce%b1%ce%ba%cf%81%cf%85%cf%83%ce%bc%ce%ad%ce%bd%cf%89%ce%bd-%cf%83%cf%85%cf%83%ce%ba%ce%b5%cf%85%cf%8e%ce%bd/)

#### Networking videos
- [Considered Normal? - Creating a Local LAN with ZeroTier](https://www.youtube.com/watch?v=Af758HL6VkA) 
- [Duane Dunston - Private ZeroTier Network on the Public Internet](https://www.youtube.com/watch?v=xp2ujXe1SOU)
- [Duane Dunston - ZeroTier Hub and Spoke](https://www.youtube.com/watch?v=Fb65bU3oyEo)
- [Eric Sloof - ZeroTier - The ethernet switch for planet earth](https://www.youtube.com/watch?v=XrLk21Xy2i0) 
- [infoTK - Finally ! work from home using VPN free and without Public IP](https://www.youtube.com/watch?v=JwGKi3UWJ_I) 
- [MRP - Local Network everywhere - Zero Tier : Global Area Networking](https://www.youtube.com/watch?v=eI-yxrMH3uY) 
- [Network Collective - How Does ZeroTier Actually Work?](https://www.youtube.com/watch?v=Lao9T_RQTak) 
- [Lawrence Systems - Open Source Mesh VPN Solutions](https://www.youtube.com/watch?v=QfcwiSkV_AU) 
- [Lawrence Systems - ZeroTier Tutorial: Delivering the Capabilities of VPN, SDN, and SD-WAN via an Open Source System](https://www.youtube.com/watch?v=Bl_Vau8wtgc)
- [LearnLinuxTV - Networking with ZeroTier: Creating software-defined networks with Ease](https://www.youtube.com/watch?v=9GTXN0opsdw) 
- [Sheridan Computers - ZeroTier | Virtual Networking | Remote Desktop | Remote Working | VPN](https://www.youtube.com/watch?v=1Sobvh6OiC8) 

#### Networking videos global
- [ADINATA - ZeroTier Solusi Remote Perangkat Aman Dan Nyaman Untuk Pengguna Internet Broadband Dan Dedicated](https://www.youtube.com/watch?v=7tN9iw7FIo4)
- [Usando ZeroTier One y NextDNS para acceder a tus datos por VPN](https://blog.ayudait.eu/2020/11/usando-zerotier-one-y-nextdns.html)
- [NASeros - Incorporación de un ordenador a ZeroTier](https://www.youtube.com/watch?v=ZtXhZCkxaak) 
- [Servicios Virtuales Administrados SVA - Multi Usuario RDP/VPN ZeroTier -- CURSO GRATUITO](https://www.youtube.com/watch?v=z8N1NeYORbM)
- [Software Defined Networks with ZeroTier | Urdu](https://www.youtube.com/watch?v=Pk5EXqNLFzA&t=1s)
- [VPN multisitio con ZeroTier](https://www.youtube.com/watch?v=ZDcwKQM1J4s&t=2s)
- [Zerotier: la Terra è il tuo ufficio (sicuro e privato)](https://www.youtube.com/watch?v=LHilEAF5S2U&t)


## ZeroTier Linux 

- [Duoslow / zerotierIndicator](https://github.com/Duoslow/zerotierIndicator)

#### Linux articles
- [Curl and jq to Manage ZeroTier networks](https://www.simplecto.com/zerotier-jq-manage-zerotier-networks/)
- [Install Zerotier CLI Linux](https://www.greghilston.com/post/install_zerotier/)
- [Arch Linux wiki - ZeroTier](https://wiki.archlinux.org/title/ZeroTier)

#### Linux videos
- [Roel Van de Paar - Install ZeroTier on Ubuntu with armhf hardware](https://www.youtube.com/watch?v=9KMHwCUzf4g)

#### Linux videos global
- [Oracle Linux y Zerotier One](https://www.youtube.com/watch?v=y6nwlr9JiV4)


## ZeroTier Windows
- [Chocolatey - zerotier-one (Install)](https://community.chocolatey.org/packages/zerotier-one)


## ZeroTier Remote Access

#### Remote Access articles
- [Remote Access Without Port Forwarding](https://john.muchovej.com/thoughts/remote-access-without-port-forwarding/)
- [Setting up Remote Access During a Crisis](https://www.spikefishsolutions.com/post/setting-up-remote-access-during-a-crisis)
- [Stratospherix FileBrowser - How to access your files from anywhere](https://www.stratospherix.com/support/how-to-access-your-files-from-anywhere-with-zerotier.php)

#### Remote Access articles global
- [Télétravail, RDP & VPN](https://www.canaletto.fr/post/teletravail-rdp-vpn)
- [zerotier 팀뷰어만 되는 환경에서 사용하니 정말 좋군요.](https://www.clien.net/service/board/park/14534750)

#### Remote Access videos
- [Lawrence Systems - How To Work Remotely Using ZeroTier & Windows Remote Desktop (RDP)](https://www.youtube.com/watch?v=ZShna7v77xc)
- [Odly Otter - Setting up ZeroTier to securely connect to your home server while roaming](https://www.youtube.com/watch?v=EgdFzxit_6M) 
- [Remote Access: Securely connect your devices over the internet with ZeroTier](https://www.youtube.com/watch?v=7C2AGnr9Q-w)
- [The Cyber Mentor - Hack From Anywhere! - ZeroTier Remote Access](https://www.youtube.com/watch?v=bUOU8BW0IrM) 


## ZeroTier SD-WAN

#### SD-WAN articles
- [A consumer-grade SD-WAN solution to improve mobile internet](https://www.linkedin.com/pulse/consumer-grade-sd-wan-solution-improve-mobile-jonathan-gearinger/)
- [How do I create a VPN/SD-WAN with Zerotier and Teltonika?](https://know.innon.com/vpn-zerotier-and-teltonika)
- [ZeroTier on OpenWrt (VPN + SD-WAN)](https://foro.seguridadwireless.net/openwrt/vpn-con-zerotier-en-openwrt/)

#### SD-WAN videos
- [Profitap HQ B.V - How to Connect IOTA to ZeroTier SD-WAN environment](https://www.youtube.com/watch?v=dn8rFCttJVg) 
- [SecurityGuy - Hands-on with ZeroTier SD-WAN for Cloud Connectivity](https://www.youtube.com/watch?v=pntbQBtneZg) 


#### SD-WAN videos global
- [LACNIC RIR - ZeroTier - Usando una solución Open Source para integrar VPNs e iniciar operaciones SD-WAN](https://www.youtube.com/watch?v=pM2ZQ9trcM8)


## ZeroTier IoT

#### IoT articles
- [Do you want to control your #panasonic #broadcast #video cameras from anywhere?](https://www.linkedin.com/posts/jeremyrollinson_panasonic-broadcast-video-activity-7057337376078999552-hFEW)
- [IOTStack ZeroTier](https://sensorsiot.github.io/IOTstack/Containers/ZeroTier/)
- [qbee.io IoT - Setup and manage ZeroTier](https://qbee.io/docs/zerotier-setup-with-qbee-agent.html)
- [MQTT to a Server with ZeroTier](https://meshtastic.discourse.group/t/mqtt-to-a-server-with-zerotier/8431/2)
- [I just connected my home automation gateway server to my Sonoff devices using MQTT and Ignition Maker Edition](https://www.linkedin.com/posts/alexandre-castro-msc-28381039_homeautomation-smarthome-mqtt-activity-7086013481119793152-Il8X)
- [IoT (Internet of Things) refers to the network of interconnected physical devices, vehicles, buildings, and other objects embedded with sensors](https://www.linkedin.com/posts/dharmendra-kumar-94472611a_zerotier-opcua-iec61850-activity-7087052704509755392-hkrO)

#### IoT published research
- [Sensor Actuator Network for In Situ Studies of Antarctic Plants Physiology](https://www.ncbi.nlm.nih.gov/pmc/articles/PMC9695489/)
- [European Chemical Bulletin - BRIDGING THE GAP: UNIFYING REMOTE WORK AND IOT INTEGRATION WITH ZEROTIER FOR BETTER CONNECTIVITY AND SECURITY](https://www.eurchembull.com/issue-content/bridging-the-gap-unifying-remote-work-and-iot-integration-with-zero-tier-for-better-connectivity-and-security-14608)
- [Development of sensors using Internet of Things](https://riunet.upv.es/bitstream/handle/10251/186553/Yerpes%20-%20Development%20of%20sensors%20using%20Internet%20of%20Things.pdf?sequence=1)
- [ieee.org - Accurate Detection of IoT Sensor Behaviors in Legitimate, Faulty and Compromised Scenarios](https://www.computer.org/csdl/journal/tq/2023/01/09632348/1yYPqVxHkgU)
- [C3PO: Cloud-based Confidentiality-preserving Continuous Query Processing (IoT)](https://dl.acm.org/doi/10.1145/3472717)

#### IoT articles global
- [Se connecter à distance à Home Assistant avec ZeroTier](https://automation360blog.wordpress.com/2021/01/25/iot2050_zerotier/)
- [Industry 4.0 Systems - Zerotier como bridge con una sola interface de red](https://industry40.systems/8)
- [Diario Curso: Raspberry Pi y Node-RED. 2ª ed](https://aprendiendoarduino.wordpress.com/2022/06/04/diario-curso-raspberry-pi-y-node-red-2a-ed/)

#### IoT videos global
- [การเชื่อมต่อ VPN ให้กับ IOT2050 ด้วย ZeroTier](https://automation360blog.wordpress.com/2021/01/25/iot2050_zerotier/)
- [industry4.0 systems - ZeroTier para IoT](https://www.youtube.com/watch?v=xTaHqo5fUhU)
- [Node-RED Cihazına ZeroTier ile Uzaktan Erişim](https://www.youtube.com/watch?v=T5iBesDyxCU)
- [AI_SmartSwitch ESP01 #NgobrolSantai Basic Networking - ZeroTier-One VPN](https://www.youtube.com/watch?v=kV3Wbz7fyZE)


## ZeroTier Industrial IoT

- [mpsaltis / wago_ZeroTierContainer](https://github.com/mpsaltis/wago_ZeroTierContainer/tree/main)
- [balena-io-examples / balena-zerotier-gateway](https://github.com/balena-io-examples/balena-zerotier-gateway)

#### Industrial IoT articles
- [Zerotier & Mikrotik design concept](https://infrageeks.com/post/2023-08-29.zerotier-mikrotik-design-concept/)
- [InHand Networks Industrial IoT - InRouter305 User Manual - ZeroTier VPN](https://www.inhandnetworks.com/upload/attachment/202305/15/InRouter305%20User%20Manual%20V1.4.pdf)
- [NavigateWorx Routers now support ZeroTier Platform](https://www.linkedin.com/posts/navigateworx_navigateworx-routers-now-support-zerotier-activity-7084105000540385280-0o7C/)
- [WLINK IoT - About ZeroTier](https://www.wlink-tech.com/art/about-zerotier)
- [How To: Use ZeroTier on Wago Controllers](https://www.wago.community/t/how-to-use-zerotier-on-wago-controllers/529/1)
- [RiverPlus Industrial IoT](https://riverplus.atlassian.net/wiki/spaces/IIOTPUB/pages/2422014014/Teltonika+with+ZeroTier+VPN)
- [Utilising ZeroTier for remote access of the PLC and HMIs](https://www.linkedin.com/posts/sherwin-jacobs_utilising-zerotier-for-remote-access-of-the-activity-7079560913476886528-SyNk)
- [r/ZeroTier - Windows and remote PLC programming](https://www.reddit.com/r/zerotier/comments/rdhu8v/windows_and_remote_plc_programming/)
- [Teltonika Networks - ZeroTier bridge PLCs behind different routers](https://community.teltonika.lt/t/zerotier-bridge-plc-s-behind-different-routers/2800/21)
- [IEC-61850 - For Industrial OT Engineers - A step-by-step guide on how to use Zerotier and a Raspberry Pi to connect radio and satellites](https://www.linkedin.com/pulse/iec-61850-industrial-ot-engineers-kylo-parisher/)

#### Industrial IoT articles global
- [Especialización en Industria 4.0: Aplicaciones IOT](https://autotecperu.com/capacitaciones_curso.php?i=28&n=variadores_y_sistema_de_presion_constante)
- [Configurare una VPN ZeroTier su un router MikroTik per raggiungere un supervisiore Schneider Wiser KNX su un impianto](https://www.linkedin.com/posts/marco-boschini_mikrotik-routeros-scheider-activity-6994358479893217280-J0eE/)

#### Industrial IoT videos global
- [Configurar PLC Siemens S7 1200 en remoto con diferentes IP desde Zerotier](https://www.youtube.com/watch?v=oeXo0wk3dBE)


## ZeroTier Industrial IoT Hardware

#### Espressif - ZeroTier on embedded devices for Espressif (like ESP8266/ESP32)
- [zhzhzhy / Zerotier-Espressif](https://github.com/zhzhzhy/Zerotier-Espressif)

#### EtherTek Circuits - Remote Monitoring & Control Devices
- [Exciting News! Introducing ZeroTier to our RMSv2 products!](https://twitter.com/EtherTek/status/1668797431474184192)
- [RMS-100v2 Firmware](https://remotemonitoringsystems.ca/rms100v2/rms-100v2-upgrade-firmware.php)

#### Logic Machine platform for KNX/EIB, EnOcean, Modbus, DALI, BacNet | plc, knx, enocean, modbus, bacnet, dali, scada, gsm
- [ZeroTier remote maintenance of LogicMachine](https://kb.logicmachine.net/misc/zerotier/)


## ZeroTier Edge Computing

#### Edge Computing articles
- [Dell Validated Design for Manufacturing Edge - Design Guide with 5 Independent Software Vendors](https://infohub.delltechnologies.com/l/dell-validated-design-for-manufacturing-edge-design-guide-with-5-independent-software-vendors-1/litmus-system-design-5/)
- [AI@Edge - A Secure and Reusable Artificial Intelligence Platform for Edge Computing in Beyond 5G Networks](https://aiatedge.eu/wp-content/uploads/2023/02/AI@EDGE_D5.2_Preliminary-validation-and-use-case-benchmarking.pdf)


## ZeroTier Drone/UAV

- [uavpal / disco4g](https://github.com/uavpal/disco4g)

#### Drone/UAV articles 

- [COEX Clover - Creating a virtual network ZeroTier One and connecting to it](https://clover.coex.tech/en/zerotier_vpn.html)
- [Exodronics EXO DATA TELECOMMUNICATIONS, SOFTWARE AND HARDWARE](https://exodronics.com/exo-data-telecommunications-software-hardware/)
- [RC Bellergy's Drones - 4. Install Zerotier](http://bellergy.com/4-install-zerotier/)
- [UAVCast- Pro ZeroTier VPN](https://docs.uavmatrix.com/vpn/zerotier/)
- [VPNs, Cliff Bars, and a Delivery Drone](https://intellitect.com/delivery-drone/)
- [PX4 Autopilot User Guide - Data Telephony LTE](https://docs.px4.io/v1.12/en/peripherals/companion_computer_peripherals.html#data-telephony-lte)

#### Drone/UAV published research
- [ieee.org - A Safe, Open Source, 4G Connected Self-Flying Plane With 1 Hour Flight Time and All Up Weight (AUW) < 300 g: Towards a New Class of Internet Enabled UAVs](https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=8718270)
- [Sensors - Mobile Network Performance and Technical Feasibility of LTE-Powered Unmanned Aerial Vehicle](https://www.mdpi.com/1424-8220/21/8/2848)


## ZeroTier Robotics

- [nikivanov / watney](https://github.com/nikivanov/watney)

#### Robotics articles

- [Help understanding BlueBoat Hardware/Software Architecture for hydrography](https://discuss.bluerobotics.com/t/help-understanding-blueboat-hardware-software-architecture-for-hydrography/14822/2)
- [ETHZ RobotX SuperMegaBot](https://ethz-robotx.github.io/SuperMegaBot/robot-operation/HowToVPN.html) 
- [Telepresent Operation](https://hackaday.io/project/181888-omni/log/198193-telepresent-operation)

#### Robotics published research
- [Frontiers in Robotics and AI - Scalable and heterogenous mobile robot fleet-based task automation in crowded hospital environments—a field test](https://www.frontiersin.org/articles/10.3389/frobt.2022.922835/full)
- [Remote Operation of Marine Robotic Systems and Next-Generation Multi-Purpose Control Rooms](https://www.mdpi.com/2077-1312/11/10/1942)
- [A 4G-Connected Micro-Rover With Infinite Range](https://www.burkelab.com/wp-content/uploads/A-4G-Connected-Micro-Rover.pdf)


## ZeroTier Automotive

#### Automotive/Electric/Autonomous Vehicles articles
- [Smart Card-based Access Control System using Isolated Many-to-Many Authentication Scheme for Electric Vehicle Charging Stations](https://journals.itb.ac.id/index.php/jictra/article/view/19796)
- [Certifying battery usage for Vehicle-to-Grid and second life with a blockchain-based framework](https://www.sciencedirect.com/science/article/pii/S1389128623000038?via%3Dihub)
- [Connecting to my car over ZeroTier](https://www.tiernanotoole.ie/2020/11/09/connecting-to-my-car-over-zerotier.html)
- [Ford Transit USA Forum - Routers? Can't be without internet](https://www.fordtransitusaforum.com/threads/routers-cant-be-without-internet-nature-its-all-over-me-get-it-off-of-me.94075/page-5)


## ZeroTier AgTech

#### AgTech articles
- [Smart Agricultural Technology - Smart implements by leveraging ISOBUS: Development and evaluation of field applications](https://www.researchgate.net/publication/374594291_Smart_implements_by_leveraging_ISOBUS_Development_and_evaluation_of_field_applications)


## ZeroTier Earthquake Detection

#### Earthquake Detection articles
- [How to connect to Raspberry Shake remotely](https://manual.raspberryshake.org/remoteConnection.html)
- [A Peer-to-Peer Communication Method for Distributed Earthquake Early Warning Networks: Preliminary Findings](https://idl.iscram.org/files/benjaminhong/2023/2485_BenjaminHong_etal2023.pdf)
- [“Saving Precious Seconds”—A Novel Approach to Implementing a Low-Cost Earthquake Early Warning System with Node-Level Detection and Alert Generation](https://www.mdpi.com/2227-9709/9/1/25)
- [eqc.govt.nz - Community-led low-cost micro-seismic (MS) sensor network applications for Earthquake Early Warning (EEW)](https://www.eqc.govt.nz/assets/Publications-Resources/Funded-Research-papers/1973-Community-led-low-cost-micro-seismic-MS-sensor-network-applications-for-Earthquake-Early-Warning-EEW.pdf)


## ZeroTier Infosec

#### Infosec articles
- [LOCKING DOWN ZEROTIER PEER-TO-PEER NETWORKS](https://blog.reconinfosec.com/locking-down-zerotier/)
- [PENTEST DROPBOX 2021 EDITION.](https://www.chesapeakesec.com/blog/pentest-dropbox-2021-edition)
- [Wireless (in)security in Canberra CBD](https://blog.gaborszathmari.me/wireless-insecurity-canberra-cbd/)
- [ZeroTier for a Reliable and Private Security Monitoring Network](https://chrisapproved.com/blog/zerotier-reliable-security-monitoring.html)

#### Infosec videos
- [Lawrence Systems - How to Use Kali Linux on Raspberry Pi 4 As a Remote Network Access and NMAP Discovery Audit Tool](https://www.youtube.com/watch?v=ksTHrJBihLM)
- [Lawrence Systems - ZeroTier VS VPN and A Look At The Data Stream With Wireshark](https://www.youtube.com/watch?v=9Rfqi62bo5M)


## ZeroTier OpenWISP

#### ZeroTier OpenWISP articles
- [ZeroTier Tunnel Automation](https://openwisp.io/docs/user/zerotier.html)


## ZeroTier IBM

#### IBM articles
- [Experience ZeroTier: Zero-trust networking for the cloud](https://developer.ibm.com/articles/experience-zerotier-zero-trust-networking-for-the-cloud/)


## ZeroTier Terraform

- https://registry.terraform.io/providers/zerotier/zerotier/latest
- https://registry.terraform.io/modules/zerotier/network/zerotier/latest
- https://registry.terraform.io/modules/zerotier/member/zerotier/latest


## ZeroTier Kubernetes

#### Kubernetes articles
- [Setting up self-hosted Kubernetes](https://fredrik.space/posts/self-hosted-kubernetes/)
- [Kube Endpoints and Reverse-Proxying Non-Kube Services](https://www.danmanners.com/posts/2022-01-kubernetes-endpoint-proxies/)
- [Kubernetes Zerotier Bridge](https://www.opensourceagenda.com/projects/kubernetes-zerotier-bridge)

#### Kubernetes articles global
- [Mise en oeuvre d’un cluster Kubernetes dans une instance AMD EPYC de Scaleway via Rancher et Multipass : introduction au No-Ops avec DevSpace …](https://deep75.medium.com/mise-en-oeuvre-dun-cluster-kubernetes-dans-une-instance-amd-epyc-de-scaleway-via-rancher-et-7372a3fc22a6)


## ZeroTier Docker

#### Docker articles
- [Self-host your own SOCKS5 Proxy Server with Docker](https://www.simplecto.com/self-host-socks5-proxy-server-with-docker/)

#### Docker videos
- [DB Tech - ZeroTier Network Controller in Docker](https://www.youtube.com/watch?v=oC7y_qYKUTU)

#### Docker videos global
- [uGeek - ZeroTier. Alternativa a una VPN. También por Docker (hecho con Spreaker)](https://www.youtube.com/watch?v=g0Smu0rPhy8)


## ZeroTier Bridging

#### Bridging articles
- [Using Synology as a ZeroTier Bridge](http://www.homeops.tech/2020/07/15/Zero-Tier-On-Synology/)
- [Zerotier bridge to WiFi Router](https://linustechtips.com/topic/1181940-zerotier-bridge-to-wifi-router/)

#### Bridging videos global
- [Zerotier como bridge con una sola interface de red Ubuntu 20.04.3](https://www.youtube.com/watch?v=pzsJB40F_tk)


## ZeroTier MikroTik

#### MikroTik articles
- [ZeroTier - RouterOS - MikroTik Documentation - Support](https://help.mikrotik.com/docs/display/ROS/ZeroTier)
- [Zerotier & Mikrotik design concept](https://itigic.com/mikrotiks-routeros-already-supports-zerotier/)
- [MikroTik’s RouterOS already supports ZeroTier to create SDN networks](https://itigic.com/mikrotiks-routeros-already-supports-zerotier/)

#### MikroTik articles global
- [#009 - MikroTik ZeroTier jako tunel VPN](https://bananowe.it/blog/009-mikrotik-zerotier-jako-tunel-vpn-bananowe-it)

#### MikroTik videos
- [MikroTik - MikroTik RouterOS v7 is finally here!](https://youtu.be/Zp-U7Anv5-0?t=287)
- [The Network Berg - Testing out the Ethernet Switch of the Planet! ZeroTier ft. MikroTik!](https://www.youtube.com/watch?v=eFI59jJ2MM8)
- [ZeroTier Implementation on MikroTik - MIKROTIK TUTORIAL [ENG SUB]](https://www.youtube.com/watch?v=P37YRtsMKD0)

#### MikroTik videos global
- [Fitur ZeroTier pada RouterOS v7 MikroTik [Live Streaming]](https://www.youtube.com/watch?v=iubEUjmKZms) 
- [VPN MikroTik ZeroTier RouterOS v7 Atras CGNAT | Leonardo Vieira](https://www.youtube.com/watch?v=cE-UIyerQPg)
- [TuMaster - Zerotier llegó a Mikrotik](https://www.youtube.com/watch?v=r8XmX8qjmSA&t=27s)
- [Network & Software Solutions - Zerotier Mikrotik - VPNs Gratis!](https://www.youtube.com/watch?v=DX6Ka3aV7Ck)
- [Zerotier στο Mikrotik || Πως το ρυθμίζουμε στο RouterOS!](https://www.youtube.com/watch?v=RDJdaXtnC9A)


## ZeroTier Teltonika Networks

#### Teltonika Networks articles
- [Teltonika Wiki ZeroTier Configuration](https://wiki.teltonika-networks.com/view/ZeroTier_Configuration)
- [ZeroTier One VPN configuration RutOS](https://wiki.teltonika-networks.com/wikibase/index.php?title=ZeroTier_One_VPN_configuration_RutOS&mobileaction=toggle_view_desktop)
- [How do I create a VPN/SD-WAN with Zerotier and Teltonika?](https://know.innon.com/vpn-zerotier-and-teltonika)
- [RUT240 Cellular Router, Verizon](https://novotech.com/products/cellular-routers/4g-lte-wifi-cellular-router-w-ethernet-i-o-verizon.html)

#### Teltonika Networks articles global
- [Jak skonfigurować sieć ZeroTier dla routera przemysłowego 4G / LTE – na przykładzie Teltonika RUT240](https://www.astor.com.pl/poradnikautomatyka/jak-skonfigurowac-siec-zerotier-dla-routera-przemyslowego-4g-lte-na-przykladzie-teltonika-rut240/)
- [Zdalny dostęp w celu programowania sterownika PLC bez publicznego IP, na przykładzie Teltonika RUT955 + Horner XL4e + ZeroTier | Kurs zdalnego dostępu do maszyn i stanowisk produkcyjnych odc.3](https://www.astor.com.pl/poradnikautomatyka/zdalny-dostep-w-celu-programowania-sterownika-plc-bez-publicznego-ip-na-przykladzie-teltonika-rut955-horner-xl4e-zerotier-kurs-zdalnego-dostepu-do-maszyn-i-stanowisk-produkcyjnych-odc-3/)

#### Teltonika Networks videos
- [How to Set Up ZeroTier Communication Bridge on RUTX50 & RUTX11](https://www.youtube.com/watch?v=aVwwjQNpJh4)


## ZeroTier Ubiquiti

#### Ubiquiti articles
- [ZeroTier on a Ubiquiti EdgeRouter](https://kruyt.org/zerotier-on-a-ubiquiti-edgerouter/)
- [ZeroTier on a Ubiquiti EdgeRouter (part 2)](https://kruyt.org/zerotier-on-edgerouter-p2/)
- [The Ubiquiti Diaries: A Site-to-Site VPN Story - Activating ZeroTier - A Virtual SDN](https://www.anandtech.com/show/18692/the-ubiquiti-diaries-a-sitetosite-vpn-story/5)

#### Ubiquiti articles global
- [Unifi UDM Pro, ZT, encore...](https://www.canaletto.fr/post/unifi-udm-pro-encore)

#### Ubiquiti videos
- [Roel Van de Paar - Exposing LAN with ZeroTier when using Ubiquiti Edge Router X?](https://www.youtube.com/watch?v=F_EWh77-3g8) 


## ZeroTier OpenWrt

- [OpenWrt package: zerotier](https://openwrt.org/packages/pkgdata/zerotier)
- [mwarning / zerotier-openwrt](https://github.com/mwarning/zerotier-openwrt)

#### OpenWrt articles
- [OpenWrt Wiki - ZeroTier](https://openwrt.org/docs/guide-user/services/vpn/zerotier)
- [OpenWrt.org - Install a Router as ZeroTier Client](https://forum.openwrt.org/t/install-a-router-as-zerotier-client/152732/6)
- [Set Up a ZeroTier Network on OpenWRT](https://kysonlok.github.io/2020/06/12/Set-Up-a-ZeroTier-Network-on-OpenWRT/)
- [ZeroTier on OpenWrt (VPN + SD-WAN)](https://foro.seguridadwireless.net/openwrt/vpn-con-zerotier-en-openwrt/)

#### OpenWrt videos
- [How to remote access Openwrt router over the internet using Zerotier](https://www.youtube.com/watch?v=dTmp7rY4wHc)

#### OpenWrt videos global
- [PABALATAK - CARA MEMBUAT ZEROTIER UNTUK REMOTE OPENWRT DI LUAR JARINGAN](https://www.youtube.com/watch?v=Cfy8xOxW-34)
- [💻 Configurar ZeroTier en OpenWRT para acceso remoto ⚡ GRATIS](https://www.youtube.com/watch?v=AFzKJJgJJNk)


## ZeroTier OPNsense

#### OPNsense articles
- [OPNsense Documentation - ZeroTier Configuration](https://docs.opnsense.org/manual/how-tos/zerotier.html)
- [Gateway IT Tutorials - OPNsense: ZeroTier Installation and configuration (site-to-site connection)](https://www.youtube.com/watch?v=JQfjFqoVePg) 
- [zerotier – The Dorknet rises](https://www.exclusionzone.org/2019/12/10/zerotier-the-dorknet-rises/) - Self-hosted ZeroTier on OPNsense.


## ZeroTier pfSense

#### pfSense articles
- [jbgzevla - ZeroTier pfSense package demo](https://www.youtube.com/watch?v=t0L_C7_LUgY) 


## ZeroTier Other Routers

- [jvoss / zerotier-bird-router](https://github.com/jvoss/zerotier-bird-router)
- [xwings / xwingswrt](https://github.com/xwings/xwingswrt)

#### Advantech
- [ZeroTier on Advantech Routers](https://icr.advantech.com/support/faq/detail/zerotier-on-advantech-routers)

#### Cudy
- [Cudy Gigabit Multi-WAN VPN Router, R700](http://www.cudytech.com/productinfo/1707613.html)
- [Cudy 5G SA/NSA AX3000 Wi-Fi 6 Router, Model: P5](http://www.cudytech.com/productinfo/1247700.html)

#### EXVIST
- [EXVIST Router EX2](https://docs.exvist.com/ex2/configuration/advance-setting/zerotier)

#### InHand Networks
- [InHand Networks Industrial IoT - InRouter305 User Manual - ZeroTier VPN](https://www.inhandnetworks.com/upload/attachment/202305/15/InRouter305%20User%20Manual%20V1.4.pdf)

#### GL.iNet
- [GL.iNet Router Docs](https://docs.gl-inet.com/router/en/4/interface_guide/zerotier/)
- [GL.iNet Router Docs - ZeroTier Supported Models](https://docs.gl-inet.com/router/en/4/interface_guide/zerotier/#supported-models)
- [GL-iNet Puli AX Wi-Fi 6 Cellular Router review](https://www.techradar.com/pro/phone-communications/gl-inet-puli-ax-wi-fi-6-cellular-router-review)

#### ICC Networking
- [How to: MGS/AWG Gateway - Setting up ZeroTier (snmp on a switch)](https://iccnetworking.zohodesk.com/portal/en/kb/articles/how-to-awg-gateway-setting-up-zerotier)

#### NavigateWorx
- [NavigateWorx Routers now support ZeroTier Platform](https://www.linkedin.com/posts/navigateworx_navigateworx-routers-now-support-zerotier-activity-7084105000540385280-0o7C/)

#### Proroute 4G and 5G routers for remote access and monitoring applications. Industrial grade LTE routers. 
- [Proroute Support For ZeroTier](https://proroute.co.uk/zero-tier/)

#### SunComm
- [SunComm SC-588-5G 5G Outdoor CPE/Router](http://www.suncommtech.com.tw/list_16/46.html)
- [SUNCOMM 5G CPE Zerotier Setting Introduction](https://www.youtube.com/watch?v=7kCWF3g7M3c)
- [ACCESS SUNCOMM DASHBOARD THRU ZEROTIER - TUTORIAL](https://www.youtube.com/watch?v=_FnGCul4_Sw)

#### TAKTIKAL
- [TAKTIKAL 5G / 4G LTE Dual-Band Openwrt Wi-Fi Sim Router](https://www.amazon.com/TAKTIKAL-Dual-Band-Openwrt-Business-Zero-Tier/dp/B0BSCTXB2R)

#### VyOS
- [Run ZeroTier on VyOS router](https://medium.com/@qdrddr/run-zerotier-on-vyos-router-de5aaf1da02b)
- [Run ZeroTier Node on VyOS router as a bare app](https://medium.com/@qdrddr/run-zerotier-node-on-vyos-router-as-a-bare-app-223037443f85)

#### Webdyn
- [Webdyn EasyRouter](https://www.linkedin.com/posts/activity-7130887066925592576-0onC)

#### WLINK Cellular, 5G/4G/3G/2G, IoT, Industrial IoT, Embedded IoT, Routers, Gateways, Modems
- [WLINK IoT - About ZeroTier](https://www.wlink-tech.com/art/about-zerotier)

#### Xiamen Yifan Communication Technology
- [Yeacomm NR610 5G outdoor CPE](https://www.linkedin.com/posts/xiamen-yifan-communication-technology-co-ltd_yeacomm-nr610-5g-outdoor-cpe-initial-setup-activity-7043874882387918849-QGjC/)

#### Yang Yang
- [Check out our industrial 5G robust Router F-NR100](https://www.linkedin.com/posts/yang-yang-b53540191_5g-industrial-robust-activity-7056473572667510784-9zgY/)


## ZeroTier Gateways

- [ddeitterick / zerotier-gateway](https://github.com/ddeitterick/zerotier-gateway)
- [tjelen / zerotier-ubuntu-gateway.md](https://gist.github.com/tjelen/0c070d343c9e6d3db2fbf57e6ceafa7c)

#### ELASTEL
- [EG410 IoT Gateway](https://www.elastel.com/products/industrial-raspberry-pi/eg410-iot-gateway/)

#### OpenVox 
- [OpenVox FXS/FXO VoIP Gateways](https://www.openvox.cn/products/38/b200m-detail.html?tmpl=component&print=1)


## ZeroTier Bastions

- [heri16 / 0-README.md](https://gist.github.com/heri16/3ffdac34a3190efeae199fd5bd83b561)
- [orbiously / zerotier-orb](https://github.com/orbiously/zerotier-orb)

#### Bastion articles
- [AWS ZeroTier Bastion](https://www.matthewevans.co.za/coding/useful-tools/aws-zerotier-bastion.html)
  

## ZeroTier Synology

#### Synology articles
- [Upgrading to DSM7](https://www.unixdude.net/posts/2022/Jan/03/upgrading-to-dsm7/)
- [Using Synology as a ZeroTier Bridge](http://www.homeops.tech/2020/07/15/Zero-Tier-On-Synology/)

#### Synology articles global
- [VPN zwischen zwei Synology NAS mit Zerotier](https://techbox.rocks/vpn-zwischen-zwei-synology-nas-mit-zerotier/)

#### Synology videos
- [Nick Bodmer - Backup your Synology to any remote site, no network configuration with ZeroTier!](https://www.youtube.com/watch?v=NB5CQcw1qmg) 
- [Quik Tech Solutions L.L.C - Use ZeroTier to Access Synology](https://www.youtube.com/watch?v=BTm0HyZCv3I)


## ZeroTier Raspberry Pi

- [rogeriopradoj / zt_VPN.md](https://gist.github.com/rogeriopradoj/84a42420695f048705073aaf5f51c233)
- [sirmaestro / docker-pi-hole-zerotier](https://github.com/sirmaestro/docker-pi-hole-zerotier)

#### Raspberry Pi articles
- [Enable snaps on Raspberry Pi and install zerotier](https://snapcraft.io/install/zerotier/raspbian)
- [RaspiServer - How to: Install ZeroTier on Raspberry Pi](https://raspiserver.com/how-to-install-zerotier-on-raspberry-pi/)
- [PiMyLifeUp - Running ZeroTier on the Raspberry Pi](https://pimylifeup.com/raspberry-pi-zerotier/)
- [Setup a VPN using Zerotier and a Raspberry Pi](https://www.jamesleighton.com/2020/05/16/vpn-using-zerotier-and-a-raspberry-pi/)
- [Connecting Raspberry Pi's to DigitalOcean with ZeroTier](https://www.danmanners.com/posts/p2-k3s-digitalocean-zerotier-and-more/)
- [From zero to Zerotier in k3s way](https://medium.com/iotops/from-zero-to-zerotier-in-k3s-way-eadff5745566)

#### Raspberry Pi articles global
- [Δημιουργία ενός ασφαλούς δικτύου ZeroTier με το Raspberry Pi, το κινητό και το φορητό υπολογιστή](https://eiosifidis.blogspot.com/2023/07/zerotier-raspberry-pi-mobile-laptop-desktop.html)
- [Raspberry Pi 4Bで、VPN接続。](https://lifelog.tokoton0ch.com/post-403/)

#### Raspberry Pi videos
- [Byte My Pi - Remote Access: Securely connect your devices over the internet with ZeroTier](https://www.youtube.com/watch?v=7C2AGnr9Q-w) 
- [KPeyanski - Raspberry Pi into ZeroTier VPN (How-To)](https://www.youtube.com/watch?v=lFmeF5xoAPI) 
- [Lawrence Systems - How To Access a Raspberry Pi Running Kali Linux Anywhere with ZeroTier](https://www.youtube.com/watch?v=L3KIhZxvQ5A) 
- [Lawrence Systems - How to Use Kali Linux on Raspberry Pi 4 As a Remote Network Access and NMAP Discovery Audit Tool](https://www.youtube.com/watch?v=ksTHrJBihLM) 
- [PcMac - Pihole on Raspberry Pi Docker | Network Wide Ad blocking](https://www.youtube.com/watch?v=HT4Eu57kZt0) 
- [QRQcw - Raspberry PI 4 - ZeroTier Virtual Network - RTSP Server for multiple CW OPs to QSO Morse Code Audio](https://www.youtube.com/watch?v=1aPxmegh6jQ)


## ZeroTier 3-D Printing

#### 3-D Printing articles
- [Ultimate Guide to Octo4a](https://alche.thrideas.com/3d-printing/2021/10/10/ultimate-guide-to-octo4a.html)


## ZeroTier Homelab

#### Homelab articles
- [Remote connecting to my VMware homelab - ZeroTier](https://jgautierit.github.io/post/remote-connecting-to-my-homelab/) 
- [Configure Travel Router to route traffic via ZeroTier](https://harivemula.com/2021/09/18/configure-travel-router-to-route-traffic-via-zerotier/)
- [Routing all traffic through Home with ZeroTier on travel](https://harivemula.com/2021/09/18/routing-all-traffic-through-home-with-zerotier-on-travel/)
- [Switching from KeePass to Bitwarden after 14 years](https://trycatch.dev/blog/switching-from-keepass-to-bitwarden-after-14-years/)
- [ZeroTier in my homelab](https://darkcloud.dk/2020/02/05/ZeroTier-in-the-homelab/)
- [ZeroTier makes Homelab VPN Easy](https://www.danmanners.com/posts/2020-09-zerotier/)


#### Homelab articles global
- [Обзор ZeroTier. VPN и SD-WAN в одном флаконе](https://blog.themarfa.name/obzor-zerotier-vpn-i-sd-wan-v-odnom-flakonie/)


## ZeroTier Home Automation

- [hassio-addons / repository](https://github.com/hassio-addons/repository/blob/master/zerotier/DOCS.md)

#### Home Automation articles
- [Access your Home Assistant from the Internet with the ZeroTier VPN](https://www.gearrice.com/update/access-your-home-assistant-from-the-internet-with-the-zerotier-vpn/)

#### Home Automation videos
- [Franck Nijhof - ZeroTier add-on for Home Assistant](https://www.youtube.com/watch?v=uDIShhlJhqw) 
- [KPeyanski - How to setup ZeroTier network and to add Home Assistant inside?](https://www.youtube.com/watch?v=X47est0lzdg) 
- [Sauber-Lab UK - Let's install ZeroTier in Home Assistant](https://www.youtube.com/watch?v=iubmZ3rXWEU)


## ZeroTier Video/Camera/CCTV

- [Mo3he / ZeroTier ACAP for Axis cameras](https://github.com/Mo3he/Axis_Cam_ZeroTier)

#### Video/Camera/CCTV articles
- [ZeroTier accessing Local LAN through Bridge](https://medium.com/@vssaiarunesh/zerotier-accessing-local-lan-through-bridge-b97c7309215b)

#### Video/Camera/CCTV videos
- [Blue Iris Secure Remote Access Using ZeroTier](https://www.youtube.com/watch?v=dmqrK2Fomqw&t)
- [Blue Iris Remote Access - Port Forwarding vs. VPN](https://www.youtube.com/watch?v=viLwbbX2oJQ)

#### Video/Camera/CCTV videos global
- [DANIEL FELIPE ORJUELA FLOREZ - Transmisión de Video IP - Zerotier - VLC](https://www.youtube.com/watch?v=4M-e4GznAw0)
- [Michael Guerra - Utilizando Celular como cámara a Vmix de forma remota por SRT y ZeroTier](https://www.youtube.com/watch?v=C__ulFyqDUo)


## ZeroTier EVE-NG

#### EVE-NG videos
- [Network Collective - EVE-NG & ZeroTier: Intro](https://www.youtube.com/watch?v=alATWfvyJmE) 
- [Network Collective - Part #3: Use ZeroTier and Connect Directly to Your EVE-NG Labs and Images](https://www.youtube.com/watch?v=PcntWwiSk5Q) 


## ZeroTier Blender

#### Blender articles
- [Blender multi-user instructions](https://multi-user.readthedocs.io/en/latest/tutorials/hosting_guide.html) 

#### Blender videos
- [Activemotionpictures - Blender realtime collaborative environment (Multi-User addon)](https://www.youtube.com/watch?v=xV4R5AukkVw&t=759s) 


## ZeroTier Oculus

#### Oculus videos
- [Steam VR on Oculus Quest (2) Anywhere (No Port Forwarding) | Virtual Desktop + Zero Tier VR Tutorial](https://www.youtube.com/watch?v=W8Id61IyBGk) 


## ZeroTier Gaming

- [moonlight-stream / moonlight-docs](https://github.com/moonlight-stream/moonlight-docs/wiki/Setup-Guide) 
- [ecalder6 / azure-gaming](https://github.com/ecalder6/azure-gaming)
- [alvr-org / ALVR](https://github.com/alvr-org/ALVR/wiki/ALVR-client-and-server-on-separate-networks)
- [diasurgical / devilutionX](https://github.com/diasurgical/devilutionX)
- [gcloudrig / gcloudrig](https://github.com/gcloudrig/gcloudrig)

#### Gaming articles
- [How to get the most out of The Logitech G Cloud](https://medium.com/@quiethours/how-to-get-the-most-out-of-the-logitech-g-cloud-2e91be871eeb)
- [DIY Cloud Gaming with Sunshine: How to setup and use Sunshine GameStream](https://www.jilaxzone.com/2021/09/01/diy-cloud-gaming-with-sunshine-how-to-setup-and-use-sunshine-gamestream-over-the-internet-to-play-pc-games-emulators-anywhere-on-android-and-ios/)
- [FnafDoomMod2Wiki - Multiplayer Tutorial - ZerotierOne Tutorial](https://fnaf-doom-mod-2.fandom.com/wiki/Multiplayer_Tutorial#ZerotierOne_Tutorial)

#### Gaming published research
- [End-to-end Characterization of Game Streaming Applications on Mobile Platforms](https://dl.acm.org/doi/pdf/10.1145/3508030)

#### Gaming videos
- [Arkham Knight - ZeroTier LAN Coop gaming (Tunngle Alternative,Peer to Peer Network ) 2020 multiplayer gaming](https://www.youtube.com/watch?v=WIxpVHf4ic8) 
- [Bivens PC - How To Create A VPN Tunnel With ZeroTier For Gaming](https://www.youtube.com/watch?v=KEGQaMrjwVQ) 
- [Lord Gwydion - Running a Fantasy Grounds Game using ZeroTier](https://www.youtube.com/watch?v=Os1jjbQAFao) 
- [Mr. Horseman Gaming - PPSSPP 1.11.3 Online Settings with ZeroTier](https://www.youtube.com/watch?v=RKpkm6MjyJA) 
- [Mr. Horseman Gaming - PPSSPP Online for PC & Android (with ZeroTier)](https://www.youtube.com/watch?v=I4AXYZAuV-A) 
- [TECHY DOOD - Host Minecraft 1.14.4 or 1.15 LAN Server and play with your friends up to 100 - No Hamachi (2020)](https://www.youtube.com/watch?v=oTlxwg3atBc) 


## ZeroTier Blockchain/Crypto

- [transumption / holo-router](https://github.com/transumption/holo-router)
- [oxheadalpha / tezos-k8s](https://github.com/oxheadalpha/tezos-k8s)

#### Blockchain/Crypto articles
- [bitcoin-tutorials Set up the RaspiBlitz for remote connections with ZeroTier](https://openoms.github.io/bitcoin-tutorials/zerotier/)
- [NODL - Connect remotely using ZeroTier](https://docs.nodl.it/guides/zerotier.html)
- [HOW TO INSTALL CARDANO STAKING POOL ON A PI 4B](https://www.drokdev.pro/blog/how-to-install-cardano-staking-pool-on-a-pi-4b/)
- [HOWTO Remote plotting and farming over the internet, Ubuntu edition](https://chiaforum.com/t/howto-remote-plotting-and-farming-over-the-internet-ubuntu-edition/11507)
- [Spinning up a Tezos blockchain with Kubernetes (k8s)](https://medium.com/tqtezos/spinning-up-a-tezos-blockchain-with-kubernetes-k8s-7107e2a257a0)
- [Certifying battery usage for Vehicle-to-Grid and second life with a blockchain-based framework](https://www.sciencedirect.com/science/article/pii/S1389128623000038?via%3Dihub)

#### Blockchain/Crypto videos
- [Node Box Guide 12 - ZeroTier](https://www.youtube.com/watch?v=oM0HvY_x_Hc)


## ZeroTier Everything Else

- [airman604 / discord-zerotier-bot](https://github.com/airman604/discord-zerotier-bot)
- [leonardodino / wc3proxy](https://github.com/leonardodino/wc3proxy)

#### Everything Else articles
- [Self built moon root server of zerotier for Linux / VPS](https://cdmana.com/2021/10/20211020200010977x.html)
- [Astrophotography - Starkeeper](https://forum.starkeeper.it/t/daily-build-voyager-2-3-4j-version-ready/3315/37)


## ZeroTier Reddit
- [r/zerotier](https://www.reddit.com/r/zerotier/)


## ZeroTier YouTube
- [ZeroTierOffficial YouTube Channel](https://www.youtube.com/ZeroTierOfficial)
- [Most Recent Community-Created ZeroTier Videos](https://www.youtube.com/results?search_query=zerotier&sp=CAI%253D)





