<!-- readme.md v0.9.99.0
ZPE Propulsion (ZPEP)
created: 23 Dec 2015
updated: 17 Jul 2023

TEMPLATE: readme.md v1.7.5.0
created: 17 Aug 2016
updated: 11 Jun 2023

THIS FILE: CC BY-ND 4.0 by zer0Kerbal -->
<small><i> — post will self update; latest readme always on GitHub. most images are links —</i></small>

# [ZPE Propulsion (ZPEP)][CURSFG:url]

[![ZPE Propulsion (ZPEP)][SHD:mod]][CURSFG:url]  
[![KSP version][KSP:shd]][KSP:url] [![License][LIC:shd]][LIC:url]  
[![Curseforge][CURSFG:shd]][CURSFG:url] [![GitHub][GITHUB:shd]][GITHUB:url] [![Pages][SHD:pgs]][pages]

This is standalone expansion to my Rusty Star Rockets mod. It adds eleven (11) parts for new propulsion system: ZPE (Zero Point Energy) all with Rusty Star Shipyard aesthetics. It also adds new fuel resource: Quantum Fluctuations. For Kerbal Space Program.

## By [`zer0Kerbal`][zedK], originally by [`GagaX`][auth-link]

adopted with *express* permission and brought to you by *KerbSimpleCo*

<img src="https://raw.githubusercontent.com/zer0Kerbal/ZPEPropulsion/master/img/HeroLogo.png" alt="ZPE Propulsion (ZPEP) Hero" width="50%" height="50%">

### Preamble by [`GagaX`][auth-link]

> This is standalone expansion to my Rusty Star Rockets mod. It adds parts for new propulsion system: ZPE (Zero Point Energy) propulsion system
>
> It also adds new fuel resource: Quantum Fluctuations.
>
> ZPE propulsion system works like this:
>
> 1. Quantum Fluctuations are generated in Quantum Fluctuations Extractor (QFE)
> 2. Quantum Fluctuations are stored in Uncertainty Containment Chamber (UCC)
> 3. ZPE engine uses Quantum Fluctuations and electricity to create thrust.
>
> Since Quantum fluctuations are generated constantly by QFE, this is sort of infinite fuel mod, but it is somewhat justified by ZPE propulsion concept. Nevertheless, i wouldn't dare call this mod near future or even very realistic.
>
> But it could be fun. :) Especially because of funky particle effects and custom engine sounds.
>
> All parts are on the very top of tech tree, on additional experimental nodes, and are VERY expensive.

### See More

>* the latest version of this readme is always found on [GitHub][GITHUB:url]
>* [Mod Listing (WIP)][mlist] for a list of addons by [zer0Kerbal][zedK]
>* [ChangeLog][chlog] for more details of changes
>* [Discussions][discu] or [forums][forum] for discussions and news
>* [GitHub Pages][pages]
>* [Known Issues][issue] for more details of feature requests and known issues
>* [Marketing Slicks][markt]
>* [Parts Catalog][parts] for pretty part pictures

### <img src="https://cdn.pixabay.com/photo/2014/05/14/14/17/youtube-344106_960_720.png" alt="Youtube logo" height="33px" width="66px">

>Review by [`Kottabos Gaming`](https://forum.kerbalspaceprogram.com/index.php?/profile/36583-*/)
>
>[![KSP Mods - ZPE Propulsion System](https://img.youtube.com/vi/_JNYDX7tSBE/0.jpg)](https://www.youtube.com/watch?v=_JNYDX7tSBE)

### Localization

>* ![English](https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/zed'K/img/EN.png) English
>* ***your translation here***

### Help Wanted

> * Compatibility patches
> * Contracts for these glorious parts: '_Letters of Marque_'
> * Sample crafts/subassemblies
> * Variant textures and model updates (add/improve: lights, iva, hatches et al)
> * Model updates (add/improve lights, iva, hatches and so forth)
> * Marketing Images and Videos such as hero shots, animated gifs, short highlights
> * Translations: See the [README's in the Localization folder](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/readme.md) for instructions for adding or improving translations. There is also the [quick start guide(s)](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/quickstart.md). [GitHub][GitHub:url] push is the best way to contribute. *Additions and corrections welcome!*
> * Have a request? Glad to have them, kindly submit through [GitHub][issue].

### Installation Directions

Most recent releases only available via CurseForge/OverWolf Website/App

<a href="https://download.curseforge.com/"><img src="https://www.overwolf.com/brand-guidelines/img/logo2.svg" alt="CurseForge/OverWolf App" height="100px"></a>

### Dependencies

* 📌 Pinned
  * Dependencies:
    * [Rusty Star Shipyards (RSS)](https://curseforge.com/kerbal/ksp-mods/RustyStarShipyards)<small><i>agent, flags, common files</i></small>
    * [Kerbal Space Program][KSP:url] [![Kerbal Space Program][KSP:shd]][KSP:url]

#### Recommends  

* by [Rusty Star Shipyards (RSS)](https://curseforge.com/kerbal/ksp-mods/RustyStarShipyards)
  * [Rusty Star Rockets (RSR)](https://curseforge.com/kerbal/ksp-mods/RustyStarRockets)
  * [Pirates of the Keribbean (PoK)](https://curseforge.com/kerbal/ksp-mods/ZPEPropulsion)
  * [Rusty Textures for Procedural Parts (RTP)](https://curseforge.com/kerbal/ksp-mods/RustyTexturesforProceduralParts)
  * [ZPE Propulsion System (ZPE)](https://curseforge.com/kerbal/ksp-mods/ZPEPropulsionSystem)
  * [Rusty Panels (RP)](https://curseforge.com/kerbal/ksp-mods/RustyPanels) by [Sooner266](https://forum.kerbalspaceprogram.com/index.php?/profile/107575-*/)

#### Suggests

* [list][mlist] of other addons by [zer0Kerbal][zedK]

* [Adjustable Mod Panel (KAMP)](https://curseforge.com/kerbal/ksp-mods/AdjustableModPanel)
* [DRELite (DREL)](https://www.curseforge.com/kerbal/ksp-mods/drelite) <small><i>Start the game. Watch the fiery death.</i></small>
* [Exception Detector (EXCD)](https://curseforge.com/kerbal/ksp-mods/ExceptionDetector)
* [Gimbal Trim (TRIM)](https://curseforge.com/kerbal/ksp-mods/GimbalTrim)
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)](https://curseforge.com/kerbal/ksp-mods/GPOSpeedPump)
* [Kaboom! (BOOM)](https://curseforge.com/kerbal/ksp-mods/Kaboom)
* [On Demand Fuel Cells (ODFC)](https://curseforge.com/kerbal/ksp-mods/OnDemandFuelCells)
* [Precise Maneuver (PM)](https://curseforge.com/kerbal/ksp-mods/PreciseManeuver)
* [SimpleLogistics! (SLOG)](https://curseforge.com/kerbal/ksp-mods/SimpleLogistics)
* [SimpleNotes! (NOTE)](https://curseforge.com/kerbal/ksp-mods/Notes)

#### Supports

<!-- * Fuel Switchers: -->
  <!-- * [B9 Part Switch](https://forum.kerbalspaceprogram.com/topic/140541-*/) -->
  <!-- * [FireSpitter Core](https://legacy.curseforge.com/kerbal/ksp-mods/firespitter) -->
  <!-- * [Interstellar Fuel Switch Core](https://legacy.curseforge.com/kerbal/ksp-mods/interstellar-fuel-switch) -->
  <!-- * [Modular Fuel Tanks](http://forum.kerbalspaceprogram.com/index.php?/topic/58235-*/) -->
  <!-- * [SimpleFuelSwitch](https://forum.kerbalspaceprogram.com/topic/181274-*/) -->
<!-- * Life Support -->
  <!-- * [ECLSS](https://forum.kerbalspaceprogram.com/index.php?/topic/84197-*/) -->
  <!-- * [Kerbalism (kerb)](https://forum.kerbalspaceprogram.com/index.php?/topic/190382-*/) -->
  <!-- * [Snacks](https://forum.kerbalspaceprogram.com/index.php?/topic/149604-*/) -->
  <!-- * [TAC Life Support (TAC-LS)](https://forum.kerbalspaceprogram.com/index.php?/topic/146465-*/) -->
  <!-- * [USI Life Support (USI-LS)](https://forum.kerbalspaceprogram.com/index.php?/topic/105202-*/) -->

### Tags

parts, config, science

<div style="border:0.5px solid Tomato; background-color: #BADA55; color: #FF0000; text-align:center">
  <p><b>red box below is a link to forum post on how to get support</b></p>
  <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*">
    <p><img src="https://i.postimg.cc/vHP6zmrw/image.png" alt="How to get support"></p></a>
  <p style="color: #000000;">Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date</p>
</div>

### Credits and Special Thanks

* [`GagaX`][auth-link] for creating this glorious parts addon!
* see [Attribution.md][attrb] for more

### Legal Mumbo Jumbo (License *provenance*)

#### Author (1) - [`zer0Kerbal`][zedK]

> Forum: [Thread][forum] - Source: [GitHub][GITHUB:url] - Download: [CurseForge][CURSFG:url]  
> License: [![License][LIC:shd]][LIC:url] ![License][LIC:log]

#### Original (ROOT) (0) - Author: [`GagaX`][auth-link]

> Forum: [Thread][0:thr] - Download: [SpaceDock][0:dwn] - Source: [SpaceDock][0:src]  
> License: [![License][0:shd]][0:url] ![License][0:log]

#### Disclaimer(s)
>
>* ***All bundled mods are distributed under their own licenses***  
>* ***All assets, including but not limited to: animations, models, sounds and textures are distributed under their own licenses. [![License][LIC:sp:shd]][LIC:sp:url]***
>
>* see [Notices][notic] for more *legal Mumbo Jumbo*

### How to support this and other great mods by [`zer0Kerbal`][zedk]

Comment, click, like, share, up-vote, subscribe

> ***Completely voluntary, absolutely amazing, and really does help out a lot!***  
> *and it is true.*

[![Support][PAYPAL:img]][PAYPAL:url] [![Patreon][PATREON:img]][PATREON:url]

<!-- links -->
[attrb]: https://zer0kerbal.github.io/ZPEPropulsion/Attributions "Attribution"
[chlog]: https://raw.githubusercontent.com/zer0Kerbal/ZPEPropulsion/master/changelog.md  "Changelog"
[discu]: https://github.com/zer0Kerbal/ZPEPropulsion/discussions "Discussions"
[forum]: https://forum.kerbalspaceprogram.com/topic/218476-*/ "ZPE Propulsion (ZPEP)"
[issue]: https://github.com/zer0Kerbal/ZPEPropulsion/issues "Issues"
[markt]: https://zer0kerbal.github.io/ZPEPropulsion/Marketing "Marketing Slicks"
[mlist]: https://zer0kerbal.github.io/zer0Kerbal/AddonListing.html "zer0Kerbal mod list"
[notic]: https://zer0kerbal.github.io/ZPEPropulsion/Notices "Notices"
[pages]: https://zer0kerbal.github.io/ZPEPropulsion "GitHub Pages"
[parts]: https://zer0kerbal.github.io/ZPEPropulsion/PartsCatalog "Parts Catalog"

<!--- shields -->
[SHD:mod]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/ZPEPropulsion/master/json/mod.json
[SHD:pgs]: https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "GitHub IO"

<!--- mod and license provenance -->
[0:dwn]: https://spacedock.info/mod/270 "SpaceDock"
[0:src]: https://spacedock.info/mod/270 "SpaceDock"
[0:thr]: https://forum.kerbalspaceprogram.com/index.php?/topic/128502-*/ "KSP Forum"

[0:log]: https://licensebuttons.net/i/l/by-nc-nd/transparent/33/66/99/76x22.png "CC BY-NC-ND 4.0"
[0:shd]: https://img.shields.io/badge/License-CC%20BY--NC--ND%204.0-ef9421?labelColor=black&style=plastic&logoColor=ef9421&logo=creativecommons "CC BY-NC-ND 4.0"
[0:url]: https://creativecommons.org/licenses/by-nc-nd/4.0/ "CC BY-NC-ND 4.0"

[LIC:url]: https://creativecommons.org/licenses/by-nd/4.0/ "CC BY-ND 4.0+ARR"
[LIC:log]: https://licensebuttons.net/i/l/by-nd/transparent/33/66/99/76x22.png "CC BY-ND 4.0+ARR"
[LIC:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/ZPEPropulsion/master/json/license.json "CC BY-ND 4.0+ARR"

[LIC:sp:url]: https://en.wikipedia.org/wiki/All_rights_reserved "All Rights Reserved"
[LIC:sp:shd]: https://img.shields.io/badge/License-All%20Rights%20Reserved-white?labelColor=black&style=plastic "All Rights Reserved"

<!--- release links -->
[CURSFG:url]: https://www.curseforge.com/kerbal/ksp-mods/ZPEPropulsion "Curseforge"
[CURSFG:shd]: https://img.shields.io/badge/CurseForge-Link-CCFF00.svg?labelColor=6441A4&style=plastic&logo=curseforge "Curseforge"

[GITHUB:url]: https://github.com/zer0Kerbal/ZPEPropulsion/ "GitHub"
[GITHUB:shd]: https://img.shields.io/badge/Github-Link-CCFF00.svg?labelColor=181717&style=plastic&logo=github "GitHub"

<!-- Kerbal Space Program -->
[KSP:url]: https://kerbalspaceprogram.com/ "Kerbal Space Program"
[KSP:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/ZPEPropulsion/master/json/ksp.json "Kerbal Space Program"

<!-- links -->
[auth-link]: https://forum.kerbalspaceprogram.com/index.php?/profile/57813-*/ "GagaX"
[zedK]: https://forum.kerbalspaceprogram.com/index.php?/profile/190933-*/ "zer0Kerbal"

[curseforge]: https://curseforge.com/members/zer0kerbal/projects
[reddit]: https://www.reddit.com/user/zer0Kerbal
[twitch]: https://www.twitch.tv/zer0kerbal
[twitter]: https://twitter.com/zer0Kerbal
[youtube]: https://www.youtube.com/@zer0Kerbal
[steam]: https://steamcommunity.com/id/zeroKerbal
[projects]: https://zer0kerbal.github.io/zer0Kerbal/projects.html

<!-- financial support -->
[PAYPAL:img]: https://img.shields.io/badge/Buy%20me%20some%20-LFO-BADA55?style=for-the-badge&logo=paypal&labelColor=FFDD00/ "PayPal"
[PAYPAL:url]: https://www.paypal.com/donate/?hosted_button_id=DC22YHMEJREKL "PayPal"
[PATREON:img]: https://img.shields.io/badge/Patreon%20-Patreonize-FF424D?style=for-the-badge&logo=patreon/ "Patreon"
[PATREON:url]: https://www.patreon.com/zer0Kerbal/membership "Patreon"

#### Connect with me

Track progress: issues [here][issue] and projects [here](https://github.com/zer0Kerbal/ZPEPropulsion/projects/) along with **[The Short List](https://github.com/users/zer0Kerbal/projects/27)**

[<img align="left" alt="zer0Kerbal | kerbalspaceprogram.com" width="32px" src="https://cdn.icon-icons.com/icons2/1381/PNG/32/kerbalspaceprogram_93898.png" />][zedk] [<img align="left" alt="zer0Kerbal | CurseForge" width="32px" src="https://cdn.jsdelivr.net/npm/simple-icons@v3/icons/curseforge.svg" />][curseforge] [<img align="left" alt="zer0Kerbal | reddit" width="32px" src="https://cdn.icon-icons.com/icons2/1945/PNG/512/iconfinder-reddit-4661631_122483.png" />][reddit] [<img align="left" alt="zer0Kerbal | Patreon" width="32px" src="https://cdn.icon-icons.com/icons2/2429/PNG/512/patreon_logo_icon_147253.png" />][PATREON:url] [<img align="left" alt="zer0Kerbal | YouTube" width="32px" src="https://cdn.icon-icons.com/icons2/836/PNG/512/Youtube_icon-icons.com_66802.png" />][youtube] [<img align="left" alt="zer0Kerbal | Twitch" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/twitch_logo_icon_170383.png" />][twitch] [<img align="left" alt="zer0Kerbal | PayPal" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/paypal_logo_icon_168055.png" />][PAYPAL:url] [<img align="left" alt="zer0Kerbal | steam" width="32px" src="https://icons.iconarchive.com/icons/3xhumed/mega-games-pack-05/48/Steam-icon.png" />][steam] [<img align="left" alt="zer0Kerbal | Twitter" width="32px" src="https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/twitter-32.ico" />][twitter] [<img align="left" alt="zer0Kerbal | project list" width="32px" src="https://www.pngall.com/wp-content/uploads/5/Vector-Checklist-PNG-HD-Image-180x180.png" />][projects]</br>