# Mk2Y -  Two Kerbal Command Pod
### formerly Yarbrough08's Mk. 1-1 A2 Two Kerbal Command Pod
![Mk2Y Version](https://img.shields.io/github/v/release/zer0Kerbal/Mk2Y?include_prereleases?style=plastic)
![KSP version](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/DuoPods/master/json/ksp.json?style=plastic) ![KSP-AVC](https://img.shields.io/badge/KSP-AVC--supported-brightgreen.svg?style=plastic) ![License CC BY-NC-SA 4.0](https://img.shields.io/badge/license-CC%20BY--NC--SA%204.0-lightgrey?style=plastic)  
![Spacedock](https://img.shields.io/badge/SpaceDock-listed-blue.svg?style=plastic) ![CKAN](https://img.shields.io/badge/CKAN-Indexed-blue.svg?style=plastic) ![Github](https://img.shields.io/badge/Github-Indexed-blue.svg?style=plastic) ![Curseforge](https://img.shields.io/badge/CurseForge-listed-blue.svg?style=plastic)

> ***A mod that adds three parts - two versions of a two-kerbal pod, and a matching RCS enabled heat shield *** 
## Author
Mk2Y [M2Y] adopts Yarbrough08's Mk. 1-1 A2 Two Kerbal Command Pod for curation by [zer0Kerbal](https://forum.kerbalspaceprogram.com/index.php?/profile/190933-zer0kerbal/)*** Originally created by [Yarbrough08](https://forum.kerbalspaceprogram.com/index.php?/profile/72048-yarbrough08/)

## Description
This is a 2.5m to 1.25m, 2-kerbal, command module. Yarbrough08 used the dimensions of kerbals to determine this size. The 3-kerbal Mk 1-2 pod crams too many kerbals in, and doesn't leave room for them to move around or even exit. It will be compensated for in a mass reduction, as not as much(insert your ideals of life support or equipment) is needed to contain 2 vs 3 kerbals. This comes with a dedicated IVA.

- ***Mk2Y-036*** is the 0.0.3.6 version which has integrated heat shield
- ***Mk2Y-040*** is the 0.0.4.0 version which does NOT have integrated heat shield
- ***Mk2Y-040-HS*** is RCS inabled heat shield for the M2Y-040 2 Kerbal Command Pod

[Yarbrough08] became interested in modeling a 2 person CP that was not historic in nature. I am looking for feedback at the moment, as well as interest in the project. So, with that being said...


RCS ports are working, as well as a very basic IVA implementation. Windows are zoomable, airlock/ladder functions, and compatibility with DRE and RF (RCS Ports). Has (at the moment) an almost non-existent Texture footprint in RAM because of placeholder textures.

Includes a shroud to smooth transition to decouplers, which are still needed.

IVA layout changed (Stock Props Complete). I used at least one of each of the stock props.

Added lights to the IVA

Interior model touch up and UV'd. Ready for when I produce textures.

Airlock wall, hatch, and cover added

Of course this is a WIP and nowhere near finished. Although it looks pretty good, I have not finished creating proper textures for it.



Mk. 1-1 A2 Two Kerbal Command Pod

This is a 2.5m, 2 Kerbal, command pod. It includes the IVA, as well as, attachable heatshield with RCS ports. The heatshield is equipped with a shroud to smooth the transition to whatever 2.5m part you choose to place under it. Although the current version is a WIP, most of the pod is complete (todo: some visual and minor .cfg tweaking). The RCS ports do work, as does the heatshield (stock ablative protection). On the IVA side I have working stock props, IVA lights, front and side windows that are 'clickable', and a front window docking guide ('iron sights').

NOTE: TEXTURES ARE separate NOW! YOU WILL NEED TO DOWNLOAD A TEXTURE PACK! PICK ONLY ONE!

I created high, medium, and low textures (both diffuse and normal map) for the pod exterior shell. I also am giving an ultra low choice that will make the pod appear as it was before - no detail.

<del>AGAIN, THE TEXTURES ARE NOT INCLUDED IN THE POD DOWNLOAD.</del>
![](https://raw.githubusercontent.com/zer0Kerbal/Mk2Y/master/img/Mk._1-1_A2.png)
![](https://raw.githubusercontent.com/zer0Kerbal/Mk2Y/master/img/QyYzqbX.jpg)
![](https://raw.githubusercontent.com/zer0Kerbal/Mk2Y/master/img/YajsY8D.png)

I have uploaded and linked several texture packs for the pod. These packs contain the textures for the exterior (previously white) "shell," as well as the interior and exterior windows. The packs are divided up based off of the exterior shell texture size, and include:

(Note: Main Textures are the exterior shell's diffuse and normal map. -Size listed is for each texture)

![Texture Pack 4096](http://spacedock.info/mod/419)
    Main textures = 4096x4096
    Window textures = 512x512

![Texture Pack 2048](http://spacedock.info/mod/420)
    Main textures = 2048x2048
    Window textures = 512x512

![Texture Pack 1024](http://spacedock.info/mod/421)
    Main textures = 1024x1024
    Window textures = 512x512

![Low Quality Texture Pack (The Original Textures)](http://spacedock.info/mod/422)
    Main textures = 4x4
    Window textures = 4x4

### Cabin Sticky Notes:
> #### NOTE: Might be issues with hatch and currently the pod doesn't have lights.
> #### *There are no plans to improve them unless someone submits new ones via PR on github.*

### Installation Directions 
- Use CKAN (best way)
**— or —**
- Before installation please delete Yarbrough/Mk2Y/ folder in KSP/Gamedata/. 
- Then copy .zip content into your GameData folder.

### Changelog Summary
*See [ChangeLog](https://github.com/zer0Kerbal/M2Y/blob/master/Changelog.cfg) for full details of mod changes*
<hr>

### Requires 
- [Kerbal Space Program](https://kerbalspaceprogram.com)

### Supports
- [Kerbal Change Log](https://forum.kerbalspaceprogram.com/index.php?/topic/179207-*)
- [Module Manager](https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*)

### Replaces
- [Mk1-1A2](https://github.com/KSP-CKAN/NetKAN/blob/4c4e8a71d90a0cf37dae140d506b2a923384ce72/NetKAN/Mk1-1A2.frozen)
<hr>

<a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*" target="_blank"><img src="https://i.imgur.com/YdYfStN.jpg"/></a>

### Original
Author: Yarbrough08  
Mod Website: [Forum Thread](http://forum.kerbalspaceprogram.com/index.php?/topic/88604-*)
For now, license is: ![CC BY-NC-SA-4.0](https://licensebuttons.net/l/by-nc-sa/4.0/80x15.png)
![CC BY-NC-SA-4.0](https://img.shields.io/badge/license-CC--BY--NC--SA--4.0-lightgrey)

### Legal Mumbo Jumbo
Source: [GitHub](https://github.com/zer0Kerbal/Mk2Y)
License: [CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/) ![CC BY-NC-SA 4.0](https://licensebuttons.net/i/l/by-nc-sa/transparent/33/66/99/88x31.png "CC BY-NC-SA 4.0")<br>

Mk2Y is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International license, which in layman's terms means:
> * You are permitted to use, copy and redistribute my work as-is.
> * You may remix your own derivatives (new models, alternative textures, etc.) and release them under your own name.
> * You may not use the material for any commercial purposes.
> * You must use the same license as the original work.
> * You must credit the following people when publishing your derivative: riocrokite (Stork Delivery System).

- ***All bundled mods are distributed under their own licenses***<br>
- ***All art assets (textures, models, animations) are distributed under their own licenses***  

<a href="https://github.com/zer0Kerbal/Mk2Y/releases/latest" target="_blank"><img src="https://i.imgur.com/RE4Ppr9.png"/></a>
<a href="https://spacedock.info/mod/2358" target="_blank"><img src="https://i.imgur.com/m0a7tn2.png"/></a>
<a href="https://www.curseforge.com/kerbal/ksp-mods/mk2y" target="_blank"><img src="https://i.postimg.cc/RZNyB5vP/Download-On-Curse.png"/></a>  
###### v0.0.5.0 original: 17 Jul 2018 zed'K | updated: 2020 03 02 zed'K
<!--
CC BY-NC-SA-4.0
zer0Kerbal-->

