<!-- readme.md v2.0.99.5
Fuel Tanks Plus (FTP)
created: 01 Sep 2022
updated: 04 Jul 2023

TEMPLATE: readme.md v1.7.4.2
created: 17 Jul 2017
updated: 18 Jun 2023

THIS FILE: CC BY-ND 4.0 by zer0Kerbal -->
# [Fuel Tanks Plus (FTP)][CURSFG:url]

[![Fuel Tanks Plus (FTP)][SHD:mod]][CURSFG:url]  
[![KSP version][KSP:shd]][KSP:url] [![License][LIC:shd]][LIC:url]  
[![Curseforge][CURSFG:shd]][CURSFG:url] [![GitHub][GITHUB:shd]][GITHUB:url] [![Pages][SHD:pgs]][pages]

A set of fuel tanks that are longer than largest stock tanks in each diameter, plus fuel-filled nose cones for those diameters. These are meant to give you some visual choice of styles that are loosely inspired by real-world rockets from NASA, ESA, and private space firms (though that inspiration is mainly in color choice), while maintaining the style established in the Color Coded Canisters mod.

48 parts

## By [`zer0Kerbal`][zedK], originally by [`NecroBones`][necrobones]

adopted with *express* permission and brought to you by *KerbSimpleCo*

<img src="https://raw.githubusercontent.com/zer0Kerbal/FuelTanksPlus/master/img/HeroLogo.png" alt="Fuel Tanks Plus (FTP)" width="50%" height="50%">

### Preamble by [NecroBones][necrobones]

> What is "Fuel Tanks Plus" exactly? Simply, it's a set of fuel tanks that are 1.5x the length of the largest stock tanks in each diameter, plus fuel-filled nose cones for those diameters.
>
> These tanks are meant to give you some visual choice of styles that are loosely inspired by real-world rockets from NASA, ESA, and private space firms (though that inspiration is mainly in color choice), while maintaining the style established in the Color Coded Canisters mod (since CCC replaces stock visuals, any "new" tanks should be spun off into a separate pack, and hence we have FTP).
>
> Design Goals
>
>* Provide some new visual styles, to dress up the booster sections of your rockets.
>* Help mildly reduce part count and wobble, by providing larger tanks.
>* Be as memory efficient as possible. Each diameter has a shared texture to keep memory usage low.
>* Follow the same colors and artistic style established in Color Coded Canisters.

### See more

>* [ChangeLog][chlog] for more details of changes
>* [Discussions][discu] or [forums][forum] for discussions and news
>* [GitHub Pages][pages]
>* [Known Issues][issue] for more details of feature requests and known issues
>* [Marketing Slicks][markt]
>* [Parts Catalog][parts] for part pictures

### <img src="https://cdn.pixabay.com/photo/2014/05/14/14/17/youtube-344106_960_720.png" alt="Youtube logo" height="33px" width="66px">

>KSP FuelTanksPlus 1.0 Overhaul by [NecroBones][necrobones]
>
[![KSP FuelTanksPlus 1.0 Overhaul](https://img.youtube.com/vi/wuxzfhtiCgI/0.jpg)](https://www.youtube.com/watch?v=wuxzfhtiCgI)

>Review by [`Kottabos Gaming`](https://forum.kerbalspaceprogram.com/index.php?/profile/36583-*/)
>
[![Kottabos reviews Fuel Tanks Plus](https://img.youtube.com/vi/bWo2u1lKdaY/0.jpg)](https://www.youtube.com/watch?v=bWo2u1lKdaY)

### Localization

>* ![English](https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/zed'K/img/EN.png) English
>* ![Italiano](https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/zed'K/img/IT.png) Italian (Italiano) - grazie [MattNot](https://github.com/MattNot)
>* ![Russian (Русский)](https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/RU.png) Russian (Русский) - спасибо [evanisrael](https://github.com/evanisrael)
>* ***your translation here***

### Help Wanted

> * Compatibility patches
> * Contracts for these glorious parts
> * Sample crafts/subassemblies
> * Variant textures and model updates (add/improve: lights, iva, hatches et al)
> * Marketing Images and Videos such as hero shots, animated gifs, short highlights
> * Translations: See the [README's in the Localization folder](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/readme.md) for instructions for adding or improving translations. There is also the [quick start guide(s)](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/quickstart.md). [GitHub][GitHub:url] push is the best way to contribute. *Additions and corrections welcome!*
> * Have a request? Glad to have them, kindly submit through [GitHub][issue].

### Installation Directions

Most recent releases only available via CurseForge/OverWolf Website/App

<a href="https://download.curseforge.com/"><img src="https://www.overwolf.com/brand-guidelines/img/logo2.svg" alt="CurseForge/OverWolf App" height="100px"></a>

### Dependencies

* 📌 Pinned
  * Dependencies:
    * [Fuel Tanks Plus Ltd (FTPL)](https://curseforge.com/kerbal/ksp-mods/FTPLtd) <small><i>(required for the models and textures)</i></small>
    * [Kerbal Space Program][KSP:url] [![Kerbal Space Program][KSP:shd]][KSP:url]

### Recommends

* The collection of [Fuel Tanks Plus Ltd (FTPL)](https://curseforge.com/kerbal/ksp-mods/FTPLtd) large stock-like tanks with Color Coded Canister style:
  * [Fuel Tanks Plus (FTP)](https://curseforge.com/kerbal/ksp-mods/FuelTanksPlus)
  * [Fuel Tanks Plus Xtra Kerbal (FTPXK)](https://curseforge.com/kerbal/ksp-mods/FTPXK)
  * [Fuel Tanks Plus IS (FTPIS)](https://curseforge.com/kerbal/ksp-mods/FTPIS)
* [NecroBones](https://forum.kerbalspaceprogram.com/index.php?/profile/105424-*/) suite of mods that play nicely together
  * [Lithobrake Exploration Technologies (LET)](https://curseforge.com/kerbal/ksp-mods/LithobrakeExplorationTechnologies) lander parts, large chutes/legs/ladders/etc
  * [SpaceY Corporation (SYC)](https://curseforge.com/kerbal/ksp-mods/SpaceYCorp)
    * [SpaceY Lifters (SYL)](https://curseforge.com/kerbal/ksp-mods/SpaceYLifters) stock-balanced large rocket parts, 5m parts, large SRBs
    * [SpaceY Expanded (SYX)](https://curseforge.com/kerbal/ksp-mods/SpaceYExpanded)
  * [Color Coded Canisters (CCC)](https://curseforge.com/kerbal/ksp-mods/ColorCodedCanisters) beautification replacement models/textures for stock tanks, with color-coded end caps, and auto-closing shrouds
  * [ColorFuel Lines (CFL)](https://curseforge.com/kerbal/ksp-mods/ColorfulFuelLines) color-selectable fuel lines
  * [Joolian Discovery (JOOL)](https://curseforge.com/kerbal/ksp-mods/JoolianDiscovery)
  * [Modular Rocket Systems (MRS)](https://curseforge.com/kerbal/ksp-mods/ModularRocketSystems) stock-alike parts pack, NASA-like alternatives, and filling the gaps
  * [Modular Rocket Systems LITE (MRSL)](https://curseforge.com/kerbal/ksp-mods/ModularRocketSystemsLite)
  * [SeaDragon (SEA)](https://curseforge.com/kerbal/ksp-mods/SeaDragon)
  * [The Burger Mod (BURG)](https://curseforge.com/kerbal/ksp-mods/BurgerMod)
  * [The Elephant Engine (ELEP)](https://curseforge.com/kerbal/ksp-mods/ElephantEngine)

### Suggests

* [Adjustable Mod Panel (KAMP)](https://curseforge.com/kerbal/ksp-mods/AdjustableModPanel)
* [Behemoth Aerospace Engineering (BAE)](https://curseforge.com/kerbal/ksp-mods/BehemothAerospaceEngineerings)
* [Biomatic (BIO)](https://curseforge.com/kerbal/ksp-mods/Biomatic)
* [DRELite (DREL)](https://www.curseforge.com/kerbal/ksp-mods/drelite) <small><i>Start the game. Watch the firey death.</i></small>
* [Exception Detector (EXCD)](https://curseforge.com/kerbal/ksp-mods/ExceptionDetector)
* [Field Training Facility (FTF)](https://curseforge.com/kerbal/ksp-mods/FieldTrainingFacility)
* [Field Training Lab (FTL)](https://curseforge.com/kerbal/ksp-mods/FieldTrainingLab)
* [Gimbal Trim (TRIM)](https://curseforge.com/kerbal/ksp-mods/GimbalTrim)
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)](https://curseforge.com/kerbal/ksp-mods/GPOSpeedPump)
* [Kaboom! (BOOM)](https://curseforge.com/kerbal/ksp-mods/Kaboom)
* [MoarKerbals (MOAR)](https://curseforge.com/kerbal/ksp-mods/MoarKerbals)
* [Near Future Rovers (NFR)](https://curseforge.com/kerbal/ksp-mods/NearFutureRovers)
* [OhScrap! (OHS)](https://curseforge.com/kerbal/ksp-mods/OhScrap)
* [On Demand Fuel Cells (ODFC)](https://curseforge.com/kerbal/ksp-mods/OnDemandFuelCells)
* [Precise Maneuver (PM)](https://curseforge.com/kerbal/ksp-mods/PreciseManeuver)
* [ScrapYard (SCRAP)](https://curseforge.com/kerbal/ksp-mods/ScrapYard)
* [SimpleConstruction! (SCON)](https://curseforge.com/kerbal/ksp-mods/SimpleConstruction)
  * [Keridian Dynamics Vessel Assembly (KDVA)](https://curseforge.com/kerbal/ksp-mods/KeridianDynamics) <i><small>lots of stockalike parts</small></i>
  * [Not So SimpleConstructon! (NSSC)](https://curseforge.com/kerbal/ksp-mods/NotSoSimpleConstructon) <i><small>adds recyling and surveying</small></i>
* [SimpleLogistics! (SLOG)](https://curseforge.com/kerbal/ksp-mods/SimpleLogistics)
* [SimpleNotes! (NOTE)](https://curseforge.com/kerbal/ksp-mods/Notes)
* [Stack Inline Lights (SIL)](https://curseforge.com/kerbal/ksp-mods/StackInlineLights)
* [Foundations (FND)](https://curseforge.com/kerbal/ksp-mods/Foundations) <small><i>Helps prevent ground constructions from floating away</small></i>
* [Transparent Command Pods (PODS)](https://curseforge.com/kerbal/ksp-mods/TransparentCommandPods)
* Science!
  * [Mini Sample Return Capsule (MSRC)](https://www.curseforge.com/kerbal/ksp-mods/MiniSampleReturnCapsule)
  * [Mkerb Science Instruments](https://curseforge.com/kerbal/ksp-mods/ScienceInstruments)
  * [OScience Laboratories (OSL)](https://curseforge.com/kerbal/ksp-mods/OScienceLaboratories)
  * [Papa Kerballini's Pizza (PIZZA)](https://curseforge.com/kerbal/ksp-mods/Pizza)
  * [Solar Science (SOL)](https://curseforge.com/kerbal/ksp-mods/SolarScience)
* More Tanks
  * [Drop Tanks (DROP)](https://curseforge.com/kerbal/ksp-mods/DropTanks)
  * [Drop Tanks III (DTIII)](https://curseforge.com/kerbal/ksp-mods/DropTanksIII)
  * [DaMichel's SphericalTanks(DST)](https://curseforge.com/kerbal/ksp-mods/)
  * [Mkerb Oxidizer Tanks (MOT)](https://curseforge.com/kerbal/ksp-mods/OxidizerTank)
* [TweakScale (twk)](https://curseforge.com/kerbal/ksp-mods/TweakScale)

### Supports

* [ModularManagement (MM)](https://curseforge.com/kerbal/ksp-mods/ModularManagement) or [Module Manager](https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*/)
* [On Demand Fuel Cells (ODFC)](https://curseforge.com/kerbal/ksp-mods/OnDemandFuelCells)
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)](https://curseforge.com/kerbal/ksp-mods/GPOSpeedPump)
* [DRELite (DREL)](https://www.curseforge.com/kerbal/ksp-mods/drelite) or [Deadly Reentry (dre)](https://forum.kerbalspaceprogram.com/index.php?/topic/50296-*/)
* [Ferram Aerospace Research (far)](https://forum.kerbalspaceprogram.com/index.php?/topic/179445-*/) NEAR-FAR
* [Restock](https://forum.kerbalspaceprogram.com/index.php?/topic/182679-*/)
* [TweakScale (twk)](https://curseforge.com/kerbal/ksp-mods/TweakScale)
* Fuel Switchers:
  * [B9 Part Switch](https://forum.kerbalspaceprogram.com/topic/140541-*/)
  * [FireSpitter Core](https://legacy.curseforge.com/kerbal/ksp-mods/firespitter)
  * [Interstellar Fuel Switch Core](https://legacy.curseforge.com/kerbal/ksp-mods/interstellar-fuel-switch)
  * [Modular Fuel Tanks](http://forum.kerbalspaceprogram.com/index.php?/topic/58235-*/)
  <!-- * [SimpleFuelSwitch](https://forum.kerbalspaceprogram.com/topic/181274-*/) -->

### Tags

parts, resources, variants

<div style="border:0.5px solid Tomato; background-color: #BADA55; color: #FF0000; text-align:center">
  <p><b>red box below is a link to forum post on how to get support</b></p>
  <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*">
    <p><img src="https://i.postimg.cc/vHP6zmrw/image.png" alt="How to get support"></p></a>
  <p style="color: #000000;">Be Kind: Lithobrake, not jakebrake! Keep your ModularManagment up to date</p>
</div>

### Credits and Special Thanks

* [`NecroBones`][necrobones] for creating this glorious mod!
* see [Attribution][attrb] for more

### Legal Mumbo Jumbo (License *provenance*)

#### Author (1) - [`zer0Kerbal`][zedK]

> Forum: [Thread][forum] - Source: [GitHub][GITHUB:url] - Download [CurseForge][CURSFG:url]  
> License: [![License][LIC:shd]][LIC:url] ![License][LIC:log]

#### Original Author (ROOT) (0): [`NecroBones`][necrobones]

> Forum: [Thread][0:thr] - Download: [CurseForge][0:dwn] - Source: [SpaceDock][0:src]  
> License: [![License][0:shd]][0:url] ![License][0:log]

#### Disclaimer(s)
>
>* ***All bundled mods are distributed under their own licenses***  
>* ***All assets, including but not limited to: animations, models, sounds and textures are distributed under their own licenses. [![License][LIC:sp:shd]][LIC:sp:url]***
>
>* see [Notices][notic] for more *legal Mumbo Jumbo*

### How to support this and other great mods by [`zer0Kerbal`][zedK]

Comment, click, like, share, up-vote, subscribe

> ***Completely voluntary, absolutely amazing, and really does help out a lot!***  
> *and it is true.*

[![Support][PAYPAL:img]][PAYPAL:url] [![Patreon][PATREON:img]][PATREON:url]

<!-- links -->
[attrb]: https://zer0kerbal.github.io/FuelTanksPlus/Attributions "Attribution"
[chlog]: https://raw.githubusercontent.com/zer0Kerbal/FuelTanksPlus/master/changelog.md  "Changelog"
[discu]: https://github.com/zer0Kerbal/FuelTanksPlus/discussions "Discussions"
[forum]: https://forum.kerbalspaceprogram.com/index.php?/topic/207702-*/ "Fuel Tanks Plus (FTP)"
[issue]: https://github.com/zer0Kerbal/FuelTanksPlus/issues "Issues"
[markt]: https://zer0kerbal.github.io/FuelTanksPlus/Marketing "Marketing Slicks"
[notic]: https://zer0kerbal.github.io/FuelTanksPlus/Notices "Notices"
[pages]: https://zer0kerbal.github.io/FuelTanksPlus "GitHub Pages"
[parts]: https://zer0kerbal.github.io/FuelTanksPlus/PartsCatalog "Parts Catalog"

<!--- shields -->
[SHD:mod]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/FuelTanksPlus/master/json/mod.json
[SHD:pgs]: https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "GitHub IO"

<!--- mod provenance -->
[0:dwn]: https://www.curseforge.com/kerbal/ksp-mods/fueltanksplus "CurseForge"
[0:src]: https://spacedock.info/mod/92 "SpaceDock"
[0:thr]:https://forum.kerbalspaceprogram.com/index.php?/topic/97541-*/ "KSP Forum"

[0:log]: https://licensebuttons.net/i/l/by-nc-sa/transparent/33/66/99/76x22.png "CC BY-NC-SA 4.0"
[0:shd]: https://img.shields.io/badge/License-CC%20BY--NC--SA%204.0-ef9421?labelColor=black&style=plastic&logoColor=ef9421&logo=creativecommons "CC BY-NC-SA 4.0"
[0:url]: https://creativecommons.org/licenses/by-nc-sa/4.0/ "CC BY-NC-SA 4.0"

[LIC:url]: https://creativecommons.org/licenses/by-nc-sa/4.0/ "CC BY-NC-SA 4.0+ARR"
[LIC:log]: https://licensebuttons.net/i/l/by-nc-sa/transparent/33/66/99/76x22.png "CC BY-NC-SA 4.0+ARR"
[LIC:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/FuelTanksPlus/master/json/license.json "CC BY-NC-SA 4.0+ARR"

[LIC:sp:url]: https://en.wikipedia.org/wiki/All_rights_reserved "All Rights Reserved"
[LIC:sp:shd]: https://img.shields.io/badge/License-All%20Rights%20Reserved-white?labelColor=black&style=plastic "All Rights Reserved"

<!--- release links -->
[CURSFG:url]: https://www.curseforge.com/kerbal/ksp-mods/FuelTanksPlus "Curseforge"
[CURSFG:shd]: https://img.shields.io/badge/CurseForge-Link-CCFF00.svg?labelColor=6441A4&style=plastic&logo=curseforge "Curseforge"

[GITHUB:url]: https://github.com/zer0Kerbal/FuelTanksPlus/ "GitHub"
[GITHUB:shd]: https://img.shields.io/badge/Github-Link-CCFF00.svg?labelColor=181717&style=plastic&logo=github "GitHub"

<!-- Kerbal Space Program -->
[KSP:url]: https://kerbalspaceprogram.com/ "Kerbal Space Program"
[KSP:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/FuelTanksPlus/master/json/ksp.json "Kerbal Space Program"

<!-- links -->
[necrobones]: https://forum.kerbalspaceprogram.com/index.php?/profile/105424-*/ "NecroBones"
[zedK]: https://forum.kerbalspaceprogram.com/index.php?/profile/190933-*/ "zer0Kerbal"

<!-- financial support -->
[PAYPAL:img]: https://img.shields.io/badge/Buy%20me%20some%20-LFO-BADA55?style=for-the-badge&logo=paypal&labelColor=FFDD00/ "PayPal"
[PAYPAL:url]: https://www.paypal.com/donate/?hosted_button_id=DC22YHMEJREKL "PayPal"
[PATREON:img]: https://img.shields.io/badge/Patreon%20-Patreonize-FF424D?style=for-the-badge&logo=patreon/ "Patreon"
[PATREON:url]: https://www.patreon.com/zer0Kerbal/membership "Patreon"

[curseforge]: https://curseforge.com/members/zer0kerbal/projects
[reddit]: https://www.reddit.com/user/zer0Kerbal
[twitch]: https://www.twitch.tv/zer0kerbal
[twitter]: https://twitter.com/zer0Kerbal
[youtube]: https://www.youtube.com/@zer0Kerbal
[steam]: https://steamcommunity.com/id/zeroKerbal
[projects]: https://zer0kerbal.github.io/zer0Kerbal/projects.html

#### Connect with me

Track progress: issues [here][issue] and projects [here](https://github.com/zer0Kerbal/FuelTanksPlus/projects/) along with **[The Short List](https://github.com/users/zer0Kerbal/projects/27)**

[<img align="left" alt="zer0Kerbal | kerbalspaceprogram.com" width="32px" src="https://cdn.icon-icons.com/icons2/1381/PNG/32/kerbalspaceprogram_93898.png" />][zedk] [<img align="left" alt="zer0Kerbal | CurseForge" width="32px" src="https://cdn.jsdelivr.net/npm/simple-icons@v3/icons/curseforge.svg" />][curseforge] [<img align="left" alt="zer0Kerbal | reddit" width="32px" src="https://cdn.icon-icons.com/icons2/1945/PNG/512/iconfinder-reddit-4661631_122483.png" />][reddit] [<img align="left" alt="zer0Kerbal | Patreon" width="32px" src="https://cdn.icon-icons.com/icons2/2429/PNG/512/patreon_logo_icon_147253.png" />][PATREON:url] [<img align="left" alt="zer0Kerbal | YouTube" width="32px" src="https://cdn.icon-icons.com/icons2/836/PNG/512/Youtube_icon-icons.com_66802.png" />][youtube] [<img align="left" alt="zer0Kerbal | Twitch" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/twitch_logo_icon_170383.png" />][twitch] [<img align="left" alt="zer0Kerbal | PayPal" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/paypal_logo_icon_168055.png" />][PAYPAL:url] [<img align="left" alt="zer0Kerbal | steam" width="32px" src="https://icons.iconarchive.com/icons/3xhumed/mega-games-pack-05/48/Steam-icon.png" />][steam] [<img align="left" alt="zer0Kerbal | Twitter" width="32px" src="https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/twitter-32.ico" />][twitter] [<img align="left" alt="zer0Kerbal | project list" width="32px" src="https://www.pngall.com/wp-content/uploads/5/Vector-Checklist-PNG-HD-Image-180x180.png" />][projects]</br>