<!-- readme.md v1.0.2.0
Drop Tanks III (DTIII)
created: 06 Apr 2023
updated: 20 Jun 2023

TEMPLATE: readme.md v1.7.3.2
created: 17 Jul 2017
updated: 25 May 2023

THIS FILE: CC BY-ND 4.0 by zer0Kerbal -->
# [Drop Tanks III (DTIII)][CURSFG:url]

[![Drop Tanks III (DTIII)][SHD:mod]][forum]  
[![KSP version][KSP:shd]][KSP:url] [![License][LIC:shd]][LIC:url]  
[![Curseforge][CURSFG:shd]][CURSFG:url] [![GitHub][GITHUB:shd]][GITHUB:url] [![Pages][SHD:pgs]][pages]

3.75m stockalike curved conformal (wrap-around) DropTanksIII with an integrated decoupler

<img src="https://thumbs.gfycat.com/DefiniteAcclaimedAlpaca-size_restricted.gif" alt="Rotating Nose Cap" width="35%" height="35%">

## By [`zer0Kerbal`][zer0Kerbal], inspired by [`Enceos`][Enceos]

Created by *KerbSimpleCo*

<img src="https://raw.githubusercontent.com/zer0Kerbal/DropTanksIII/master/img/HeroLogo.png" alt="Drop Tanks Hero" width="50%" height="50%">

### Description by [Enceos][Enceos]

> * It's always nice to add some extra fuel without adding much to the size of the spacecraft
> * 4 different length plus cap
> * Aeroynamic nosecap to close the ends or make a boat
> * Very *'fairing friendly'* due to its shape
> * Has a stock crossfeed switcher
> * Integrated decoupler
> * Stockalike texture will blend in with any craft
> * TweakScale support

### See More

>* [Drop Tank Wiki](https://en.wikipedia.org/wiki/Drop_tank)
>* [GitHub Pages][pages]
>* [Marketing Slicks][markt]
>* [Parts Catalog][parts] for part pictures
>* [Discussions][discu] or [forums][forum] for discussions and news
>* [ChangeLog][chlog] for more details of changes
>* [Known Issues][issue] for more details of feature requests and known issues

### Help Wanted

> * Compatibility patches
> * Contracts for these glorious parts
> * More models/textures
> * Marketing Images and Videos such as hero shots, animated gifs, short highlights
> * Translations: See the [README in the Localization folder][lreadme] for instructions for adding or improving translations. There is also the [quickstart guide][qstart]. [GitHub][GitHub:url] push is the best way to contribute. *Additions and corrections welcome!*
> * Have a request? Glad to have them, kindly submit through [GitHub][issue].

### Localization

>* ![English][EN] English
>* ![Dutch][NL] Dutch - thank you to @renejant (*bedankt!*)
>* ***your translation here***

### Installation Directions

Most recent releases only available via CurseForge/OverWolf Website/App

<a href="https://download.curseforge.com/"><img src="https://www.overwolf.com/brand-guidelines/img/logo2.svg" alt="CurseForge/OverWolf App" height="100px"></a>

### Dependencies

* [Kerbal Hacks Ltd (KHL)](https://www.curseforge.com/kerbal/ksp-mods/kerbalhacksltd)
* [Kerbal Space Program][KSP:url] [![Kerbal Space Program][KSP:shd]][KSP:url]

### Recommends

* By [Kerbal Hacks Ltd (KHL)](https://www.curseforge.com/kerbal/ksp-mods/kerbalhacksltd)
  * [Animated Station Screens (ASS)](https://forum.kerbalspaceprogram.com/index.php?/topic/134889-*/)
  * [Asphalt Tiles (AT)](https://forum.kerbalspaceprogram.com/index.php?/topic/134889-*/)
  * [Drop Tanks (DROP)](https://www.curseforge.com/kerbal/ksp-mods/DropTanks)
  * [Drop Tanks III (DTIII)](https://www.curseforge.com/kerbal/ksp-mods/DropTanksIII)
  * [Hazard Tanks Textures (HZT)](https://forum.kerbalspaceprogram.com/index.php?/topic/134889-*/)
  * [KIS Props (KISP)](https://forum.kerbalspaceprogram.com/index.php?/topic/134889-*/)
  * [Large Stock Fairings (LSF)](https://forum.kerbalspaceprogram.com/index.php?/topic/134889-*/)
  * [More Asphalt Tiles (AT)](https://forum.kerbalspaceprogram.com/index.php?/topic/134889-*/)
  * [Portable Science Container (PRC)](https://www.curseforge.com/kerbal/ksp-mods/PortableScienceContainer)
  * [Simple Mission Flags (SMF)](https://www.curseforge.com/kerbal/ksp-mods/SimpleMisisonFlags)
  * [Ven's Style Textures (VST)](https://forum.kerbalspaceprogram.com/index.php?/topic/134889-*/)

### Suggests

* [GPO (Goo Pumps & Oils') Speed Pump (GPO)][GPO]
* [Kaboom! (BOOM)][BOOM]
* [TweakScale (TWK)][twk]

### Supports

* [On Demand Fuel Cells (ODFC)][ODFC]
* [SimpleConstruction! (SCON)][SCON]
* Fuel Switchers
  * [IFS core][ifsc]
  * [FS core][fs]
  * [B9 Part Switcher][b9ps]
  * [Modular Fuel Tanks (mft)][mft]
  * CryoEngines, Stock Fuel Switch, Configurable Containers
* [ModularManagement (MM)][MM] or [Module Manager][omm]

### Tags

parts, resources, combat

<div style="border:0.5px solid Tomato; background-color: #BADA55; color: #FF0000; text-align:center">
  <p><b>red box below is a link to forum post on how to get support</b></p>
  <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*">
    <p><img src="https://i.postimg.cc/vHP6zmrw/image.png" alt="How to get support"></p></a>
  <p style="color: #000000;">Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date</p>
</div>

### Credits and Special Thanks

* [`Enceos`][Enceos] for inspiring this glorious parts addon!
* see [Attribution][attrb] for more

### Legal Mumbo Jumbo (License *provenance*)

#### Original (0) - Author: [`zer0Kerbal`][zer0Kerbal]

> Forum: [Thread][forum] - Source: [GitHub][GITHUB:url]  
> License: [![License][LIC:shd]][LIC:url] ![License][LIC:log]

#### Disclaimer(s)
>
>* ***All bundled mods are distributed under their own licenses***  
>* ***All assets, including but not limited to: animations, models, sounds and textures are distributed under their own licenses. [![License][LIC:sp:shd]][LIC:sp:url]***
>
>* see [Notices][notic] for more *legal Mumbo Jumbo*

### How to support this and other great mods by [`zer0Kerbal`][zer0Kerbal]

Comment, click, like, share, up-vote, subscribe

> ***Completely voluntary, absolutely amazing, and really does help out a lot!***  
> *and it is true.*

[![Support][PAYPAL:img]][PAYPAL:url] [![Patreon][PATREON:img]][PATREON:url]

<!-- links -->
[attrb]: https://zer0kerbal.github.io/DropTanksIII/Attributions "Attribution"
[chlog]: https://raw.githubusercontent.com/zer0Kerbal/DropTanksIII/master/changelog.md  "Changelog"
[discu]: https://github.com/zer0Kerbal/DropTanksIII/discussions "Discussions"
[forum]: https://forum.kerbalspaceprogram.com/index.php?/topic/209332-*/ "DropTanks III (DTIII)"
[issue]: https://github.com/zer0Kerbal/DropTanksIII/issues "Issues"
[markt]: https://zer0kerbal.github.io/DropTanksIII/Marketing "Marketing Slicks"
[notic]: https://zer0kerbal.github.io/DropTanksIII/Notices "Notices"
[pages]: https://zer0kerbal.github.io/DropTanksIII "GitHub Pages"
[parts]: https://zer0kerbal.github.io/DropTanksIII/PartsCatalog "Parts Catalog"

<!-- shields -->
[SHD:mod]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/DropTanksIII/master/json/mod.json
[SHD:pgs]: https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "GitHub IO"

<!-- provenance -->
[LIC:url]: https://creativecommons.org/licenses/by-sa/4.0/ "CC BY-SA 4.0"
[LIC:log]: https://licensebuttons.net/i/l/by-sa/transparent/33/66/99/76x22.png "CC BY-SA 4.0"
[LIC:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/DropTanksIII/master/json/license.json "CC BY-SA 4.0"

[LIC:sp:url]: https://en.wikipedia.org/wiki/All_rights_reserved "All Rights Reserved"
[LIC:sp:shd]: https://img.shields.io/badge/License-All%20Rights%20Reserved-white?labelColor=black&style=plastic "All Rights Reserved"

<!-- release links -->
[CURSFG:url]: https://www.curseforge.com/kerbal/ksp-mods/DropTanksIII "Curseforge"
[CURSFG:shd]: https://img.shields.io/badge/CurseForge-Link-CCFF00.svg?labelColor=6441A4&style=plastic&logo=curseforge "Curseforge"

[GITHUB:url]: https://github.com/zer0Kerbal/DropTanksIII/ "GitHub"
[GITHUB:shd]: https://img.shields.io/badge/Github-Link-CCFF00.svg?labelColor=181717&style=plastic&logo=github "GitHub"

<!-- Kerbal Space Program -->
[KSP:url]: https://kerbalspaceprogram.com/ "Kerbal Space Program"
[KSP:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/DropTanksIII/master/json/ksp.json "Kerbal Space Program"

<!-- links to add-ons/mods -->
[BOOM]: https://www.curseforge.com/kerbal/ksp-mods/Kaboom "Kaboom! (BOOM)"
[GPO]: https://www.curseforge.com/kerbal/ksp-mods/GPOSpeedPump "GPO SpeedPump (GPO)"
[ODFC]: https://www.curseforge.com/kerbal/ksp-mods/OnDemandFuelCells "On Demand Fuel Cells (ODFC)"
[SCON]: https://www.curseforge.com/kerbal/ksp-mods/SimpleConstruction "SimpleConstruction! (SCON)"

[b9ps]: https://forum.kerbalspaceprogram.com/index.php?/topic/140541-*/ "B9 Part Switch"
[fs]: https://github.com/snjo/Firespitter/ "Firespitter Core"
[ifsc]: https://forum.kerbalspaceprogram.com/index.php?/topic/106243-*/ "Interstellar Fuel Switch (Core)"
[mft]: http://forum.kerbalspaceprogram.com/index.php?/topic/58235-*/ "Modular Fuel Tanks"

[MM]: https://github.com/net-lisias-ksp/ModularManagement "ModularManagement (MM)"
[omm]: https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*/ "Module Manager"
[twk]: https://forum.kerbalspaceprogram.com/index.php?/topic/179030-*/ "TweakScale"

[Enceos]: https://forum.kerbalspaceprogram.com/index.php?/profile/110725-*/ "Enceos"  
[zer0Kerbal]: https://forum.kerbalspaceprogram.com/index.php?/profile/190933-*/ "zer0Kerbal"
<!-- financial support -->
[PAYPAL:img]: https://img.shields.io/badge/Buy%20me%20some%20-LFO-BADA55?style=for-the-badge&logo=paypal&labelColor=FFDD00/ "PayPal"
[PAYPAL:url]: https://www.paypal.com/donate/?hosted_button_id=DC22YHMEJREKL "PayPal"
[PATREON:img]: https://img.shields.io/badge/Patreon%20-Patreonize-FF424D?style=for-the-badge&logo=patreon/ "Patreon"
[PATREON:url]: https://www.patreon.com/zer0Kerbal/membership "Patreon"

<!-- Localization -->
[lreadme]: https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/readme.md "Localization Readme"
[qstart]: https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/quickstart.md "Quickstart"
[EN]: https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/EN.png "English"
[NL]: https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/NL.png "Dutch"

[curseforge]: https://www.curseforge.com/members/zer0kerbal/projects
[reddit]: https://www.reddit.com/user/zer0Kerbal
[twitch]: https://www.twitch.tv/zer0kerbal
[twitter]: https://twitter.com/zer0Kerbal
[youtube]: https://www.youtube.com/@zer0Kerbal
[steam]: https://steamcommunity.com/id/zeroKerbal
[projects]: https://zer0kerbal.github.io/zer0Kerbal/projects.html

#### Connect with me

Track progress: issues [here][issue] and projects [here](https://github.com/zer0Kerbal/DropTanksIII/projects/) along with **[The Short List](https://github.com/users/zer0Kerbal/projects/27)**

[<img align="left" alt="zer0Kerbal | kerbalspaceprogram.com" width="32px" src="https://cdn.icon-icons.com/icons2/1381/PNG/32/kerbalspaceprogram_93898.png" />][zer0Kerbal] [<img align="left" alt="zer0Kerbal | CurseForge" width="32px" src="https://cdn.jsdelivr.net/npm/simple-icons@v3/icons/curseforge.svg" />][curseforge] [<img align="left" alt="zer0Kerbal | reddit" width="32px" src="https://cdn.icon-icons.com/icons2/1945/PNG/512/iconfinder-reddit-4661631_122483.png" />][reddit] [<img align="left" alt="zer0Kerbal | Patreon" width="32px" src="https://cdn.icon-icons.com/icons2/2429/PNG/512/patreon_logo_icon_147253.png" />][PATREON:url] [<img align="left" alt="zer0Kerbal | YouTube" width="32px" src="https://cdn.icon-icons.com/icons2/836/PNG/512/Youtube_icon-icons.com_66802.png" />][youtube] [<img align="left" alt="zer0Kerbal | Twitch" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/twitch_logo_icon_170383.png" />][twitch] [<img align="left" alt="zer0Kerbal | PayPal" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/paypal_logo_icon_168055.png" />][PAYPAL:url] [<img align="left" alt="zer0Kerbal | steam" width="32px" src="https://icons.iconarchive.com/icons/3xhumed/mega-games-pack-05/48/Steam-icon.png" />][steam] [<img align="left" alt="zer0Kerbal | Twitter" width="32px" src="https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/twitter-32.ico" />][twitter] [<img align="left" alt="zer0Kerbal | project list" width="32px" src="https://www.pngall.com/wp-content/uploads/5/Vector-Checklist-PNG-HD-Image-180x180.png" />][projects]</br>
