<!-- readme.md v1.6.5.9
Antennas (ANTS)
created: 01 Jun 2015
updated: 07 Aug 2023

TEMPLATE: readme.md v1.7.6.0
created: 17 Jul 2017
updated: 07 Aug 2023

THIS FILE: CC BY-ND 4.0 by zer0Kerbal -->
# [Antennas (ANTS)][C:url]

[![Antennas][SHD:mod]][C:url]  
[![KSP version][K:shd]][K:url] [![License][LIC:shd]][LIC:url]  
[![Curseforge][C:shd]][C:url] [![GitHub][G:shd]][G:url] [![GitHub Pages][SHD:pgs]][pages]  

Adds new antennas that are compatible with Antenna Range, Remote Tech and Telemachus to Kerbal Space Program.

## By [`zer0Kerbal`][zedK], originally by [`DTPhantom`][auth-link]

adopted with *express* permission and brought to you by *KerbSimpleCo*

<img src="https://raw.githubusercontent.com/zer0Kerbal/Antennas/master/img/HeroLogo.png" alt="Antennas Hero" width="50%" height="50%">

### Includes the following new antennas

* **H1X Helical** Antenna which is a directional antenna with a 35 degree angle and a range of 70Mm
* **YA6 Yagi** Antenna which is a directional antenna with a range of 40Gm and a 0.1 degree angle perfect for covering the inner solar system
* **V17-7 Scimitar** Antenna which is an Omni antenna with a 300Km range and based off the Scimitar antennas flown on the Apollo command module
* **Q4-4 Quad Helix** which is an Omni Antenna with a 100Km range, but unlocked on start and primarily designed to provide a Telemachus Link early in the game
* **LA-7 Log Periodic** Antenna which is a directional antenna with a range of 50Mm and a 60 degree angle
* **HU6s-125 Twin Loop** is an omni antenna designed to wrap around your 1.25m ship and provide 1Mn of range

### See more

>* the latest version of this readme is always found on [GitHub][G:url]
>* [Mod Listing (WIP)][mlist] for a list of addons by [zer0Kerbal][zedK]
>* [ChangeLog][chlog] for more details of changes
>* [Discussions][discu] or [forums][forum] for discussions and news
>* [Flags][flags]
>* [GitHub Pages][pages]
>* [Known Issues][issue] for more details of feature requests and known issues
>* [Marketing Slicks][markt]
>* [Parts Catalog][parts] for pretty part pictures

### Localization

>* ![English](https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/zed'K/img/EN.png) English
>* ![Russian (Русский)](https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/RU.png) Russian (Русский) - спасибо [TheKyrlukCat](https://github.com/TheKyrlukCat)
>* ***your translation here***

### Help Wanted

> * Would love some Blender/Unity love to add animations, and *dablinkingness*
> * Compatibility Patches
> * Stock Balance Pass
> * Contracts for these glorious parts
> * Variant textures and model updates (add/improve: lights, iva, hatches et al)
> * Marketing Images and Videos such as hero shots, animated gifs, short highlights
> * Translations: See the [README's in the Localization folder](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/readme.md) for instructions for adding or improving translations. There is also the [quick start guide(s)](https://github.com/zer0Kerbal/zer0Kerbal/blob/master/Localization/quickstart.md). [GitHub][G:url] push is the best way to contribute. *Additions and corrections welcome!*
> * Have a request? Glad to have them, kindly submit through [GitHub][issue].

### Installation Directions

Most recent releases only available via CurseForge/OverWolf Website/App

<a href="https://download.curseforge.com/"><img src="https://www.overwolf.com/brand-guidelines/img/logo2.svg" alt="CurseForge/OverWolf App" height="100px"></a>

### Dependencies

* 📌 Pinned
  * Dependencies:
    * [Kerbal Space Program][K:url] [![Kerbal Space][K:shd]][K:url]

#### Suggests

* [list][mlist] of other addons by [zer0Kerbal][zedK]

* Also by [Radio Free Kerbol (RFK)](https://curseforge.com/kerbal/ksp-mods/RadioFreeKerbol "Radio Free Kerbol (RFK)")
  * [Antennas (ANTS)](https://www.curseforge.com/kerbal/ksp-mods/Antennas "Antennas (ANTS)")
* [Adjustable Mod Panel (KAMP)](https://curseforge.com/kerbal/ksp-mods/AdjustableModPanel)
* [Biomatic (BIO)](https://curseforge.com/kerbal/ksp-mods/Biomatic)
* [DRELite (DREL)](https://www.curseforge.com/kerbal/ksp-mods/drelite) <small><i>Start the game. Watch the fiery death.</i></small>
* [Exception Detector (EXCD)](https://curseforge.com/kerbal/ksp-mods/ExceptionDetector)
* [Field Training Facility (FTF)](https://curseforge.com/kerbal/ksp-mods/FieldTrainingFacility)
* [Field Training Lab (FTL)](https://curseforge.com/kerbal/ksp-mods/FieldTrainingLab)
* [Foundations (FND)](https://curseforge.com/kerbal/ksp-mods/Foundations) <small><i>Helps prevent ground constructions from floating away</small></i>
* [Gimbal Trim (TRIM)](https://curseforge.com/kerbal/ksp-mods/GimbalTrim)
* [GPO (Goo Pumps & Oils') Speed Pump (GPO)](https://curseforge.com/kerbal/ksp-mods/GPOSpeedPump)
* [Kaboom! (BOOM)](https://curseforge.com/kerbal/ksp-mods/Kaboom)
* [MoarKerbals (MOAR)](https://curseforge.com/kerbal/ksp-mods/MoarKerbals)
* [On Demand Fuel Cells (ODFC)](https://curseforge.com/kerbal/ksp-mods/OnDemandFuelCells)
* [Precise Maneuver (PM)](https://curseforge.com/kerbal/ksp-mods/PreciseManeuver)
* [ScrapYard (SCRAP)](https://curseforge.com/kerbal/ksp-mods/ScrapYard)
* [SimpleConstruction! (SCON)](https://curseforge.com/kerbal/ksp-mods/SimpleConstruction)
* [SimpleLogistics! (SLOG)](https://curseforge.com/kerbal/ksp-mods/SimpleLogistics)
* [SimpleNotes! (NOTE)](https://curseforge.com/kerbal/ksp-mods/Notes)
* <b>Science!</b>
  * [Mini Sample Return Capsule (MSRC)](https://www.curseforge.com/kerbal/ksp-mods/MiniSampleReturnCapsule)
  * [Mkerb Science Instruments](https://curseforge.com/kerbal/ksp-mods/ScienceInstruments)
  * [OScience Laboratories (OSL)](https://curseforge.com/kerbal/ksp-mods/OScienceLaboratories)
  * [Papa Kerballini's Pizza (PIZZA)](https://curseforge.com/kerbal/ksp-mods/Pizza)
  * [Portable Science Container (PRC)](https://curseforge.com/kerbal/ksp-mods/PortableScienceContainer)
  * [Solar Science (SOL)](https://curseforge.com/kerbal/ksp-mods/SolarScience)

### Supports

* [ModularManagement (MM)](https://curseforge.com/kerbal/ksp-mods/ModularManagement) or [Module Manager](https://forum.kerbalspaceprogram.com/index.php?/topic/50533-*/) *only required to use the compatibility patches*
* [Antenna Range](http://forum.kerbalspaceprogram.com/index.php?/topic/51591-*/ "AntennaRange")
* [Telemachus](https://forum.kerbalspaceprogram.com/index.php?/topic/144482-*/ "Telemachus")
* [RemoteTech (RT)](https://remotetechnologiesgroup.github.io/RemoteTech/ "RemoteTech (RT)")

### Tags

agency, comms, flags, part

<div style="border:0.5px solid Tomato; background-color: #BADA55; color: #FF0000; text-align:center">
  <p><b>red box below is a link to forum post on how to get support</b></p>
  <a href="https://forum.kerbalspaceprogram.com/index.php?/topic/83212-*">
    <p><img src="https://i.postimg.cc/vHP6zmrw/image.png" alt="How to get support"></p></a>
  <p style="color: #000000;">Be Kind: Lithobrake, not jakebrake! Keep your Module Manager up to date</p>
</div>

### Credits and Special Thanks

>* [`DTPhantom`][auth-link] for creating this glorious mod!
>* see [Attributions][attrb] for more

### Legal Mumbo Jumbo (License *provenance*)

#### Author (1) - [`zer0Kerbal`][zedK]

> Forum: [Thread][forum] - Source: [GitHub][G:url] - Download: [CurseForge][C:url]  
> License: [![License][LIC:shd]][LIC:url] ![License][LIC:log]

#### Original Author (ROOT) (0): [`DTPhantom`][auth-link]

> Forum: [Thread][0:thr] - Download: [SpaceDock][0:dwn] - Source: [SpaceDock][0:src]
> License: [![License][0:shd]][0:url] ![License][0:log]

#### Disclaimer(s)
>
>* ***All bundled mods are distributed under their own licenses***  
>* ***All assets, including but not limited to: animations, models, sounds and textures are distributed under their own licenses. [![License][LIC:sp:shd]][LIC:sp:url]***
>
>* see [Notices][notic] for more *legal Mumbo Jumbo*

### How to support this and other great mods by [`zer0Kerbal`][zedk]

Comment, click, like, share, up-vote, subscribe

> ***Completely voluntary, absolutely amazing, and really does help out a lot!***  
> *and it is true.*

[![Support][PAYPAL:img]][PAYPAL:url] [![Patreon][PATREON:img]][PATREON:url]

<!-- links -->
[attrb]: https://zer0kerbal.github.io/Antennas/Attributions "Attribution"
[chlog]: https://raw.githubusercontent.com/zer0Kerbal/Antennas/master/changelog.md  "Changelog"
[discu]: https://github.com/zer0Kerbal/Antennas/discussions "Discussions"
[flags]: https://zer0kerbal.github.io/Antennas/Flags "Flags"
[forum]: https://forum.kerbalspaceprogram.com/index.php?/topic/207329-*/ "Antennas (ANTS)"
[issue]: https://github.com/zer0Kerbal/Antennas/issues "Issues"
[markt]: https://zer0kerbal.github.io/Antennas/Marketing "Marketing Slicks"
[mlist]: https://zer0kerbal.github.io/zer0Kerbal/AddonListing.html "zer0Kerbal mod list"
[notic]: https://zer0kerbal.github.io/Antennas/Notices "Notices"
[pages]: https://zer0kerbal.github.io/Antennas "GitHub Pages"
[parts]: https://zer0kerbal.github.io/Antennas/PartsCatalog "Parts Catalog"

<!--- shields -->
[SHD:mod]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/Antennas/master/json/mod.json
[SHD:pgs]: https://img.shields.io/badge/GitHub-Pages-white?style=plastic&labelColor=9cf&logoColor=181717&logo=github "GitHub IO"

<!--- mod provenance -->
[0:dwn]: https://spacedock.info/mod/98 "SpaceDock"
[0:src]: https://spacedock.info/mod/98 "SpaceDock"
[0:thr]:https://forum.kerbalspaceprogram.com/index.php?/topic/113109-*/ "KSP Forum"

[0:url]: https://creativecommons.org/licenses/by-nc-sa/4.0/ "CC BY-NC-SA 4.0"
[0:log]: https://licensebuttons.net/i/l/by-nc-sa/transparent/33/66/99/76x22.png "CC BY-NC-SA 4.0"
[0:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/Antennas/master/json/license.json "Creative Commons"

[LIC:url]: https://creativecommons.org/licenses/by-sa/4.0/ "CC BY-SA 4.0+ARR"
[LIC:log]: https://licensebuttons.net/i/l/by-sa/transparent/33/66/99/76x22.png "CC BY-SA 4.0+ARR"
[LIC:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/Antennas/master/json/license.json "CC BY-SA 4.0+ARR"

[LIC:sp:url]: https://en.wikipedia.org/wiki/All_rights_reserved "All Rights Reserved"
[LIC:sp:shd]: https://img.shields.io/badge/License-All%20Rights%20Reserved-white?labelColor=black&style=plastic "All Rights Reserved"

<!--- release links -->
[C:url]: https://www.curseforge.com/kerbal/ksp-mods/Antennas "Curseforge"
[C:shd]: https://img.shields.io/badge/CurseForge-Link-CCFF00.svg?labelColor=6441A4&style=plastic&logo=curseforge "Curseforge"

[G:url]: https://github.com/zer0Kerbal/Antennas/ "GitHub"
[G:shd]: https://img.shields.io/badge/Github-Link-CCFF00.svg?labelColor=071776&style=plastic&logo=github "GitHub"

<!-- Kerbal Space Program -->
[K:url]: https://kerbalspaceprogram.com/ "Kerbal Space Program"
[K:shd]: https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/zer0Kerbal/Antennas/master/json/ksp.json "Kerbal Space Program"

<!-- links -->
[zedK]: https://forum.kerbalspaceprogram.com/index.php?/profile/190933-zer0kerbal/ "zer0Kerbal"
[auth-link]:  https://forum.kerbalspaceprogram.com/index.php?/profile/146393-dtphantom/ "DTPhantom"

[curseforge]: https://curseforge.com/members/zer0kerbal/projects
[reddit]: https://www.reddit.com/user/zer0Kerbal
[twitch]: https://www.twitch.tv/zer0kerbal
[twitter]: https://twitter.com/zer0Kerbal
[youtube]: https://www.youtube.com/@zer0Kerbal
[steam]: https://steamcommunity.com/id/zeroKerbal
[projects]: https://zer0kerbal.github.io/zer0Kerbal/projects.html

<!-- financial support -->
[PAYPAL:img]: https://img.shields.io/badge/Buy%20me%20some%20-LFO-BADA55?style=for-the-badge&logo=paypal&labelColor=FFDD00/ "PayPal"
[PAYPAL:url]: https://www.paypal.com/donate/?hosted_button_id=DC22YHMEJREKL "PayPal"
[PATREON:img]: https://img.shields.io/badge/Patreon%20-Patreonize-FF424D?style=for-the-badge&logo=patreon/ "Patreon"
[PATREON:url]: https://www.patreon.com/zer0Kerbal/membership "Patreon"

#### Connect with me

Track progress: issues [here][issue] and projects [here](https://github.com/zer0Kerbal/Antennas/projects/) along with **[The Short List](https://github.com/users/zer0Kerbal/projects/27)**

[<img align="left" alt="zer0Kerbal | kerbalspaceprogram.com" width="32px" src="https://cdn.icon-icons.com/icons2/1381/PNG/32/kerbalspaceprogram_93898.png" />][zedk] [<img align="left" alt="zer0Kerbal | CurseForge" width="32px" src="https://cdn.jsdelivr.net/npm/simple-icons@v3/icons/curseforge.svg" />][curseforge] [<img align="left" alt="zer0Kerbal | reddit" width="32px" src="https://cdn.icon-icons.com/icons2/1945/PNG/512/iconfinder-reddit-4661631_122483.png" />][reddit] [<img align="left" alt="zer0Kerbal | Patreon" width="32px" src="https://cdn.icon-icons.com/icons2/2429/PNG/512/patreon_logo_icon_147253.png" />][PATREON:url] [<img align="left" alt="zer0Kerbal | YouTube" width="32px" src="https://cdn.icon-icons.com/icons2/836/PNG/512/Youtube_icon-icons.com_66802.png" />][youtube] [<img align="left" alt="zer0Kerbal | Twitch" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/twitch_logo_icon_170383.png" />][twitch] [<img align="left" alt="zer0Kerbal | PayPal" width="32px" src="https://cdn.icon-icons.com/icons2/2699/PNG/512/paypal_logo_icon_168055.png" />][PAYPAL:url] [<img align="left" alt="zer0Kerbal | steam" width="32px" src="https://icons.iconarchive.com/icons/3xhumed/mega-games-pack-05/48/Steam-icon.png" />][steam] [<img align="left" alt="zer0Kerbal | Twitter" width="32px" src="https://raw.githubusercontent.com/zer0Kerbal/zer0Kerbal/master/img/twitter-32.ico" />][twitter] [<img align="left" alt="zer0Kerbal | project list" width="32px" src="https://www.pngall.com/wp-content/uploads/5/Vector-Checklist-PNG-HD-Image-180x180.png" />][projects]</br>
