## Version 1.4 `08 Jan 2024`

### Features

- New renderer with progressive enhancement for utilizing of OffscreenCanvas in a worker thread
- Shader parsing is moved to a worker thread as well
- Added manual shader recompilation

### ⚠️ Issues ⚠️

Large shaders may take long to recompile and since the GPU resources are not properly shared between main and worker threads there will still be a UI freeze.

To eliminate this issue you need to <mark>disable</mark> `"Hardware Acceleration"` in settings of your browser. Alternatively opt into manual recompilation.

### Changes

- Textures now have mipmaps generated by default, so you can use `textureLod()` to sample the levels

## Version 1.3 `07 Aug 2023`

### Features

- Now users can add up to 16 local textures (supports images and videos) to use inside of shaders. Just drag'n'drop a file (or multiple files at once) into editor view. Alternatively click texture slot and choose a file in a dialog

<video src="/media/textures_update.webm" autoplay loop muted playsinline style="aspect-ratio: 1130/890; width: 30rem; max-width: 100%;"></video>

### Fixes

- Changelog dates were using 2022 year instead of 2023

## Version 1.2 `15 Jul 2023`

### Features

- Added online shader sharing with shorter links
- Added a new setting to choose the sharing method (online/offline)

## Version 1.1 `30 Apr 2023`

### Features

- Added lygia autocompletion for include directive

## Version 1.0 `20 Apr 2023`

_Public release_

### Features

- Code highlighting
- Autocompletion suggestions
- Including of other shaders and libraries
- Errors and warnings reporting and highlighting
- Vector fields autocompletion
- Variable renaming
- Foldable code regions
- Hover over variables, structures, functions for more info
- Color picker for vec3/vec4
- Tweak menu for vectors and numbers
- Portable canvas can be dragged and resized
- Ability to export shaders with optionally renaming inputs and uniforms along with expanding includes
- Local shaders storage
- Ability to share shaders by generating a link (which also works offline)
- Local cache storage for included shaders
