unit HlpTiger;

{$I ..\Include\HashLib.inc}

interface

uses
  SysUtils,
{$IFDEF DELPHI}
  HlpHash,
  HlpHashBuffer,
{$ENDIF DELPHI}
  HlpHashLibTypes,
  HlpConverters,
  HlpHashRounds,
  HlpIHash,
  HlpIHashInfo,
  HlpHashCryptoNotBuildIn;

resourcestring
  SInvalidTigerHashSize =
    'Tiger HashSize Must be Either 128 bit(16 byte), 160 bit(20 byte) or 192 bit(24 byte)';
  SInvalidHashRound = 'Specified HashRound Is Invalid or UnSupported "%d"';

type
  TTiger = class abstract(TBlockHash, ICryptoNotBuildIn, ITransformBlock)

  strict private

{$REGION 'Consts'}
  const

    C1 = UInt64($A5A5A5A5A5A5A5A5);
    C2 = UInt64($0123456789ABCDEF);

    ST1: array [0 .. 255] of UInt64 = (UInt64($02AAB17CF7E90C5E),
      UInt64($AC424B03E243A8EC), UInt64($72CD5BE30DD5FCD3),
      UInt64($6D019B93F6F97F3A), UInt64($CD9978FFD21F9193),
      UInt64($7573A1C9708029E2), UInt64($B164326B922A83C3),
      UInt64($46883EEE04915870), UInt64($EAACE3057103ECE6),
      UInt64($C54169B808A3535C), UInt64($4CE754918DDEC47C),
      UInt64($0AA2F4DFDC0DF40C), UInt64($10B76F18A74DBEFA),
      UInt64($C6CCB6235AD1AB6A), UInt64($13726121572FE2FF),
      UInt64($1A488C6F199D921E), UInt64($4BC9F9F4DA0007CA),
      UInt64($26F5E6F6E85241C7), UInt64($859079DBEA5947B6),
      UInt64($4F1885C5C99E8C92), UInt64($D78E761EA96F864B),
      UInt64($8E36428C52B5C17D), UInt64($69CF6827373063C1),
      UInt64($B607C93D9BB4C56E), UInt64($7D820E760E76B5EA),
      UInt64($645C9CC6F07FDC42), UInt64($BF38A078243342E0),
      UInt64($5F6B343C9D2E7D04), UInt64($F2C28AEB600B0EC6),
      UInt64($6C0ED85F7254BCAC), UInt64($71592281A4DB4FE5),
      UInt64($1967FA69CE0FED9F), UInt64($FD5293F8B96545DB),
      UInt64($C879E9D7F2A7600B), UInt64($860248920193194E),
      UInt64($A4F9533B2D9CC0B3), UInt64($9053836C15957613),
      UInt64($DB6DCF8AFC357BF1), UInt64($18BEEA7A7A370F57),
      UInt64($037117CA50B99066), UInt64($6AB30A9774424A35),
      UInt64($F4E92F02E325249B), UInt64($7739DB07061CCAE1),
      UInt64($D8F3B49CECA42A05), UInt64($BD56BE3F51382F73),
      UInt64($45FAED5843B0BB28), UInt64($1C813D5C11BF1F83),
      UInt64($8AF0E4B6D75FA169), UInt64($33EE18A487AD9999),
      UInt64($3C26E8EAB1C94410), UInt64($B510102BC0A822F9),
      UInt64($141EEF310CE6123B), UInt64($FC65B90059DDB154),
      UInt64($E0158640C5E0E607), UInt64($884E079826C3A3CF),
      UInt64($930D0D9523C535FD), UInt64($35638D754E9A2B00),
      UInt64($4085FCCF40469DD5), UInt64($C4B17AD28BE23A4C),
      UInt64($CAB2F0FC6A3E6A2E), UInt64($2860971A6B943FCD),
      UInt64($3DDE6EE212E30446), UInt64($6222F32AE01765AE),
      UInt64($5D550BB5478308FE), UInt64($A9EFA98DA0EDA22A),
      UInt64($C351A71686C40DA7), UInt64($1105586D9C867C84),
      UInt64($DCFFEE85FDA22853), UInt64($CCFBD0262C5EEF76),
      UInt64($BAF294CB8990D201), UInt64($E69464F52AFAD975),
      UInt64($94B013AFDF133E14), UInt64($06A7D1A32823C958),
      UInt64($6F95FE5130F61119), UInt64($D92AB34E462C06C0),
      UInt64($ED7BDE33887C71D2), UInt64($79746D6E6518393E),
      UInt64($5BA419385D713329), UInt64($7C1BA6B948A97564),
      UInt64($31987C197BFDAC67), UInt64($DE6C23C44B053D02),
      UInt64($581C49FED002D64D), UInt64($DD474D6338261571),
      UInt64($AA4546C3E473D062), UInt64($928FCE349455F860),
      UInt64($48161BBACAAB94D9), UInt64($63912430770E6F68),
      UInt64($6EC8A5E602C6641C), UInt64($87282515337DDD2B),
      UInt64($2CDA6B42034B701B), UInt64($B03D37C181CB096D),
      UInt64($E108438266C71C6F), UInt64($2B3180C7EB51B255),
      UInt64($DF92B82F96C08BBC), UInt64($5C68C8C0A632F3BA),
      UInt64($5504CC861C3D0556), UInt64($ABBFA4E55FB26B8F),
      UInt64($41848B0AB3BACEB4), UInt64($B334A273AA445D32),
      UInt64($BCA696F0A85AD881), UInt64($24F6EC65B528D56C),
      UInt64($0CE1512E90F4524A), UInt64($4E9DD79D5506D35A),
      UInt64($258905FAC6CE9779), UInt64($2019295B3E109B33),
      UInt64($F8A9478B73A054CC), UInt64($2924F2F934417EB0),
      UInt64($3993357D536D1BC4), UInt64($38A81AC21DB6FF8B),
      UInt64($47C4FBF17D6016BF), UInt64($1E0FAADD7667E3F5),
      UInt64($7ABCFF62938BEB96), UInt64($A78DAD948FC179C9),
      UInt64($8F1F98B72911E50D), UInt64($61E48EAE27121A91),
      UInt64($4D62F7AD31859808), UInt64($ECEBA345EF5CEAEB),
      UInt64($F5CEB25EBC9684CE), UInt64($F633E20CB7F76221),
      UInt64($A32CDF06AB8293E4), UInt64($985A202CA5EE2CA4),
      UInt64($CF0B8447CC8A8FB1), UInt64($9F765244979859A3),
      UInt64($A8D516B1A1240017), UInt64($0BD7BA3EBB5DC726),
      UInt64($E54BCA55B86ADB39), UInt64($1D7A3AFD6C478063),
      UInt64($519EC608E7669EDD), UInt64($0E5715A2D149AA23),
      UInt64($177D4571848FF194), UInt64($EEB55F3241014C22),
      UInt64($0F5E5CA13A6E2EC2), UInt64($8029927B75F5C361),
      UInt64($AD139FABC3D6E436), UInt64($0D5DF1A94CCF402F),
      UInt64($3E8BD948BEA5DFC8), UInt64($A5A0D357BD3FF77E),
      UInt64($A2D12E251F74F645), UInt64($66FD9E525E81A082),
      UInt64($2E0C90CE7F687A49), UInt64($C2E8BCBEBA973BC5),
      UInt64($000001BCE509745F), UInt64($423777BBE6DAB3D6),
      UInt64($D1661C7EAEF06EB5), UInt64($A1781F354DAACFD8),
      UInt64($2D11284A2B16AFFC), UInt64($F1FC4F67FA891D1F),
      UInt64($73ECC25DCB920ADA), UInt64($AE610C22C2A12651),
      UInt64($96E0A810D356B78A), UInt64($5A9A381F2FE7870F),
      UInt64($D5AD62EDE94E5530), UInt64($D225E5E8368D1427),
      UInt64($65977B70C7AF4631), UInt64($99F889B2DE39D74F),
      UInt64($233F30BF54E1D143), UInt64($9A9675D3D9A63C97),
      UInt64($5470554FF334F9A8), UInt64($166ACB744A4F5688),
      UInt64($70C74CAAB2E4AEAD), UInt64($F0D091646F294D12),
      UInt64($57B82A89684031D1), UInt64($EFD95A5A61BE0B6B),
      UInt64($2FBD12E969F2F29A), UInt64($9BD37013FEFF9FE8),
      UInt64($3F9B0404D6085A06), UInt64($4940C1F3166CFE15),
      UInt64($09542C4DCDF3DEFB), UInt64($B4C5218385CD5CE3),
      UInt64($C935B7DC4462A641), UInt64($3417F8A68ED3B63F),
      UInt64($B80959295B215B40), UInt64($F99CDAEF3B8C8572),
      UInt64($018C0614F8FCB95D), UInt64($1B14ACCD1A3ACDF3),
      UInt64($84D471F200BB732D), UInt64($C1A3110E95E8DA16),
      UInt64($430A7220BF1A82B8), UInt64($B77E090D39DF210E),
      UInt64($5EF4BD9F3CD05E9D), UInt64($9D4FF6DA7E57A444),
      UInt64($DA1D60E183D4A5F8), UInt64($B287C38417998E47),
      UInt64($FE3EDC121BB31886), UInt64($C7FE3CCC980CCBEF),
      UInt64($E46FB590189BFD03), UInt64($3732FD469A4C57DC),
      UInt64($7EF700A07CF1AD65), UInt64($59C64468A31D8859),
      UInt64($762FB0B4D45B61F6), UInt64($155BAED099047718),
      UInt64($68755E4C3D50BAA6), UInt64($E9214E7F22D8B4DF),
      UInt64($2ADDBF532EAC95F4), UInt64($32AE3909B4BD0109),
      UInt64($834DF537B08E3450), UInt64($FA209DA84220728D),
      UInt64($9E691D9B9EFE23F7), UInt64($0446D288C4AE8D7F),
      UInt64($7B4CC524E169785B), UInt64($21D87F0135CA1385),
      UInt64($CEBB400F137B8AA5), UInt64($272E2B66580796BE),
      UInt64($3612264125C2B0DE), UInt64($057702BDAD1EFBB2),
      UInt64($D4BABB8EACF84BE9), UInt64($91583139641BC67B),
      UInt64($8BDC2DE08036E024), UInt64($603C8156F49F68ED),
      UInt64($F7D236F7DBEF5111), UInt64($9727C4598AD21E80),
      UInt64($A08A0896670A5FD7), UInt64($CB4A8F4309EBA9CB),
      UInt64($81AF564B0F7036A1), UInt64($C0B99AA778199ABD),
      UInt64($959F1EC83FC8E952), UInt64($8C505077794A81B9),
      UInt64($3ACAAF8F056338F0), UInt64($07B43F50627A6778),
      UInt64($4A44AB49F5ECCC77), UInt64($3BC3D6E4B679EE98),
      UInt64($9CC0D4D1CF14108C), UInt64($4406C00B206BC8A0),
      UInt64($82A18854C8D72D89), UInt64($67E366B35C3C432C),
      UInt64($B923DD61102B37F2), UInt64($56AB2779D884271D),
      UInt64($BE83E1B0FF1525AF), UInt64($FB7C65D4217E49A9),
      UInt64($6BDBE0E76D48E7D4), UInt64($08DF828745D9179E),
      UInt64($22EA6A9ADD53BD34), UInt64($E36E141C5622200A),
      UInt64($7F805D1B8CB750EE), UInt64($AFE5C7A59F58E837),
      UInt64($E27F996A4FB1C23C), UInt64($D3867DFB0775F0D0),
      UInt64($D0E673DE6E88891A), UInt64($123AEB9EAFB86C25),
      UInt64($30F1D5D5C145B895), UInt64($BB434A2DEE7269E7),
      UInt64($78CB67ECF931FA38), UInt64($F33B0372323BBF9C),
      UInt64($52D66336FB279C74), UInt64($505F33AC0AFB4EAA),
      UInt64($E8A5CD99A2CCE187), UInt64($534974801E2D30BB),
      UInt64($8D2D5711D5876D90), UInt64($1F1A412891BC038E),
      UInt64($D6E2E71D82E56648), UInt64($74036C3A497732B7),
      UInt64($89B67ED96361F5AB), UInt64($FFED95D8F1EA02A2),
      UInt64($E72B3BD61464D43D), UInt64($A6300F170BDC4820),
      UInt64($EBC18760ED78A77A));

    ST2: array [0 .. 255] of UInt64 = (UInt64($E6A6BE5A05A12138),
      UInt64($B5A122A5B4F87C98), UInt64($563C6089140B6990),
      UInt64($4C46CB2E391F5DD5), UInt64($D932ADDBC9B79434),
      UInt64($08EA70E42015AFF5), UInt64($D765A6673E478CF1),
      UInt64($C4FB757EAB278D99), UInt64($DF11C6862D6E0692),
      UInt64($DDEB84F10D7F3B16), UInt64($6F2EF604A665EA04),
      UInt64($4A8E0F0FF0E0DFB3), UInt64($A5EDEEF83DBCBA51),
      UInt64($FC4F0A2A0EA4371E), UInt64($E83E1DA85CB38429),
      UInt64($DC8FF882BA1B1CE2), UInt64($CD45505E8353E80D),
      UInt64($18D19A00D4DB0717), UInt64($34A0CFEDA5F38101),
      UInt64($0BE77E518887CAF2), UInt64($1E341438B3C45136),
      UInt64($E05797F49089CCF9), UInt64($FFD23F9DF2591D14),
      UInt64($543DDA228595C5CD), UInt64($661F81FD99052A33),
      UInt64($8736E641DB0F7B76), UInt64($15227725418E5307),
      UInt64($E25F7F46162EB2FA), UInt64($48A8B2126C13D9FE),
      UInt64($AFDC541792E76EEA), UInt64($03D912BFC6D1898F),
      UInt64($31B1AAFA1B83F51B), UInt64($F1AC2796E42AB7D9),
      UInt64($40A3A7D7FCD2EBAC), UInt64($1056136D0AFBBCC5),
      UInt64($7889E1DD9A6D0C85), UInt64($D33525782A7974AA),
      UInt64($A7E25D09078AC09B), UInt64($BD4138B3EAC6EDD0),
      UInt64($920ABFBE71EB9E70), UInt64($A2A5D0F54FC2625C),
      UInt64($C054E36B0B1290A3), UInt64($F6DD59FF62FE932B),
      UInt64($3537354511A8AC7D), UInt64($CA845E9172FADCD4),
      UInt64($84F82B60329D20DC), UInt64($79C62CE1CD672F18),
      UInt64($8B09A2ADD124642C), UInt64($D0C1E96A19D9E726),
      UInt64($5A786A9B4BA9500C), UInt64($0E020336634C43F3),
      UInt64($C17B474AEB66D822), UInt64($6A731AE3EC9BAAC2),
      UInt64($8226667AE0840258), UInt64($67D4567691CAECA5),
      UInt64($1D94155C4875ADB5), UInt64($6D00FD985B813FDF),
      UInt64($51286EFCB774CD06), UInt64($5E8834471FA744AF),
      UInt64($F72CA0AEE761AE2E), UInt64($BE40E4CDAEE8E09A),
      UInt64($E9970BBB5118F665), UInt64($726E4BEB33DF1964),
      UInt64($703B000729199762), UInt64($4631D816F5EF30A7),
      UInt64($B880B5B51504A6BE), UInt64($641793C37ED84B6C),
      UInt64($7B21ED77F6E97D96), UInt64($776306312EF96B73),
      UInt64($AE528948E86FF3F4), UInt64($53DBD7F286A3F8F8),
      UInt64($16CADCE74CFC1063), UInt64($005C19BDFA52C6DD),
      UInt64($68868F5D64D46AD3), UInt64($3A9D512CCF1E186A),
      UInt64($367E62C2385660AE), UInt64($E359E7EA77DCB1D7),
      UInt64($526C0773749ABE6E), UInt64($735AE5F9D09F734B),
      UInt64($493FC7CC8A558BA8), UInt64($B0B9C1533041AB45),
      UInt64($321958BA470A59BD), UInt64($852DB00B5F46C393),
      UInt64($91209B2BD336B0E5), UInt64($6E604F7D659EF19F),
      UInt64($B99A8AE2782CCB24), UInt64($CCF52AB6C814C4C7),
      UInt64($4727D9AFBE11727B), UInt64($7E950D0C0121B34D),
      UInt64($756F435670AD471F), UInt64($F5ADD442615A6849),
      UInt64($4E87E09980B9957A), UInt64($2ACFA1DF50AEE355),
      UInt64($D898263AFD2FD556), UInt64($C8F4924DD80C8FD6),
      UInt64($CF99CA3D754A173A), UInt64($FE477BACAF91BF3C),
      UInt64($ED5371F6D690C12D), UInt64($831A5C285E687094),
      UInt64($C5D3C90A3708A0A4), UInt64($0F7F903717D06580),
      UInt64($19F9BB13B8FDF27F), UInt64($B1BD6F1B4D502843),
      UInt64($1C761BA38FFF4012), UInt64($0D1530C4E2E21F3B),
      UInt64($8943CE69A7372C8A), UInt64($E5184E11FEB5CE66),
      UInt64($618BDB80BD736621), UInt64($7D29BAD68B574D0B),
      UInt64($81BB613E25E6FE5B), UInt64($071C9C10BC07913F),
      UInt64($C7BEEB7909AC2D97), UInt64($C3E58D353BC5D757),
      UInt64($EB017892F38F61E8), UInt64($D4EFFB9C9B1CC21A),
      UInt64($99727D26F494F7AB), UInt64($A3E063A2956B3E03),
      UInt64($9D4A8B9A4AA09C30), UInt64($3F6AB7D500090FB4),
      UInt64($9CC0F2A057268AC0), UInt64($3DEE9D2DEDBF42D1),
      UInt64($330F49C87960A972), UInt64($C6B2720287421B41),
      UInt64($0AC59EC07C00369C), UInt64($EF4EAC49CB353425),
      UInt64($F450244EEF0129D8), UInt64($8ACC46E5CAF4DEB6),
      UInt64($2FFEAB63989263F7), UInt64($8F7CB9FE5D7A4578),
      UInt64($5BD8F7644E634635), UInt64($427A7315BF2DC900),
      UInt64($17D0C4AA2125261C), UInt64($3992486C93518E50),
      UInt64($B4CBFEE0A2D7D4C3), UInt64($7C75D6202C5DDD8D),
      UInt64($DBC295D8E35B6C61), UInt64($60B369D302032B19),
      UInt64($CE42685FDCE44132), UInt64($06F3DDB9DDF65610),
      UInt64($8EA4D21DB5E148F0), UInt64($20B0FCE62FCD496F),
      UInt64($2C1B912358B0EE31), UInt64($B28317B818F5A308),
      UInt64($A89C1E189CA6D2CF), UInt64($0C6B18576AAADBC8),
      UInt64($B65DEAA91299FAE3), UInt64($FB2B794B7F1027E7),
      UInt64($04E4317F443B5BEB), UInt64($4B852D325939D0A6),
      UInt64($D5AE6BEEFB207FFC), UInt64($309682B281C7D374),
      UInt64($BAE309A194C3B475), UInt64($8CC3F97B13B49F05),
      UInt64($98A9422FF8293967), UInt64($244B16B01076FF7C),
      UInt64($F8BF571C663D67EE), UInt64($1F0D6758EEE30DA1),
      UInt64($C9B611D97ADEB9B7), UInt64($B7AFD5887B6C57A2),
      UInt64($6290AE846B984FE1), UInt64($94DF4CDEACC1A5FD),
      UInt64($058A5BD1C5483AFF), UInt64($63166CC142BA3C37),
      UInt64($8DB8526EB2F76F40), UInt64($E10880036F0D6D4E),
      UInt64($9E0523C9971D311D), UInt64($45EC2824CC7CD691),
      UInt64($575B8359E62382C9), UInt64($FA9E400DC4889995),
      UInt64($D1823ECB45721568), UInt64($DAFD983B8206082F),
      UInt64($AA7D29082386A8CB), UInt64($269FCD4403B87588),
      UInt64($1B91F5F728BDD1E0), UInt64($E4669F39040201F6),
      UInt64($7A1D7C218CF04ADE), UInt64($65623C29D79CE5CE),
      UInt64($2368449096C00BB1), UInt64($AB9BF1879DA503BA),
      UInt64($BC23ECB1A458058E), UInt64($9A58DF01BB401ECC),
      UInt64($A070E868A85F143D), UInt64($4FF188307DF2239E),
      UInt64($14D565B41A641183), UInt64($EE13337452701602),
      UInt64($950E3DCF3F285E09), UInt64($59930254B9C80953),
      UInt64($3BF299408930DA6D), UInt64($A955943F53691387),
      UInt64($A15EDECAA9CB8784), UInt64($29142127352BE9A0),
      UInt64($76F0371FFF4E7AFB), UInt64($0239F450274F2228),
      UInt64($BB073AF01D5E868B), UInt64($BFC80571C10E96C1),
      UInt64($D267088568222E23), UInt64($9671A3D48E80B5B0),
      UInt64($55B5D38AE193BB81), UInt64($693AE2D0A18B04B8),
      UInt64($5C48B4ECADD5335F), UInt64($FD743B194916A1CA),
      UInt64($2577018134BE98C4), UInt64($E77987E83C54A4AD),
      UInt64($28E11014DA33E1B9), UInt64($270CC59E226AA213),
      UInt64($71495F756D1A5F60), UInt64($9BE853FB60AFEF77),
      UInt64($ADC786A7F7443DBF), UInt64($0904456173B29A82),
      UInt64($58BC7A66C232BD5E), UInt64($F306558C673AC8B2),
      UInt64($41F639C6B6C9772A), UInt64($216DEFE99FDA35DA),
      UInt64($11640CC71C7BE615), UInt64($93C43694565C5527),
      UInt64($EA038E6246777839), UInt64($F9ABF3CE5A3E2469),
      UInt64($741E768D0FD312D2), UInt64($0144B883CED652C6),
      UInt64($C20B5A5BA33F8552), UInt64($1AE69633C3435A9D),
      UInt64($97A28CA4088CFDEC), UInt64($8824A43C1E96F420),
      UInt64($37612FA66EEEA746), UInt64($6B4CB165F9CF0E5A),
      UInt64($43AA1C06A0ABFB4A), UInt64($7F4DC26FF162796B),
      UInt64($6CBACC8E54ED9B0F), UInt64($A6B7FFEFD2BB253E),
      UInt64($2E25BC95B0A29D4F), UInt64($86D6A58BDEF1388C),
      UInt64($DED74AC576B6F054), UInt64($8030BDBC2B45805D),
      UInt64($3C81AF70E94D9289), UInt64($3EFF6DDA9E3100DB),
      UInt64($B38DC39FDFCC8847), UInt64($123885528D17B87E),
      UInt64($F2DA0ED240B1B642), UInt64($44CEFADCD54BF9A9),
      UInt64($1312200E433C7EE6), UInt64($9FFCC84F3A78C748),
      UInt64($F0CD1F72248576BB), UInt64($EC6974053638CFE4),
      UInt64($2BA7B67C0CEC4E4C), UInt64($AC2F4DF3E5CE32ED),
      UInt64($CB33D14326EA4C11), UInt64($A4E9044CC77E58BC),
      UInt64($5F513293D934FCEF), UInt64($5DC9645506E55444),
      UInt64($50DE418F317DE40A), UInt64($388CB31A69DDE259),
      UInt64($2DB4A83455820A86), UInt64($9010A91E84711AE9),
      UInt64($4DF7F0B7B1498371), UInt64($D62A2EABC0977179),
      UInt64($22FAC097AA8D5C0E));

    ST3: array [0 .. 255] of UInt64 = (UInt64($F49FCC2FF1DAF39B),
      UInt64($487FD5C66FF29281), UInt64($E8A30667FCDCA83F),
      UInt64($2C9B4BE3D2FCCE63), UInt64($DA3FF74B93FBBBC2),
      UInt64($2FA165D2FE70BA66), UInt64($A103E279970E93D4),
      UInt64($BECDEC77B0E45E71), UInt64($CFB41E723985E497),
      UInt64($B70AAA025EF75017), UInt64($D42309F03840B8E0),
      UInt64($8EFC1AD035898579), UInt64($96C6920BE2B2ABC5),
      UInt64($66AF4163375A9172), UInt64($2174ABDCCA7127FB),
      UInt64($B33CCEA64A72FF41), UInt64($F04A4933083066A5),
      UInt64($8D970ACDD7289AF5), UInt64($8F96E8E031C8C25E),
      UInt64($F3FEC02276875D47), UInt64($EC7BF310056190DD),
      UInt64($F5ADB0AEBB0F1491), UInt64($9B50F8850FD58892),
      UInt64($4975488358B74DE8), UInt64($A3354FF691531C61),
      UInt64($0702BBE481D2C6EE), UInt64($89FB24057DEDED98),
      UInt64($AC3075138596E902), UInt64($1D2D3580172772ED),
      UInt64($EB738FC28E6BC30D), UInt64($5854EF8F63044326),
      UInt64($9E5C52325ADD3BBE), UInt64($90AA53CF325C4623),
      UInt64($C1D24D51349DD067), UInt64($2051CFEEA69EA624),
      UInt64($13220F0A862E7E4F), UInt64($CE39399404E04864),
      UInt64($D9C42CA47086FCB7), UInt64($685AD2238A03E7CC),
      UInt64($066484B2AB2FF1DB), UInt64($FE9D5D70EFBF79EC),
      UInt64($5B13B9DD9C481854), UInt64($15F0D475ED1509AD),
      UInt64($0BEBCD060EC79851), UInt64($D58C6791183AB7F8),
      UInt64($D1187C5052F3EEE4), UInt64($C95D1192E54E82FF),
      UInt64($86EEA14CB9AC6CA2), UInt64($3485BEB153677D5D),
      UInt64($DD191D781F8C492A), UInt64($F60866BAA784EBF9),
      UInt64($518F643BA2D08C74), UInt64($8852E956E1087C22),
      UInt64($A768CB8DC410AE8D), UInt64($38047726BFEC8E1A),
      UInt64($A67738B4CD3B45AA), UInt64($AD16691CEC0DDE19),
      UInt64($C6D4319380462E07), UInt64($C5A5876D0BA61938),
      UInt64($16B9FA1FA58FD840), UInt64($188AB1173CA74F18),
      UInt64($ABDA2F98C99C021F), UInt64($3E0580AB134AE816),
      UInt64($5F3B05B773645ABB), UInt64($2501A2BE5575F2F6),
      UInt64($1B2F74004E7E8BA9), UInt64($1CD7580371E8D953),
      UInt64($7F6ED89562764E30), UInt64($B15926FF596F003D),
      UInt64($9F65293DA8C5D6B9), UInt64($6ECEF04DD690F84C),
      UInt64($4782275FFF33AF88), UInt64($E41433083F820801),
      UInt64($FD0DFE409A1AF9B5), UInt64($4325A3342CDB396B),
      UInt64($8AE77E62B301B252), UInt64($C36F9E9F6655615A),
      UInt64($85455A2D92D32C09), UInt64($F2C7DEA949477485),
      UInt64($63CFB4C133A39EBA), UInt64($83B040CC6EBC5462),
      UInt64($3B9454C8FDB326B0), UInt64($56F56A9E87FFD78C),
      UInt64($2DC2940D99F42BC6), UInt64($98F7DF096B096E2D),
      UInt64($19A6E01E3AD852BF), UInt64($42A99CCBDBD4B40B),
      UInt64($A59998AF45E9C559), UInt64($366295E807D93186),
      UInt64($6B48181BFAA1F773), UInt64($1FEC57E2157A0A1D),
      UInt64($4667446AF6201AD5), UInt64($E615EBCACFB0F075),
      UInt64($B8F31F4F68290778), UInt64($22713ED6CE22D11E),
      UInt64($3057C1A72EC3C93B), UInt64($CB46ACC37C3F1F2F),
      UInt64($DBB893FD02AAF50E), UInt64($331FD92E600B9FCF),
      UInt64($A498F96148EA3AD6), UInt64($A8D8426E8B6A83EA),
      UInt64($A089B274B7735CDC), UInt64($87F6B3731E524A11),
      UInt64($118808E5CBC96749), UInt64($9906E4C7B19BD394),
      UInt64($AFED7F7E9B24A20C), UInt64($6509EADEEB3644A7),
      UInt64($6C1EF1D3E8EF0EDE), UInt64($B9C97D43E9798FB4),
      UInt64($A2F2D784740C28A3), UInt64($7B8496476197566F),
      UInt64($7A5BE3E6B65F069D), UInt64($F96330ED78BE6F10),
      UInt64($EEE60DE77A076A15), UInt64($2B4BEE4AA08B9BD0),
      UInt64($6A56A63EC7B8894E), UInt64($02121359BA34FEF4),
      UInt64($4CBF99F8283703FC), UInt64($398071350CAF30C8),
      UInt64($D0A77A89F017687A), UInt64($F1C1A9EB9E423569),
      UInt64($8C7976282DEE8199), UInt64($5D1737A5DD1F7ABD),
      UInt64($4F53433C09A9FA80), UInt64($FA8B0C53DF7CA1D9),
      UInt64($3FD9DCBC886CCB77), UInt64($C040917CA91B4720),
      UInt64($7DD00142F9D1DCDF), UInt64($8476FC1D4F387B58),
      UInt64($23F8E7C5F3316503), UInt64($032A2244E7E37339),
      UInt64($5C87A5D750F5A74B), UInt64($082B4CC43698992E),
      UInt64($DF917BECB858F63C), UInt64($3270B8FC5BF86DDA),
      UInt64($10AE72BB29B5DD76), UInt64($576AC94E7700362B),
      UInt64($1AD112DAC61EFB8F), UInt64($691BC30EC5FAA427),
      UInt64($FF246311CC327143), UInt64($3142368E30E53206),
      UInt64($71380E31E02CA396), UInt64($958D5C960AAD76F1),
      UInt64($F8D6F430C16DA536), UInt64($C8FFD13F1BE7E1D2),
      UInt64($7578AE66004DDBE1), UInt64($05833F01067BE646),
      UInt64($BB34B5AD3BFE586D), UInt64($095F34C9A12B97F0),
      UInt64($247AB64525D60CA8), UInt64($DCDBC6F3017477D1),
      UInt64($4A2E14D4DECAD24D), UInt64($BDB5E6D9BE0A1EEB),
      UInt64($2A7E70F7794301AB), UInt64($DEF42D8A270540FD),
      UInt64($01078EC0A34C22C1), UInt64($E5DE511AF4C16387),
      UInt64($7EBB3A52BD9A330A), UInt64($77697857AA7D6435),
      UInt64($004E831603AE4C32), UInt64($E7A21020AD78E312),
      UInt64($9D41A70C6AB420F2), UInt64($28E06C18EA1141E6),
      UInt64($D2B28CBD984F6B28), UInt64($26B75F6C446E9D83),
      UInt64($BA47568C4D418D7F), UInt64($D80BADBFE6183D8E),
      UInt64($0E206D7F5F166044), UInt64($E258A43911CBCA3E),
      UInt64($723A1746B21DC0BC), UInt64($C7CAA854F5D7CDD3),
      UInt64($7CAC32883D261D9C), UInt64($7690C26423BA942C),
      UInt64($17E55524478042B8), UInt64($E0BE477656A2389F),
      UInt64($4D289B5E67AB2DA0), UInt64($44862B9C8FBBFD31),
      UInt64($B47CC8049D141365), UInt64($822C1B362B91C793),
      UInt64($4EB14655FB13DFD8), UInt64($1ECBBA0714E2A97B),
      UInt64($6143459D5CDE5F14), UInt64($53A8FBF1D5F0AC89),
      UInt64($97EA04D81C5E5B00), UInt64($622181A8D4FDB3F3),
      UInt64($E9BCD341572A1208), UInt64($1411258643CCE58A),
      UInt64($9144C5FEA4C6E0A4), UInt64($0D33D06565CF620F),
      UInt64($54A48D489F219CA1), UInt64($C43E5EAC6D63C821),
      UInt64($A9728B3A72770DAF), UInt64($D7934E7B20DF87EF),
      UInt64($E35503B61A3E86E5), UInt64($CAE321FBC819D504),
      UInt64($129A50B3AC60BFA6), UInt64($CD5E68EA7E9FB6C3),
      UInt64($B01C90199483B1C7), UInt64($3DE93CD5C295376C),
      UInt64($AED52EDF2AB9AD13), UInt64($2E60F512C0A07884),
      UInt64($BC3D86A3E36210C9), UInt64($35269D9B163951CE),
      UInt64($0C7D6E2AD0CDB5FA), UInt64($59E86297D87F5733),
      UInt64($298EF221898DB0E7), UInt64($55000029D1A5AA7E),
      UInt64($8BC08AE1B5061B45), UInt64($C2C31C2B6C92703A),
      UInt64($94CC596BAF25EF42), UInt64($0A1D73DB22540456),
      UInt64($04B6A0F9D9C4179A), UInt64($EFFDAFA2AE3D3C60),
      UInt64($F7C8075BB49496C4), UInt64($9CC5C7141D1CD4E3),
      UInt64($78BD1638218E5534), UInt64($B2F11568F850246A),
      UInt64($EDFABCFA9502BC29), UInt64($796CE5F2DA23051B),
      UInt64($AAE128B0DC93537C), UInt64($3A493DA0EE4B29AE),
      UInt64($B5DF6B2C416895D7), UInt64($FCABBD25122D7F37),
      UInt64($70810B58105DC4B1), UInt64($E10FDD37F7882A90),
      UInt64($524DCAB5518A3F5C), UInt64($3C9E85878451255B),
      UInt64($4029828119BD34E2), UInt64($74A05B6F5D3CECCB),
      UInt64($B610021542E13ECA), UInt64($0FF979D12F59E2AC),
      UInt64($6037DA27E4F9CC50), UInt64($5E92975A0DF1847D),
      UInt64($D66DE190D3E623FE), UInt64($5032D6B87B568048),
      UInt64($9A36B7CE8235216E), UInt64($80272A7A24F64B4A),
      UInt64($93EFED8B8C6916F7), UInt64($37DDBFF44CCE1555),
      UInt64($4B95DB5D4B99BD25), UInt64($92D3FDA169812FC0),
      UInt64($FB1A4A9A90660BB6), UInt64($730C196946A4B9B2),
      UInt64($81E289AA7F49DA68), UInt64($64669A0F83B1A05F),
      UInt64($27B3FF7D9644F48B), UInt64($CC6B615C8DB675B3),
      UInt64($674F20B9BCEBBE95), UInt64($6F31238275655982),
      UInt64($5AE488713E45CF05), UInt64($BF619F9954C21157),
      UInt64($EABAC46040A8EAE9), UInt64($454C6FE9F2C0C1CD),
      UInt64($419CF6496412691C), UInt64($D3DC3BEF265B0F70),
      UInt64($6D0E60F5C3578A9E));

    ST4: array [0 .. 255] of UInt64 = (UInt64($5B0E608526323C55),
      UInt64($1A46C1A9FA1B59F5), UInt64($A9E245A17C4C8FFA),
      UInt64($65CA5159DB2955D7), UInt64($05DB0A76CE35AFC2),
      UInt64($81EAC77EA9113D45), UInt64($528EF88AB6AC0A0D),
      UInt64($A09EA253597BE3FF), UInt64($430DDFB3AC48CD56),
      UInt64($C4B3A67AF45CE46F), UInt64($4ECECFD8FBE2D05E),
      UInt64($3EF56F10B39935F0), UInt64($0B22D6829CD619C6),
      UInt64($17FD460A74DF2069), UInt64($6CF8CC8E8510ED40),
      UInt64($D6C824BF3A6ECAA7), UInt64($61243D581A817049),
      UInt64($048BACB6BBC163A2), UInt64($D9A38AC27D44CC32),
      UInt64($7FDDFF5BAAF410AB), UInt64($AD6D495AA804824B),
      UInt64($E1A6A74F2D8C9F94), UInt64($D4F7851235DEE8E3),
      UInt64($FD4B7F886540D893), UInt64($247C20042AA4BFDA),
      UInt64($096EA1C517D1327C), UInt64($D56966B4361A6685),
      UInt64($277DA5C31221057D), UInt64($94D59893A43ACFF7),
      UInt64($64F0C51CCDC02281), UInt64($3D33BCC4FF6189DB),
      UInt64($E005CB184CE66AF1), UInt64($FF5CCD1D1DB99BEA),
      UInt64($B0B854A7FE42980F), UInt64($7BD46A6A718D4B9F),
      UInt64($D10FA8CC22A5FD8C), UInt64($D31484952BE4BD31),
      UInt64($C7FA975FCB243847), UInt64($4886ED1E5846C407),
      UInt64($28CDDB791EB70B04), UInt64($C2B00BE2F573417F),
      UInt64($5C9590452180F877), UInt64($7A6BDDFFF370EB00),
      UInt64($CE509E38D6D9D6A4), UInt64($EBEB0F00647FA702),
      UInt64($1DCC06CF76606F06), UInt64($E4D9F28BA286FF0A),
      UInt64($D85A305DC918C262), UInt64($475B1D8732225F54),
      UInt64($2D4FB51668CCB5FE), UInt64($A679B9D9D72BBA20),
      UInt64($53841C0D912D43A5), UInt64($3B7EAA48BF12A4E8),
      UInt64($781E0E47F22F1DDF), UInt64($EFF20CE60AB50973),
      UInt64($20D261D19DFFB742), UInt64($16A12B03062A2E39),
      UInt64($1960EB2239650495), UInt64($251C16FED50EB8B8),
      UInt64($9AC0C330F826016E), UInt64($ED152665953E7671),
      UInt64($02D63194A6369570), UInt64($5074F08394B1C987),
      UInt64($70BA598C90B25CE1), UInt64($794A15810B9742F6),
      UInt64($0D5925E9FCAF8C6C), UInt64($3067716CD868744E),
      UInt64($910AB077E8D7731B), UInt64($6A61BBDB5AC42F61),
      UInt64($93513EFBF0851567), UInt64($F494724B9E83E9D5),
      UInt64($E887E1985C09648D), UInt64($34B1D3C675370CFD),
      UInt64($DC35E433BC0D255D), UInt64($D0AAB84234131BE0),
      UInt64($08042A50B48B7EAF), UInt64($9997C4EE44A3AB35),
      UInt64($829A7B49201799D0), UInt64($263B8307B7C54441),
      UInt64($752F95F4FD6A6CA6), UInt64($927217402C08C6E5),
      UInt64($2A8AB754A795D9EE), UInt64($A442F7552F72943D),
      UInt64($2C31334E19781208), UInt64($4FA98D7CEAEE6291),
      UInt64($55C3862F665DB309), UInt64($BD0610175D53B1F3),
      UInt64($46FE6CB840413F27), UInt64($3FE03792DF0CFA59),
      UInt64($CFE700372EB85E8F), UInt64($A7BE29E7ADBCE118),
      UInt64($E544EE5CDE8431DD), UInt64($8A781B1B41F1873E),
      UInt64($A5C94C78A0D2F0E7), UInt64($39412E2877B60728),
      UInt64($A1265EF3AFC9A62C), UInt64($BCC2770C6A2506C5),
      UInt64($3AB66DD5DCE1CE12), UInt64($E65499D04A675B37),
      UInt64($7D8F523481BFD216), UInt64($0F6F64FCEC15F389),
      UInt64($74EFBE618B5B13C8), UInt64($ACDC82B714273E1D),
      UInt64($DD40BFE003199D17), UInt64($37E99257E7E061F8),
      UInt64($FA52626904775AAA), UInt64($8BBBF63A463D56F9),
      UInt64($F0013F1543A26E64), UInt64($A8307E9F879EC898),
      UInt64($CC4C27A4150177CC), UInt64($1B432F2CCA1D3348),
      UInt64($DE1D1F8F9F6FA013), UInt64($606602A047A7DDD6),
      UInt64($D237AB64CC1CB2C7), UInt64($9B938E7225FCD1D3),
      UInt64($EC4E03708E0FF476), UInt64($FEB2FBDA3D03C12D),
      UInt64($AE0BCED2EE43889A), UInt64($22CB8923EBFB4F43),
      UInt64($69360D013CF7396D), UInt64($855E3602D2D4E022),
      UInt64($073805BAD01F784C), UInt64($33E17A133852F546),
      UInt64($DF4874058AC7B638), UInt64($BA92B29C678AA14A),
      UInt64($0CE89FC76CFAADCD), UInt64($5F9D4E0908339E34),
      UInt64($F1AFE9291F5923B9), UInt64($6E3480F60F4A265F),
      UInt64($EEBF3A2AB29B841C), UInt64($E21938A88F91B4AD),
      UInt64($57DFEFF845C6D3C3), UInt64($2F006B0BF62CAAF2),
      UInt64($62F479EF6F75EE78), UInt64($11A55AD41C8916A9),
      UInt64($F229D29084FED453), UInt64($42F1C27B16B000E6),
      UInt64($2B1F76749823C074), UInt64($4B76ECA3C2745360),
      UInt64($8C98F463B91691BD), UInt64($14BCC93CF1ADE66A),
      UInt64($8885213E6D458397), UInt64($8E177DF0274D4711),
      UInt64($B49B73B5503F2951), UInt64($10168168C3F96B6B),
      UInt64($0E3D963B63CAB0AE), UInt64($8DFC4B5655A1DB14),
      UInt64($F789F1356E14DE5C), UInt64($683E68AF4E51DAC1),
      UInt64($C9A84F9D8D4B0FD9), UInt64($3691E03F52A0F9D1),
      UInt64($5ED86E46E1878E80), UInt64($3C711A0E99D07150),
      UInt64($5A0865B20C4E9310), UInt64($56FBFC1FE4F0682E),
      UInt64($EA8D5DE3105EDF9B), UInt64($71ABFDB12379187A),
      UInt64($2EB99DE1BEE77B9C), UInt64($21ECC0EA33CF4523),
      UInt64($59A4D7521805C7A1), UInt64($3896F5EB56AE7C72),
      UInt64($AA638F3DB18F75DC), UInt64($9F39358DABE9808E),
      UInt64($B7DEFA91C00B72AC), UInt64($6B5541FD62492D92),
      UInt64($6DC6DEE8F92E4D5B), UInt64($353F57ABC4BEEA7E),
      UInt64($735769D6DA5690CE), UInt64($0A234AA642391484),
      UInt64($F6F9508028F80D9D), UInt64($B8E319A27AB3F215),
      UInt64($31AD9C1151341A4D), UInt64($773C22A57BEF5805),
      UInt64($45C7561A07968633), UInt64($F913DA9E249DBE36),
      UInt64($DA652D9B78A64C68), UInt64($4C27A97F3BC334EF),
      UInt64($76621220E66B17F4), UInt64($967743899ACD7D0B),
      UInt64($F3EE5BCAE0ED6782), UInt64($409F753600C879FC),
      UInt64($06D09A39B5926DB6), UInt64($6F83AEB0317AC588),
      UInt64($01E6CA4A86381F21), UInt64($66FF3462D19F3025),
      UInt64($72207C24DDFD3BFB), UInt64($4AF6B6D3E2ECE2EB),
      UInt64($9C994DBEC7EA08DE), UInt64($49ACE597B09A8BC4),
      UInt64($B38C4766CF0797BA), UInt64($131B9373C57C2A75),
      UInt64($B1822CCE61931E58), UInt64($9D7555B909BA1C0C),
      UInt64($127FAFDD937D11D2), UInt64($29DA3BADC66D92E4),
      UInt64($A2C1D57154C2ECBC), UInt64($58C5134D82F6FE24),
      UInt64($1C3AE3515B62274F), UInt64($E907C82E01CB8126),
      UInt64($F8ED091913E37FCB), UInt64($3249D8F9C80046C9),
      UInt64($80CF9BEDE388FB63), UInt64($1881539A116CF19E),
      UInt64($5103F3F76BD52457), UInt64($15B7E6F5AE47F7A8),
      UInt64($DBD7C6DED47E9CCF), UInt64($44E55C410228BB1A),
      UInt64($B647D4255EDB4E99), UInt64($5D11882BB8AAFC30),
      UInt64($F5098BBB29D3212A), UInt64($8FB5EA14E90296B3),
      UInt64($677B942157DD025A), UInt64($FB58E7C0A390ACB5),
      UInt64($89D3674C83BD4A01), UInt64($9E2DA4DF4BF3B93B),
      UInt64($FCC41E328CAB4829), UInt64($03F38C96BA582C52),
      UInt64($CAD1BDBD7FD85DB2), UInt64($BBB442C16082AE83),
      UInt64($B95FE86BA5DA9AB0), UInt64($B22E04673771A93F),
      UInt64($845358C9493152D8), UInt64($BE2A488697B4541E),
      UInt64($95A2DC2DD38E6966), UInt64($C02C11AC923C852B),
      UInt64($2388B1990DF2A87B), UInt64($7C8008FA1B4F37BE),
      UInt64($1F70D0C84D54E503), UInt64($5490ADEC7ECE57D4),
      UInt64($002B3C27D9063A3A), UInt64($7EAEA3848030A2BF),
      UInt64($C602326DED2003C0), UInt64($83A7287D69A94086),
      UInt64($C57A5FCB30F57A8A), UInt64($B56844E479EBE779),
      UInt64($A373B40F05DCBCE9), UInt64($D71A786E88570EE2),
      UInt64($879CBACDBDE8F6A0), UInt64($976AD1BCC164A32F),
      UInt64($AB21E25E9666D78B), UInt64($901063AAE5E5C33C),
      UInt64($9818B34448698D90), UInt64($E36487AE3E1E8ABB),
      UInt64($AFBDF931893BDCB4), UInt64($6345A0DC5FBBD519),
      UInt64($8628FE269B9465CA), UInt64($1E5D01603F9C51EC),
      UInt64($4DE44006A15049B7), UInt64($BF6C70E5F776CBB1),
      UInt64($411218F2EF552BED), UInt64($CB0C0708705A36A3),
      UInt64($E74D14754F986044), UInt64($CD56D9430EA8280E),
      UInt64($C12591D7535F5065), UInt64($C83223F1720AEF96),
      UInt64($C3A0396F7363A51F));

{$ENDREGION}
  strict protected
  var
    FRounds: Int32;
    FHash: THashLibUInt64Array;

    constructor Create(AHashSize: Int32; ARounds: THashRounds);

    function GetName: String; override;
    function GetResult(): THashLibByteArray; override;
    procedure Finish(); override;
    procedure TransformBlock(AData: PByte; ADataLength: Int32;
      AIndex: Int32); override;

    function GetHashRound(AHashRound: Int32): THashRounds; inline;

  public
    procedure Initialize(); override;

  end;

type

  TTiger_Base = class sealed(TTiger)

  public
    constructor Create(AHashSize: Int32; ARounds: THashRounds);
    function Clone(): IHash; override;

  end;

type

  TTiger_128 = class sealed(TTiger)

  public
    constructor CreateRound3();
    constructor CreateRound4();
    constructor CreateRound5();
    function Clone(): IHash; override;

  end;

type

  TTiger_160 = class sealed(TTiger)

  public
    constructor CreateRound3();
    constructor CreateRound4();
    constructor CreateRound5();
    function Clone(): IHash; override;

  end;

type
  TTiger_192 = class sealed(TTiger)

  public
    constructor CreateRound3();
    constructor CreateRound4();
    constructor CreateRound5();
    function Clone(): IHash; override;

  end;

implementation

{ TTiger }

function TTiger.GetHashRound(AHashRound: Int32): THashRounds;
begin
  case AHashRound of
    3:
      Result := THashRounds.hrRounds3;
    4:
      Result := THashRounds.hrRounds4;
    5:
      Result := THashRounds.hrRounds5;
    8:
      Result := THashRounds.hrRounds8
  else
    begin
      raise EArgumentInvalidHashLibException.CreateResFmt(@SInvalidHashRound,
        [AHashRound]);
    end;
  end;
end;

constructor TTiger.Create(AHashSize: Int32; ARounds: THashRounds);
begin
  Inherited Create(AHashSize, 64);
  System.SetLength(FHash, 3);
  FRounds := Int32(ARounds);
end;

procedure TTiger.Finish;
var
  LBits: UInt64;
  LPadIndex: Int32;
  LPad: THashLibByteArray;
begin
  LBits := FProcessedBytesCount * 8;
  if FBuffer.Position < 56 then
  begin
    LPadIndex := 56 - FBuffer.Position
  end
  else
  begin
    LPadIndex := 120 - FBuffer.Position;
  end;
  System.SetLength(LPad, LPadIndex + 8);

  LPad[0] := 1;

  LBits := TConverters.le2me_64(LBits);

  TConverters.ReadUInt64AsBytesLE(LBits, LPad, LPadIndex);

  LPadIndex := LPadIndex + 8;

  TransformBytes(LPad, 0, LPadIndex);
end;

function TTiger.GetName: String;
begin
  Result := Format('%s_%u_%u', [Self.ClassParent.ClassName, FRounds,
    Self.HashSize * 8]);
end;

function TTiger.GetResult: THashLibByteArray;
begin
  System.SetLength(Result, HashSize);
  TConverters.le64_copy(PUInt64(FHash), 0, PByte(Result), 0,
    System.Length(Result));
end;

procedure TTiger.Initialize;
begin
  FHash[0] := $0123456789ABCDEF;
  FHash[1] := UInt64($FEDCBA9876543210);
  FHash[2] := UInt64($F096A5B4C3B2E187);
  Inherited Initialize();
end;

procedure TTiger.TransformBlock(AData: PByte; ADataLength: Int32;
  AIndex: Int32);
var
  LA, LB, LC, LTempA: UInt64;
  LRounds: Int32;
  LData: array [0 .. 7] of UInt64;
begin
  TConverters.le64_copy(AData, AIndex, @(LData[0]), 0, ADataLength);

  LA := FHash[0];
  LB := FHash[1];
  LC := FHash[2];

  LC := LC xor LData[0];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 5;

  LA := LA xor LData[1];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 5;

  LB := LB xor LData[2];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 5;

  LC := LC xor LData[3];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 5;

  LA := LA xor LData[4];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 5;

  LB := LB xor LData[5];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 5;

  LC := LC xor LData[6];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 5;

  LA := LA xor LData[7];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 5;

  LData[0] := LData[0] - (LData[7] xor C1);
  LData[1] := LData[1] xor LData[0];
  LData[2] := LData[2] + LData[1];
  LData[3] := LData[3] - (LData[2] xor (not LData[1] shl 19));
  LData[4] := LData[4] xor LData[3];
  LData[5] := LData[5] + LData[4];
  LData[6] := LData[6] - (LData[5] xor (not LData[4] shr 23));
  LData[7] := LData[7] xor LData[6];
  LData[0] := LData[0] + LData[7];
  LData[1] := LData[1] - (LData[0] xor (not LData[7] shl 19));
  LData[2] := LData[2] xor LData[1];
  LData[3] := LData[3] + LData[2];
  LData[4] := LData[4] - (LData[3] xor (not LData[2] shr 23));
  LData[5] := LData[5] xor LData[4];
  LData[6] := LData[6] + LData[5];
  LData[7] := LData[7] - (LData[6] xor C2);

  LB := LB xor LData[0];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 7;

  LC := LC xor LData[1];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 7;

  LA := LA xor LData[2];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 7;

  LB := LB xor LData[3];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 7;

  LC := LC xor LData[4];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 7;

  LA := LA xor LData[5];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 7;

  LB := LB xor LData[6];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 7;

  LC := LC xor LData[7];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 7;

  LData[0] := LData[0] - (LData[7] xor C1);
  LData[1] := LData[1] xor LData[0];
  LData[2] := LData[2] + LData[1];
  LData[3] := LData[3] - (LData[2] xor (not LData[1] shl 19));
  LData[4] := LData[4] xor LData[3];
  LData[5] := LData[5] + LData[4];
  LData[6] := LData[6] - (LData[5] xor (not LData[4] shr 23));
  LData[7] := LData[7] xor LData[6];
  LData[0] := LData[0] + LData[7];
  LData[1] := LData[1] - (LData[0] xor (not LData[7] shl 19));
  LData[2] := LData[2] xor LData[1];
  LData[3] := LData[3] + LData[2];
  LData[4] := LData[4] - (LData[3] xor (not LData[2] shr 23));
  LData[5] := LData[5] xor LData[4];
  LData[6] := LData[6] + LData[5];
  LData[7] := LData[7] - (LData[6] xor C2);

  LA := LA xor LData[0];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 9;

  LB := LB xor LData[1];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 9;

  LC := LC xor LData[2];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 9;

  LA := LA xor LData[3];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 9;

  LB := LB xor LData[4];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 9;

  LC := LC xor LData[5];
  LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
    ] xor ST4[Byte(LC shr 48)]);
  LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
    ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
  LB := LB * 9;

  LA := LA xor LData[6];
  LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
    ] xor ST4[Byte(LA shr 48)]);
  LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
    ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
  LC := LC * 9;

  LB := LB xor LData[7];
  LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
    ] xor ST4[Byte(LB shr 48)]);
  LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
    ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
  LA := LA * 9;

  LRounds := 3;
  while LRounds < FRounds do
  begin
    LData[0] := LData[0] - (LData[7] xor C1);
    LData[1] := LData[1] xor LData[0];
    LData[2] := LData[2] + LData[1];
    LData[3] := LData[3] - (LData[2] xor (not LData[1] shl 19));
    LData[4] := LData[4] xor LData[3];
    LData[5] := LData[5] + LData[4];
    LData[6] := LData[6] - (LData[5] xor (not LData[4] shr 23));
    LData[7] := LData[7] xor LData[6];
    LData[0] := LData[0] + LData[7];
    LData[1] := LData[1] - (LData[0] xor (not LData[7] shl 19));
    LData[2] := LData[2] xor LData[1];
    LData[3] := LData[3] + LData[2];
    LData[4] := LData[4] - (LData[3] xor (not LData[2] shr 23));
    LData[5] := LData[5] xor LData[4];
    LData[6] := LData[6] + LData[5];
    LData[7] := LData[7] - (LData[6] xor C2);

    LC := LC xor LData[0];
    LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
      ] xor ST4[Byte(LC shr 48)]);
    LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
      ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
    LB := LB * 9;

    LA := LA xor LData[1];
    LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
      ] xor ST4[Byte(LA shr 48)]);
    LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
      ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
    LC := LC * 9;

    LB := LB xor LData[2];
    LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
      ] xor ST4[Byte(LB shr 48)]);
    LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
      ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
    LA := LA * 9;

    LC := LC xor LData[3];
    LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
      ] xor ST4[Byte(LC shr 48)]);
    LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
      ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
    LB := LB * 9;

    LA := LA xor LData[4];
    LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
      ] xor ST4[Byte(LA shr 48)]);
    LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
      ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
    LC := LC * 9;

    LB := LB xor LData[5];
    LC := LC - (ST1[Byte(LB)] xor ST2[Byte(LB shr 16)] xor ST3[Byte(LB shr 32)
      ] xor ST4[Byte(LB shr 48)]);
    LA := LA + (ST4[Byte(LB shr 8)] xor ST3[Byte(LB shr 24)
      ] xor ST2[Byte(LB shr 40)] xor ST1[Byte(LB shr 56)]);
    LA := LA * 9;

    LC := LC xor LData[6];
    LA := LA - (ST1[Byte(LC)] xor ST2[Byte(LC shr 16)] xor ST3[Byte(LC shr 32)
      ] xor ST4[Byte(LC shr 48)]);
    LB := LB + (ST4[Byte(LC shr 8) and $FF] xor ST3[Byte(LC shr 24)
      ] xor ST2[Byte(LC shr 40)] xor ST1[Byte(LC shr 56)]);
    LB := LB * 9;

    LA := LA xor LData[7];
    LB := LB - (ST1[Byte(LA)] xor ST2[Byte(LA shr 16)] xor ST3[Byte(LA shr 32)
      ] xor ST4[Byte(LA shr 48)]);
    LC := LC + (ST4[Byte(LA shr 8)] xor ST3[Byte(LA shr 24)
      ] xor ST2[Byte(LA shr 40)] xor ST1[Byte(LA shr 56)]);
    LC := LC * 9;

    LTempA := LA;
    LA := LC;
    LC := LB;
    LB := LTempA;

    System.Inc(LRounds);
  end;

  FHash[0] := FHash[0] xor LA;
  FHash[1] := LB - FHash[1];
  FHash[2] := FHash[2] + LC;

  System.FillChar(LData, System.SizeOf(LData), UInt64(0));
end;

{ TTiger_128 }

function TTiger_128.Clone(): IHash;
var
  LHashInstance: TTiger_128;
begin
  LHashInstance := TTiger_128.Create(HashSize, GetHashRound(FRounds));
  LHashInstance.FHash := System.Copy(FHash);
  LHashInstance.FBuffer := FBuffer.Clone();
  LHashInstance.FProcessedBytesCount := FProcessedBytesCount;
  Result := LHashInstance as IHash;
  Result.BufferSize := BufferSize;
end;

constructor TTiger_128.CreateRound3;
begin
  Inherited Create(16, THashRounds.hrRounds3);
end;

constructor TTiger_128.CreateRound4;
begin
  Inherited Create(16, THashRounds.hrRounds4);
end;

constructor TTiger_128.CreateRound5;
begin
  Inherited Create(16, THashRounds.hrRounds5);
end;

{ TTiger_160 }

function TTiger_160.Clone(): IHash;
var
  LHashInstance: TTiger_160;
begin
  LHashInstance := TTiger_160.Create(HashSize, GetHashRound(FRounds));
  LHashInstance.FHash := System.Copy(FHash);
  LHashInstance.FBuffer := FBuffer.Clone();
  LHashInstance.FProcessedBytesCount := FProcessedBytesCount;
  Result := LHashInstance as IHash;
  Result.BufferSize := BufferSize;
end;

constructor TTiger_160.CreateRound3;
begin
  Inherited Create(20, THashRounds.hrRounds3);
end;

constructor TTiger_160.CreateRound4;
begin
  Inherited Create(20, THashRounds.hrRounds4);
end;

constructor TTiger_160.CreateRound5;
begin
  Inherited Create(20, THashRounds.hrRounds5);
end;

{ TTiger_192 }

function TTiger_192.Clone(): IHash;
var
  LHashInstance: TTiger_192;
begin
  LHashInstance := TTiger_192.Create(HashSize, GetHashRound(FRounds));
  LHashInstance.FHash := System.Copy(FHash);
  LHashInstance.FBuffer := FBuffer.Clone();
  LHashInstance.FProcessedBytesCount := FProcessedBytesCount;
  Result := LHashInstance as IHash;
  Result.BufferSize := BufferSize;
end;

constructor TTiger_192.CreateRound3;
begin
  Inherited Create(24, THashRounds.hrRounds3);
end;

constructor TTiger_192.CreateRound4;
begin
  Inherited Create(24, THashRounds.hrRounds4);
end;

constructor TTiger_192.CreateRound5;
begin
  Inherited Create(24, THashRounds.hrRounds5);
end;

{ TTiger_Base }

function TTiger_Base.Clone(): IHash;
var
  LHashInstance: TTiger_Base;
begin
  LHashInstance := TTiger_Base.Create(HashSize, GetHashRound(FRounds));
  LHashInstance.FHash := System.Copy(FHash);
  LHashInstance.FBuffer := FBuffer.Clone();
  LHashInstance.FProcessedBytesCount := FProcessedBytesCount;
  Result := LHashInstance as IHash;
  Result.BufferSize := BufferSize;
end;

constructor TTiger_Base.Create(AHashSize: Int32; ARounds: THashRounds);
begin
  Inherited Create(AHashSize, ARounds);
end;

end.
