# Copyright (C) 2022-now yui-mhcp project author. All rights reserved.
# Licenced under a modified Affero GPL v3 Licence (the "Licence").
# you may not use this file except in compliance with the License.
# See the "LICENCE" file at the root of the directory for the licence information.
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from .bounding_box import *
from .image_io import *
from .mask_utils import *
from .image_utils import *
from .video_utils import *
from .image_augmentation import *
from .custom_cameras import HTTPScreenMirror
from .image_normalization import get_image_normalization_fn

_image_formats  = ('gif', 'png', 'jpeg', 'jpg')
_video_formats  = ('mp4', 'avi', 'ogg', 'm4a', 'mov')

from utils.file_utils import load_data, dump_data

load_data.dispatch(load_image, _image_formats)
dump_data.dispatch(save_image, _image_formats)
