/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.ContextFreeAtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;

public final class YearMonthDurationValue
extends DurationValue
implements XPathComparable,
ContextFreeAtomicValue {
    public YearMonthDurationValue(int months, AtomicType typeLabel) {
        super(0, months, 0, 0, 0, 0L, 0, typeLabel);
    }

    public static ConversionResult makeYearMonthDurationValue(UnicodeString s2) {
        ConversionResult d = DurationValue.makeDuration(s2, true, false);
        if (d instanceof ValidationFailure) {
            return d;
        }
        DurationValue dv = (DurationValue)d;
        return YearMonthDurationValue.fromMonths((dv.getYears() * 12 + dv.getMonths()) * dv.signum());
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new YearMonthDurationValue(this.getLengthInMonths(), typeLabel);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        int y = this.getYears();
        int m4 = this.getMonths();
        UnicodeBuilder sb = new UnicodeBuilder(16);
        if (this._negative) {
            sb.append('-');
        }
        sb.append('P');
        if (y != 0) {
            sb.append(y + "Y");
        }
        if (m4 != 0 || y == 0) {
            sb.append(m4 + "M");
        }
        return sb.toUnicodeString();
    }

    public int getLengthInMonths() {
        return this._months * (this._negative ? -1 : 1);
    }

    public static YearMonthDurationValue fromMonths(int months) {
        return new YearMonthDurationValue(months, BuiltInAtomicType.YEAR_MONTH_DURATION);
    }

    @Override
    public YearMonthDurationValue multiply(long factor) throws XPathException {
        if (Math.abs(factor) < 30000L && Math.abs(this._months) < 30000) {
            return YearMonthDurationValue.fromMonths((int)factor * this.getLengthInMonths());
        }
        return this.multiply((double)factor);
    }

    @Override
    public YearMonthDurationValue multiply(double n) throws XPathException {
        if (Double.isNaN(n)) {
            XPathException err = new XPathException("Cannot multiply a duration by NaN");
            err.setErrorCode("FOCA0005");
            throw err;
        }
        double m4 = this.getLengthInMonths();
        double product = n * m4;
        if (Double.isInfinite(product) || product > 2.147483647E9 || product < -2.147483648E9) {
            XPathException err = new XPathException("Overflow when multiplying a duration by a number");
            err.setErrorCode("FODT0002");
            throw err;
        }
        return YearMonthDurationValue.fromMonths((int)new DoubleValue(product).round(0).longValue());
    }

    @Override
    public YearMonthDurationValue multiply(BigDecimal n) throws XPathException {
        int m4 = this.getLengthInMonths();
        BigDecimal product = n.multiply(BigDecimal.valueOf(m4));
        if (product.abs().compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) > 0) {
            XPathException err = new XPathException("Overflow when multiplying a duration by a number");
            err.setErrorCode("FODT0002");
            throw err;
        }
        return YearMonthDurationValue.fromMonths((int)new BigDecimalValue(product).round(0).longValue());
    }

    @Override
    public DurationValue divide(double n) throws XPathException {
        if (Double.isNaN(n)) {
            XPathException err = new XPathException("Cannot divide a duration by NaN");
            err.setErrorCode("FOCA0005");
            throw err;
        }
        double m4 = this.getLengthInMonths();
        double product = m4 / n;
        if (Double.isInfinite(product) || product > 2.147483647E9 || product < -2.147483648E9) {
            XPathException err = new XPathException("Overflow when dividing a duration by a number");
            err.setErrorCode("FODT0002");
            throw err;
        }
        return YearMonthDurationValue.fromMonths((int)new DoubleValue(product).round(0).longValue());
    }

    @Override
    public BigDecimalValue divide(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            BigDecimal v1 = BigDecimal.valueOf(this.getLengthInMonths());
            BigDecimal v2 = BigDecimal.valueOf(((YearMonthDurationValue)other).getLengthInMonths());
            if (v2.signum() == 0) {
                throw new XPathException("Divide by zero (durations)", "FOAR0001");
            }
            return new BigDecimalValue(this.divideBigDecimal(v1, v2));
        }
        throw new XPathException("Cannot divide two durations of different type", "XPTY0004");
    }

    private BigDecimal divideBigDecimal(BigDecimal v1, BigDecimal v2) {
        return v1.divide(v2, 20, RoundingMode.HALF_EVEN);
    }

    @Override
    public DurationValue add(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() + ((YearMonthDurationValue)other).getLengthInMonths());
        }
        XPathException err = new XPathException("Cannot add two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue subtract(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() - ((YearMonthDurationValue)other).getLengthInMonths());
        }
        XPathException err = new XPathException("Cannot subtract two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue negate() {
        return YearMonthDurationValue.fromMonths(-this.getLengthInMonths());
    }

    @Override
    public int compareTo(XPathComparable other) {
        if (other instanceof YearMonthDurationValue) {
            return Integer.compare(this.getLengthInMonths(), ((YearMonthDurationValue)other).getLengthInMonths());
        }
        throw new ClassCastException("Cannot compare xs:yearMonthDuration with " + other);
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) {
        return this;
    }

    @Override
    public XPathComparable getXPathComparable() {
        return this;
    }

    @Override
    public AtomicMatchKey getXPathMatchKey(StringCollator collator, int implicitTimezone) {
        return this;
    }
}

