/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GYearValue
extends GDateValue {
    private static final Pattern regex = Pattern.compile("(-?[0-9]+)(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GYearValue(GDateValue.MutableGDateValue m4) {
        super(m4);
    }

    public static ConversionResult makeGYearValue(UnicodeString value, ConversionRules rules) {
        GDateValue.MutableGDateValue g2 = new GDateValue.MutableGDateValue();
        UnicodeString trimmed = Whitespace.trim(value);
        Matcher m4 = regex.matcher(trimmed.toString());
        if (!m4.matches()) {
            return new ValidationFailure("Cannot convert '" + value + "' to a gYear");
        }
        String base = m4.group(1);
        String tz = m4.group(2);
        String date = base + "-01-01" + (tz == null ? "" : tz);
        g2.typeLabel = BuiltInAtomicType.G_YEAR;
        GYearValue.setLexicalValue(g2, BMPString.of(date), rules.isAllowYearZero());
        return g2.error == null ? new GYearValue(g2) : g2.error;
    }

    public GYearValue(int year, int tz, boolean xsd10) {
        this(new GDateValue.MutableGDateValue(year, 1, 1, xsd10, tz, BuiltInAtomicType.G_YEAR));
    }

    public GYearValue(int year, int tz, AtomicType type) {
        this(new GDateValue.MutableGDateValue(year, 1, 1, false, tz, type));
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        GDateValue.MutableGDateValue m4 = this.makeMutableCopy();
        m4.typeLabel = typeLabel;
        return new GYearValue(m4);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_YEAR;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        UnicodeBuilder sb = new UnicodeBuilder(16);
        int yr = this.year;
        if (this.year <= 0 && (yr = -yr + (this.hasNoYearZero ? 1 : 0)) != 0) {
            sb.append('-');
        }
        GYearValue.appendString(sb, yr, yr > 9999 ? (yr + "").length() : 4);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb.toUnicodeString();
    }

    @Override
    public CalendarValue add(DurationValue duration) throws XPathException {
        XPathException err = new XPathException("Cannot add a duration to an xs:gYear");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public CalendarValue adjustTimezone(int tz) {
        DateTimeValue dt = this.toDateTime().adjustTimezone(tz);
        return new GYearValue(dt.getYear(), dt.getTimezoneInMinutes(), this.hasNoYearZero);
    }
}

