/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.Whitespace;

public class GDayValue
extends GDateValue {
    private static final Pattern regex = Pattern.compile("---([0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    protected GDayValue(GDateValue.MutableGDateValue m4) {
        super(m4);
    }

    public static ConversionResult makeGDayValue(UnicodeString value) {
        UnicodeString trimmed = Whitespace.trim(value);
        Matcher m4 = regex.matcher(trimmed.toString());
        if (!m4.matches()) {
            return new ValidationFailure("Cannot convert '" + value + "' to a gDay");
        }
        GDateValue.MutableGDateValue g2 = new GDateValue.MutableGDateValue();
        String base = m4.group(1);
        String tz = m4.group(2);
        String date = "2000-01-" + base + (tz == null ? "" : tz);
        g2.typeLabel = BuiltInAtomicType.G_DAY;
        GDayValue.setLexicalValue(g2, BMPString.of(date), true);
        return g2.error == null ? new GDayValue(g2) : g2.error;
    }

    public GDayValue(byte day, int tz) {
        this(day, tz, BuiltInAtomicType.G_DAY);
    }

    public GDayValue(byte day, int tz, AtomicType type) {
        this(new GDateValue.MutableGDateValue(2000, 1, day, false, tz, type));
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        GDateValue.MutableGDateValue m4 = this.makeMutableCopy();
        m4.typeLabel = typeLabel;
        return new GDayValue(m4);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_DAY;
    }

    @Override
    public UnicodeString getPrimitiveStringValue() {
        UnicodeBuilder sb = new UnicodeBuilder(16);
        sb.appendLatin("---");
        GDayValue.appendTwoDigits(sb, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb.toUnicodeString();
    }

    @Override
    public CalendarValue add(DurationValue duration) throws XPathException {
        XPathException err = new XPathException("Cannot add a duration to an xs:gDay");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public CalendarValue adjustTimezone(int tz) {
        DateTimeValue dt = this.toDateTime().adjustTimezone(tz);
        return new GDayValue(dt.getDay(), dt.getTimezoneInMinutes());
    }
}

