/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import net.sf.saxon.expr.sort.XPathComparable;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DayTimeDurationValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.Whitespace;

public abstract class GDateValue
extends CalendarValue {
    protected final int year;
    protected final byte month;
    protected final byte day;
    protected final boolean hasNoYearZero;
    protected static byte[] daysPerMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static final short[] monthData = new short[]{306, 337, 0, 31, 61, 92, 122, 153, 184, 214, 245, 275};

    public GDateValue(int year, byte month, byte day, boolean hasNoYearZero, int tzMinutes, AtomicType typeLabel) {
        super(typeLabel, tzMinutes);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hasNoYearZero = hasNoYearZero;
    }

    protected MutableGDateValue makeMutableCopy() {
        MutableGDateValue m4 = new MutableGDateValue();
        m4.year = this.year;
        m4.month = this.month;
        m4.day = this.day;
        m4.hasNoYearZero = this.hasNoYearZero;
        m4.tzMinutes = this.getTimezoneInMinutes();
        m4.typeLabel = this.typeLabel;
        return m4;
    }

    protected GDateValue(MutableGDateValue m4) {
        super(m4.typeLabel, m4.tzMinutes);
        this.year = m4.year;
        this.month = m4.month;
        this.day = m4.day;
        this.hasNoYearZero = m4.hasNoYearZero;
    }

    public int getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    @Override
    public GregorianCalendar getCalendar() {
        int tz = this.hasTimezone() ? this.getTimezoneInMinutes() * 60000 : 0;
        SimpleTimeZone zone = new SimpleTimeZone(tz, "LLL");
        GregorianCalendar calendar = new GregorianCalendar(zone);
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        if (tz < calendar.getMinimum(15) || tz > calendar.getMaximum(15)) {
            return this.adjustTimezone(0).getCalendar();
        }
        calendar.clear();
        calendar.setLenient(false);
        int yr = this.year;
        if (this.year <= 0) {
            yr = this.hasNoYearZero ? 1 - this.year : 0 - this.year;
            calendar.set(0, 0);
        }
        calendar.set(yr, this.month - 1, this.day);
        calendar.set(15, tz);
        calendar.set(16, 0);
        calendar.getTime();
        return calendar;
    }

    protected static void setLexicalValue(MutableGDateValue m4, UnicodeString s2, boolean allowYearZero) {
        m4.hasNoYearZero = !allowYearZero;
        StringTokenizer tok = new StringTokenizer(Whitespace.trim(s2).toString(), "-:+TZ", true);
        try {
            if (!tok.hasMoreTokens()) {
                m4.error = GDateValue.badDate("Too short", s2);
                return;
            }
            String part = tok.nextToken();
            int era = 1;
            if ("+".equals(part)) {
                m4.error = GDateValue.badDate("Date must not start with '+' sign", s2);
                return;
            }
            if ("-".equals(part)) {
                era = -1;
                if (!tok.hasMoreTokens()) {
                    m4.error = GDateValue.badDate("No year after '-'", s2);
                    return;
                }
                part = tok.nextToken();
            }
            if (part.length() < 4) {
                m4.error = GDateValue.badDate("Year is less than four digits", s2);
                return;
            }
            if (part.length() > 4 && part.charAt(0) == '0') {
                m4.error = GDateValue.badDate("When year exceeds 4 digits, leading zeroes are not allowed", s2);
                return;
            }
            int value = DurationValue.simpleInteger(part);
            if (value < 0) {
                m4.error = value == -1 ? GDateValue.badDate("Non-numeric year component", s2) : GDateValue.badDate("Year is outside the range that Saxon can handle", s2, "FODT0001");
                return;
            }
            m4.year = value * era;
            if (m4.year == 0 && !allowYearZero) {
                m4.error = GDateValue.badDate("Year zero is not allowed", s2);
                return;
            }
            if (era < 0 && !allowYearZero) {
                ++m4.year;
            }
            if (!tok.hasMoreTokens()) {
                m4.error = GDateValue.badDate("Too short", s2);
                return;
            }
            if (!"-".equals(tok.nextToken())) {
                m4.error = GDateValue.badDate("Wrong delimiter after year", s2);
                return;
            }
            if (!tok.hasMoreTokens()) {
                m4.error = GDateValue.badDate("Too short", s2);
                return;
            }
            part = tok.nextToken();
            if (part.length() != 2) {
                m4.error = GDateValue.badDate("Month must be two digits", s2);
                return;
            }
            value = DurationValue.simpleInteger(part);
            if (value < 0) {
                m4.error = GDateValue.badDate("Non-numeric month component", s2);
                return;
            }
            m4.month = (byte)value;
            if (m4.month < 1 || m4.month > 12) {
                m4.error = GDateValue.badDate("Month is out of range", s2);
                return;
            }
            if (!tok.hasMoreTokens()) {
                m4.error = GDateValue.badDate("Too short", s2);
                return;
            }
            if (!"-".equals(tok.nextToken())) {
                m4.error = GDateValue.badDate("Wrong delimiter after month", s2);
                return;
            }
            if (!tok.hasMoreTokens()) {
                m4.error = GDateValue.badDate("Too short", s2);
                return;
            }
            part = tok.nextToken();
            if (part.length() != 2) {
                m4.error = GDateValue.badDate("Day must be two digits", s2);
                return;
            }
            value = DurationValue.simpleInteger(part);
            if (value < 0) {
                m4.error = GDateValue.badDate("Non-numeric day component", s2);
                return;
            }
            m4.day = (byte)value;
            if (m4.day < 1 || m4.day > 31) {
                m4.error = GDateValue.badDate("Day is out of range", s2);
                return;
            }
            if (tok.hasMoreTokens()) {
                String delim = tok.nextToken();
                if ("T".equals(delim)) {
                    m4.error = GDateValue.badDate("Value includes time", s2);
                    return;
                }
                if ("Z".equals(delim)) {
                    int tzOffset = 0;
                    if (tok.hasMoreTokens()) {
                        m4.error = GDateValue.badDate("Continues after 'Z'", s2);
                        return;
                    }
                    m4.tzMinutes = tzOffset;
                } else if ("+".equals(delim) || "-".equals(delim)) {
                    if (!tok.hasMoreTokens()) {
                        m4.error = GDateValue.badDate("Missing timezone", s2);
                        return;
                    }
                    part = tok.nextToken();
                    value = DurationValue.simpleInteger(part);
                    if (value < 0) {
                        m4.error = GDateValue.badDate("Non-numeric timezone hour component", s2);
                        return;
                    }
                    int tzhour = value;
                    if (part.length() != 2) {
                        m4.error = GDateValue.badDate("Timezone hour must be two digits", s2);
                        return;
                    }
                    if (tzhour > 14) {
                        m4.error = GDateValue.badDate("Timezone hour is out of range", s2);
                        return;
                    }
                    if (!tok.hasMoreTokens()) {
                        m4.error = GDateValue.badDate("No minutes in timezone", s2);
                        return;
                    }
                    if (!":".equals(tok.nextToken())) {
                        m4.error = GDateValue.badDate("Wrong delimiter after timezone hour", s2);
                        return;
                    }
                    if (!tok.hasMoreTokens()) {
                        m4.error = GDateValue.badDate("No minutes in timezone", s2);
                        return;
                    }
                    part = tok.nextToken();
                    value = DurationValue.simpleInteger(part);
                    if (value < 0) {
                        m4.error = GDateValue.badDate("Non-numeric timezone minute component", s2);
                        return;
                    }
                    int tzminute = value;
                    if (part.length() != 2) {
                        m4.error = GDateValue.badDate("Timezone minute must be two digits", s2);
                        return;
                    }
                    if (tzminute > 59) {
                        m4.error = GDateValue.badDate("Timezone minute is out of range", s2);
                        return;
                    }
                    if (tok.hasMoreTokens()) {
                        m4.error = GDateValue.badDate("Continues after timezone", s2);
                        return;
                    }
                    int tzOffset = tzhour * 60 + tzminute;
                    if ("-".equals(delim)) {
                        tzOffset = -tzOffset;
                    }
                    m4.tzMinutes = tzOffset;
                } else {
                    m4.error = GDateValue.badDate("Timezone format is incorrect", s2);
                    return;
                }
            }
            if (!GDateValue.isValidDate(m4.year, m4.month, m4.day)) {
                m4.error = GDateValue.badDate("Non-existent date", s2);
            }
        }
        catch (NumberFormatException err) {
            m4.error = GDateValue.badDate("Non-numeric component", s2);
        }
    }

    private static ValidationFailure badDate(String msg, UnicodeString value) {
        ValidationFailure err = new ValidationFailure("Invalid date " + Err.wrap(value, 4) + " (" + msg + ")");
        err.setErrorCode("FORG0001");
        return err;
    }

    private static ValidationFailure badDate(String msg, UnicodeString value, String errorCode) {
        ValidationFailure err = new ValidationFailure("Invalid date " + Err.wrap(value, 4) + " (" + msg + ")");
        err.setErrorCode(errorCode);
        return err;
    }

    public static boolean isValidDate(int year, int month, int day) {
        return month > 0 && month <= 12 && day > 0 && day <= daysPerMonth[month - 1] || month == 2 && day == 29 && GDateValue.isLeapYear(year);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    @Override
    public void checkValidInJavascript() throws XPathException {
        if (this.year <= 0 || this.year > 9999) {
            throw new XPathException("Year out of range for SaxonJS", "FODT0001");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GDateValue) {
            GDateValue gdv = (GDateValue)o;
            return this.getPrimitiveType() == gdv.getPrimitiveType() && this.toDateTime().equals(gdv.toDateTime());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return DateTimeValue.computeHashCode(this.year, this.month, this.day, (byte)12, (byte)0, (byte)0, 0, this.getTimezoneInMinutes());
    }

    @Override
    public int compareTo(CalendarValue other, int implicitTimezone) throws NoDynamicContextException {
        if (this.getPrimitiveType() != other.getPrimitiveType()) {
            throw new ClassCastException("Cannot compare dates of different types");
        }
        GDateValue v2 = (GDateValue)other;
        if (this.getTimezoneInMinutes() == other.getTimezoneInMinutes()) {
            if (this.year != v2.year) {
                return IntegerValue.signum(this.year - v2.year);
            }
            if (this.month != v2.month) {
                return IntegerValue.signum(this.month - v2.month);
            }
            if (this.day != v2.day) {
                return IntegerValue.signum(this.day - v2.day);
            }
            return 0;
        }
        return this.toDateTime().compareTo(other.toDateTime(), implicitTimezone);
    }

    @Override
    public DateTimeValue toDateTime() {
        return new DateTimeValue(this.year, this.month, this.day, 0, 0, 0, 0, this.getTimezoneInMinutes(), this.hasNoYearZero);
    }

    public GDateComparable getSchemaComparable() {
        return new GDateComparable(this);
    }

    @Override
    public XPathComparable getXPathComparable(StringCollator collator, int implicitTimezone) throws NoDynamicContextException {
        return null;
    }

    @Override
    public AtomicValue getComponent(AccessorFn.Component component) throws XPathException {
        switch (component) {
            case YEAR_ALLOWING_ZERO: {
                return Int64Value.makeIntegerValue(this.year);
            }
            case YEAR: {
                return Int64Value.makeIntegerValue(this.year > 0 || !this.hasNoYearZero ? (long)this.year : (long)(this.year - 1));
            }
            case MONTH: {
                return Int64Value.makeIntegerValue(this.month);
            }
            case DAY: {
                return Int64Value.makeIntegerValue(this.day);
            }
            case TIMEZONE: {
                if (this.hasTimezone()) {
                    return DayTimeDurationValue.fromMilliseconds(60000L * (long)this.getTimezoneInMinutes());
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for date: " + (Object)((Object)component));
    }

    public static class GDateComparable
    implements Comparable<GDateComparable> {
        private final GDateValue value;

        public GDateComparable(GDateValue value) {
            this.value = value;
        }

        public GDateValue asGDateValue() {
            return this.value;
        }

        @Override
        public int compareTo(GDateComparable o) {
            if (this.asGDateValue().getPrimitiveType() != o.asGDateValue().getPrimitiveType()) {
                return Integer.MIN_VALUE;
            }
            DateTimeValue dt0 = this.value.toDateTime();
            DateTimeValue dt1 = o.value.toDateTime();
            return dt0.getSchemaComparable().compareTo(dt1.getSchemaComparable());
        }

        public boolean equals(Object o) {
            return o instanceof GDateComparable && this.compareTo((GDateComparable)o) == 0;
        }

        public int hashCode() {
            return this.value.toDateTime().getSchemaComparable().hashCode();
        }
    }

    protected static class MutableGDateValue {
        public int year;
        public byte month;
        public byte day;
        public boolean hasNoYearZero;
        public int tzMinutes = Integer.MIN_VALUE;
        public AtomicType typeLabel = BuiltInAtomicType.DATE_TIME;
        public ValidationFailure error = null;

        public MutableGDateValue() {
        }

        public MutableGDateValue(int year, int month, int day, boolean hasNoYearZero, int tzMinutes, AtomicType typeLabel) {
            this.year = year;
            this.month = (byte)month;
            this.day = (byte)day;
            this.hasNoYearZero = hasNoYearZero;
            this.tzMinutes = tzMinutes;
            this.typeLabel = typeLabel;
        }
    }
}

