/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sxpath;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.UnprefixedElementMatchingPolicy;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public abstract class AbstractStaticContext
implements StaticContext {
    private String baseURI = null;
    private Configuration config;
    private PackageData packageData;
    private Location containingLocation = Loc.NONE;
    private String defaultCollationName;
    private FunctionLibraryList libraryList = new FunctionLibraryList();
    private NamespaceUri defaultFunctionNamespace = NamespaceUri.FN;
    private NamespaceUri defaultElementNamespace = NamespaceUri.NULL;
    private boolean backwardsCompatible = false;
    private int xpathLanguageLevel = 31;
    protected boolean usingDefaultFunctionLibrary;
    private final Map<StructuredQName, ItemType> typeAliases = new HashMap<StructuredQName, ItemType>();
    private UnprefixedElementMatchingPolicy unprefixedElementPolicy = UnprefixedElementMatchingPolicy.DEFAULT_NAMESPACE;
    private WarningHandler warningHandler;

    protected void setConfiguration(Configuration config) {
        this.config = config;
        this.defaultCollationName = config.getDefaultCollationName();
        this.warningHandler = (message, code, locator) -> {
            XmlProcessingIncident incident = new XmlProcessingIncident(message, code, locator).asWarning();
            config.makeErrorReporter().report(incident);
        };
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    public void setPackageData(PackageData packageData) {
        this.packageData = packageData;
    }

    @Override
    public PackageData getPackageData() {
        return this.packageData;
    }

    public void setSchemaAware(boolean aware) {
        this.getPackageData().setSchemaAware(aware);
    }

    @Override
    public RetainedStaticContext makeRetainedStaticContext() {
        return new RetainedStaticContext(this);
    }

    protected final void setDefaultFunctionLibrary() {
        FunctionLibraryList lib = new FunctionLibraryList();
        lib.addFunctionLibrary(XPath31FunctionSet.getInstance());
        lib.addFunctionLibrary(this.getConfiguration().getBuiltInExtensionLibraryList(31));
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        lib.addFunctionLibrary(this.config.getIntegratedFunctionLibrary());
        this.config.addExtensionBinders(lib);
        this.setFunctionLibrary(lib);
    }

    public final void setDefaultFunctionLibrary(int version) {
        FunctionLibraryList lib = new FunctionLibraryList();
        lib.addFunctionLibrary(this.config.getXPathFunctionSet(version));
        lib.addFunctionLibrary(this.config.getBuiltInExtensionLibraryList(version));
        lib.addFunctionLibrary(new ConstructorFunctionLibrary(this.config));
        lib.addFunctionLibrary(this.config.getIntegratedFunctionLibrary());
        this.config.addExtensionBinders(lib);
        this.setFunctionLibrary(lib);
    }

    protected final void addFunctionLibrary(FunctionLibrary library) {
        this.libraryList.addFunctionLibrary(library);
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration());
    }

    @Override
    public Location getContainingLocation() {
        return this.containingLocation;
    }

    public void setContainingLocation(Location location) {
        this.containingLocation = location;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public String getStaticBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.libraryList;
    }

    public void setFunctionLibrary(FunctionLibraryList lib) {
        this.libraryList = lib;
        this.usingDefaultFunctionLibrary = false;
    }

    public void setDefaultCollationName(String collationName) {
        this.defaultCollationName = collationName;
    }

    @Override
    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public void setWarningHandler(BiConsumer<String, Location> handler) {
        this.warningHandler = (message, code, loc) -> handler.accept(message, loc);
    }

    public void setWarningHandler(WarningHandler handler) {
        this.warningHandler = handler;
    }

    public WarningHandler getWarningHandler() {
        return this.warningHandler;
    }

    @Override
    public void issueWarning(String s2, String errorCode, Location locator) {
        this.getWarningHandler().accept(s2, errorCode, locator);
    }

    @Override
    public String getSystemId() {
        return "";
    }

    @Override
    public NamespaceUri getDefaultElementNamespace() {
        return this.defaultElementNamespace;
    }

    public void setDefaultElementNamespace(NamespaceUri uri) {
        this.defaultElementNamespace = uri;
    }

    public void setDefaultFunctionNamespace(NamespaceUri uri) {
        this.defaultFunctionNamespace = uri;
    }

    @Override
    public NamespaceUri getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setXPathLanguageLevel(int level) {
        this.xpathLanguageLevel = level;
        if (this.packageData.getHostLanguageVersion() != level) {
            this.packageData.setHostLanguage(this.packageData.getHostLanguage(), level);
        }
    }

    @Override
    public int getXPathVersion() {
        return this.xpathLanguageLevel;
    }

    public void setBackwardsCompatibilityMode(boolean option) {
        this.backwardsCompatible = option;
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return this.backwardsCompatible;
    }

    public void setDecimalFormatManager(DecimalFormatManager manager) {
        this.getPackageData().setDecimalFormatManager(manager);
    }

    @Override
    public ItemType getRequiredContextItemType() {
        return AnyItemType.getInstance();
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        DecimalFormatManager manager = this.getPackageData().getDecimalFormatManager();
        if (manager == null) {
            manager = new DecimalFormatManager(HostLanguage.XPATH, this.xpathLanguageLevel);
            this.getPackageData().setDecimalFormatManager(manager);
        }
        return manager;
    }

    @Override
    public KeyManager getKeyManager() {
        return this.getPackageData().getKeyManager();
    }

    public void setTypeAlias(StructuredQName name, ItemType type) {
        this.typeAliases.put(name, type);
    }

    @Override
    public ItemType resolveTypeAlias(StructuredQName typeName) {
        return this.typeAliases.get(typeName);
    }

    public void setUnprefixedElementMatchingPolicy(UnprefixedElementMatchingPolicy policy) {
        this.unprefixedElementPolicy = policy;
    }

    @Override
    public UnprefixedElementMatchingPolicy getUnprefixedElementMatchingPolicy() {
        return this.unprefixedElementPolicy;
    }

    @FunctionalInterface
    public static interface WarningHandler {
        public void accept(String var1, String var2, Location var3);
    }
}

