/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.function.IntPredicate;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.str.ZenoString;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.z.IntIterator;

public abstract class UnicodeString
implements AtomicMatchKey,
Comparable<UnicodeString> {
    public UnicodeString tidy() {
        return this;
    }

    public UnicodeString economize() {
        return this;
    }

    public abstract long length();

    public int length32() {
        return UnicodeString.requireInt(this.length());
    }

    public long estimatedLength() {
        return this.length();
    }

    public boolean isEmpty() {
        return this.length() == 0L;
    }

    public abstract int getWidth();

    public long indexOf(int codePoint) {
        return this.indexOf(codePoint, 0L);
    }

    public abstract long indexOf(int var1, long var2);

    public long indexWhere(IntPredicate predicate, long from) {
        IntIterator iter = this.codePoints();
        from = Math.max(from, 0L);
        long i = 0L;
        while (iter.hasNext()) {
            int ch = iter.next();
            if (i >= from && predicate.test(ch)) {
                return i;
            }
            ++i;
        }
        return -1L;
    }

    public long indexOf(UnicodeString other, long from) {
        if (from < 0L || from >= this.length()) {
            return -1L;
        }
        if (other.isEmpty()) {
            return from;
        }
        int initial = other.codePointAt(0L);
        long len = other.length();
        long lastPossible = this.length() - len;
        while (from <= lastPossible) {
            long i = this.indexOf(initial, from);
            if (i < 0L) {
                return -1L;
            }
            if (this.hasSubstring(other, i)) {
                return i;
            }
            from = i + 1L;
        }
        return -1L;
    }

    public boolean hasSubstring(UnicodeString other, long offset) {
        if (offset < 0L || offset > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        long len = other.length();
        if (len + offset > this.length()) {
            return false;
        }
        for (long k = 0L; k < len; ++k) {
            if (this.codePointAt(offset + k) == other.codePointAt(k)) continue;
            return false;
        }
        return true;
    }

    public abstract IntIterator codePoints();

    public abstract int codePointAt(long var1);

    public UnicodeString substring(long start) {
        return this.substring(start, this.length());
    }

    public abstract UnicodeString substring(long var1, long var3);

    public UnicodeString prefix(long end) {
        return this.substring(0L, end);
    }

    public UnicodeString concat(UnicodeString other) {
        return ZenoString.of(this).concat(other);
    }

    protected void checkSubstringBounds(long start, long end) {
        if (start < 0L) {
            throw new IndexOutOfBoundsException("UnicodeString.substring(): start (" + start + ") < 0");
        }
        if (end < start) {
            throw new IndexOutOfBoundsException("UnicodeString.substring(): end (" + end + ") < start ( + start + ");
        }
        if (end > this.length()) {
            throw new IndexOutOfBoundsException("UnicodeString.substring(): end (" + end + ") > length (" + this.length() + ")");
        }
    }

    public void verifyCharacters() {
        IntIterator iter = this.codePoints();
        int p = 0;
        while (iter.hasNext()) {
            int x = iter.next();
            if (!XMLCharacterData.isValid11(x)) {
                throw new IllegalStateException("Invalid char " + x + " in " + this.getClass() + " at offset " + p);
            }
            ++p;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnicodeString) {
            boolean more2;
            boolean more1;
            block2: {
                int ch2;
                int ch1;
                UnicodeString other = (UnicodeString)obj;
                IntIterator iter1 = this.codePoints();
                IntIterator iter2 = other.codePoints();
                do {
                    more1 = iter1.hasNext();
                    more2 = iter2.hasNext();
                    if (!more1 || !more2) break block2;
                } while ((ch1 = iter1.next()) == (ch2 = iter2.next()));
                return false;
            }
            return !more1 && !more2;
        }
        return false;
    }

    public int hashCode() {
        int h2 = 0;
        IntIterator iter = this.codePoints();
        while (iter.hasNext()) {
            int cp = iter.next();
            if ((cp & 0xFF0000) != 0) {
                h2 = 31 * h2 + UTF16CharacterSet.highSurrogate(cp);
                h2 = 31 * h2 + UTF16CharacterSet.lowSurrogate(cp);
                continue;
            }
            h2 = 31 * h2 + cp;
        }
        return h2;
    }

    @Override
    public int compareTo(UnicodeString other) {
        boolean more2;
        boolean more1;
        block2: {
            int ch2;
            int ch1;
            int diff;
            IntIterator iter1 = this.codePoints();
            IntIterator iter2 = other.codePoints();
            do {
                more1 = iter1.hasNext();
                more2 = iter2.hasNext();
                if (!more1 || !more2) break block2;
            } while ((diff = (ch1 = iter1.next()) - (ch2 = iter2.next())) == 0);
            return diff;
        }
        if (!more1 && !more2) {
            return 0;
        }
        return more1 ? 1 : -1;
    }

    private byte[] getCodepointCollationKey() {
        UnicodeString prep = this.tidy();
        int len = UnicodeString.requireInt(prep.length());
        byte[] result = new byte[len * 3];
        IntIterator iter = prep.codePoints();
        int j = 0;
        while (iter.hasNext()) {
            int c = iter.next();
            result[j++] = (byte)(c >> 16);
            result[j++] = (byte)(c >> 8);
            result[j++] = (byte)c;
        }
        return result;
    }

    @Override
    public AtomicValue asAtomic() {
        return new Base64BinaryValue(this.getCodepointCollationKey());
    }

    public static int requireInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("String offset exceeds 2^31 characters");
        }
        return (int)value;
    }

    public static int requireNonNegativeInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("String exceeds 2^31 characters");
        }
        return (int)Math.max(value, 0L);
    }

    void copy8bit(byte[] target, int offset) {
        throw new UnsupportedOperationException();
    }

    void copy16bit(char[] target, int offset) {
        throw new UnsupportedOperationException();
    }

    void copy24bit(byte[] target, int offset) {
        throw new UnsupportedOperationException();
    }

    void copy32bit(int[] target, int offset) {
        IntIterator iter = this.codePoints();
        while (iter.hasNext()) {
            target[offset++] = iter.next();
        }
    }
}

