/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.Doc_2;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapCreate;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.MapUntypedContains;
import net.sf.saxon.ma.map.RecordTest;
import net.sf.saxon.ma.map.SingleEntryMap;
import net.sf.saxon.ma.zeno.ZenoChain;
import net.sf.saxon.ma.zeno.ZenoSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.Twine8;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class VendorFunctionSetHE
extends BuiltInFunctionSet {
    private static final VendorFunctionSetHE THE_INSTANCE = new VendorFunctionSetHE();
    private static StringValue valueKey = new StringValue(new Twine8(StringConstants.bytes("value")));

    public static VendorFunctionSetHE getInstance() {
        return THE_INSTANCE;
    }

    private VendorFunctionSetHE() {
        this.init();
    }

    private void init() {
        this.register("is-whole-number", 1, e -> e.populate(IsWholeNumberFn::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, NumericType.getInstance(), 24576, EMPTY));
        this.register("dynamic-error-info", 1, e -> e.populate(DynamicErrorInfoFn::new, AnyItemType.getInstance(), 57344, 31236).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("create-map", 1, e -> e.populate(MapCreate::new, MapType.ANY_MAP_TYPE, 16384, 0).arg(0, MapType.ANY_MAP_TYPE, 57344, null));
        this.register("doc", 2, e -> e.populate(Doc_2::new, NodeKindTest.DOCUMENT, 16384, 512).arg(0, BuiltInAtomicType.STRING, 16384, null).arg(1, MapType.ANY_MAP_TYPE, 16384, EMPTY).setOptionDetails(Doc_2.makeOptionsParameter()));
        this.register("has-local-namespaces", 1, e -> e.populate(HasLocalNamespaces::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, NodeKindTest.ELEMENT, 16384, null));
        this.register("has-uniform-namespaces", 1, e -> e.populate(HasUniformNamespaces::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, NodeKindTest.ELEMENT, 16384, null));
        this.register("map-untyped-contains", 2, e -> e.populate(MapUntypedContains::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, MapType.ANY_MAP_TYPE, 57344, null).arg(1, BuiltInAtomicType.ANY_ATOMIC, 16384, null));
        RecordTest mapRepresentation = new RecordTest(Arrays.asList("key", "value"), Arrays.asList(SequenceType.SINGLE_ATOMIC, SequenceType.ANY_SEQUENCE), Collections.emptyList(), false);
        this.register("map-as-sequence-of-maps", 1, e -> e.populate(MapAsSequenceOfMaps::new, mapRepresentation, 57344, 0).arg(0, MapType.ANY_MAP_TYPE, 16384, null));
        this.register("yes-no-boolean", 1, e -> e.populate(YesNoBoolean::new, BuiltInAtomicType.BOOLEAN, 16384, 0).arg(0, BuiltInAtomicType.STRING, 16384, null));
        this.register("concatenate-sequences", 2, e -> e.populate(ConcatenateSequences::new, AnyItemType.getInstance(), 57344, 0).arg(0, AnyItemType.getInstance(), 57344, null).arg(1, AnyItemType.getInstance(), 57344, null));
    }

    @Override
    public NamespaceUri getNamespace() {
        return NamespaceUri.SAXON;
    }

    @Override
    public String getConventionalPrefix() {
        return "saxon";
    }

    public static class ConcatenateSequences
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ZenoChain<Object> chain = new ZenoChain<Item>();
            chain = chain.addAll(arguments[0].materialize().asIterable());
            chain = chain.addAll(arguments[1].materialize().asIterable());
            return new ZenoSequence(chain);
        }
    }

    public static class YesNoBoolean
    extends SystemFunction {
        @Override
        public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            String supplied = arguments[0].head().getStringValue();
            switch (Whitespace.trim(supplied)) {
                case "0": 
                case "no": 
                case "false": {
                    return BooleanValue.FALSE;
                }
                case "1": 
                case "yes": 
                case "true": {
                    return BooleanValue.TRUE;
                }
            }
            throw new XPathException("Supplied value for boolean argument must be 0|false|no or 1|true|yes", "FORG0001");
        }
    }

    public static class MapAsSequenceOfMaps
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem map = (MapItem)arguments[0].head();
            ArrayList<DictionaryMap> mapList = new ArrayList<DictionaryMap>();
            for (KeyValuePair pair : map.keyValuePairs()) {
                DictionaryMap dictionary = new DictionaryMap(2);
                dictionary.initialPut("key", pair.key);
                dictionary.initialPut("value", pair.value);
                mapList.add(dictionary);
            }
            return new SequenceExtent.Of(mapList);
        }
    }

    public static class ArrayAsSequenceOfMaps
    extends SystemFunction {
        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            ArrayItem array = (ArrayItem)arguments[0].head();
            ArrayList<SingleEntryMap> mapList = new ArrayList<SingleEntryMap>();
            for (GroundedValue value : array.members()) {
                mapList.add(new SingleEntryMap(valueKey, value));
            }
            return new SequenceExtent.Of(mapList);
        }
    }

    public static class DynamicErrorInfoFn
    extends SystemFunction {
        @Override
        public int getSpecialProperties(Expression[] arguments) {
            return 0;
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            String var = arguments[0].head().getStringValue();
            XPathException error = context.getCurrentException();
            if (error == null) {
                return EmptySequence.getInstance();
            }
            Location locator = error.getLocator();
            switch (var) {
                case "code": {
                    StructuredQName errorCodeQName = error.getErrorCodeQName();
                    if (errorCodeQName == null) {
                        errorCodeQName = new StructuredQName("saxon", NamespaceUri.SAXON, "XXXX9999");
                    }
                    return new QNameValue(errorCodeQName, BuiltInAtomicType.QNAME);
                }
                case "description": {
                    String s2 = error.getMessage();
                    if (error.getCause() != null) {
                        s2 = s2 + "(" + error.getCause().getMessage() + ")";
                    }
                    return new StringValue(s2);
                }
                case "value": {
                    Sequence value = error.getErrorObject();
                    if (value == null) {
                        return EmptySequence.getInstance();
                    }
                    return value;
                }
                case "module": {
                    String module;
                    String string = module = locator == null ? null : locator.getSystemId();
                    if (module == null) {
                        return EmptySequence.getInstance();
                    }
                    return new StringValue(module);
                }
                case "line-number": {
                    int line;
                    int n = line = locator == null ? -1 : locator.getLineNumber();
                    if (line == -1) {
                        return EmptySequence.getInstance();
                    }
                    return new Int64Value(line);
                }
                case "column-number": {
                    int column = -1;
                    if (locator == null) {
                        return EmptySequence.getInstance();
                    }
                    column = locator instanceof XPathParser.NestedLocation ? ((XPathParser.NestedLocation)locator).getContainingLocation().getColumnNumber() : locator.getColumnNumber();
                    if (column == -1) {
                        return EmptySequence.getInstance();
                    }
                    return new Int64Value(column);
                }
            }
            return EmptySequence.getInstance();
        }
    }

    public static class HasUniformNamespaces
    extends SystemFunction {
        @Override
        public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo val = (NodeInfo)arguments[0].head();
            if (val instanceof TinyElementImpl) {
                return BooleanValue.get(((TinyElementImpl)val).hasUniformNamespaces());
            }
            return BooleanValue.FALSE;
        }
    }

    public static class HasLocalNamespaces
    extends SystemFunction {
        @Override
        public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
            NodeInfo child = (NodeInfo)arguments[0].head();
            NodeInfo parent = child.getParent();
            return BooleanValue.get(parent == null || parent.getNodeKind() == 9 || child.getAllNamespaces() != parent.getAllNamespaces());
        }
    }

    public static class IsWholeNumberFn
    extends SystemFunction {
        @Override
        public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
            if (arguments[0].getItemType().getPrimitiveItemType() == BuiltInAtomicType.INTEGER) {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            return null;
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            NumericValue val = (NumericValue)arguments[0].head();
            return BooleanValue.get(val != null && val.isWholeNumber());
        }
    }
}

