/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.registry;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.PackageLoaderHE;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class SefFunction
extends SystemFunction {
    private static final NamespaceUri FN_ALIAS = NamespaceUri.of("http://ns.saxonica.com/xpath-functions");
    protected SymbolicName.F functionAlias;
    protected StylesheetPackage pack;

    @Override
    public void setDetails(BuiltInFunctionSet.Entry entry) {
        super.setDetails(entry);
        this.functionAlias = new SymbolicName.F(new StructuredQName("", FN_ALIAS, this.getDetails().name.getLocalPart()), this.getDetails().maxArity);
    }

    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        SystemFunctionCall e = new SystemFunctionCall(this, arguments);
        ((Expression)e).setRetainedStaticContext(this.getRetainedStaticContext());
        return e;
    }

    protected Sequence callFunction(XPathContext context, SymbolicName.F name, Sequence[] args) throws XPathException {
        Component target;
        if (this.pack == null) {
            Configuration config = context.getConfiguration();
            PackageLoaderHE loader = new PackageLoaderHE(config);
            ArrayList<String> messages = new ArrayList<String>();
            InputStream is = Version.platform.locateResource("sef/function-library.sef.xml", messages);
            if (is == null) {
                StringBuilder sb = new StringBuilder("Failed to load built-in function library: function-library.sef.xml");
                for (String msg : messages) {
                    sb.append(": ").append(msg);
                }
                throw new XPathException(sb.toString());
            }
            this.pack = loader.loadPackage(new StreamSource(is));
        }
        if ((target = this.pack.getComponent(name)) == null) {
            throw new XPathException("Built-in XSLT function " + this.getDetails().name.getEQName() + " not found");
        }
        if (target.isHiddenAbstractComponent()) {
            throw new XPathException("Cannot call an abstract function (" + name.getComponentName().getDisplayName() + ") with no implementation", "XTDE3052");
        }
        UserFunction targetFunction = (UserFunction)target.getActor();
        XPathContextMajor c2 = targetFunction.makeNewContext(context, null);
        c2.setCurrentComponent(target);
        try {
            return targetFunction.call(c2, args);
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] args) throws XPathException {
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].materialize();
        }
        return this.callFunction(context, this.functionAlias, args);
    }
}

