/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions.hof;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.functions.hof.UserFunctionReference;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;

public class FunctionLiteral
extends Literal {
    public FunctionLiteral(FunctionItem value) {
        super(value);
    }

    @Override
    public FunctionItem getGroundedValue() {
        return (FunctionItem)super.getGroundedValue();
    }

    @Override
    public Expression simplify() throws XPathException {
        if (this.getGroundedValue() instanceof AbstractFunction) {
            ((AbstractFunction)this.getGroundedValue()).simplify();
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.getGroundedValue() instanceof AbstractFunction) {
            ((AbstractFunction)this.getGroundedValue()).typeCheck(visitor, contextInfo);
        }
        return this;
    }

    @Override
    public FunctionItemType getItemType() {
        return this.getGroundedValue().getFunctionItemType();
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    protected int computeSpecialProperties() {
        return 0x800000;
    }

    @Override
    public boolean isVacuousExpression() {
        return false;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        FunctionLiteral fl2 = new FunctionLiteral(this.getGroundedValue());
        ExpressionTool.copyLocationInfo(this, fl2);
        return fl2;
    }

    @Override
    public void setRetainedStaticContext(RetainedStaticContext rsc) {
        super.setRetainedStaticContext(rsc);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FunctionLiteral && ((FunctionLiteral)obj).getGroundedValue() == this.getGroundedValue();
    }

    @Override
    protected int computeHashCode() {
        return this.getGroundedValue().hashCode();
    }

    @Override
    public String getExpressionName() {
        return "namedFunctionRef";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        FunctionItem f = this.getGroundedValue();
        if (f instanceof UserFunction) {
            new UserFunctionReference((UserFunction)f).export(out);
        } else {
            f.export(out);
        }
    }
}

