/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ParseXml;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.resource.ActiveSAXSource;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ParseXmlFragment
extends SystemFunction
implements Callable {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue input = (StringValue)arguments[0].head();
        if (input == null) {
            return EmptySequence.getInstance();
        }
        return this.evalParseXml(input, context);
    }

    private NodeInfo evalParseXml(StringValue inputArg, XPathContext context) throws XPathException {
        NodeInfo node = null;
        String baseURI = this.getStaticBaseUriString();
        ParseXml.RetentiveErrorHandler errorHandler = new ParseXml.RetentiveErrorHandler();
        int attempt = 0;
        while (attempt++ < 3) {
            try {
                XMLReader reader;
                Controller controller = context.getController();
                if (controller == null) {
                    throw new XPathException("parse-xml-fragment() function is not available in this environment");
                }
                Configuration configuration = controller.getConfiguration();
                StringReader fragmentReader = new StringReader(inputArg.getStringValue());
                String skeleton = "<!DOCTYPE z [<!ENTITY e SYSTEM \"http://www.saxonica.com/parse-xml-fragment/actual.xml\">]>\n<z>&e;</z>";
                StringReader skeletonReader = new StringReader(skeleton);
                InputSource is = new InputSource(skeletonReader);
                is.setSystemId(baseURI);
                SAXSource source = new SAXSource(is);
                if (attempt == 1) {
                    reader = configuration.getSourceParser();
                    if (reader.getEntityResolver() != null) {
                        continue;
                    }
                } else {
                    reader = Version.platform.loadParserForXmlFragments();
                }
                ActiveSAXSource.configureParser(reader);
                source.setXMLReader(reader);
                source.setSystemId(baseURI);
                Builder b = controller.makeBuilder();
                b.setDurability(Durability.TEMPORARY);
                if (b instanceof TinyBuilder) {
                    ((TinyBuilder)b).setStatistics(controller.getConfiguration().getTreeStatistics().FN_PARSE_STATISTICS);
                }
                Receiver s2 = b;
                ParseOptions options = new ParseOptions().withSchemaValidationMode(4).withDTDValidationMode(4);
                ArrayList safetyCheck = new ArrayList();
                reader.setEntityResolver((publicId, systemId) -> {
                    if ("http://www.saxonica.com/parse-xml-fragment/actual.xml".equals(systemId)) {
                        safetyCheck.add(true);
                        InputSource is1 = new InputSource(fragmentReader);
                        is1.setSystemId(baseURI);
                        return is1;
                    }
                    return null;
                });
                PackageData pd = this.getRetainedStaticContext().getPackageData();
                if (pd instanceof StylesheetPackage) {
                    options = options.withSpaceStrippingRule(((StylesheetPackage)pd).getSpaceStrippingRule());
                    if (((StylesheetPackage)pd).isStripsTypeAnnotations()) {
                        s2 = configuration.getAnnotationStripper(s2);
                    }
                } else {
                    options = options.withSpaceStrippingRule(IgnorableSpaceStrippingRule.getInstance());
                }
                options = options.withErrorHandler(errorHandler);
                s2.setPipelineConfiguration(b.getPipelineConfiguration());
                options = options.withFilter(CSharp.methodRef(OuterElementStripper::new));
                try {
                    Sender.send(source, s2, options);
                }
                catch (XPathException e) {
                    if (safetyCheck.isEmpty()) {
                        if (attempt != 2) continue;
                        XPathException xe = new XPathException("The configured XML parser cannot be used by fn:parse-xml-fragment(), because it ignores the supplied EntityResolver", "FODC0006");
                        errorHandler.captureRetainedErrors(xe);
                        xe.maybeSetContext(context);
                        throw xe;
                    }
                    throw e;
                }
                node = b.getCurrentRoot();
                b.reset();
            }
            catch (XPathException err) {
                XPathException xe = new XPathException("First argument to parse-xml-fragment() is not a well-formed and namespace-well-formed XML fragment. XML parser reported: " + err.getMessage(), "FODC0006");
                errorHandler.captureRetainedErrors(xe);
                xe.maybeSetContext(context);
                throw xe;
            }
        }
        return node;
    }

    private static class OuterElementStripper
    extends ProxyReceiver {
        private int level = 0;
        private final boolean suppressStartContent = false;

        public OuterElementStripper(Receiver next) {
            super(next);
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            if (this.level++ > 0) {
                super.startElement(elemName, type, attributes, namespaces, location, properties);
            }
        }

        @Override
        public void endElement() throws XPathException {
            if (--this.level > 0) {
                super.endElement();
            }
        }
    }
}

