/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.math.BigInteger;
import java.util.function.Supplier;
import net.sf.saxon.expr.AscendingRangeIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class RangeExpression
extends Expression {
    private Operand start;
    private Operand step;
    private Operand end;
    private boolean defaultedStep;

    public static RangeExpression makeSteppingExpression(Expression lhs, Expression rhs) throws XPathException {
        if (!(lhs instanceof RangeExpression) || !((RangeExpression)lhs).defaultedStep) {
            throw new XPathException("Temporary restriction: 'by' operator must be preceded by 'x to y'");
        }
        return new RangeExpression(((RangeExpression)lhs).getStartExpression(), rhs, ((RangeExpression)lhs).getEndExpression());
    }

    public boolean isDefaultedStep() {
        return this.defaultedStep;
    }

    public RangeExpression(Expression start, Expression end) {
        this(start, new Literal(Int64Value.PLUS_ONE), end);
        this.defaultedStep = true;
    }

    public RangeExpression(Expression start, Expression step, Expression end) {
        this.start = new Operand(this, start, OperandRole.SINGLE_ATOMIC);
        this.step = new Operand(this, step, OperandRole.SINGLE_ATOMIC);
        this.end = new Operand(this, end, OperandRole.SINGLE_ATOMIC);
        this.adoptChildExpression(start);
        this.adoptChildExpression(step);
        this.adoptChildExpression(end);
    }

    public Expression getStartExpression() {
        return this.start.getChildExpression();
    }

    public Expression getStepExpression() {
        return this.step.getChildExpression();
    }

    public Expression getEndExpression() {
        return this.end.getChildExpression();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.start.typeCheck(visitor, contextInfo);
        this.step.typeCheck(visitor, contextInfo);
        this.end.typeCheck(visitor, contextInfo);
        boolean backCompat = visitor.getStaticContext().isInBackwardsCompatibleMode();
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(backCompat);
        Supplier<RoleDiagnostic> role0 = () -> new RoleDiagnostic(1, "to", 0);
        this.start.setChildExpression(tc.staticTypeCheck(this.getStartExpression(), SequenceType.OPTIONAL_INTEGER, role0, visitor));
        Supplier<RoleDiagnostic> role1 = () -> new RoleDiagnostic(1, "by", 1);
        this.step.setChildExpression(tc.staticTypeCheck(this.getStepExpression(), SequenceType.OPTIONAL_INTEGER, role1, visitor));
        Supplier<RoleDiagnostic> role2 = () -> new RoleDiagnostic(1, "to", 1);
        this.end.setChildExpression(tc.staticTypeCheck(this.getEndExpression(), SequenceType.OPTIONAL_INTEGER, role2, visitor));
        return this.makeConstantRange();
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.start.optimize(visitor, contextInfo);
        this.step.optimize(visitor, contextInfo);
        this.end.optimize(visitor, contextInfo);
        return this.makeConstantRange();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.start, this.step, this.end);
    }

    private Expression makeConstantRange() throws XPathException {
        if (this.getStartExpression() instanceof Literal && this.getStepExpression() instanceof Literal && this.getEndExpression() instanceof Literal) {
            Literal result;
            GroundedValue v0 = ((Literal)this.getStartExpression()).getGroundedValue();
            GroundedValue v1 = ((Literal)this.getStepExpression()).getGroundedValue();
            GroundedValue v2 = ((Literal)this.getEndExpression()).getGroundedValue();
            if (v0.getLength() == 0 || v1.getLength() == 0 || v2.getLength() == 0) {
                result = Literal.makeEmptySequence();
            } else if (v0 instanceof Int64Value && v1 instanceof Int64Value && v2 instanceof Int64Value) {
                long i0 = ((Int64Value)v0).longValue();
                long i1 = ((Int64Value)v1).longValue();
                long i2 = ((Int64Value)v2).longValue();
                if (i1 == 0L || i0 > i2) {
                    result = Literal.makeEmptySequence();
                } else {
                    if (Math.abs((i2 - i0) / i1) > Integer.MAX_VALUE) {
                        throw new XPathException("Maximum length of sequence in Saxon is 2147483647", "XPDY0130");
                    }
                    result = Literal.makeLiteral(i1 < 0L ? new IntegerRange(i2, i1, i0) : new IntegerRange(i0, i1, i2), this);
                }
            } else {
                BigInteger i0 = ((IntegerValue)v0).asBigInteger();
                BigInteger i1 = ((IntegerValue)v1).asBigInteger();
                BigInteger i2 = ((IntegerValue)v2).asBigInteger();
                if (i0.equals(BigInteger.ZERO) || i0.compareTo(i2) > 0) {
                    result = Literal.makeEmptySequence();
                } else if (i0.equals(i2)) {
                    result = Literal.makeLiteral(Int64Value.makeIntegerValue(i0), this);
                } else {
                    return this;
                }
            }
            ExpressionTool.copyLocationInfo(this, result);
            return result;
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.INTEGER;
    }

    @Override
    public UType getStaticUType(UType contextItemType) {
        return UType.DECIMAL;
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        IntegerValue[] start = this.getStartExpression().getIntegerBounds();
        IntegerValue[] end = this.getEndExpression().getIntegerBounds();
        if (start == null || end == null) {
            return null;
        }
        return new IntegerValue[]{start[0], end[1]};
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        RangeExpression exp = new RangeExpression(this.getStartExpression().copy(rebindings), this.getStepExpression().copy(rebindings), this.getEndExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public String getExpressionName() {
        return "range";
    }

    @Override
    protected int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x800000;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RangeExpression && this.hasCompatibleStaticContext((Expression)other)) {
            RangeExpression b = (RangeExpression)other;
            Expression start1 = this.getStartExpression();
            Expression step1 = this.getStepExpression();
            Expression end1 = this.getEndExpression();
            Expression start2 = b.getStartExpression();
            Expression step2 = b.getStepExpression();
            Expression end2 = b.getEndExpression();
            return start1.equals(start2) && step1.equals(step2) && end1.equals(end2);
        }
        return false;
    }

    @Override
    protected int computeHashCode() {
        return this.getStartExpression().hashCode() ^ this.getStepExpression().hashCode() << 3 ^ this.getEndExpression().hashCode() << 7;
    }

    @Override
    public String toString() {
        String by = this.getStepExpression().toString();
        return this.getStartExpression().toString() + " to " + this.getEndExpression().toString() + (by.equals("1") ? "" : " by " + by);
    }

    @Override
    public String toShortString() {
        String by = this.getStepExpression().toShortString();
        return this.getStartExpression().toShortString() + " to " + this.getEndExpression().toShortString() + (by.equals("1") ? "" : " by " + by);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("to", this);
        this.getStartExpression().export(out);
        this.getEndExpression().export(out);
        out.endElement();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        IntegerValue av1 = (IntegerValue)this.getStartExpression().evaluateItem(context);
        IntegerValue av2 = (IntegerValue)this.getStepExpression().evaluateItem(context);
        IntegerValue av3 = (IntegerValue)this.getEndExpression().evaluateItem(context);
        return AscendingRangeIterator.makeRangeIterator(av1, av2, av3);
    }

    @Override
    public Elaborator getElaborator() {
        return new RangeElaborator();
    }

    public static class RangeElaborator
    extends PullElaborator {
        @Override
        public PullEvaluator elaborateForPull() {
            RangeExpression expr = (RangeExpression)this.getExpression();
            ItemEvaluator iv1 = expr.getStartExpression().makeElaborator().elaborateForItem();
            ItemEvaluator iv2 = expr.getStepExpression().makeElaborator().elaborateForItem();
            ItemEvaluator iv3 = expr.getEndExpression().makeElaborator().elaborateForItem();
            return context -> {
                IntegerValue av1 = (IntegerValue)iv1.eval(context);
                IntegerValue av2 = (IntegerValue)iv2.eval(context);
                IntegerValue av3 = (IntegerValue)iv3.eval(context);
                return AscendingRangeIterator.makeRangeIterator(av1, av2, av3);
            };
        }
    }
}

