/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class IntegerRangeTest
extends Expression {
    private final Operand valueOp;
    private final Operand minOp;
    private final Operand maxOp;

    public IntegerRangeTest(Expression value, Expression min2, Expression max) {
        this.valueOp = new Operand(this, value, OperandRole.ATOMIC_SEQUENCE);
        this.minOp = new Operand(this, min2, OperandRole.SINGLE_ATOMIC);
        this.maxOp = new Operand(this, max, OperandRole.SINGLE_ATOMIC);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.valueOp, this.minOp, this.maxOp);
    }

    public Expression getValue() {
        return this.valueOp.getChildExpression();
    }

    public void setValue(Expression value) {
        this.valueOp.setChildExpression(value);
    }

    public Expression getMin() {
        return this.minOp.getChildExpression();
    }

    public void setMin(Expression min2) {
        this.minOp.setChildExpression(min2);
    }

    public Expression getMax() {
        return this.maxOp.getChildExpression();
    }

    public void setMax(Expression max) {
        this.maxOp.setChildExpression(max);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (Literal.isEmptySequence(this.getMin()) || Literal.isEmptySequence(this.getMax()) || Literal.isEmptySequence(this.getValue())) {
            return new Literal(BooleanValue.FALSE);
        }
        if (this.getMin() instanceof Literal && this.getMax() instanceof Literal && this.getValue() instanceof Literal) {
            BooleanValue result = this.evaluateItem(visitor.makeDynamicContext());
            return new Literal(result);
        }
        return this;
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        IntegerRangeTest exp = new IntegerRangeTest(this.getValue().copy(rebindings), this.getMin().copy(rebindings), this.getMax().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof IntegerRangeTest && ((IntegerRangeTest)other).getValue().isEqual(this.getValue()) && ((IntegerRangeTest)other).getMin().isEqual(this.getMin()) && ((IntegerRangeTest)other).getMax().isEqual(this.getMax());
    }

    @Override
    protected int computeHashCode() {
        int h2 = this.getValue().hashCode() + 77;
        return h2 ^= this.getMin().hashCode() ^ this.getMax().hashCode();
    }

    @Override
    public BooleanValue evaluateItem(XPathContext c) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(c));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        try {
            return IntegerRangeTest.eval(context -> this.getMin().evaluateItem(context), context -> this.getMax().evaluateItem(context), context -> this.getValue().iterate(context), c);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this.getLocation());
            throw e;
        }
    }

    public static boolean eval(ItemEvaluator minEval, ItemEvaluator maxEval, PullEvaluator valueEval, XPathContext c) throws XPathException {
        AtomicValue atom;
        IntegerValue minVal = null;
        IntegerValue maxVal = null;
        StringConverter toDouble = null;
        SequenceIterator iter = valueEval.iterate(c);
        while ((atom = (AtomicValue)iter.next()) != null) {
            NumericValue v;
            if (minVal == null) {
                minVal = (IntegerValue)minEval.eval(c);
                if (minVal == null) {
                    return false;
                }
                maxVal = (IntegerValue)maxEval.eval(c);
                if (maxVal == null || maxVal.compareTo(minVal) < 0) {
                    return false;
                }
            }
            if (atom.isUntypedAtomic()) {
                ConversionResult result;
                if (toDouble == null) {
                    toDouble = BuiltInAtomicType.DOUBLE.getStringConverter(c.getConfiguration().getConversionRules());
                }
                if ((result = toDouble.convertString(atom.getUnicodeStringValue())) instanceof ValidationFailure) {
                    throw new XPathException("Failed to convert untypedAtomic value {" + atom.getUnicodeStringValue() + "}  to xs:integer", "FORG0001");
                }
                v = (DoubleValue)result.asAtomic();
            } else if (atom instanceof NumericValue) {
                v = (NumericValue)atom;
            } else {
                XPathException e = new XPathException("Cannot compare value of type " + atom.getUType() + " to xs:integer", "XPTY0004");
                e.setIsTypeError(true);
                throw e;
            }
            if (!v.isWholeNumber() || v.compareTo(minVal) < 0 || v.compareTo(maxVal) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getExpressionName() {
        return "intRangeTest";
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("intRangeTest", this);
        this.getValue().export(destination);
        this.getMin().export(destination);
        this.getMax().export(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getValue()) + " = (" + ExpressionTool.parenthesize(this.getMin()) + " to " + ExpressionTool.parenthesize(this.getMax()) + ")";
    }

    @Override
    public Elaborator getElaborator() {
        return new IntegerRangeTestElaborator();
    }

    public static class IntegerRangeTestElaborator
    extends BooleanElaborator {
        @Override
        public BooleanEvaluator elaborateForBoolean() {
            IntegerRangeTest expr = (IntegerRangeTest)this.getExpression();
            ItemEvaluator iv1 = expr.getMin().makeElaborator().elaborateForItem();
            ItemEvaluator iv2 = expr.getMax().makeElaborator().elaborateForItem();
            PullEvaluator iv3 = expr.getValue().makeElaborator().elaborateForPull();
            return context -> IntegerRangeTest.eval(iv1, iv2, iv3, context);
        }
    }
}

