/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CompareToConstant;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

public class CompareToStringConstant
extends CompareToConstant {
    private final UnicodeString comparand;

    public CompareToStringConstant(Expression operand, int operator, UnicodeString comparand) {
        super(operand);
        this.operator = operator;
        this.comparand = comparand;
    }

    public UnicodeString getComparand() {
        return this.comparand;
    }

    @Override
    public Expression getRhsExpression() {
        return new StringLiteral(this.comparand);
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        CompareToStringConstant c2 = new CompareToStringConstant(this.getLhsExpression().copy(rebindings), this.operator, this.comparand);
        ExpressionTool.copyLocationInfo(this, c2);
        return c2;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof CompareToStringConstant && ((CompareToStringConstant)other).getLhsExpression().isEqual(this.getLhsExpression()) && ((CompareToStringConstant)other).comparand.equals(this.comparand) && ((CompareToStringConstant)other).operator == this.operator;
    }

    @Override
    protected int computeHashCode() {
        int h2 = 1212879520;
        return h2 + this.getLhsExpression().hashCode() ^ this.comparand.hashCode();
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        UnicodeString s2 = this.getLhsExpression().evaluateItem(context).getUnicodeStringValue();
        int c = CodepointCollator.getInstance().compareStrings(s2, this.comparand);
        return CompareToStringConstant.interpretComparisonResult(this.operator, c);
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public String getExpressionName() {
        return "compareToString";
    }

    @Override
    public void export(ExpressionPresenter destination) throws XPathException {
        destination.startElement("compareToString", this);
        destination.emitAttribute("op", Token.tokens[this.operator]);
        destination.emitAttribute("val", this.getComparand().toString());
        this.getLhsExpression().export(destination);
        destination.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getLhsExpression()) + " " + Token.tokens[this.operator] + " " + this.comparand.toString();
    }

    @Override
    public String toShortString() {
        return this.getLhsExpression().toShortString() + " " + Token.tokens[this.operator] + " \"" + this.comparand + "\"";
    }

    @Override
    public AtomicComparer getAtomicComparer() {
        return CodepointCollatingComparer.getInstance();
    }

    @Override
    public StringCollator getStringCollator() {
        return CodepointCollator.getInstance();
    }

    @Override
    public Elaborator getElaborator() {
        return new CompareToStringConstantElaborator();
    }

    public static class CompareToStringConstantElaborator
    extends BooleanElaborator {
        @Override
        public BooleanEvaluator elaborateForBoolean() {
            CompareToStringConstant expression = (CompareToStringConstant)this.getExpression();
            Expression arg = expression.getBaseExpression();
            UnicodeStringEvaluator argEval = arg.makeElaborator().elaborateForUnicodeString(false);
            boolean nullable = Cardinality.allowsZero(expression.getCardinality());
            int operator = expression.getComparisonOperator();
            UnicodeString comparand = expression.getComparand();
            return context -> {
                UnicodeString value = argEval.eval(context);
                if (nullable && value == null) {
                    return false;
                }
                int c = value.compareTo(comparand);
                return CompareToConstant.interpretComparisonResult(operator, c);
            };
        }
    }
}

