/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class SimplifyBooleanReturnCheck
extends AbstractCheck {
    public static final String MSG_KEY = "simplify.boolReturn";

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{83};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST elseLiteral = ast.findFirstToken(92);
        if (elseLiteral != null) {
            DetailAST elseStatement = elseLiteral.getFirstChild();
            DetailAST condition = ast.getFirstChild().getNextSibling();
            DetailAST thenStatement = condition.getNextSibling().getNextSibling();
            if (SimplifyBooleanReturnCheck.canReturnOnlyBooleanLiteral(thenStatement) && SimplifyBooleanReturnCheck.canReturnOnlyBooleanLiteral(elseStatement)) {
                this.log(ast, MSG_KEY, new Object[0]);
            }
        }
    }

    private static boolean canReturnOnlyBooleanLiteral(DetailAST ast) {
        boolean result = true;
        if (!SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(ast)) {
            DetailAST firstStatement = ast.getFirstChild();
            result = SimplifyBooleanReturnCheck.isBooleanLiteralReturnStatement(firstStatement);
        }
        return result;
    }

    private static boolean isBooleanLiteralReturnStatement(DetailAST ast) {
        DetailAST expr;
        boolean booleanReturnStatement = false;
        if (ast != null && ast.getType() == 88 && (expr = ast.getFirstChild()).getType() != 45) {
            DetailAST value = expr.getFirstChild();
            booleanReturnStatement = TokenUtil.isBooleanLiteralType(value.getType());
        }
        return booleanReturnStatement;
    }
}

