/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.CheckstyleParserErrorStrategy;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocNodeImpl;
import com.puppycrawl.tools.checkstyle.grammar.javadoc.JavadocLexer;
import com.puppycrawl.tools.checkstyle.grammar.javadoc.JavadocParser;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayDeque;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class JavadocDetailNodeParser {
    public static final String MSG_JAVADOC_MISSED_HTML_CLOSE = "javadoc.missed.html.close";
    public static final String MSG_JAVADOC_WRONG_SINGLETON_TAG = "javadoc.wrong.singleton.html.tag";
    public static final String MSG_JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
    public static final String MSG_UNCLOSED_HTML_TAG = "javadoc.unclosedHtml";
    private static final String JAVADOC_START = "/**";
    private int blockCommentLineNumber;

    public ParseStatus parseJavadocAsDetailNode(DetailAST javadocCommentAst) {
        this.blockCommentLineNumber = javadocCommentAst.getLineNo();
        String javadocComment = JavadocUtil.getJavadocCommentContent(javadocCommentAst);
        DescriptiveErrorListener errorListener = new DescriptiveErrorListener();
        errorListener.setOffset(javadocCommentAst.getLineNo() - 1);
        ParseStatus result = new ParseStatus();
        try {
            JavadocParser javadocParser = JavadocDetailNodeParser.createJavadocParser(javadocComment, errorListener);
            JavadocParser.JavadocContext javadocParseTree = javadocParser.javadoc();
            DetailNode tree = this.convertParseTreeToDetailNode(javadocParseTree);
            this.adjustFirstLineToJavadocIndent(tree, javadocCommentAst.getColumnNo() + JAVADOC_START.length());
            result.setTree(tree);
            result.firstNonTightHtmlTag = JavadocDetailNodeParser.getFirstNonTightHtmlTag(javadocParser, errorListener.offset);
        }
        catch (IllegalArgumentException | ParseCancellationException ex) {
            RecognitionException recognitionEx;
            ParseErrorMessage parseErrorMessage = null;
            if ((ex.getCause() instanceof FailedPredicateException || ex.getCause() instanceof NoViableAltException) && (recognitionEx = (RecognitionException)ex.getCause()).getCtx() instanceof JavadocParser.HtmlTagContext) {
                Token htmlTagNameStart = JavadocDetailNodeParser.getMissedHtmlTag(recognitionEx);
                parseErrorMessage = new ParseErrorMessage(errorListener.offset + htmlTagNameStart.getLine(), MSG_JAVADOC_MISSED_HTML_CLOSE, htmlTagNameStart.getCharPositionInLine(), htmlTagNameStart.getText());
            }
            if (parseErrorMessage == null) {
                parseErrorMessage = errorListener.getErrorMessage();
            }
            result.setParseErrorMessage(parseErrorMessage);
        }
        return result;
    }

    private static JavadocParser createJavadocParser(String blockComment, DescriptiveErrorListener errorListener) {
        JavadocLexer lexer = new JavadocLexer(CharStreams.fromString(blockComment), true);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        JavadocParser parser = new JavadocParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener(errorListener);
        parser.setErrorHandler(new CheckstyleParserErrorStrategy());
        return parser;
    }

    private DetailNode convertParseTreeToDetailNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode;
        JavadocNodeImpl currentJavadocParent = rootJavadocNode = this.createRootJavadocNode(parseTreeNode);
        ParseTree parseTreeParent = parseTreeNode;
        while (currentJavadocParent != null) {
            if (currentJavadocParent.getType() == 10074) {
                currentJavadocParent.setChildren(JavadocNodeImpl.EMPTY_DETAIL_NODE_ARRAY);
            }
            JavadocNodeImpl[] children = (JavadocNodeImpl[])currentJavadocParent.getChildren();
            this.insertChildrenNodes(children, parseTreeParent);
            if (children.length > 0) {
                currentJavadocParent = children[0];
                parseTreeParent = parseTreeParent.getChild(0);
                continue;
            }
            JavadocNodeImpl nextJavadocSibling = (JavadocNodeImpl)JavadocUtil.getNextSibling(currentJavadocParent);
            ParseTree nextParseTreeSibling = JavadocDetailNodeParser.getNextSibling(parseTreeParent);
            while (nextJavadocSibling == null) {
                currentJavadocParent = (JavadocNodeImpl)currentJavadocParent.getParent();
                parseTreeParent = parseTreeParent.getParent();
                if (currentJavadocParent == null) break;
                nextJavadocSibling = (JavadocNodeImpl)JavadocUtil.getNextSibling(currentJavadocParent);
                nextParseTreeSibling = JavadocDetailNodeParser.getNextSibling(parseTreeParent);
            }
            currentJavadocParent = nextJavadocSibling;
            parseTreeParent = nextParseTreeSibling;
        }
        return rootJavadocNode;
    }

    private void insertChildrenNodes(JavadocNodeImpl[] nodes, ParseTree parseTreeParent) {
        for (int i = 0; i < nodes.length; ++i) {
            JavadocNodeImpl currentJavadocNode = nodes[i];
            ParseTree currentParseTreeNodeChild = parseTreeParent.getChild(i);
            DetailNode[] subChildren = this.createChildrenNodes(currentJavadocNode, currentParseTreeNodeChild);
            currentJavadocNode.setChildren(subChildren);
        }
    }

    private JavadocNodeImpl[] createChildrenNodes(DetailNode parentJavadocNode, ParseTree parseTreeNode) {
        JavadocNodeImpl[] children = new JavadocNodeImpl[parseTreeNode.getChildCount()];
        for (int j = 0; j < children.length; ++j) {
            JavadocNodeImpl child;
            children[j] = child = this.createJavadocNode(parseTreeNode.getChild(j), parentJavadocNode, j);
        }
        return children;
    }

    private JavadocNodeImpl createRootJavadocNode(ParseTree parseTreeNode) {
        JavadocNodeImpl rootJavadocNode = this.createJavadocNode(parseTreeNode, null, -1);
        int childCount = parseTreeNode.getChildCount();
        DetailNode[] children = rootJavadocNode.getChildren();
        for (int i = 0; i < childCount; ++i) {
            JavadocNodeImpl child = this.createJavadocNode(parseTreeNode.getChild(i), rootJavadocNode, i);
            children[i] = child;
        }
        rootJavadocNode.setChildren(children);
        return rootJavadocNode;
    }

    private JavadocNodeImpl createJavadocNode(ParseTree parseTree, DetailNode parent, int index) {
        JavadocNodeImpl node = new JavadocNodeImpl();
        if (parseTree.getChildCount() == 0 || "Text".equals(JavadocDetailNodeParser.getNodeClassNameWithoutContext(parseTree))) {
            node.setText(parseTree.getText());
        } else {
            node.setText(JavadocDetailNodeParser.getFormattedNodeClassNameWithoutContext(parseTree));
        }
        node.setColumnNumber(JavadocDetailNodeParser.getColumn(parseTree));
        node.setLineNumber(JavadocDetailNodeParser.getLine(parseTree) + this.blockCommentLineNumber);
        node.setIndex(index);
        node.setType(JavadocDetailNodeParser.getTokenType(parseTree));
        node.setParent(parent);
        node.setChildren(new JavadocNodeImpl[parseTree.getChildCount()]);
        return node;
    }

    private void adjustFirstLineToJavadocIndent(DetailNode tree, int javadocColumnNumber) {
        if (tree.getLineNumber() == this.blockCommentLineNumber) {
            DetailNode[] children;
            ((JavadocNodeImpl)tree).setColumnNumber(tree.getColumnNumber() + javadocColumnNumber);
            for (DetailNode child : children = tree.getChildren()) {
                this.adjustFirstLineToJavadocIndent(child, javadocColumnNumber);
            }
        }
    }

    private static int getLine(ParseTree tree) {
        int line;
        if (tree instanceof TerminalNode) {
            line = ((TerminalNode)tree).getSymbol().getLine() - 1;
        } else {
            ParserRuleContext rule = (ParserRuleContext)tree;
            line = rule.start.getLine() - 1;
        }
        return line;
    }

    private static int getColumn(ParseTree tree) {
        int column;
        if (tree instanceof TerminalNode) {
            column = ((TerminalNode)tree).getSymbol().getCharPositionInLine();
        } else {
            ParserRuleContext rule = (ParserRuleContext)tree;
            column = rule.start.getCharPositionInLine();
        }
        return column;
    }

    private static ParseTree getNextSibling(ParseTree node) {
        ParseTree nextSibling = null;
        if (node.getParent() != null) {
            ParseTree parent = node.getParent();
            int index = 0;
            while (true) {
                ParseTree currentNode;
                if ((currentNode = parent.getChild(index)).equals(node)) {
                    nextSibling = parent.getChild(index + 1);
                    break;
                }
                ++index;
            }
        }
        return nextSibling;
    }

    private static int getTokenType(ParseTree node) {
        int tokenType;
        if (node.getChildCount() == 0) {
            tokenType = ((TerminalNode)node).getSymbol().getType();
        } else {
            String className = JavadocDetailNodeParser.getNodeClassNameWithoutContext(node);
            tokenType = JavadocUtil.getTokenId(JavadocDetailNodeParser.convertUpperCamelToUpperUnderscore(className));
        }
        return tokenType;
    }

    private static String getFormattedNodeClassNameWithoutContext(ParseTree node) {
        String classNameWithoutContext = JavadocDetailNodeParser.getNodeClassNameWithoutContext(node);
        return JavadocDetailNodeParser.convertUpperCamelToUpperUnderscore(classNameWithoutContext);
    }

    private static String getNodeClassNameWithoutContext(ParseTree node) {
        String className = node.getClass().getSimpleName();
        int contextLength = 7;
        return className.substring(0, className.length() - 7);
    }

    private static Token getMissedHtmlTag(RecognitionException exception) {
        Token htmlTagNameStart = null;
        Interval sourceInterval = exception.getCtx().getSourceInterval();
        List<Token> tokenList = ((BufferedTokenStream)exception.getInputStream()).getTokens(sourceInterval.a, sourceInterval.b);
        ArrayDeque<Token> stack = new ArrayDeque<Token>();
        int prevTokenType = -1;
        for (Token token : tokenList) {
            int tokenType = token.getType();
            if (tokenType == 100 && prevTokenType == 5) {
                stack.push(token);
            } else if (tokenType == 100 && !stack.isEmpty()) {
                if (((Token)stack.peek()).getText().equals(token.getText())) {
                    stack.pop();
                } else {
                    htmlTagNameStart = (Token)stack.pop();
                }
            }
            prevTokenType = tokenType;
        }
        if (htmlTagNameStart == null) {
            htmlTagNameStart = (Token)stack.pop();
        }
        return htmlTagNameStart;
    }

    private static Token getFirstNonTightHtmlTag(JavadocParser javadocParser, int javadocLineOffset) {
        CommonToken offendingToken;
        ParserRuleContext nonTightTagStartContext = javadocParser.nonTightTagStartContext;
        if (nonTightTagStartContext == null) {
            offendingToken = null;
        } else {
            Token token = ((TerminalNode)nonTightTagStartContext.getChild(1)).getSymbol();
            offendingToken = new CommonToken(token);
            offendingToken.setLine(offendingToken.getLine() + javadocLineOffset);
        }
        return offendingToken;
    }

    private static String convertUpperCamelToUpperUnderscore(String text) {
        StringBuilder result = new StringBuilder(20);
        boolean first = true;
        for (char letter : text.toCharArray()) {
            if (!first && Character.isUpperCase(letter)) {
                result.append('_');
            }
            result.append(Character.toUpperCase(letter));
            first = false;
        }
        return result.toString();
    }

    public static class ParseErrorMessage {
        private final int lineNumber;
        private final String messageKey;
        private final Object[] messageArguments;

        ParseErrorMessage(int lineNumber, String messageKey, Object ... messageArguments) {
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageArguments = (Object[])messageArguments.clone();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public Object[] getMessageArguments() {
            return (Object[])this.messageArguments.clone();
        }
    }

    public static class ParseStatus {
        private DetailNode tree;
        private ParseErrorMessage parseErrorMessage;
        private Token firstNonTightHtmlTag;

        public DetailNode getTree() {
            return this.tree;
        }

        public void setTree(DetailNode tree) {
            this.tree = tree;
        }

        public ParseErrorMessage getParseErrorMessage() {
            return this.parseErrorMessage;
        }

        public void setParseErrorMessage(ParseErrorMessage parseErrorMessage) {
            this.parseErrorMessage = parseErrorMessage;
        }

        public boolean isNonTight() {
            return this.firstNonTightHtmlTag != null;
        }

        public Token getFirstNonTightHtmlTag() {
            return this.firstNonTightHtmlTag;
        }
    }

    private static final class DescriptiveErrorListener
    extends BaseErrorListener {
        private int offset;
        private ParseErrorMessage errorMessage;

        private DescriptiveErrorListener() {
        }

        private ParseErrorMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            int lineNumber = this.offset + line;
            if (JavadocDetailNodeParser.MSG_JAVADOC_WRONG_SINGLETON_TAG.equals(msg)) {
                this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_WRONG_SINGLETON_TAG, charPositionInLine, ((Token)offendingSymbol).getText());
                throw new IllegalArgumentException(msg);
            }
            int ruleIndex = ex.getCtx().getRuleIndex();
            String ruleName = recognizer.getRuleNames()[ruleIndex];
            String upperCaseRuleName = JavadocDetailNodeParser.convertUpperCamelToUpperUnderscore(ruleName);
            this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_PARSE_RULE_ERROR, charPositionInLine, msg, upperCaseRuleName);
        }
    }
}

