/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.jcommander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jf.util.WrappedIndentingWriter;
import org.jf.util.jcommander.ExtendedCommands;
import org.jf.util.jcommander.ExtendedParameters;

public class HelpFormatter {
    private int width = 80;

    @Nonnull
    public HelpFormatter width(int width) {
        this.width = width;
        HelpFormatter helpFormatter = this;
        if (helpFormatter == null) {
            HelpFormatter.$$$reportNull$$$0(0);
        }
        return helpFormatter;
    }

    @Nonnull
    private static ExtendedParameters getExtendedParameters(JCommander jc) {
        ExtendedParameters anno = jc.getObjects().get(0).getClass().getAnnotation(ExtendedParameters.class);
        if (anno == null) {
            throw new IllegalStateException("All commands should have an ExtendedParameters annotation");
        }
        ExtendedParameters extendedParameters = anno;
        if (extendedParameters == null) {
            HelpFormatter.$$$reportNull$$$0(1);
        }
        return extendedParameters;
    }

    @Nonnull
    private static List<String> getCommandAliases(JCommander jc) {
        List list = Lists.newArrayList((Object[])HelpFormatter.getExtendedParameters(jc).commandAliases());
        if (list == null) {
            HelpFormatter.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static boolean includeParametersInUsage(@Nonnull JCommander jc) {
        if (jc == null) {
            HelpFormatter.$$$reportNull$$$0(3);
        }
        return HelpFormatter.getExtendedParameters(jc).includeParametersInUsage();
    }

    @Nonnull
    private static String getPostfixDescription(@Nonnull JCommander jc) {
        if (jc == null) {
            HelpFormatter.$$$reportNull$$$0(4);
        }
        String string = HelpFormatter.getExtendedParameters(jc).postfixDescription();
        if (string == null) {
            HelpFormatter.$$$reportNull$$$0(5);
        }
        return string;
    }

    private int getParameterArity(ParameterDescription param) {
        if (param.getParameter().arity() > 0) {
            return param.getParameter().arity();
        }
        Class type = param.getParameterized().getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            return 0;
        }
        return 1;
    }

    private List<ParameterDescription> getSortedParameters(JCommander jc) {
        List parameters = Lists.newArrayList((Collection)jc.getParameters());
        final Pattern pattern = Pattern.compile("^-*(.*)$");
        Collections.sort(parameters, new Comparator<ParameterDescription>(){

            @Override
            public int compare(ParameterDescription o1, ParameterDescription o2) {
                Matcher matcher = pattern.matcher(o1.getParameter().names()[0]);
                if (!matcher.matches()) {
                    throw new IllegalStateException();
                }
                String s1 = matcher.group(1);
                matcher = pattern.matcher(o2.getParameter().names()[0]);
                if (!matcher.matches()) {
                    throw new IllegalStateException();
                }
                String s2 = matcher.group(1);
                return s1.compareTo(s2);
            }
        });
        return parameters;
    }

    @Nonnull
    public String format(JCommander ... jc) {
        if (jc == null) {
            HelpFormatter.$$$reportNull$$$0(6);
        }
        String string = this.format(Arrays.asList(jc));
        if (string == null) {
            HelpFormatter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nonnull
    public String format(@Nonnull List<JCommander> commandHierarchy) {
        String string;
        if (commandHierarchy == null) {
            HelpFormatter.$$$reportNull$$$0(8);
        }
        try {
            String postfixDescription;
            StringWriter stringWriter = new StringWriter();
            WrappedIndentingWriter writer = new WrappedIndentingWriter(stringWriter, this.width - 5, this.width);
            JCommander leafJc = Iterables.getLast(commandHierarchy);
            writer.write("usage:");
            writer.indent(2);
            for (JCommander jc : commandHierarchy) {
                writer.write(" ");
                writer.write(ExtendedCommands.commandName(jc));
            }
            if (HelpFormatter.includeParametersInUsage(leafJc)) {
                for (ParameterDescription param : leafJc.getParameters()) {
                    if (param.getParameter().hidden()) continue;
                    writer.write(" [");
                    writer.write(param.getParameter().getParameter().names()[0]);
                    writer.write("]");
                }
            } else if (!leafJc.getParameters().isEmpty()) {
                writer.write(" [<options>]");
            }
            if (!leafJc.getCommands().isEmpty()) {
                writer.write(" [<command [<args>]]");
            }
            if (leafJc.getMainParameter() != null) {
                String[] argumentNames = ExtendedCommands.parameterArgumentNames(leafJc.getMainParameter());
                if (argumentNames.length == 0) {
                    writer.write(" <args>");
                } else {
                    String argumentName = argumentNames[0];
                    boolean writeAngleBrackets = !argumentName.startsWith("<") && !argumentName.startsWith("[");
                    writer.write(" ");
                    if (writeAngleBrackets) {
                        writer.write("<");
                    }
                    writer.write(argumentNames[0]);
                    if (writeAngleBrackets) {
                        writer.write(">");
                    }
                }
            }
            writer.deindent(2);
            String commandDescription = ExtendedCommands.getCommandDescription(leafJc);
            if (commandDescription != null) {
                writer.write("\n");
                writer.write(commandDescription);
            }
            if (!leafJc.getParameters().isEmpty() || leafJc.getMainParameter() != null) {
                writer.write("\n\nOptions:");
                writer.indent(2);
                for (ParameterDescription param : this.getSortedParameters(leafJc)) {
                    if (param.getParameter().hidden()) continue;
                    writer.write("\n");
                    writer.indent(4);
                    if (!param.getNames().isEmpty()) {
                        writer.write(Joiner.on(',').join(param.getParameter().names()));
                    }
                    if (this.getParameterArity(param) > 0) {
                        String[] argumentNames = ExtendedCommands.parameterArgumentNames(param);
                        for (int i = 0; i < this.getParameterArity(param); ++i) {
                            writer.write(" ");
                            if (i < argumentNames.length) {
                                writer.write("<");
                                writer.write(argumentNames[i]);
                                writer.write(">");
                                continue;
                            }
                            writer.write("<arg>");
                        }
                    }
                    if (param.getDescription() != null && !param.getDescription().isEmpty()) {
                        writer.write(" - ");
                        writer.write(param.getDescription());
                    }
                    if (param.getDefault() != null) {
                        String defaultValue = null;
                        if (param.getParameterized().getType() == Boolean.class || param.getParameterized().getType() == Boolean.TYPE) {
                            if (((Boolean)param.getDefault()).booleanValue()) {
                                defaultValue = "True";
                            }
                        } else if (List.class.isAssignableFrom(param.getParameterized().getType())) {
                            if (!((List)param.getDefault()).isEmpty()) {
                                defaultValue = param.getDefault().toString();
                            }
                        } else {
                            defaultValue = param.getDefault().toString();
                        }
                        if (defaultValue != null) {
                            writer.write(" (default: ");
                            writer.write(defaultValue);
                            writer.write(")");
                        }
                    }
                    writer.deindent(4);
                }
                if (leafJc.getMainParameter() != null) {
                    String[] argumentNames = ExtendedCommands.parameterArgumentNames(leafJc.getMainParameter());
                    writer.write("\n");
                    writer.indent(4);
                    if (argumentNames.length > 0) {
                        writer.write("<");
                        writer.write(argumentNames[0]);
                        writer.write(">");
                    } else {
                        writer.write("<args>");
                    }
                    if (leafJc.getMainParameterDescription() != null) {
                        writer.write(" - ");
                        writer.write(leafJc.getMainParameterDescription());
                    }
                    writer.deindent(4);
                }
                writer.deindent(2);
            }
            if (!leafJc.getCommands().isEmpty()) {
                writer.write("\n\nCommands:");
                writer.indent(2);
                List entryList = Lists.newArrayList(leafJc.getCommands().entrySet());
                Collections.sort(entryList, new Comparator<Map.Entry<String, JCommander>>(){

                    @Override
                    public int compare(Map.Entry<String, JCommander> o1, Map.Entry<String, JCommander> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                for (Map.Entry entry : entryList) {
                    String commandDesc;
                    String commandName = (String)entry.getKey();
                    JCommander command = (JCommander)entry.getValue();
                    Object arg = command.getObjects().get(0);
                    Parameters parametersAnno = arg.getClass().getAnnotation(Parameters.class);
                    if (parametersAnno.hidden()) continue;
                    writer.write("\n");
                    writer.indent(4);
                    writer.write(commandName);
                    List<String> aliases = HelpFormatter.getCommandAliases(command);
                    if (!aliases.isEmpty()) {
                        writer.write("(");
                        writer.write(Joiner.on(',').join(aliases));
                        writer.write(")");
                    }
                    if ((commandDesc = leafJc.getCommandDescription(commandName)) != null) {
                        writer.write(" - ");
                        writer.write(commandDesc);
                    }
                    writer.deindent(4);
                }
                writer.deindent(2);
            }
            if (!(postfixDescription = HelpFormatter.getPostfixDescription(leafJc)).isEmpty()) {
                writer.write("\n\n");
                writer.write(postfixDescription);
            }
            writer.flush();
            string = stringWriter.getBuffer().toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (string == null) {
            HelpFormatter.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/util/jcommander/HelpFormatter";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jc";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "width";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandAliases";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/util/jcommander/HelpFormatter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostfixDescription";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "includeParametersInUsage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPostfixDescription";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

