/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util.jcommander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.Parameterized;
import com.beust.jcommander.Parameters;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;

public class ExtendedCommands {
    @Nonnull
    private static ExtendedParameters getExtendedParameters(Object command) {
        ExtendedParameters anno = command.getClass().getAnnotation(ExtendedParameters.class);
        if (anno == null) {
            throw new IllegalStateException("All extended commands should have an ExtendedParameters annotation: " + command.getClass().getCanonicalName());
        }
        ExtendedParameters extendedParameters = anno;
        if (extendedParameters == null) {
            ExtendedCommands.$$$reportNull$$$0(0);
        }
        return extendedParameters;
    }

    @Nonnull
    public static String commandName(JCommander jc) {
        String string = ExtendedCommands.getExtendedParameters(jc.getObjects().get(0)).commandName();
        if (string == null) {
            ExtendedCommands.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nonnull
    public static String commandName(Object command) {
        String string = ExtendedCommands.getExtendedParameters(command).commandName();
        if (string == null) {
            ExtendedCommands.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nonnull
    public static String[] commandAliases(JCommander jc) {
        String[] stringArray = ExtendedCommands.commandAliases(jc.getObjects().get(0));
        if (stringArray == null) {
            ExtendedCommands.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] commandAliases(Object command) {
        String[] stringArray = ExtendedCommands.getExtendedParameters(command).commandAliases();
        if (stringArray == null) {
            ExtendedCommands.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public static boolean includeParametersInUsage(JCommander jc) {
        return ExtendedCommands.includeParametersInUsage(jc.getObjects().get(0));
    }

    public static boolean includeParametersInUsage(Object command) {
        return ExtendedCommands.getExtendedParameters(command).includeParametersInUsage();
    }

    @Nonnull
    public static String postfixDescription(JCommander jc) {
        String string = ExtendedCommands.postfixDescription(jc.getObjects().get(0));
        if (string == null) {
            ExtendedCommands.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nonnull
    public static String postfixDescription(Object command) {
        String string = ExtendedCommands.getExtendedParameters(command).postfixDescription();
        if (string == null) {
            ExtendedCommands.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void addExtendedCommand(JCommander jc, Command command) {
        jc.addCommand(ExtendedCommands.commandName(command), (Object)command, ExtendedCommands.commandAliases(command));
        command.setupCommand(command.getJCommander());
    }

    @Nonnull
    public static String[] parameterArgumentNames(ParameterDescription parameterDescription) {
        Parameterized parameterized = parameterDescription.getParameterized();
        Field field = null;
        for (Class<?> cls = parameterDescription.getObject().getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                field = cls.getDeclaredField(parameterized.getName());
                break;
            }
            catch (NoSuchFieldException ex) {
                continue;
            }
        }
        assert (field != null);
        ExtendedParameter extendedParameter = field.getAnnotation(ExtendedParameter.class);
        if (extendedParameter != null) {
            String[] stringArray = extendedParameter.argumentNames();
            if (stringArray == null) {
                ExtendedCommands.$$$reportNull$$$0(7);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{};
        if (stringArray == null) {
            ExtendedCommands.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @Nullable
    public static JCommander getSubcommand(JCommander jc, String commandName) {
        if (jc.getCommands().containsKey(commandName)) {
            return (JCommander)jc.getCommands().get(commandName);
        }
        for (JCommander command : jc.getCommands().values()) {
            for (String alias : ExtendedCommands.commandAliases(command)) {
                if (!commandName.equals(alias)) continue;
                return command;
            }
        }
        return null;
    }

    @Nullable
    public static String getCommandDescription(@Nonnull JCommander jc) {
        Parameters parameters;
        if (jc == null) {
            ExtendedCommands.$$$reportNull$$$0(9);
        }
        if ((parameters = jc.getObjects().get(0).getClass().getAnnotation(Parameters.class)) == null) {
            return null;
        }
        return parameters.commandDescription();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 9: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/util/jcommander/ExtendedCommands";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedParameters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "commandName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "commandAliases";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "postfixDescription";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterArgumentNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/util/jcommander/ExtendedCommands";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommandDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

