/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.util.ArraySortedSet;

public abstract class ImmutableConverter<ImmutableItem, Item> {
    protected abstract boolean isImmutable(@Nonnull Item var1);

    @Nonnull
    protected abstract ImmutableItem makeImmutable(@Nonnull Item var1);

    @Nonnull
    public ImmutableList<ImmutableItem> toList(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                ImmutableConverter.$$$reportNull$$$0(0);
            }
            return immutableList;
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableList) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            ImmutableList immutableList = (ImmutableList)iterable;
            if (immutableList == null) {
                ImmutableConverter.$$$reportNull$$$0(1);
            }
            return immutableList;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        ImmutableList immutableList = ImmutableList.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
        if (immutableList == null) {
            ImmutableConverter.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @Nonnull
    public ImmutableSet<ImmutableItem> toSet(@Nullable Iterable<? extends Item> iterable) {
        if (iterable == null) {
            ImmutableSet immutableSet = ImmutableSet.of();
            if (immutableSet == null) {
                ImmutableConverter.$$$reportNull$$$0(3);
            }
            return immutableSet;
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSet) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            ImmutableSet immutableSet = (ImmutableSet)iterable;
            if (immutableSet == null) {
                ImmutableConverter.$$$reportNull$$$0(4);
            }
            return immutableSet;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        ImmutableSet immutableSet = ImmutableSet.copyOf(new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
        if (immutableSet == null) {
            ImmutableConverter.$$$reportNull$$$0(5);
        }
        return immutableSet;
    }

    @Nonnull
    public ImmutableSortedSet<ImmutableItem> toSortedSet(@Nonnull Comparator<? super ImmutableItem> comparator, @Nullable Iterable<? extends Item> iterable) {
        if (comparator == null) {
            ImmutableConverter.$$$reportNull$$$0(6);
        }
        if (iterable == null) {
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.of();
            if (immutableSortedSet == null) {
                ImmutableConverter.$$$reportNull$$$0(7);
            }
            return immutableSortedSet;
        }
        boolean needsCopy = false;
        if (iterable instanceof ImmutableSortedSet && ((ImmutableSortedSet)iterable).comparator().equals(comparator)) {
            for (Item element : iterable) {
                if (this.isImmutable(element)) continue;
                needsCopy = true;
                break;
            }
        } else {
            needsCopy = true;
        }
        if (!needsCopy) {
            ImmutableSortedSet immutableSortedSet = (ImmutableSortedSet)iterable;
            if (immutableSortedSet == null) {
                ImmutableConverter.$$$reportNull$$$0(8);
            }
            return immutableSortedSet;
        }
        final Iterator<? extends Item> iter = iterable.iterator();
        ImmutableSortedSet<? super ImmutableItem> immutableSortedSet = ImmutableSortedSet.copyOf(comparator, new Iterator<ImmutableItem>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public ImmutableItem next() {
                return ImmutableConverter.this.makeImmutable(iter.next());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
        if (immutableSortedSet == null) {
            ImmutableConverter.$$$reportNull$$$0(9);
        }
        return immutableSortedSet;
    }

    @Nonnull
    public SortedSet<ImmutableItem> toSortedSet(@Nonnull Comparator<? super ImmutableItem> comparator, @Nullable SortedSet<? extends Item> sortedSet) {
        if (comparator == null) {
            ImmutableConverter.$$$reportNull$$$0(10);
        }
        if (sortedSet == null || sortedSet.size() == 0) {
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.of();
            if (immutableSortedSet == null) {
                ImmutableConverter.$$$reportNull$$$0(11);
            }
            return immutableSortedSet;
        }
        Object[] newItems = new Object[sortedSet.size()];
        int index = 0;
        for (Object item : sortedSet) {
            newItems[index++] = this.makeImmutable(item);
        }
        ArraySortedSet<Object> arraySortedSet = ArraySortedSet.of(comparator, newItems);
        if (arraySortedSet == null) {
            ImmutableConverter.$$$reportNull$$$0(12);
        }
        return arraySortedSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 10: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/util/ImmutableConverter";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toSet";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/util/ImmutableConverter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toSortedSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toSortedSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

