/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nonnull;

public class CollectionUtils {
    public static <T> int listHashCode(@Nonnull Iterable<T> iterable) {
        if (iterable == null) {
            CollectionUtils.$$$reportNull$$$0(0);
        }
        int hashCode = 1;
        for (T item : iterable) {
            hashCode = hashCode * 31 + item.hashCode();
        }
        return hashCode;
    }

    public static <T> int lastIndexOf(@Nonnull Iterable<T> iterable, @Nonnull Predicate<? super T> predicate) {
        if (iterable == null) {
            CollectionUtils.$$$reportNull$$$0(1);
        }
        if (predicate == null) {
            CollectionUtils.$$$reportNull$$$0(2);
        }
        int index = 0;
        int lastMatchingIndex = -1;
        for (T item : iterable) {
            if (predicate.apply(item)) {
                lastMatchingIndex = index;
            }
            ++index;
        }
        return lastMatchingIndex;
    }

    public static <T extends Comparable<? super T>> int compareAsList(@Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res;
        if (list1 == null) {
            CollectionUtils.$$$reportNull$$$0(3);
        }
        if (list2 == null) {
            CollectionUtils.$$$reportNull$$$0(4);
        }
        if ((res = Ints.compare(list1.size(), list2.size())) != 0) {
            return res;
        }
        Iterator<T> elements2 = list2.iterator();
        for (Comparable element1 : list1) {
            res = element1.compareTo(elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int compareAsIterable(@Nonnull Comparator<? super T> comparator, @Nonnull Iterable<? extends T> it1, @Nonnull Iterable<? extends T> it2) {
        if (comparator == null) {
            CollectionUtils.$$$reportNull$$$0(5);
        }
        if (it1 == null) {
            CollectionUtils.$$$reportNull$$$0(6);
        }
        if (it2 == null) {
            CollectionUtils.$$$reportNull$$$0(7);
        }
        Iterator<T> elements2 = it2.iterator();
        for (T element1 : it1) {
            T element2;
            try {
                element2 = elements2.next();
            }
            catch (NoSuchElementException ex) {
                return 1;
            }
            int res = comparator.compare(element1, element2);
            if (res == 0) continue;
            return res;
        }
        if (elements2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T extends Comparable<? super T>> int compareAsIterable(@Nonnull Iterable<? extends T> it1, @Nonnull Iterable<? extends T> it2) {
        if (it1 == null) {
            CollectionUtils.$$$reportNull$$$0(8);
        }
        if (it2 == null) {
            CollectionUtils.$$$reportNull$$$0(9);
        }
        Iterator<T> elements2 = it2.iterator();
        for (Comparable element1 : it1) {
            Comparable element2;
            try {
                element2 = (Comparable)elements2.next();
            }
            catch (NoSuchElementException ex) {
                return 1;
            }
            int res = element1.compareTo(element2);
            if (res == 0) continue;
            return res;
        }
        if (elements2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T> int compareAsList(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res;
        if (elementComparator == null) {
            CollectionUtils.$$$reportNull$$$0(10);
        }
        if (list1 == null) {
            CollectionUtils.$$$reportNull$$$0(11);
        }
        if (list2 == null) {
            CollectionUtils.$$$reportNull$$$0(12);
        }
        if ((res = Ints.compare(list1.size(), list2.size())) != 0) {
            return res;
        }
        Iterator<T> elements2 = list2.iterator();
        for (T element1 : list1) {
            res = elementComparator.compare(element1, elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Nonnull
    public static <T> Comparator<Collection<? extends T>> listComparator(final @Nonnull Comparator<? super T> elementComparator) {
        if (elementComparator == null) {
            CollectionUtils.$$$reportNull$$$0(13);
        }
        Comparator comparator = new Comparator<Collection<? extends T>>(){

            @Override
            public int compare(Collection<? extends T> list1, Collection<? extends T> list2) {
                return CollectionUtils.compareAsList(elementComparator, list1, list2);
            }
        };
        if (comparator == null) {
            CollectionUtils.$$$reportNull$$$0(14);
        }
        return comparator;
    }

    public static <T> boolean isNaturalSortedSet(@Nonnull Iterable<? extends T> it) {
        if (it == null) {
            CollectionUtils.$$$reportNull$$$0(15);
        }
        if (it instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)it;
            Comparator comparator = sortedSet.comparator();
            return comparator == null || comparator.equals(Ordering.natural());
        }
        return false;
    }

    public static <T> boolean isSortedSet(@Nonnull Comparator<? extends T> elementComparator, @Nonnull Iterable<? extends T> it) {
        if (elementComparator == null) {
            CollectionUtils.$$$reportNull$$$0(16);
        }
        if (it == null) {
            CollectionUtils.$$$reportNull$$$0(17);
        }
        if (it instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)it;
            Comparator comparator = sortedSet.comparator();
            if (comparator == null) {
                return elementComparator.equals(Ordering.natural());
            }
            return elementComparator.equals(comparator);
        }
        return false;
    }

    @Nonnull
    private static <T> SortedSet<? extends T> toNaturalSortedSet(@Nonnull Collection<? extends T> collection) {
        if (collection == null) {
            CollectionUtils.$$$reportNull$$$0(18);
        }
        if (CollectionUtils.isNaturalSortedSet(collection)) {
            SortedSet sortedSet = (SortedSet)collection;
            if (sortedSet == null) {
                CollectionUtils.$$$reportNull$$$0(19);
            }
            return sortedSet;
        }
        ImmutableSortedSet<? extends T> immutableSortedSet = ImmutableSortedSet.copyOf(collection);
        if (immutableSortedSet == null) {
            CollectionUtils.$$$reportNull$$$0(20);
        }
        return immutableSortedSet;
    }

    @Nonnull
    private static <T> SortedSet<? extends T> toSortedSet(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> collection) {
        SortedSet sortedSet;
        Comparator comparator;
        if (elementComparator == null) {
            CollectionUtils.$$$reportNull$$$0(21);
        }
        if (collection == null) {
            CollectionUtils.$$$reportNull$$$0(22);
        }
        if (collection instanceof SortedSet && (comparator = (sortedSet = (SortedSet)collection).comparator()) != null && comparator.equals(elementComparator)) {
            SortedSet sortedSet2 = sortedSet;
            if (sortedSet2 == null) {
                CollectionUtils.$$$reportNull$$$0(23);
            }
            return sortedSet2;
        }
        ImmutableSortedSet<? extends T> immutableSortedSet = ImmutableSortedSet.copyOf(elementComparator, collection);
        if (immutableSortedSet == null) {
            CollectionUtils.$$$reportNull$$$0(24);
        }
        return immutableSortedSet;
    }

    @Nonnull
    public static <T> Comparator<Collection<? extends T>> setComparator(final @Nonnull Comparator<? super T> elementComparator) {
        if (elementComparator == null) {
            CollectionUtils.$$$reportNull$$$0(25);
        }
        Comparator comparator = new Comparator<Collection<? extends T>>(){

            @Override
            public int compare(Collection<? extends T> list1, Collection<? extends T> list2) {
                return CollectionUtils.compareAsSet(elementComparator, list1, list2);
            }
        };
        if (comparator == null) {
            CollectionUtils.$$$reportNull$$$0(26);
        }
        return comparator;
    }

    public static <T extends Comparable<T>> int compareAsSet(@Nonnull Collection<? extends T> set1, @Nonnull Collection<? extends T> set2) {
        int res;
        if (set1 == null) {
            CollectionUtils.$$$reportNull$$$0(27);
        }
        if (set2 == null) {
            CollectionUtils.$$$reportNull$$$0(28);
        }
        if ((res = Ints.compare(set1.size(), set2.size())) != 0) {
            return res;
        }
        SortedSet<? extends T> sortedSet1 = CollectionUtils.toNaturalSortedSet(set1);
        SortedSet<? extends T> sortedSet2 = CollectionUtils.toNaturalSortedSet(set2);
        Iterator<T> elements2 = set2.iterator();
        for (Comparable element1 : set1) {
            res = element1.compareTo(elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public static <T> int compareAsSet(@Nonnull Comparator<? super T> elementComparator, @Nonnull Collection<? extends T> list1, @Nonnull Collection<? extends T> list2) {
        int res;
        if (elementComparator == null) {
            CollectionUtils.$$$reportNull$$$0(29);
        }
        if (list1 == null) {
            CollectionUtils.$$$reportNull$$$0(30);
        }
        if (list2 == null) {
            CollectionUtils.$$$reportNull$$$0(31);
        }
        if ((res = Ints.compare(list1.size(), list2.size())) != 0) {
            return res;
        }
        SortedSet set1 = CollectionUtils.toSortedSet(elementComparator, list1);
        SortedSet set2 = CollectionUtils.toSortedSet(elementComparator, list2);
        Iterator elements2 = set2.iterator();
        for (Object element1 : set1) {
            res = elementComparator.compare(element1, elements2.next());
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 3: 
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 4: 
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementComparator";
                break;
            }
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/util/CollectionUtils";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/util/CollectionUtils";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "listComparator";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toNaturalSortedSet";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "toSortedSet";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "listHashCode";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareAsList";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareAsIterable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "listComparator";
                break;
            }
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNaturalSortedSet";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSortedSet";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toNaturalSortedSet";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toSortedSet";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setComparator";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareAsSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

