/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;

public class ArraySortedSet<T>
implements SortedSet<T> {
    @Nonnull
    private final Comparator<? super T> comparator;
    @Nonnull
    private final Object[] arr;

    private ArraySortedSet(@Nonnull Comparator<? super T> comparator, @Nonnull T[] arr) {
        if (comparator == null) {
            ArraySortedSet.$$$reportNull$$$0(0);
        }
        if (arr == null) {
            ArraySortedSet.$$$reportNull$$$0(1);
        }
        this.comparator = comparator;
        this.arr = arr;
    }

    public static <T> ArraySortedSet<T> of(@Nonnull Comparator<? super T> comparator, @Nonnull T[] arr) {
        if (comparator == null) {
            ArraySortedSet.$$$reportNull$$$0(2);
        }
        if (arr == null) {
            ArraySortedSet.$$$reportNull$$$0(3);
        }
        return new ArraySortedSet<T>(comparator, arr);
    }

    @Override
    public int size() {
        return this.arr.length;
    }

    @Override
    public boolean isEmpty() {
        return this.arr.length > 0;
    }

    @Override
    public boolean contains(Object o) {
        return Arrays.binarySearch(this.arr, o, this.comparator) >= 0;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.forArray(this.arr);
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.arr.clone();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length <= this.arr.length) {
            System.arraycopy(this.arr, 0, a, 0, this.arr.length);
            return a;
        }
        return Arrays.copyOf(this.arr, this.arr.length);
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T first() {
        if (this.arr.length == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.arr[0];
    }

    @Override
    public T last() {
        if (this.arr.length == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.arr[this.arr.length - 1];
    }

    @Override
    public int hashCode() {
        int result = 0;
        for (Object o : this.arr) {
            result += o.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof SortedSet) {
            SortedSet other = (SortedSet)o;
            if (this.arr.length != other.size()) {
                return false;
            }
            return Iterators.elementsEqual(this.iterator(), other.iterator());
        }
        if (o instanceof Set) {
            Set other = (Set)o;
            if (this.arr.length != other.size()) {
                return false;
            }
            return this.containsAll(other);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
        }
        objectArray2[1] = "org/jf/util/ArraySortedSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "of";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

