/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.TypeListPool;

class PoolClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    final ClassDef classDef;
    @Nonnull
    final TypeListPool.Key<List<String>> interfaces;
    @Nonnull
    final ImmutableSortedSet<Field> staticFields;
    @Nonnull
    final ImmutableSortedSet<Field> instanceFields;
    @Nonnull
    final ImmutableSortedSet<PoolMethod> directMethods;
    @Nonnull
    final ImmutableSortedSet<PoolMethod> virtualMethods;
    int classDefIndex;
    int encodedArrayOffset;
    int annotationDirectoryOffset;

    PoolClassDef(@Nonnull ClassDef classDef) {
        if (classDef == null) {
            PoolClassDef.$$$reportNull$$$0(0);
        }
        this.classDefIndex = -1;
        this.encodedArrayOffset = 0;
        this.annotationDirectoryOffset = 0;
        this.classDef = classDef;
        this.interfaces = new TypeListPool.Key<ImmutableList<String>>(ImmutableList.copyOf(classDef.getInterfaces()));
        this.staticFields = ImmutableSortedSet.copyOf(classDef.getStaticFields());
        this.instanceFields = ImmutableSortedSet.copyOf(classDef.getInstanceFields());
        this.directMethods = ImmutableSortedSet.copyOf(Iterables.transform(classDef.getDirectMethods(), PoolMethod.TRANSFORM));
        this.virtualMethods = ImmutableSortedSet.copyOf(Iterables.transform(classDef.getVirtualMethods(), PoolMethod.TRANSFORM));
    }

    @Override
    @Nonnull
    public String getType() {
        String string = this.classDef.getType();
        if (string == null) {
            PoolClassDef.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public int getAccessFlags() {
        return this.classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.classDef.getSuperclass();
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        List list = (List)this.interfaces.types;
        if (list == null) {
            PoolClassDef.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.classDef.getSourceFile();
    }

    @Override
    @Nonnull
    public Set<? extends Annotation> getAnnotations() {
        Set<? extends Annotation> set = this.classDef.getAnnotations();
        if (set == null) {
            PoolClassDef.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Nonnull
    public SortedSet<Field> getStaticFields() {
        ImmutableSortedSet<Field> immutableSortedSet = this.staticFields;
        if (immutableSortedSet == null) {
            PoolClassDef.$$$reportNull$$$0(4);
        }
        return immutableSortedSet;
    }

    @Nonnull
    public SortedSet<Field> getInstanceFields() {
        ImmutableSortedSet<Field> immutableSortedSet = this.instanceFields;
        if (immutableSortedSet == null) {
            PoolClassDef.$$$reportNull$$$0(5);
        }
        return immutableSortedSet;
    }

    @Nonnull
    public Collection<Field> getFields() {
        AbstractCollection<Field> abstractCollection = new AbstractCollection<Field>(){

            @Override
            @Nonnull
            public Iterator<Field> iterator() {
                UnmodifiableIterator<Field> unmodifiableIterator = Iterators.mergeSorted(ImmutableList.of(PoolClassDef.this.staticFields.iterator(), PoolClassDef.this.instanceFields.iterator()), Ordering.natural());
                if (unmodifiableIterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return unmodifiableIterator;
            }

            @Override
            public int size() {
                return PoolClassDef.this.staticFields.size() + PoolClassDef.this.instanceFields.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/writer/pool/PoolClassDef$1", "iterator"));
            }
        };
        if (abstractCollection == null) {
            PoolClassDef.$$$reportNull$$$0(6);
        }
        return abstractCollection;
    }

    @Nonnull
    public SortedSet<PoolMethod> getDirectMethods() {
        ImmutableSortedSet<PoolMethod> immutableSortedSet = this.directMethods;
        if (immutableSortedSet == null) {
            PoolClassDef.$$$reportNull$$$0(7);
        }
        return immutableSortedSet;
    }

    @Nonnull
    public SortedSet<PoolMethod> getVirtualMethods() {
        ImmutableSortedSet<PoolMethod> immutableSortedSet = this.virtualMethods;
        if (immutableSortedSet == null) {
            PoolClassDef.$$$reportNull$$$0(8);
        }
        return immutableSortedSet;
    }

    @Nonnull
    public Collection<PoolMethod> getMethods() {
        AbstractCollection<PoolMethod> abstractCollection = new AbstractCollection<PoolMethod>(){

            @Override
            @Nonnull
            public Iterator<PoolMethod> iterator() {
                UnmodifiableIterator<PoolMethod> unmodifiableIterator = Iterators.mergeSorted(ImmutableList.of(PoolClassDef.this.directMethods.iterator(), PoolClassDef.this.virtualMethods.iterator()), Ordering.natural());
                if (unmodifiableIterator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return unmodifiableIterator;
            }

            @Override
            public int size() {
                return PoolClassDef.this.directMethods.size() + PoolClassDef.this.virtualMethods.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/jf/dexlib2/writer/pool/PoolClassDef$2", "iterator"));
            }
        };
        if (abstractCollection == null) {
            PoolClassDef.$$$reportNull$$$0(9);
        }
        return abstractCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/pool/PoolClassDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/pool/PoolClassDef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaces";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMethods";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

