/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.writer.DexWriter;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.dexlib2.writer.pool.AnnotationPool;
import org.jf.dexlib2.writer.pool.AnnotationSetPool;
import org.jf.dexlib2.writer.pool.ClassPool;
import org.jf.dexlib2.writer.pool.FieldPool;
import org.jf.dexlib2.writer.pool.Markable;
import org.jf.dexlib2.writer.pool.MethodPool;
import org.jf.dexlib2.writer.pool.PoolClassDef;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.ProtoPool;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.dexlib2.writer.pool.TypePool;
import org.jf.util.ExceptionWithContext;

public class DexPool
extends DexWriter<CharSequence, StringReference, CharSequence, TypeReference, MethodProtoReference, FieldReference, MethodReference, PoolClassDef, Annotation, Set<? extends Annotation>, TypeListPool.Key<? extends Collection<? extends CharSequence>>, Field, PoolMethod, EncodedValue, AnnotationElement, StringPool, TypePool, ProtoPool, FieldPool, MethodPool, ClassPool, TypeListPool, AnnotationPool, AnnotationSetPool> {
    private final Markable[] sections;

    public DexPool(Opcodes opcodes) {
        super(opcodes);
        this.sections = new Markable[]{(Markable)((Object)this.stringSection), (Markable)((Object)this.typeSection), (Markable)((Object)this.protoSection), (Markable)((Object)this.fieldSection), (Markable)((Object)this.methodSection), (Markable)((Object)this.classSection), (Markable)((Object)this.typeListSection), (Markable)((Object)this.annotationSection), (Markable)((Object)this.annotationSetSection)};
    }

    @Override
    @Nonnull
    protected DexWriter.SectionProvider getSectionProvider() {
        DexPoolSectionProvider dexPoolSectionProvider = new DexPoolSectionProvider();
        if (dexPoolSectionProvider == null) {
            DexPool.$$$reportNull$$$0(0);
        }
        return dexPoolSectionProvider;
    }

    public static void writeTo(@Nonnull DexDataStore dataStore, @Nonnull DexFile input) throws IOException {
        if (dataStore == null) {
            DexPool.$$$reportNull$$$0(1);
        }
        if (input == null) {
            DexPool.$$$reportNull$$$0(2);
        }
        DexPool dexPool = new DexPool(input.getOpcodes());
        for (ClassDef classDef : input.getClasses()) {
            dexPool.internClass(classDef);
        }
        dexPool.writeTo(dataStore);
    }

    public static void writeTo(@Nonnull String path, @Nonnull DexFile input) throws IOException {
        if (path == null) {
            DexPool.$$$reportNull$$$0(3);
        }
        if (input == null) {
            DexPool.$$$reportNull$$$0(4);
        }
        DexPool dexPool = new DexPool(input.getOpcodes());
        for (ClassDef classDef : input.getClasses()) {
            dexPool.internClass(classDef);
        }
        dexPool.writeTo(new FileDataStore(new File(path)));
    }

    public void internClass(ClassDef classDef) {
        ((ClassPool)this.classSection).intern(classDef);
    }

    public void mark() {
        for (Markable section : this.sections) {
            section.mark();
        }
    }

    public void reset() {
        for (Markable section : this.sections) {
            section.reset();
        }
    }

    @Override
    protected void writeEncodedValue(@Nonnull DexWriter.InternalEncodedValueWriter writer, @Nonnull EncodedValue encodedValue) throws IOException {
        if (writer == null) {
            DexPool.$$$reportNull$$$0(5);
        }
        if (encodedValue == null) {
            DexPool.$$$reportNull$$$0(6);
        }
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.getType(), annotationEncodedValue.getElements());
                break;
            }
            case 28: {
                ArrayEncodedValue arrayEncodedValue = (ArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.getValue());
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)encodedValue).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)encodedValue).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)encodedValue).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)encodedValue).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)encodedValue).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)encodedValue).getValue());
                break;
            }
            case 23: {
                writer.writeString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                writer.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    void internEncodedValue(@Nonnull EncodedValue encodedValue) {
        if (encodedValue == null) {
            DexPool.$$$reportNull$$$0(7);
        }
        switch (encodedValue.getValueType()) {
            case 29: {
                AnnotationEncodedValue annotationEncodedValue = (AnnotationEncodedValue)encodedValue;
                ((TypePool)this.typeSection).intern(annotationEncodedValue.getType());
                for (AnnotationElement annotationElement : annotationEncodedValue.getElements()) {
                    ((StringPool)this.stringSection).intern(annotationElement.getName());
                    this.internEncodedValue(annotationElement.getValue());
                }
                break;
            }
            case 28: {
                for (EncodedValue encodedValue2 : ((ArrayEncodedValue)encodedValue).getValue()) {
                    this.internEncodedValue(encodedValue2);
                }
                break;
            }
            case 23: {
                ((StringPool)this.stringSection).intern(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                ((TypePool)this.typeSection).intern(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                ((FieldPool)this.fieldSection).intern(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                ((FieldPool)this.fieldSection).intern(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                ((MethodPool)this.methodSection).intern(((MethodEncodedValue)encodedValue).getValue());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/pool/DexPool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/pool/DexPool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeEncodedValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "internEncodedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class DexPoolSectionProvider
    extends DexWriter.SectionProvider {
        protected DexPoolSectionProvider() {
        }

        @Nonnull
        public StringPool getStringSection() {
            StringPool stringPool = new StringPool(DexPool.this);
            if (stringPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(0);
            }
            return stringPool;
        }

        @Nonnull
        public TypePool getTypeSection() {
            TypePool typePool = new TypePool(DexPool.this);
            if (typePool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(1);
            }
            return typePool;
        }

        @Nonnull
        public ProtoPool getProtoSection() {
            ProtoPool protoPool = new ProtoPool(DexPool.this);
            if (protoPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(2);
            }
            return protoPool;
        }

        @Nonnull
        public FieldPool getFieldSection() {
            FieldPool fieldPool = new FieldPool(DexPool.this);
            if (fieldPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(3);
            }
            return fieldPool;
        }

        @Nonnull
        public MethodPool getMethodSection() {
            MethodPool methodPool = new MethodPool(DexPool.this);
            if (methodPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(4);
            }
            return methodPool;
        }

        @Nonnull
        public ClassPool getClassSection() {
            ClassPool classPool = new ClassPool(DexPool.this);
            if (classPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(5);
            }
            return classPool;
        }

        @Nonnull
        public TypeListPool getTypeListSection() {
            TypeListPool typeListPool = new TypeListPool(DexPool.this);
            if (typeListPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(6);
            }
            return typeListPool;
        }

        @Nonnull
        public AnnotationPool getAnnotationSection() {
            AnnotationPool annotationPool = new AnnotationPool(DexPool.this);
            if (annotationPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(7);
            }
            return annotationPool;
        }

        @Nonnull
        public AnnotationSetPool getAnnotationSetSection() {
            AnnotationSetPool annotationSetPool = new AnnotationSetPool(DexPool.this);
            if (annotationSetPool == null) {
                DexPoolSectionProvider.$$$reportNull$$$0(8);
            }
            return annotationSetPool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jf/dexlib2/writer/pool/DexPool$DexPoolSectionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringSection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeSection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProtoSection";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSection";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodSection";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassSection";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeListSection";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationSection";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationSetSection";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", objectArray));
        }
    }
}

