/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.dexlib2.writer.pool.Markable;

public class BasePool<Key, Value>
implements Markable {
    @Nonnull
    protected final DexPool dexPool;
    @Nonnull
    protected final Map<Key, Value> internedItems;
    private int markedItemCount;

    public BasePool(@Nonnull DexPool dexPool) {
        if (dexPool == null) {
            BasePool.$$$reportNull$$$0(0);
        }
        this.internedItems = Maps.newLinkedHashMap();
        this.markedItemCount = -1;
        this.dexPool = dexPool;
    }

    @Override
    public void mark() {
        this.markedItemCount = this.internedItems.size();
    }

    @Override
    public void reset() {
        if (this.markedItemCount < 0) {
            throw new IllegalStateException("mark() must be called before calling reset()");
        }
        if (this.markedItemCount == this.internedItems.size()) {
            return;
        }
        Iterator<Key> keys = this.internedItems.keySet().iterator();
        for (int i = 0; i < this.markedItemCount; ++i) {
            keys.next();
        }
        while (keys.hasNext()) {
            keys.next();
            keys.remove();
        }
    }

    public int getItemCount() {
        return this.internedItems.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "dexPool", "org/jf/dexlib2/writer/pool/BasePool", "<init>"));
    }
}

