/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.io;

import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.writer.io.DeferredOutputStream;
import org.jf.dexlib2.writer.io.DeferredOutputStreamFactory;

public class FileDeferredOutputStream
extends DeferredOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    @Nonnull
    private final File backingFile;
    @Nonnull
    private final NakedBufferedOutputStream output;
    private int writtenBytes;

    public FileDeferredOutputStream(@Nonnull File backingFile) throws FileNotFoundException {
        if (backingFile == null) {
            FileDeferredOutputStream.$$$reportNull$$$0(0);
        }
        this(backingFile, 4096);
    }

    public FileDeferredOutputStream(@Nonnull File backingFile, int bufferSize) throws FileNotFoundException {
        if (backingFile == null) {
            FileDeferredOutputStream.$$$reportNull$$$0(1);
        }
        this.backingFile = backingFile;
        this.output = new NakedBufferedOutputStream(new FileOutputStream(backingFile), bufferSize);
    }

    @Override
    public void writeTo(@Nonnull OutputStream dest) throws IOException {
        if (dest == null) {
            FileDeferredOutputStream.$$$reportNull$$$0(2);
        }
        byte[] outBuf = this.output.getBuffer();
        int count = this.output.getCount();
        this.output.resetBuffer();
        this.output.close();
        if (count != this.writtenBytes) {
            FileInputStream fis = new FileInputStream(this.backingFile);
            ByteStreams.copy(fis, dest);
            this.backingFile.delete();
        }
        dest.write(outBuf, 0, count);
    }

    @Override
    public void write(int i) throws IOException {
        this.output.write(i);
        ++this.writtenBytes;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.output.write(bytes);
        this.writtenBytes += bytes.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.output.write(bytes, off, len);
        this.writtenBytes += len;
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    @Nonnull
    public static DeferredOutputStreamFactory getFactory(@Nullable File containingDirectory) {
        DeferredOutputStreamFactory deferredOutputStreamFactory = FileDeferredOutputStream.getFactory(containingDirectory, 4096);
        if (deferredOutputStreamFactory == null) {
            FileDeferredOutputStream.$$$reportNull$$$0(3);
        }
        return deferredOutputStreamFactory;
    }

    @Nonnull
    public static DeferredOutputStreamFactory getFactory(final @Nullable File containingDirectory, final int bufferSize) {
        DeferredOutputStreamFactory deferredOutputStreamFactory = new DeferredOutputStreamFactory(){

            @Override
            public DeferredOutputStream makeDeferredOutputStream() throws IOException {
                File tempFile = File.createTempFile("dexlibtmp", null, containingDirectory);
                return new FileDeferredOutputStream(tempFile, bufferSize);
            }
        };
        if (deferredOutputStreamFactory == null) {
            FileDeferredOutputStream.$$$reportNull$$$0(4);
        }
        return deferredOutputStreamFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backingFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/io/FileDeferredOutputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/io/FileDeferredOutputStream";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeTo";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NakedBufferedOutputStream
    extends BufferedOutputStream {
        public NakedBufferedOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        public NakedBufferedOutputStream(OutputStream outputStream, int i) {
            super(outputStream, i);
        }

        public int getCount() {
            return this.count;
        }

        public void resetBuffer() {
            this.count = 0;
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

