/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.jf.dexlib2.writer.DexWriter;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationElement;
import org.jf.dexlib2.writer.builder.BuilderAnnotationPool;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSetPool;
import org.jf.dexlib2.writer.builder.BuilderClassDef;
import org.jf.dexlib2.writer.builder.BuilderClassPool;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderFieldPool;
import org.jf.dexlib2.writer.builder.BuilderFieldReference;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderMethodParameter;
import org.jf.dexlib2.writer.builder.BuilderMethodPool;
import org.jf.dexlib2.writer.builder.BuilderMethodProtoReference;
import org.jf.dexlib2.writer.builder.BuilderMethodReference;
import org.jf.dexlib2.writer.builder.BuilderProtoPool;
import org.jf.dexlib2.writer.builder.BuilderReference;
import org.jf.dexlib2.writer.builder.BuilderStringPool;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeListPool;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.util.ExceptionWithContext;

public class DexBuilder
extends DexWriter<BuilderStringReference, BuilderStringReference, BuilderTypeReference, BuilderTypeReference, BuilderMethodProtoReference, BuilderFieldReference, BuilderMethodReference, BuilderClassDef, BuilderAnnotation, BuilderAnnotationSet, BuilderTypeList, BuilderField, BuilderMethod, BuilderEncodedValues.BuilderEncodedValue, BuilderAnnotationElement, BuilderStringPool, BuilderTypePool, BuilderProtoPool, BuilderFieldPool, BuilderMethodPool, BuilderClassPool, BuilderTypeListPool, BuilderAnnotationPool, BuilderAnnotationSetPool> {
    public DexBuilder(@Nonnull Opcodes opcodes) {
        if (opcodes == null) {
            DexBuilder.$$$reportNull$$$0(0);
        }
        super(opcodes);
    }

    @Override
    @Nonnull
    protected DexWriter.SectionProvider getSectionProvider() {
        DexBuilderSectionProvider dexBuilderSectionProvider = new DexBuilderSectionProvider();
        if (dexBuilderSectionProvider == null) {
            DexBuilder.$$$reportNull$$$0(1);
        }
        return dexBuilderSectionProvider;
    }

    @Nonnull
    public BuilderField internField(@Nonnull String definingClass, @Nonnull String name, @Nonnull String type, int accessFlags, @Nullable EncodedValue initialValue, @Nonnull Set<? extends Annotation> annotations) {
        if (definingClass == null) {
            DexBuilder.$$$reportNull$$$0(2);
        }
        if (name == null) {
            DexBuilder.$$$reportNull$$$0(3);
        }
        if (type == null) {
            DexBuilder.$$$reportNull$$$0(4);
        }
        if (annotations == null) {
            DexBuilder.$$$reportNull$$$0(5);
        }
        BuilderField builderField = new BuilderField(((BuilderFieldPool)this.fieldSection).internField(definingClass, name, type), accessFlags, this.internNullableEncodedValue(initialValue), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations));
        if (builderField == null) {
            DexBuilder.$$$reportNull$$$0(6);
        }
        return builderField;
    }

    @Nonnull
    public BuilderMethod internMethod(@Nonnull String definingClass, @Nonnull String name, @Nullable List<? extends MethodParameter> parameters, @Nonnull String returnType, int accessFlags, @Nonnull Set<? extends Annotation> annotations, @Nullable MethodImplementation methodImplementation) {
        if (definingClass == null) {
            DexBuilder.$$$reportNull$$$0(7);
        }
        if (name == null) {
            DexBuilder.$$$reportNull$$$0(8);
        }
        if (returnType == null) {
            DexBuilder.$$$reportNull$$$0(9);
        }
        if (annotations == null) {
            DexBuilder.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            parameters = ImmutableList.of();
        }
        BuilderMethod builderMethod = new BuilderMethod(((BuilderMethodPool)this.methodSection).internMethod(definingClass, name, parameters, returnType), this.internMethodParameters(parameters), accessFlags, ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations), methodImplementation);
        if (builderMethod == null) {
            DexBuilder.$$$reportNull$$$0(11);
        }
        return builderMethod;
    }

    @Nonnull
    public BuilderClassDef internClassDef(@Nonnull String type, int accessFlags, @Nullable String superclass, @Nullable List<String> interfaces, @Nullable String sourceFile, @Nonnull Set<? extends Annotation> annotations, @Nullable Iterable<? extends BuilderField> fields, @Nullable Iterable<? extends BuilderMethod> methods) {
        if (type == null) {
            DexBuilder.$$$reportNull$$$0(12);
        }
        if (annotations == null) {
            DexBuilder.$$$reportNull$$$0(13);
        }
        if (interfaces == null) {
            interfaces = ImmutableList.of();
        } else {
            HashSet<String> interfaces_copy = Sets.newHashSet(interfaces);
            Iterator<String> interfaceIterator = interfaces.iterator();
            while (interfaceIterator.hasNext()) {
                String iface = interfaceIterator.next();
                if (!interfaces_copy.contains(iface)) {
                    interfaceIterator.remove();
                    continue;
                }
                interfaces_copy.remove(iface);
            }
        }
        BuilderClassDef builderClassDef = ((BuilderClassPool)this.classSection).internClass(new BuilderClassDef(((BuilderTypePool)this.typeSection).internType(type), accessFlags, ((BuilderTypePool)this.typeSection).internNullableType(superclass), ((BuilderTypeListPool)this.typeListSection).internTypeList(interfaces), ((BuilderStringPool)this.stringSection).internNullableString(sourceFile), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(annotations), fields, methods));
        if (builderClassDef == null) {
            DexBuilder.$$$reportNull$$$0(14);
        }
        return builderClassDef;
    }

    @Nonnull
    public BuilderStringReference internStringReference(@Nonnull String string) {
        if (string == null) {
            DexBuilder.$$$reportNull$$$0(15);
        }
        BuilderStringReference builderStringReference = ((BuilderStringPool)this.stringSection).internString(string);
        if (builderStringReference == null) {
            DexBuilder.$$$reportNull$$$0(16);
        }
        return builderStringReference;
    }

    @Nullable
    public BuilderStringReference internNullableStringReference(@Nullable String string) {
        if (string != null) {
            return this.internStringReference(string);
        }
        return null;
    }

    @Nonnull
    public BuilderTypeReference internTypeReference(@Nonnull String type) {
        if (type == null) {
            DexBuilder.$$$reportNull$$$0(17);
        }
        BuilderTypeReference builderTypeReference = ((BuilderTypePool)this.typeSection).internType(type);
        if (builderTypeReference == null) {
            DexBuilder.$$$reportNull$$$0(18);
        }
        return builderTypeReference;
    }

    @Nullable
    public BuilderTypeReference internNullableTypeReference(@Nullable String type) {
        if (type != null) {
            return this.internTypeReference(type);
        }
        return null;
    }

    @Nonnull
    public BuilderFieldReference internFieldReference(@Nonnull FieldReference field) {
        if (field == null) {
            DexBuilder.$$$reportNull$$$0(19);
        }
        BuilderFieldReference builderFieldReference = ((BuilderFieldPool)this.fieldSection).internField(field);
        if (builderFieldReference == null) {
            DexBuilder.$$$reportNull$$$0(20);
        }
        return builderFieldReference;
    }

    @Nonnull
    public BuilderMethodReference internMethodReference(@Nonnull MethodReference method) {
        if (method == null) {
            DexBuilder.$$$reportNull$$$0(21);
        }
        BuilderMethodReference builderMethodReference = ((BuilderMethodPool)this.methodSection).internMethod(method);
        if (builderMethodReference == null) {
            DexBuilder.$$$reportNull$$$0(22);
        }
        return builderMethodReference;
    }

    @Nonnull
    public BuilderMethodProtoReference internMethodProtoReference(@Nonnull MethodProtoReference methodProto) {
        if (methodProto == null) {
            DexBuilder.$$$reportNull$$$0(23);
        }
        BuilderMethodProtoReference builderMethodProtoReference = ((BuilderProtoPool)this.protoSection).internMethodProto(methodProto);
        if (builderMethodProtoReference == null) {
            DexBuilder.$$$reportNull$$$0(24);
        }
        return builderMethodProtoReference;
    }

    @Nonnull
    public BuilderReference internReference(@Nonnull Reference reference) {
        if (reference == null) {
            DexBuilder.$$$reportNull$$$0(25);
        }
        if (reference instanceof StringReference) {
            BuilderStringReference builderStringReference = this.internStringReference(((StringReference)reference).getString());
            if (builderStringReference == null) {
                DexBuilder.$$$reportNull$$$0(26);
            }
            return builderStringReference;
        }
        if (reference instanceof TypeReference) {
            BuilderTypeReference builderTypeReference = this.internTypeReference(((TypeReference)reference).getType());
            if (builderTypeReference == null) {
                DexBuilder.$$$reportNull$$$0(27);
            }
            return builderTypeReference;
        }
        if (reference instanceof MethodReference) {
            BuilderMethodReference builderMethodReference = this.internMethodReference((MethodReference)reference);
            if (builderMethodReference == null) {
                DexBuilder.$$$reportNull$$$0(28);
            }
            return builderMethodReference;
        }
        if (reference instanceof FieldReference) {
            BuilderFieldReference builderFieldReference = this.internFieldReference((FieldReference)reference);
            if (builderFieldReference == null) {
                DexBuilder.$$$reportNull$$$0(29);
            }
            return builderFieldReference;
        }
        if (reference instanceof MethodProtoReference) {
            BuilderMethodProtoReference builderMethodProtoReference = this.internMethodProtoReference((MethodProtoReference)reference);
            if (builderMethodProtoReference == null) {
                DexBuilder.$$$reportNull$$$0(30);
            }
            return builderMethodProtoReference;
        }
        throw new IllegalArgumentException("Could not determine type of reference");
    }

    @Nonnull
    private List<BuilderMethodParameter> internMethodParameters(@Nullable List<? extends MethodParameter> methodParameters) {
        if (methodParameters == null) {
            ImmutableList<BuilderMethodParameter> immutableList = ImmutableList.of();
            if (immutableList == null) {
                DexBuilder.$$$reportNull$$$0(31);
            }
            return immutableList;
        }
        ImmutableList<BuilderMethodParameter> immutableList = ImmutableList.copyOf(Iterators.transform(methodParameters.iterator(), new Function<MethodParameter, BuilderMethodParameter>(){

            @Override
            @Nullable
            public BuilderMethodParameter apply(MethodParameter input) {
                return DexBuilder.this.internMethodParameter(input);
            }
        }));
        if (immutableList == null) {
            DexBuilder.$$$reportNull$$$0(32);
        }
        return immutableList;
    }

    @Nonnull
    private BuilderMethodParameter internMethodParameter(@Nonnull MethodParameter methodParameter) {
        if (methodParameter == null) {
            DexBuilder.$$$reportNull$$$0(33);
        }
        BuilderMethodParameter builderMethodParameter = new BuilderMethodParameter(((BuilderTypePool)this.typeSection).internType(methodParameter.getType()), ((BuilderStringPool)this.stringSection).internNullableString(methodParameter.getName()), ((BuilderAnnotationSetPool)this.annotationSetSection).internAnnotationSet(methodParameter.getAnnotations()));
        if (builderMethodParameter == null) {
            DexBuilder.$$$reportNull$$$0(34);
        }
        return builderMethodParameter;
    }

    @Override
    protected void writeEncodedValue(@Nonnull DexWriter.InternalEncodedValueWriter writer, @Nonnull BuilderEncodedValues.BuilderEncodedValue encodedValue) throws IOException {
        if (writer == null) {
            DexBuilder.$$$reportNull$$$0(35);
        }
        if (encodedValue == null) {
            DexBuilder.$$$reportNull$$$0(36);
        }
        switch (encodedValue.getValueType()) {
            case 29: {
                BuilderEncodedValues.BuilderAnnotationEncodedValue annotationEncodedValue = (BuilderEncodedValues.BuilderAnnotationEncodedValue)encodedValue;
                writer.writeAnnotation(annotationEncodedValue.typeReference, annotationEncodedValue.elements);
                break;
            }
            case 28: {
                BuilderEncodedValues.BuilderArrayEncodedValue arrayEncodedValue = (BuilderEncodedValues.BuilderArrayEncodedValue)encodedValue;
                writer.writeArray(arrayEncodedValue.elements);
                break;
            }
            case 31: {
                writer.writeBoolean(((BooleanEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 0: {
                writer.writeByte(((ByteEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 3: {
                writer.writeChar(((CharEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 17: {
                writer.writeDouble(((DoubleEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 27: {
                writer.writeEnum(((BuilderEncodedValues.BuilderEnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                writer.writeField(((BuilderEncodedValues.BuilderFieldEncodedValue)encodedValue).fieldReference);
                break;
            }
            case 16: {
                writer.writeFloat(((FloatEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 4: {
                writer.writeInt(((IntEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 6: {
                writer.writeLong(((LongEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 26: {
                writer.writeMethod(((BuilderEncodedValues.BuilderMethodEncodedValue)encodedValue).methodReference);
                break;
            }
            case 30: {
                writer.writeNull();
                break;
            }
            case 2: {
                writer.writeShort(((ShortEncodedValue)((Object)encodedValue)).getValue());
                break;
            }
            case 23: {
                writer.writeString(((BuilderEncodedValues.BuilderStringEncodedValue)encodedValue).stringReference);
                break;
            }
            case 24: {
                writer.writeType(((BuilderEncodedValues.BuilderTypeEncodedValue)encodedValue).typeReference);
                break;
            }
            default: {
                throw new ExceptionWithContext("Unrecognized value type: %d", encodedValue.getValueType());
            }
        }
    }

    @Nonnull
    Set<? extends BuilderAnnotationElement> internAnnotationElements(@Nonnull Set<? extends AnnotationElement> elements) {
        if (elements == null) {
            DexBuilder.$$$reportNull$$$0(37);
        }
        ImmutableSet<BuilderAnnotationElement> immutableSet = ImmutableSet.copyOf(Iterators.transform(elements.iterator(), new Function<AnnotationElement, BuilderAnnotationElement>(){

            @Override
            @Nullable
            public BuilderAnnotationElement apply(AnnotationElement input) {
                return DexBuilder.this.internAnnotationElement(input);
            }
        }));
        if (immutableSet == null) {
            DexBuilder.$$$reportNull$$$0(38);
        }
        return immutableSet;
    }

    @Nonnull
    private BuilderAnnotationElement internAnnotationElement(@Nonnull AnnotationElement annotationElement) {
        if (annotationElement == null) {
            DexBuilder.$$$reportNull$$$0(39);
        }
        BuilderAnnotationElement builderAnnotationElement = new BuilderAnnotationElement(((BuilderStringPool)this.stringSection).internString(annotationElement.getName()), this.internEncodedValue(annotationElement.getValue()));
        if (builderAnnotationElement == null) {
            DexBuilder.$$$reportNull$$$0(40);
        }
        return builderAnnotationElement;
    }

    @Nullable
    BuilderEncodedValues.BuilderEncodedValue internNullableEncodedValue(@Nullable EncodedValue encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return this.internEncodedValue(encodedValue);
    }

    @Nonnull
    private BuilderEncodedValues.BuilderEncodedValue internEncodedValue(@Nonnull EncodedValue encodedValue) {
        if (encodedValue == null) {
            DexBuilder.$$$reportNull$$$0(41);
        }
        switch (encodedValue.getValueType()) {
            case 29: {
                BuilderEncodedValues.BuilderAnnotationEncodedValue builderAnnotationEncodedValue = this.internAnnotationEncodedValue((AnnotationEncodedValue)encodedValue);
                if (builderAnnotationEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(42);
                }
                return builderAnnotationEncodedValue;
            }
            case 28: {
                BuilderEncodedValues.BuilderArrayEncodedValue builderArrayEncodedValue = this.internArrayEncodedValue((ArrayEncodedValue)encodedValue);
                if (builderArrayEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(43);
                }
                return builderArrayEncodedValue;
            }
            case 31: {
                boolean value = ((BooleanEncodedValue)encodedValue).getValue();
                BuilderEncodedValues.BuilderBooleanEncodedValue builderBooleanEncodedValue = value ? BuilderEncodedValues.BuilderBooleanEncodedValue.TRUE_VALUE : BuilderEncodedValues.BuilderBooleanEncodedValue.FALSE_VALUE;
                if (builderBooleanEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(44);
                }
                return builderBooleanEncodedValue;
            }
            case 0: {
                BuilderEncodedValues.BuilderByteEncodedValue builderByteEncodedValue = new BuilderEncodedValues.BuilderByteEncodedValue(((ByteEncodedValue)encodedValue).getValue());
                if (builderByteEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(45);
                }
                return builderByteEncodedValue;
            }
            case 3: {
                BuilderEncodedValues.BuilderCharEncodedValue builderCharEncodedValue = new BuilderEncodedValues.BuilderCharEncodedValue(((CharEncodedValue)encodedValue).getValue());
                if (builderCharEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(46);
                }
                return builderCharEncodedValue;
            }
            case 17: {
                BuilderEncodedValues.BuilderDoubleEncodedValue builderDoubleEncodedValue = new BuilderEncodedValues.BuilderDoubleEncodedValue(((DoubleEncodedValue)encodedValue).getValue());
                if (builderDoubleEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(47);
                }
                return builderDoubleEncodedValue;
            }
            case 27: {
                BuilderEncodedValues.BuilderEnumEncodedValue builderEnumEncodedValue = this.internEnumEncodedValue((EnumEncodedValue)encodedValue);
                if (builderEnumEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(48);
                }
                return builderEnumEncodedValue;
            }
            case 25: {
                BuilderEncodedValues.BuilderFieldEncodedValue builderFieldEncodedValue = this.internFieldEncodedValue((FieldEncodedValue)encodedValue);
                if (builderFieldEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(49);
                }
                return builderFieldEncodedValue;
            }
            case 16: {
                BuilderEncodedValues.BuilderFloatEncodedValue builderFloatEncodedValue = new BuilderEncodedValues.BuilderFloatEncodedValue(((FloatEncodedValue)encodedValue).getValue());
                if (builderFloatEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(50);
                }
                return builderFloatEncodedValue;
            }
            case 4: {
                BuilderEncodedValues.BuilderIntEncodedValue builderIntEncodedValue = new BuilderEncodedValues.BuilderIntEncodedValue(((IntEncodedValue)encodedValue).getValue());
                if (builderIntEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(51);
                }
                return builderIntEncodedValue;
            }
            case 6: {
                BuilderEncodedValues.BuilderLongEncodedValue builderLongEncodedValue = new BuilderEncodedValues.BuilderLongEncodedValue(((LongEncodedValue)encodedValue).getValue());
                if (builderLongEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(52);
                }
                return builderLongEncodedValue;
            }
            case 26: {
                BuilderEncodedValues.BuilderMethodEncodedValue builderMethodEncodedValue = this.internMethodEncodedValue((MethodEncodedValue)encodedValue);
                if (builderMethodEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(53);
                }
                return builderMethodEncodedValue;
            }
            case 30: {
                BuilderEncodedValues.BuilderNullEncodedValue builderNullEncodedValue = BuilderEncodedValues.BuilderNullEncodedValue.INSTANCE;
                if (builderNullEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(54);
                }
                return builderNullEncodedValue;
            }
            case 2: {
                BuilderEncodedValues.BuilderShortEncodedValue builderShortEncodedValue = new BuilderEncodedValues.BuilderShortEncodedValue(((ShortEncodedValue)encodedValue).getValue());
                if (builderShortEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(55);
                }
                return builderShortEncodedValue;
            }
            case 23: {
                BuilderEncodedValues.BuilderStringEncodedValue builderStringEncodedValue = this.internStringEncodedValue((StringEncodedValue)encodedValue);
                if (builderStringEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(56);
                }
                return builderStringEncodedValue;
            }
            case 24: {
                BuilderEncodedValues.BuilderTypeEncodedValue builderTypeEncodedValue = this.internTypeEncodedValue((TypeEncodedValue)encodedValue);
                if (builderTypeEncodedValue == null) {
                    DexBuilder.$$$reportNull$$$0(57);
                }
                return builderTypeEncodedValue;
            }
        }
        throw new ExceptionWithContext("Unexpected encoded value type: %d", encodedValue.getValueType());
    }

    @Nonnull
    private BuilderEncodedValues.BuilderAnnotationEncodedValue internAnnotationEncodedValue(@Nonnull AnnotationEncodedValue value) {
        if (value == null) {
            DexBuilder.$$$reportNull$$$0(58);
        }
        BuilderEncodedValues.BuilderAnnotationEncodedValue builderAnnotationEncodedValue = new BuilderEncodedValues.BuilderAnnotationEncodedValue(((BuilderTypePool)this.typeSection).internType(value.getType()), this.internAnnotationElements(value.getElements()));
        if (builderAnnotationEncodedValue == null) {
            DexBuilder.$$$reportNull$$$0(59);
        }
        return builderAnnotationEncodedValue;
    }

    @Nonnull
    private BuilderEncodedValues.BuilderArrayEncodedValue internArrayEncodedValue(@Nonnull ArrayEncodedValue value) {
        if (value == null) {
            DexBuilder.$$$reportNull$$$0(60);
        }
        BuilderEncodedValues.BuilderArrayEncodedValue builderArrayEncodedValue = new BuilderEncodedValues.BuilderArrayEncodedValue(ImmutableList.copyOf(Iterators.transform(value.getValue().iterator(), new Function<EncodedValue, BuilderEncodedValues.BuilderEncodedValue>(){

            @Override
            @Nullable
            public BuilderEncodedValues.BuilderEncodedValue apply(EncodedValue input) {
                return DexBuilder.this.internEncodedValue(input);
            }
        })));
        if (builderArrayEncodedValue == null) {
            DexBuilder.$$$reportNull$$$0(61);
        }
        return builderArrayEncodedValue;
    }

    @Nonnull
    private BuilderEncodedValues.BuilderEnumEncodedValue internEnumEncodedValue(@Nonnull EnumEncodedValue value) {
        if (value == null) {
            DexBuilder.$$$reportNull$$$0(62);
        }
        BuilderEncodedValues.BuilderEnumEncodedValue builderEnumEncodedValue = new BuilderEncodedValues.BuilderEnumEncodedValue(((BuilderFieldPool)this.fieldSection).internField(value.getValue()));
        if (builderEnumEncodedValue == null) {
            DexBuilder.$$$reportNull$$$0(63);
        }
        return builderEnumEncodedValue;
    }

    @Nonnull
    private BuilderEncodedValues.BuilderFieldEncodedValue internFieldEncodedValue(@Nonnull FieldEncodedValue value) {
        if (value == null) {
            DexBuilder.$$$reportNull$$$0(64);
        }
        BuilderEncodedValues.BuilderFieldEncodedValue builderFieldEncodedValue = new BuilderEncodedValues.BuilderFieldEncodedValue(((BuilderFieldPool)this.fieldSection).internField(value.getValue()));
        if (builderFieldEncodedValue == null) {
            DexBuilder.$$$reportNull$$$0(65);
        }
        return builderFieldEncodedValue;
    }

    @Nonnull
    private BuilderEncodedValues.BuilderMethodEncodedValue internMethodEncodedValue(@Nonnull MethodEncodedValue value) {
        if (value == null) {
            DexBuilder.$$$reportNull$$$0(66);
        }
        BuilderEncodedValues.BuilderMethodEncodedValue builderMethodEncodedValue = new BuilderEncodedValues.BuilderMethodEncodedValue(((BuilderMethodPool)this.methodSection).internMethod(value.getValue()));
        if (builderMethodEncodedValue == null) {
            DexBuilder.$$$reportNull$$$0(67);
        }
        return builderMethodEncodedValue;
    }

    @Nonnull
    private BuilderEncodedValues.BuilderStringEncodedValue internStringEncodedValue(@Nonnull StringEncodedValue string) {
        if (string == null) {
            DexBuilder.$$$reportNull$$$0(68);
        }
        BuilderEncodedValues.BuilderStringEncodedValue builderStringEncodedValue = new BuilderEncodedValues.BuilderStringEncodedValue(((BuilderStringPool)this.stringSection).internString(string.getValue()));
        if (builderStringEncodedValue == null) {
            DexBuilder.$$$reportNull$$$0(69);
        }
        return builderStringEncodedValue;
    }

    @Nonnull
    private BuilderEncodedValues.BuilderTypeEncodedValue internTypeEncodedValue(@Nonnull TypeEncodedValue type) {
        if (type == null) {
            DexBuilder.$$$reportNull$$$0(70);
        }
        BuilderEncodedValues.BuilderTypeEncodedValue builderTypeEncodedValue = new BuilderEncodedValues.BuilderTypeEncodedValue(((BuilderTypePool)this.typeSection).internType(type.getValue()));
        if (builderTypeEncodedValue == null) {
            DexBuilder.$$$reportNull$$$0(71);
        }
        return builderTypeEncodedValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/builder/DexBuilder";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definingClass";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 12: 
            case 17: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 15: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodProto";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParameter";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encodedValue";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationElement";
                break;
            }
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/builder/DexBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "internField";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "internMethod";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "internClassDef";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "internStringReference";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "internTypeReference";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "internFieldReference";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "internMethodReference";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "internMethodProtoReference";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "internReference";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "internMethodParameters";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "internMethodParameter";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "internAnnotationElements";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "internAnnotationElement";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "internEncodedValue";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "internAnnotationEncodedValue";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "internArrayEncodedValue";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "internEnumEncodedValue";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "internFieldEncodedValue";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "internMethodEncodedValue";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "internStringEncodedValue";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "internTypeEncodedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "internField";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "internMethod";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "internClassDef";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "internStringReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "internTypeReference";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "internFieldReference";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "internMethodReference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "internMethodProtoReference";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "internReference";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "internMethodParameter";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "writeEncodedValue";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "internAnnotationElements";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "internAnnotationElement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "internEncodedValue";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "internAnnotationEncodedValue";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "internArrayEncodedValue";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "internEnumEncodedValue";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "internFieldEncodedValue";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "internMethodEncodedValue";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "internStringEncodedValue";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "internTypeEncodedValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 71: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class DexBuilderSectionProvider
    extends DexWriter.SectionProvider {
        protected DexBuilderSectionProvider() {
            super(DexBuilder.this);
        }

        @Nonnull
        public BuilderStringPool getStringSection() {
            BuilderStringPool builderStringPool = new BuilderStringPool();
            if (builderStringPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(0);
            }
            return builderStringPool;
        }

        @Nonnull
        public BuilderTypePool getTypeSection() {
            BuilderTypePool builderTypePool = new BuilderTypePool(DexBuilder.this);
            if (builderTypePool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(1);
            }
            return builderTypePool;
        }

        @Nonnull
        public BuilderProtoPool getProtoSection() {
            BuilderProtoPool builderProtoPool = new BuilderProtoPool(DexBuilder.this);
            if (builderProtoPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(2);
            }
            return builderProtoPool;
        }

        @Nonnull
        public BuilderFieldPool getFieldSection() {
            BuilderFieldPool builderFieldPool = new BuilderFieldPool(DexBuilder.this);
            if (builderFieldPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(3);
            }
            return builderFieldPool;
        }

        @Nonnull
        public BuilderMethodPool getMethodSection() {
            BuilderMethodPool builderMethodPool = new BuilderMethodPool(DexBuilder.this);
            if (builderMethodPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(4);
            }
            return builderMethodPool;
        }

        @Nonnull
        public BuilderClassPool getClassSection() {
            BuilderClassPool builderClassPool = new BuilderClassPool(DexBuilder.this);
            if (builderClassPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(5);
            }
            return builderClassPool;
        }

        @Nonnull
        public BuilderTypeListPool getTypeListSection() {
            BuilderTypeListPool builderTypeListPool = new BuilderTypeListPool(DexBuilder.this);
            if (builderTypeListPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(6);
            }
            return builderTypeListPool;
        }

        @Nonnull
        public BuilderAnnotationPool getAnnotationSection() {
            BuilderAnnotationPool builderAnnotationPool = new BuilderAnnotationPool(DexBuilder.this);
            if (builderAnnotationPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(7);
            }
            return builderAnnotationPool;
        }

        @Nonnull
        public BuilderAnnotationSetPool getAnnotationSetSection() {
            BuilderAnnotationSetPool builderAnnotationSetPool = new BuilderAnnotationSetPool(DexBuilder.this);
            if (builderAnnotationSetPool == null) {
                DexBuilderSectionProvider.$$$reportNull$$$0(8);
            }
            return builderAnnotationSetPool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jf/dexlib2/writer/builder/DexBuilder$DexBuilderSectionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStringSection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeSection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProtoSection";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldSection";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodSection";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassSection";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeListSection";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationSection";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationSetSection";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", objectArray));
        }
    }
}

